/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.replication.fluent;

import com.hm.postgresql.replication.LogSequenceNumber;
import com.hm.postgresql.replication.fluent.ChainedCommonStreamBuilder;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractStreamBuilder<T extends ChainedCommonStreamBuilder<T>>
implements ChainedCommonStreamBuilder<T> {
    private static final int DEFAULT_STATUS_INTERVAL = (int)TimeUnit.SECONDS.toMillis(10L);
    protected int statusIntervalMs = DEFAULT_STATUS_INTERVAL;
    protected LogSequenceNumber startPosition = LogSequenceNumber.INVALID_LSN;
    protected @Nullable String slotName;

    protected abstract T self();

    @Override
    public T withStatusInterval(int n, TimeUnit timeUnit) {
        this.statusIntervalMs = (int)TimeUnit.MILLISECONDS.convert(n, timeUnit);
        return this.self();
    }

    @Override
    public T withStartPosition(LogSequenceNumber logSequenceNumber) {
        this.startPosition = logSequenceNumber;
        return this.self();
    }

    @Override
    public T withSlotName(String string) {
        this.slotName = string;
        return this.self();
    }
}

