/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.replication.fluent.logical;

import com.hm.postgresql.replication.LogSequenceNumber;
import com.hm.postgresql.replication.PGReplicationStream;
import com.hm.postgresql.replication.fluent.AbstractStreamBuilder;
import com.hm.postgresql.replication.fluent.logical.ChainedLogicalStreamBuilder;
import com.hm.postgresql.replication.fluent.logical.LogicalReplicationOptions;
import com.hm.postgresql.replication.fluent.logical.StartLogicalReplicationCallback;
import com.hm.postgresql.util.internal.Nullness;
import java.util.Properties;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LogicalStreamBuilder
extends AbstractStreamBuilder<ChainedLogicalStreamBuilder>
implements ChainedLogicalStreamBuilder,
LogicalReplicationOptions {
    private final Properties slotOptions;
    private StartLogicalReplicationCallback startCallback;

    public LogicalStreamBuilder(StartLogicalReplicationCallback startLogicalReplicationCallback) {
        this.startCallback = startLogicalReplicationCallback;
        this.slotOptions = new Properties();
    }

    @Override
    protected ChainedLogicalStreamBuilder self() {
        return this;
    }

    @Override
    public PGReplicationStream start() {
        return this.startCallback.start(this);
    }

    @Override
    public @Nullable String getSlotName() {
        return this.slotName;
    }

    @Override
    public ChainedLogicalStreamBuilder withStartPosition(LogSequenceNumber logSequenceNumber) {
        this.startPosition = logSequenceNumber;
        return this;
    }

    @Override
    public ChainedLogicalStreamBuilder withSlotOption(String string, boolean bl) {
        this.slotOptions.setProperty(string, String.valueOf(bl));
        return this;
    }

    @Override
    public ChainedLogicalStreamBuilder withSlotOption(String string, int n) {
        this.slotOptions.setProperty(string, String.valueOf(n));
        return this;
    }

    @Override
    public ChainedLogicalStreamBuilder withSlotOption(String string, String string2) {
        this.slotOptions.setProperty(string, string2);
        return this;
    }

    @Override
    public ChainedLogicalStreamBuilder withSlotOptions(Properties properties) {
        for (String string : properties.stringPropertyNames()) {
            this.slotOptions.setProperty(string, Nullness.castNonNull(properties.getProperty(string)));
        }
        return this;
    }

    @Override
    public LogSequenceNumber getStartLSNPosition() {
        return this.startPosition;
    }

    @Override
    public Properties getSlotOptions() {
        return this.slotOptions;
    }

    @Override
    public int getStatusInterval() {
        return this.statusIntervalMs;
    }
}

