/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.shaded.com.ongres.scram.common;

import com.hm.postgresql.shaded.com.ongres.scram.common.exception.ScramParseException;
import com.hm.postgresql.shaded.com.ongres.scram.common.util.CharAttribute;
import com.hm.postgresql.shaded.com.ongres.scram.common.util.Preconditions;
import java.util.HashMap;
import java.util.Map;

public enum ScramAttributes implements CharAttribute
{
    USERNAME('n'),
    AUTHZID('a'),
    NONCE('r'),
    CHANNEL_BINDING('c'),
    SALT('s'),
    ITERATION('i'),
    CLIENT_PROOF('p'),
    SERVER_SIGNATURE('v'),
    ERROR('e');

    private final char attributeChar;
    private static final Map<Character, ScramAttributes> REVERSE_MAPPING;

    private ScramAttributes(char c) {
        this.attributeChar = Preconditions.checkNotNull(Character.valueOf(c), "attributeChar").charValue();
    }

    @Override
    public char getChar() {
        return this.attributeChar;
    }

    public static ScramAttributes byChar(char c) {
        if (!REVERSE_MAPPING.containsKey(Character.valueOf(c))) {
            throw new ScramParseException("Attribute with char '" + c + "' does not exist");
        }
        return REVERSE_MAPPING.get(Character.valueOf(c));
    }

    static {
        REVERSE_MAPPING = new HashMap<Character, ScramAttributes>();
        for (ScramAttributes scramAttributes : ScramAttributes.values()) {
            REVERSE_MAPPING.put(Character.valueOf(scramAttributes.getChar()), scramAttributes);
        }
    }
}

