/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.shaded.com.ongres.scram.common.gssapi;

import com.hm.postgresql.shaded.com.ongres.scram.common.ScramStringFormatting;
import com.hm.postgresql.shaded.com.ongres.scram.common.gssapi.Gs2AttributeValue;
import com.hm.postgresql.shaded.com.ongres.scram.common.gssapi.Gs2Attributes;
import com.hm.postgresql.shaded.com.ongres.scram.common.gssapi.Gs2CbindFlag;
import com.hm.postgresql.shaded.com.ongres.scram.common.util.AbstractStringWritable;
import com.hm.postgresql.shaded.com.ongres.scram.common.util.Preconditions;
import com.hm.postgresql.shaded.com.ongres.scram.common.util.StringWritableCsv;

public class Gs2Header
extends AbstractStringWritable {
    private final Gs2AttributeValue cbind;
    private final Gs2AttributeValue authzid;

    public Gs2Header(Gs2CbindFlag gs2CbindFlag, String string, String string2) {
        Preconditions.checkNotNull(gs2CbindFlag, "cbindFlag");
        if (gs2CbindFlag == Gs2CbindFlag.CHANNEL_BINDING_REQUIRED ^ string != null) {
            throw new IllegalArgumentException("Specify channel binding flag and value together, or none");
        }
        this.cbind = new Gs2AttributeValue(Gs2Attributes.byGS2CbindFlag(gs2CbindFlag), string);
        this.authzid = string2 == null ? null : new Gs2AttributeValue(Gs2Attributes.AUTHZID, ScramStringFormatting.toSaslName(string2));
    }

    public Gs2Header(Gs2CbindFlag gs2CbindFlag, String string) {
        this(gs2CbindFlag, string, null);
    }

    public Gs2Header(Gs2CbindFlag gs2CbindFlag) {
        this(gs2CbindFlag, null, null);
    }

    public Gs2CbindFlag getChannelBindingFlag() {
        return Gs2CbindFlag.byChar(this.cbind.getChar());
    }

    public String getChannelBindingName() {
        return this.cbind.getValue();
    }

    public String getAuthzid() {
        return this.authzid != null ? this.authzid.getValue() : null;
    }

    @Override
    public StringBuffer writeTo(StringBuffer stringBuffer) {
        return StringWritableCsv.writeTo(stringBuffer, this.cbind, this.authzid);
    }

    public static Gs2Header parseFrom(String string) {
        Preconditions.checkNotNull(string, "Null message");
        String[] stringArray = StringWritableCsv.parseFrom(string, 2);
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("Invalid number of fields for the GS2 Header");
        }
        Gs2AttributeValue gs2AttributeValue = Gs2AttributeValue.parse(stringArray[0]);
        return new Gs2Header(Gs2CbindFlag.byChar(gs2AttributeValue.getChar()), gs2AttributeValue.getValue(), stringArray[1] == null || stringArray[1].isEmpty() ? null : Gs2AttributeValue.parse(stringArray[1]).getValue());
    }
}

