/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.shaded.com.ongres.scram.common.message;

import com.hm.postgresql.shaded.com.ongres.scram.common.ScramAttributeValue;
import com.hm.postgresql.shaded.com.ongres.scram.common.ScramAttributes;
import com.hm.postgresql.shaded.com.ongres.scram.common.ScramStringFormatting;
import com.hm.postgresql.shaded.com.ongres.scram.common.exception.ScramParseException;
import com.hm.postgresql.shaded.com.ongres.scram.common.gssapi.Gs2CbindFlag;
import com.hm.postgresql.shaded.com.ongres.scram.common.gssapi.Gs2Header;
import com.hm.postgresql.shaded.com.ongres.scram.common.util.Preconditions;
import com.hm.postgresql.shaded.com.ongres.scram.common.util.StringWritable;
import com.hm.postgresql.shaded.com.ongres.scram.common.util.StringWritableCsv;

public class ClientFirstMessage
implements StringWritable {
    private final Gs2Header gs2Header;
    private final String user;
    private final String nonce;

    public ClientFirstMessage(Gs2Header gs2Header, String string, String string2) {
        this.gs2Header = Preconditions.checkNotNull(gs2Header, "gs2Header");
        this.user = Preconditions.checkNotEmpty(string, "user");
        this.nonce = Preconditions.checkNotEmpty(string2, "nonce");
    }

    private static Gs2Header gs2Header(Gs2CbindFlag gs2CbindFlag, String string, String string2) {
        Preconditions.checkNotNull(gs2CbindFlag, "gs2CbindFlag");
        if (Gs2CbindFlag.CHANNEL_BINDING_REQUIRED == gs2CbindFlag && null == string2) {
            throw new IllegalArgumentException("Channel binding name is required if channel binding is specified");
        }
        return new Gs2Header(gs2CbindFlag, string2, string);
    }

    public ClientFirstMessage(Gs2CbindFlag gs2CbindFlag, String string, String string2, String string3, String string4) {
        this(ClientFirstMessage.gs2Header(gs2CbindFlag, string, string2), string3, string4);
    }

    public ClientFirstMessage(String string, String string2) {
        this(ClientFirstMessage.gs2Header(Gs2CbindFlag.CLIENT_NOT, null, null), string, string2);
    }

    public Gs2CbindFlag getChannelBindingFlag() {
        return this.gs2Header.getChannelBindingFlag();
    }

    public boolean isChannelBinding() {
        return this.gs2Header.getChannelBindingFlag() == Gs2CbindFlag.CHANNEL_BINDING_REQUIRED;
    }

    public String getChannelBindingName() {
        return this.gs2Header.getChannelBindingName();
    }

    public String getAuthzid() {
        return this.gs2Header.getAuthzid();
    }

    public Gs2Header getGs2Header() {
        return this.gs2Header;
    }

    public String getUser() {
        return this.user;
    }

    public String getNonce() {
        return this.nonce;
    }

    public StringBuffer writeToWithoutGs2Header(StringBuffer stringBuffer) {
        return StringWritableCsv.writeTo(stringBuffer, new ScramAttributeValue(ScramAttributes.USERNAME, ScramStringFormatting.toSaslName(this.user)), new ScramAttributeValue(ScramAttributes.NONCE, this.nonce));
    }

    @Override
    public StringBuffer writeTo(StringBuffer stringBuffer) {
        StringWritableCsv.writeTo(stringBuffer, this.gs2Header, null);
        return this.writeToWithoutGs2Header(stringBuffer);
    }

    public static ClientFirstMessage parseFrom(String string) {
        String[] stringArray;
        Preconditions.checkNotEmpty(string, "clientFirstMessage");
        Gs2Header gs2Header = Gs2Header.parseFrom(string);
        try {
            stringArray = StringWritableCsv.parseFrom(string, 2, 2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ScramParseException("Illegal series of attributes in client-first-message", illegalArgumentException);
        }
        ScramAttributeValue scramAttributeValue = ScramAttributeValue.parse(stringArray[0]);
        if (ScramAttributes.USERNAME.getChar() != scramAttributeValue.getChar()) {
            throw new ScramParseException("user must be the 3rd element of the client-first-message");
        }
        ScramAttributeValue scramAttributeValue2 = ScramAttributeValue.parse(stringArray[1]);
        if (ScramAttributes.NONCE.getChar() != scramAttributeValue2.getChar()) {
            throw new ScramParseException("nonce must be the 4th element of the client-first-message");
        }
        return new ClientFirstMessage(gs2Header, scramAttributeValue.getValue(), scramAttributeValue2.getValue());
    }

    public String toString() {
        return this.writeTo(new StringBuffer()).toString();
    }
}

