/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.shaded.com.ongres.scram.common.util;

import com.hm.postgresql.shaded.com.ongres.scram.common.util.Preconditions;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptoUtil {
    private static final int MIN_ASCII_PRINTABLE_RANGE = 33;
    private static final int MAX_ASCII_PRINTABLE_RANGE = 126;
    private static final int EXCLUDED_CHAR = 44;

    public static String nonce(int n, SecureRandom secureRandom) {
        if (n <= 0) {
            throw new IllegalArgumentException("Size must be positive");
        }
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = secureRandom.nextInt(94) + 33;
            if (n3 == 44) continue;
            cArray[n2++] = (char)n3;
        }
        return new String(cArray);
    }

    public static String nonce(int n) {
        return CryptoUtil.nonce(n, SecureRandomHolder.INSTANCE);
    }

    public static byte[] hi(SecretKeyFactory secretKeyFactory, int n, char[] cArray, byte[] byArray, int n2) {
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray, byArray, n2, n);
            SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
            return secretKey.getEncoded();
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new RuntimeException("Platform error: unsupported PBEKeySpec");
        }
    }

    public static byte[] hmac(SecretKeySpec secretKeySpec, Mac mac, byte[] byArray) {
        try {
            mac.init(secretKeySpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException("Platform error: unsupported key for HMAC algorithm");
        }
        return mac.doFinal(byArray);
    }

    public static byte[] xor(byte[] byArray, byte[] byArray2) {
        Preconditions.checkNotNull(byArray, "value1");
        Preconditions.checkNotNull(byArray2, "value2");
        Preconditions.checkArgument(byArray.length == byArray2.length, "Both values must have the same length");
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
        return byArray3;
    }

    private static class SecureRandomHolder {
        private static final SecureRandom INSTANCE = new SecureRandom();

        private SecureRandomHolder() {
        }
    }
}

