/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.ssl;

import com.hm.postgresql.PGProperty;
import com.hm.postgresql.core.PGStream;
import com.hm.postgresql.core.SocketFactoryFactory;
import com.hm.postgresql.jdbc.SslMode;
import com.hm.postgresql.ssl.LibPQFactory;
import com.hm.postgresql.ssl.PGjdbcHostnameVerifier;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.ObjectFactory;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class MakeSSL
extends ObjectFactory {
    private static final Logger LOGGER = Logger.getLogger(MakeSSL.class.getName());

    public static void convert(PGStream pGStream, Properties properties) {
        SslMode sslMode;
        SSLSocket sSLSocket;
        LOGGER.log(Level.FINE, "converting regular socket connection to ssl");
        SSLSocketFactory sSLSocketFactory = SocketFactoryFactory.getSslSocketFactory(properties);
        try {
            sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(pGStream.getSocket(), pGStream.getHostSpec().getHost(), pGStream.getHostSpec().getPort(), true);
            sSLSocket.setUseClientMode(true);
            sSLSocket.startHandshake();
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("SSL error: {0}", iOException.getMessage()), PSQLState.CONNECTION_FAILURE, (Throwable)iOException);
        }
        if (sSLSocketFactory instanceof LibPQFactory) {
            ((LibPQFactory)sSLSocketFactory).throwKeyManagerException();
        }
        if ((sslMode = SslMode.of(properties)).verifyPeerName()) {
            MakeSSL.verifyPeerName(pGStream, properties, sSLSocket);
        }
        pGStream.changeSocket(sSLSocket);
    }

    private static void verifyPeerName(PGStream pGStream, Properties properties, SSLSocket sSLSocket) {
        HostnameVerifier hostnameVerifier;
        String string = PGProperty.SSL_HOSTNAME_VERIFIER.get(properties);
        if (string == null) {
            hostnameVerifier = PGjdbcHostnameVerifier.INSTANCE;
            string = "PgjdbcHostnameVerifier";
        } else {
            try {
                hostnameVerifier = (HostnameVerifier)MakeSSL.instantiate(string, properties, false, null);
            }
            catch (Exception exception) {
                throw new PSQLException(GT.tr("The HostnameVerifier class provided {0} could not be instantiated.", string), PSQLState.CONNECTION_FAILURE, (Throwable)exception);
            }
        }
        if (hostnameVerifier.verify(pGStream.getHostSpec().getHost(), sSLSocket.getSession())) {
            return;
        }
        throw new PSQLException(GT.tr("The hostname {0} could not be verified by hostnameverifier {1}.", pGStream.getHostSpec().getHost(), string), PSQLState.CONNECTION_FAILURE);
    }
}

