/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.ssl;

import com.hm.postgresql.util.GT;
import java.net.IDN;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PGjdbcHostnameVerifier
implements HostnameVerifier {
    private static final Logger LOGGER = Logger.getLogger(PGjdbcHostnameVerifier.class.getName());
    public static final PGjdbcHostnameVerifier INSTANCE = new PGjdbcHostnameVerifier();
    private static final int TYPE_DNS_NAME = 2;
    private static final int TYPE_IP_ADDRESS = 7;
    public static final Comparator<String> HOSTNAME_PATTERN_COMPARATOR = new Comparator<String>(){

        private int countChars(String string, char c) {
            int n = 0;
            int n2 = -1;
            while ((n2 = string.indexOf(c, n2 + 1)) != -1) {
                ++n;
            }
            return n;
        }

        @Override
        public int compare(String string, String string2) {
            int n;
            int n2;
            int n3;
            int n4 = this.countChars(string, '.');
            if (n4 != (n3 = this.countChars(string2, '.'))) {
                return n4 > n3 ? 1 : -1;
            }
            int n5 = this.countChars(string, '*');
            if (n5 != (n2 = this.countChars(string2, '*'))) {
                return n5 < n2 ? 1 : -1;
            }
            int n6 = string.length();
            if (n6 != (n = string2.length())) {
                return n6 > n ? 1 : -1;
            }
            return 0;
        }
    };

    @Override
    public boolean verify(String string, SSLSession sSLSession) {
        boolean bl;
        LdapName ldapName;
        Object object;
        Object object2;
        List<?> list2;
        Collection<List<?>> collection;
        String string2;
        X509Certificate[] x509CertificateArray;
        try {
            x509CertificateArray = (X509Certificate[])sSLSession.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            LOGGER.log(Level.SEVERE, GT.tr("Unable to parse X509Certificate for hostname {0}", string), sSLPeerUnverifiedException);
            return false;
        }
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            LOGGER.log(Level.SEVERE, GT.tr("No certificates found for hostname {0}", string));
            return false;
        }
        if (string.startsWith("[") && string.endsWith("]")) {
            string2 = string.substring(1, string.length() - 1);
        } else {
            try {
                string2 = IDN.toASCII(string);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "Canonical host name for {0} is {1}", new Object[]{string, string2});
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.log(Level.SEVERE, GT.tr("Hostname {0} is invalid", string), illegalArgumentException);
                return false;
            }
        }
        X509Certificate x509Certificate = x509CertificateArray[0];
        try {
            collection = x509Certificate.getSubjectAlternativeNames();
            if (collection == null) {
                collection = Collections.emptyList();
            }
        }
        catch (CertificateParsingException certificateParsingException) {
            LOGGER.log(Level.SEVERE, GT.tr("Unable to parse certificates for hostname {0}", string), certificateParsingException);
            return false;
        }
        boolean bl2 = false;
        for (List<?> list2 : collection) {
            if (list2.size() != 2 || (object2 = (Integer)list2.get(0)) == null || (Integer)object2 != 7 && (Integer)object2 != 2) continue;
            object = (String)list2.get(1);
            if ((Integer)object2 == 7 && object != null && ((String)object).startsWith("*")) continue;
            bl2 |= (Integer)object2 == 2;
            if (!this.verifyHostName(string2, (String)object)) continue;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, GT.tr("Server name validation pass for {0}, subjectAltName {1}", string, object));
            }
            return true;
        }
        if (bl2) {
            LOGGER.log(Level.SEVERE, GT.tr("Server name validation failed: certificate for host {0} dNSName entries subjectAltName, but none of them match. Assuming server name validation failed", string));
            return false;
        }
        try {
            ldapName = new LdapName(x509Certificate.getSubjectX500Principal().getName("RFC2253"));
        }
        catch (InvalidNameException invalidNameException) {
            LOGGER.log(Level.SEVERE, GT.tr("Server name validation failed: unable to extract common name from X509Certificate for hostname {0}", string), invalidNameException);
            return false;
        }
        list2 = new ArrayList(1);
        object2 = ldapName.getRdns().iterator();
        while (object2.hasNext()) {
            object = (Rdn)object2.next();
            if (!"CN".equals(((Rdn)object).getType())) continue;
            list2.add((String)((Rdn)object).getValue());
        }
        if (list2.isEmpty()) {
            LOGGER.log(Level.SEVERE, GT.tr("Server name validation failed: certificate for hostname {0} has no DNS subjectAltNames, and it CommonName is missing as well", string));
            return false;
        }
        if (list2.size() > 1) {
            Collections.sort(list2, HOSTNAME_PATTERN_COMPARATOR);
        }
        if (!(bl = this.verifyHostName(string2, (String)(object2 = (String)list2.get(list2.size() - 1))))) {
            LOGGER.log(Level.SEVERE, GT.tr("Server name validation failed: hostname {0} does not match common name {1}", string, object2));
        }
        return bl;
    }

    public boolean verifyHostName(@Nullable String string, @Nullable String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        int n = string2.lastIndexOf(42);
        if (n == -1) {
            return string.equalsIgnoreCase(string2);
        }
        if (n > 0) {
            return false;
        }
        if (string2.indexOf(46) == -1) {
            return false;
        }
        if (string.length() < string2.length() - 1) {
            return false;
        }
        boolean bl = true;
        int n2 = string.length() - string2.length() + 1;
        if (string.lastIndexOf(46, n2 - 1) >= 0) {
            return false;
        }
        return string.regionMatches(true, n2, string2, 1, string2.length() - 1);
    }
}

