/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.util;

import com.hm.postgresql.util.internal.Nullness;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.checker.regex.qual.Regex;

public class ExpressionProperties
extends Properties {
    private static final @Regex(value=1) Pattern EXPRESSION = Pattern.compile("\\$\\{([^}]+)\\}");
    private final Properties[] defaults;

    public ExpressionProperties(Properties ... propertiesArray) {
        this.defaults = propertiesArray;
    }

    @Override
    public @Nullable String getProperty(String string) {
        String string2 = this.getRawPropertyValue(string);
        return this.replaceProperties(string2);
    }

    @Override
    public @PolyNull String getProperty(String string, @PolyNull String string2) {
        String string3 = this.getRawPropertyValue(string);
        if (string3 == null) {
            string3 = string2;
        }
        return this.replaceProperties(string3);
    }

    public @Nullable String getRawPropertyValue(String string) {
        String string2 = super.getProperty(string);
        if (string2 != null) {
            return string2;
        }
        for (Properties properties : this.defaults) {
            string2 = properties.getProperty(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    private @PolyNull String replaceProperties(@PolyNull String string) {
        if (string == null) {
            return null;
        }
        Matcher matcher = EXPRESSION.matcher(string);
        StringBuffer stringBuffer = null;
        while (matcher.find()) {
            String string2;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            if ((string2 = this.getProperty(Nullness.castNonNull(matcher.group(1)))) == null) {
                string2 = matcher.group();
            }
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(string2));
        }
        if (stringBuffer == null) {
            return string;
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }
}

