/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.util;

import com.hm.postgresql.core.Encoding;
import com.hm.postgresql.util.ByteConverter;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HStoreConverter {
    public static Map<String, @Nullable String> fromBytes(byte[] byArray, Encoding encoding) {
        HashMap<String, @Nullable String> hashMap = new HashMap<String, String>();
        int n = 0;
        int n2 = ByteConverter.int4(byArray, n);
        n += 4;
        try {
            for (int i = 0; i < n2; ++i) {
                String string;
                int n3 = ByteConverter.int4(byArray, n);
                String string2 = encoding.decode(byArray, n += 4, n3);
                int n4 = ByteConverter.int4(byArray, n += n3);
                n += 4;
                if (n4 == -1) {
                    string = null;
                } else {
                    string = encoding.decode(byArray, n, n4);
                    n += n4;
                }
                hashMap.put(string2, string);
            }
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Invalid character data was found.  This is most likely caused by stored data containing characters that are invalid for the character set the database was created in.  The most common example of this is storing 8bit data in a SQL_ASCII database.", new Object[0]), PSQLState.DATA_ERROR, (Throwable)iOException);
        }
        return hashMap;
    }

    public static byte[] toBytes(Map<?, ?> map, Encoding encoding) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4 + 10 * map.size());
        byte[] byArray = new byte[4];
        try {
            ByteConverter.int4(byArray, 0, map.size());
            byteArrayOutputStream.write(byArray);
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                Object obj = entry.getKey();
                if (obj == null) {
                    throw new PSQLException(GT.tr("hstore key must not be null", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
                }
                byte[] byArray2 = encoding.encode(obj.toString());
                ByteConverter.int4(byArray, 0, byArray2.length);
                byteArrayOutputStream.write(byArray);
                byteArrayOutputStream.write(byArray2);
                if (entry.getValue() == null) {
                    ByteConverter.int4(byArray, 0, -1);
                    byteArrayOutputStream.write(byArray);
                    continue;
                }
                byte[] byArray3 = encoding.encode(entry.getValue().toString());
                ByteConverter.int4(byArray, 0, byArray3.length);
                byteArrayOutputStream.write(byArray);
                byteArrayOutputStream.write(byArray3);
            }
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Invalid character data was found.  This is most likely caused by stored data containing characters that are invalid for the character set the database was created in.  The most common example of this is storing 8bit data in a SQL_ASCII database.", new Object[0]), PSQLState.DATA_ERROR, (Throwable)iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String toString(Map<?, ?> map) {
        if (map.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(map.size() * 8);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            HStoreConverter.appendEscaped(stringBuilder, entry.getKey());
            stringBuilder.append("=>");
            HStoreConverter.appendEscaped(stringBuilder, entry.getValue());
            stringBuilder.append(", ");
        }
        stringBuilder.setLength(stringBuilder.length() - 2);
        return stringBuilder.toString();
    }

    private static void appendEscaped(StringBuilder stringBuilder, @Nullable Object object) {
        if (object != null) {
            stringBuilder.append('\"');
            String string = object.toString();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\"' || c == '\\') {
                    stringBuilder.append('\\');
                }
                stringBuilder.append(c);
            }
            stringBuilder.append('\"');
        } else {
            stringBuilder.append("NULL");
        }
    }

    public static Map<String, @Nullable String> fromString(String string) {
        HashMap<String, @Nullable String> hashMap = new HashMap<String, String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            String string2;
            stringBuilder.setLength(0);
            int n = string.indexOf(34, i);
            int n2 = HStoreConverter.appendUntilQuote(stringBuilder, string, n);
            String string3 = stringBuilder.toString();
            i = n2 + 3;
            if (string.charAt(i) == 'N') {
                string2 = null;
                i += 4;
            } else {
                stringBuilder.setLength(0);
                n2 = HStoreConverter.appendUntilQuote(stringBuilder, string, i);
                string2 = stringBuilder.toString();
                i = n2;
            }
            hashMap.put(string3, string2);
        }
        return hashMap;
    }

    private static int appendUntilQuote(StringBuilder stringBuilder, String string, int n) {
        char c;
        ++n;
        while (n < string.length() && (c = string.charAt(n)) != '\"') {
            if (c == '\\') {
                c = string.charAt(++n);
            }
            stringBuilder.append(c);
            ++n;
        }
        return n;
    }
}

