/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.util;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HostSpec {
    public static final String DEFAULT_NON_PROXY_HOSTS = "localhost|127.*|[::1]|0.0.0.0|[::0]";
    protected final @Nullable String localSocketAddress;
    protected final String host;
    protected final int port;

    public HostSpec(String string, int n) {
        this(string, n, null);
    }

    public HostSpec(String string, int n, @Nullable String string2) {
        this.host = string;
        this.port = n;
        this.localSocketAddress = string2;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.host + ":" + this.port;
    }

    public boolean equals(@Nullable Object object) {
        return object instanceof HostSpec && this.port == ((HostSpec)object).port && this.host.equals(((HostSpec)object).host) && Objects.equals(this.localSocketAddress, ((HostSpec)object).localSocketAddress);
    }

    public int hashCode() {
        return Objects.hash(this.localSocketAddress, this.host, this.port);
    }

    public @Nullable String getLocalSocketAddress() {
        return this.localSocketAddress;
    }

    public Boolean shouldResolve() {
        String string = System.getProperty("socksProxyHost");
        if (string == null || string.trim().isEmpty()) {
            return true;
        }
        return this.matchesNonProxyHosts();
    }

    private Boolean matchesNonProxyHosts() {
        String string = System.getProperty("socksNonProxyHosts", DEFAULT_NON_PROXY_HOSTS);
        if (string == null || this.host.isEmpty()) {
            return false;
        }
        Pattern pattern = this.toPattern(string);
        Matcher matcher = pattern == null ? null : pattern.matcher(this.host);
        return matcher != null && matcher.matches();
    }

    private @Nullable Pattern toPattern(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "";
        for (String string3 : string.split("\\|")) {
            if (string3.isEmpty()) continue;
            String string4 = this.disjunctToRegex(string3.toLowerCase());
            stringBuilder.append(string2).append(string4);
            string2 = "|";
        }
        return stringBuilder.length() == 0 ? null : Pattern.compile(stringBuilder.toString());
    }

    private String disjunctToRegex(String string) {
        String string2 = string.startsWith("*") ? ".*" + Pattern.quote(string.substring(1)) : (string.endsWith("*") ? Pattern.quote(string.substring(0, string.length() - 1)) + ".*" : Pattern.quote(string));
        return string2;
    }
}

