/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.util;

import java.io.Writer;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LogWriterHandler
extends Handler {
    private @Nullable Writer writer;
    private final Object lock = new Object();

    public LogWriterHandler(Writer writer) {
        this.setLevel(Level.INFO);
        this.setFilter(null);
        this.setFormatter(new SimpleFormatter());
        this.setWriter(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord logRecord) {
        String string;
        Formatter formatter = this.getFormatter();
        try {
            string = formatter.format(logRecord);
        }
        catch (Exception exception) {
            this.reportError("Error Formatting record", exception, 5);
            return;
        }
        if (string.length() == 0) {
            return;
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                Writer writer = this.writer;
                if (writer != null) {
                    writer.write(string);
                }
            }
        }
        catch (Exception exception) {
            this.reportError("Error writing message", exception, 1);
        }
    }

    @Override
    public void flush() {
        try {
            Writer writer = this.writer;
            if (writer != null) {
                writer.flush();
            }
        }
        catch (Exception exception) {
            this.reportError("Error on flush", exception, 1);
        }
    }

    @Override
    public void close() {
        try {
            Writer writer = this.writer;
            if (writer != null) {
                writer.close();
            }
        }
        catch (Exception exception) {
            this.reportError("Error closing writer", exception, 1);
        }
    }

    private void setWriter(Writer writer) {
        if (writer == null) {
            throw new IllegalArgumentException("Writer cannot be null");
        }
        this.writer = writer;
        try {
            writer.write(this.getFormatter().getHead(this));
        }
        catch (Exception exception) {
            this.reportError("Error writing head section", exception, 1);
        }
    }
}

