/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.util;

import com.hm.postgresql.util.CanEstimateSize;
import com.hm.postgresql.util.Gettable;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LruCache<Key, Value extends CanEstimateSize>
implements Gettable<Key, Value> {
    private final @Nullable EvictAction<Value> onEvict;
    private final @Nullable CreateAction<Key, Value> createAction;
    private final int maxSizeEntries;
    private final long maxSizeBytes;
    private long currentSize;
    private final Map<Key, Value> cache;

    private void evictValue(Value Value2) {
        try {
            if (this.onEvict != null) {
                this.onEvict.evict(Value2);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public LruCache(int n, long l, boolean bl) {
        this(n, l, bl, null, null);
    }

    public LruCache(int n, long l, boolean bl, @Nullable CreateAction<Key, Value> createAction, @Nullable EvictAction<Value> evictAction) {
        this.maxSizeEntries = n;
        this.maxSizeBytes = l;
        this.createAction = createAction;
        this.onEvict = evictAction;
        this.cache = new LimitedMap(16, 0.75f, bl);
    }

    @Override
    public synchronized @Nullable Value get(Key Key2) {
        return (Value)((CanEstimateSize)this.cache.get(Key2));
    }

    public synchronized Value borrow(Key Key2) {
        CanEstimateSize canEstimateSize = (CanEstimateSize)this.cache.remove(Key2);
        if (canEstimateSize == null) {
            if (this.createAction == null) {
                throw new UnsupportedOperationException("createAction == null, so can't create object");
            }
            return (Value)((CanEstimateSize)this.createAction.create(Key2));
        }
        this.currentSize -= canEstimateSize.getSize();
        return (Value)canEstimateSize;
    }

    public synchronized void put(Key Key2, Value Value2) {
        long l = Value2.getSize();
        if (this.maxSizeBytes == 0L || this.maxSizeEntries == 0 || l * 2L > this.maxSizeBytes) {
            this.evictValue(Value2);
            return;
        }
        this.currentSize += l;
        @Nullable CanEstimateSize canEstimateSize = (CanEstimateSize)this.cache.put(Key2, Value2);
        if (canEstimateSize == null) {
            return;
        }
        this.currentSize -= canEstimateSize.getSize();
        if (canEstimateSize != Value2) {
            this.evictValue(canEstimateSize);
        }
    }

    public synchronized void putAll(Map<Key, Value> map) {
        for (Map.Entry<Key, Value> entry : map.entrySet()) {
            this.put(entry.getKey(), (CanEstimateSize)entry.getValue());
        }
    }

    private class LimitedMap
    extends LinkedHashMap<Key, Value> {
        LimitedMap(int n, float f, boolean bl) {
            super(n, f, bl);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Key, Value> entry) {
            if (this.size() <= LruCache.this.maxSizeEntries && LruCache.this.currentSize <= LruCache.this.maxSizeBytes) {
                return false;
            }
            Iterator iterator = this.entrySet().iterator();
            while (iterator.hasNext()) {
                if (this.size() <= LruCache.this.maxSizeEntries && LruCache.this.currentSize <= LruCache.this.maxSizeBytes) {
                    return false;
                }
                Map.Entry entry2 = iterator.next();
                LruCache.this.evictValue((CanEstimateSize)entry2.getValue());
                long l = ((CanEstimateSize)entry2.getValue()).getSize();
                if (l > 0L) {
                    LruCache.this.currentSize = LruCache.this.currentSize - l;
                }
                iterator.remove();
            }
            return false;
        }
    }

    public static interface CreateAction<Key, Value> {
        public Value create(Key var1) throws SQLException;
    }

    public static interface EvictAction<Value> {
        public void evict(Value var1) throws SQLException;
    }
}

