/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.util;

import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PGPropertyMaxResultBufferParser {
    private static final Logger LOGGER = Logger.getLogger(PGPropertyMaxResultBufferParser.class.getName());
    private static final String[] PERCENT_PHRASES = new String[]{"p", "pct", "percent"};

    public static long parseProperty(@Nullable String string) {
        long l = -1L;
        if (string != null) {
            if (PGPropertyMaxResultBufferParser.checkIfValueContainsPercent(string)) {
                l = PGPropertyMaxResultBufferParser.parseBytePercentValue(string);
            } else if (!string.isEmpty()) {
                l = PGPropertyMaxResultBufferParser.parseByteValue(string);
            }
        }
        l = PGPropertyMaxResultBufferParser.adjustResultSize(l);
        return l;
    }

    private static boolean checkIfValueContainsPercent(String string) {
        return PGPropertyMaxResultBufferParser.getPercentPhraseLengthIfContains(string) != -1;
    }

    private static long parseBytePercentValue(String string) {
        long l = -1L;
        if (!string.isEmpty()) {
            int n = PGPropertyMaxResultBufferParser.getPercentPhraseLengthIfContains(string);
            if (n == -1) {
                PGPropertyMaxResultBufferParser.throwExceptionAboutParsingError("Received MaxResultBuffer parameter can't be parsed. Value received to parse: {0}", string);
            }
            l = PGPropertyMaxResultBufferParser.calculatePercentOfMemory(string, n);
        }
        return l;
    }

    private static int getPercentPhraseLengthIfContains(String string) {
        int n = -1;
        for (String string2 : PERCENT_PHRASES) {
            int n2 = PGPropertyMaxResultBufferParser.getPhraseLengthIfContains(string, string2);
            if (n2 == -1) continue;
            n = n2;
        }
        return n;
    }

    private static int getPhraseLengthIfContains(String string, String string2) {
        String string3;
        int n = string2.length();
        if (string.length() > n && (string3 = string.substring(string.length() - n)).equals(string2)) {
            return n;
        }
        return -1;
    }

    private static long calculatePercentOfMemory(String string, int n) {
        String string2 = string.substring(0, string.length() - n);
        double d = Double.parseDouble(string2) / 100.0;
        long l = (long)(d * (double)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax());
        return l;
    }

    private static long parseByteValue(String string) {
        long l = -1L;
        long l2 = 1L;
        long l3 = 1000L;
        char c = string.charAt(string.length() - 1);
        switch (c) {
            case 'T': 
            case 't': {
                l2 *= l3;
            }
            case 'G': 
            case 'g': {
                l2 *= l3;
            }
            case 'M': 
            case 'm': {
                l2 *= l3;
            }
            case 'K': 
            case 'k': {
                String string2 = string.substring(0, string.length() - 1);
                l = (long)Integer.parseInt(string2) * (l2 *= l3);
                break;
            }
            case '%': {
                return l;
            }
            default: {
                if (c >= '0' && c <= '9') {
                    l = Long.parseLong(string);
                    break;
                }
                PGPropertyMaxResultBufferParser.throwExceptionAboutParsingError("Received MaxResultBuffer parameter can't be parsed. Value received to parse: {0}", string);
            }
        }
        return l;
    }

    private static long adjustResultSize(long l) {
        if ((double)l > 0.9 * (double)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax()) {
            long l2 = (long)(0.9 * (double)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax());
            LOGGER.log(Level.WARNING, GT.tr("WARNING! Required to allocate {0} bytes, which exceeded possible heap memory size. Assigned {1} bytes as limit.", String.valueOf(l), String.valueOf(l2)));
            l = l2;
        }
        return l;
    }

    private static void throwExceptionAboutParsingError(String string, Object ... objectArray) {
        throw new PSQLException(GT.tr(string, objectArray), PSQLState.SYNTAX_ERROR);
    }
}

