/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.util;

import org.checkerframework.checker.nullness.qual.PolyNull;

public class PGbytea {
    private static final int MAX_3_BUFF_SIZE = 0x200000;
    private static final int[] HEX_VALS;

    public static byte @PolyNull [] toBytes(byte @PolyNull [] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length < 2 || byArray[0] != 92 || byArray[1] != 120) {
            return PGbytea.toBytesOctalEscaped(byArray);
        }
        return PGbytea.toBytesHexEscaped(byArray);
    }

    private static byte[] toBytesHexEscaped(byte[] byArray) {
        int n = byArray.length - 2;
        byte[] byArray2 = new byte[n >>> 1];
        for (int i = 0; i < n; i += 2) {
            int n2 = PGbytea.getHex(byArray[2 + i]) << 4;
            byArray2[i >>> 1] = (byte)(n2 |= PGbytea.getHex(byArray[3 + i]));
        }
        return byArray2;
    }

    private static int getHex(byte by) {
        return HEX_VALS[by - 48];
    }

    private static byte[] toBytesOctalEscaped(byte[] byArray) {
        byte by;
        int n;
        int n2;
        int n3 = byArray.length;
        byte[] byArray2 = null;
        int n4 = n3;
        if (n3 > 0x200000) {
            for (n2 = 0; n2 < n3; ++n2) {
                n = byArray[n2];
                if (n != 92) continue;
                if ((by = byArray[++n2]) == 92) {
                    --n4;
                    continue;
                }
                n4 -= 3;
            }
            byArray2 = new byte[n4];
        } else {
            byArray2 = new byte[n3];
        }
        n2 = 0;
        for (int i = 0; i < n3; ++i) {
            by = byArray[i];
            if (by == 92) {
                byte by2;
                if ((by2 = byArray[++i]) == 92) {
                    byArray2[n2++] = 92;
                    continue;
                }
                if ((n = (by2 - 48) * 64 + (byArray[++i] - 48) * 8 + (byArray[++i] - 48)) > 127) {
                    n -= 256;
                }
                byArray2[n2++] = (byte)n;
                continue;
            }
            byArray2[n2++] = by;
        }
        if (n2 == n4) {
            return byArray2;
        }
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray2, 0, byArray3, 0, n2);
        return byArray3;
    }

    public static @PolyNull String toPGString(byte @PolyNull [] byArray) {
        if (byArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
        for (int n : byArray) {
            int n2 = n;
            if (n2 < 0) {
                n2 = 256 + n2;
            }
            if (n2 < 32 || n2 > 126) {
                stringBuilder.append("\\");
                stringBuilder.append((char)((n2 >> 6 & 3) + 48));
                stringBuilder.append((char)((n2 >> 3 & 7) + 48));
                stringBuilder.append((char)((n2 & 7) + 48));
                continue;
            }
            if (n == 92) {
                stringBuilder.append("\\\\");
                continue;
            }
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    static {
        int n;
        HEX_VALS = new int[55];
        for (n = 0; n < 10; ++n) {
            PGbytea.HEX_VALS[n] = (byte)n;
        }
        for (n = 0; n < 6; ++n) {
            PGbytea.HEX_VALS[65 + n - 48] = (byte)(10 + n);
            PGbytea.HEX_VALS[97 + n - 48] = (byte)(10 + n);
        }
    }
}

