/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PGtokenizer {
    private static final Map<Character, Character> CLOSING_TO_OPENING_CHARACTER = new HashMap<Character, Character>();
    protected List<String> tokens = new ArrayList<String>();

    public PGtokenizer(String string, char c) {
        this.tokenize(string, c);
    }

    public int tokenize(String string, char c) {
        this.tokens.clear();
        ArrayDeque<Character> arrayDeque = new ArrayDeque<Character>();
        boolean bl = false;
        boolean bl2 = false;
        char c2 = '\u0000';
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            c2 = string.charAt(i);
            if (c2 == '(' || c2 == '[' || c2 == '<' || !bl2 && !bl && c2 == '\"') {
                arrayDeque.push(Character.valueOf(c2));
                if (c2 == '\"') {
                    bl2 = true;
                    bl = true;
                }
            }
            if (c2 == ')' || c2 == ']' || c2 == '>' || bl2 && !bl && c2 == '\"') {
                if (c2 == '\"') {
                    while (!arrayDeque.isEmpty() && !Character.valueOf('\"').equals(arrayDeque.peek())) {
                        arrayDeque.pop();
                    }
                    bl2 = false;
                    arrayDeque.pop();
                } else {
                    Character c3 = CLOSING_TO_OPENING_CHARACTER.get(Character.valueOf(c2));
                    if (!arrayDeque.isEmpty() && c3 != null && c3.equals(arrayDeque.peek())) {
                        arrayDeque.pop();
                    }
                }
            }
            boolean bl3 = bl = c2 == '\\';
            if (!arrayDeque.isEmpty() || c2 != c) continue;
            this.tokens.add(string.substring(n, i));
            n = i + 1;
        }
        if (n < string.length()) {
            this.tokens.add(string.substring(n));
        }
        if (n == string.length() && c2 == c) {
            this.tokens.add("");
        }
        return this.tokens.size();
    }

    public int getSize() {
        return this.tokens.size();
    }

    public String getToken(int n) {
        return this.tokens.get(n);
    }

    public PGtokenizer tokenizeToken(int n, char c) {
        return new PGtokenizer(this.getToken(n), c);
    }

    public static String remove(String string, String string2, String string3) {
        if (string.startsWith(string2)) {
            string = string.substring(string2.length());
        }
        if (string.endsWith(string3)) {
            string = string.substring(0, string.length() - string3.length());
        }
        return string;
    }

    public void remove(String string, String string2) {
        for (int i = 0; i < this.tokens.size(); ++i) {
            this.tokens.set(i, PGtokenizer.remove(this.tokens.get(i), string, string2));
        }
    }

    public static String removePara(String string) {
        return PGtokenizer.remove(string, "(", ")");
    }

    public void removePara() {
        this.remove("(", ")");
    }

    public static String removeBox(String string) {
        return PGtokenizer.remove(string, "[", "]");
    }

    public void removeBox() {
        this.remove("[", "]");
    }

    public static String removeAngle(String string) {
        return PGtokenizer.remove(string, "<", ">");
    }

    public void removeAngle() {
        this.remove("<", ">");
    }

    public static String removeCurlyBrace(String string) {
        return PGtokenizer.remove(string, "{", "}");
    }

    public void removeCurlyBrace() {
        this.remove("{", "}");
    }

    static {
        CLOSING_TO_OPENING_CHARACTER.put(Character.valueOf(')'), Character.valueOf('('));
        CLOSING_TO_OPENING_CHARACTER.put(Character.valueOf(']'), Character.valueOf('['));
        CLOSING_TO_OPENING_CHARACTER.put(Character.valueOf('>'), Character.valueOf('<'));
        CLOSING_TO_OPENING_CHARACTER.put(Character.valueOf('\"'), Character.valueOf('\"'));
    }
}

