/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.util;

import com.hm.postgresql.core.EncodingPredictor;
import com.hm.postgresql.util.GT;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ServerErrorMessage
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(ServerErrorMessage.class.getName());
    private static final Character SEVERITY = Character.valueOf('S');
    private static final Character MESSAGE = Character.valueOf('M');
    private static final Character DETAIL = Character.valueOf('D');
    private static final Character HINT = Character.valueOf('H');
    private static final Character POSITION = Character.valueOf('P');
    private static final Character WHERE = Character.valueOf('W');
    private static final Character FILE = Character.valueOf('F');
    private static final Character LINE = Character.valueOf('L');
    private static final Character ROUTINE = Character.valueOf('R');
    private static final Character SQLSTATE = Character.valueOf('C');
    private static final Character INTERNAL_POSITION = Character.valueOf('p');
    private static final Character INTERNAL_QUERY = Character.valueOf('q');
    private static final Character SCHEMA = Character.valueOf('s');
    private static final Character TABLE = Character.valueOf('t');
    private static final Character COLUMN = Character.valueOf('c');
    private static final Character DATATYPE = Character.valueOf('d');
    private static final Character CONSTRAINT = Character.valueOf('n');
    private final Map<Character, String> mesgParts = new HashMap<Character, String>();

    public ServerErrorMessage(EncodingPredictor.DecodeResult decodeResult) {
        this(decodeResult.result);
        if (decodeResult.encoding != null) {
            this.mesgParts.put(MESSAGE, this.mesgParts.get(MESSAGE) + GT.tr(" (pgjdbc: autodetected server-encoding to be {0}, if the message is not readable, please check database logs and/or host, port, dbname, user, password, pg_hba.conf)", decodeResult.encoding));
        }
    }

    public ServerErrorMessage(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c == '\u0000') continue;
            int n2 = ++i;
            while (i < n && cArray[i] != '\u0000') {
                ++i;
            }
            String string2 = new String(cArray, n2, i - n2);
            this.mesgParts.put(Character.valueOf(c), string2);
        }
    }

    public @Nullable String getSQLState() {
        return this.mesgParts.get(SQLSTATE);
    }

    public @Nullable String getMessage() {
        return this.mesgParts.get(MESSAGE);
    }

    public @Nullable String getSeverity() {
        return this.mesgParts.get(SEVERITY);
    }

    public @Nullable String getDetail() {
        return this.mesgParts.get(DETAIL);
    }

    public @Nullable String getHint() {
        return this.mesgParts.get(HINT);
    }

    public int getPosition() {
        return this.getIntegerPart(POSITION);
    }

    public @Nullable String getWhere() {
        return this.mesgParts.get(WHERE);
    }

    public @Nullable String getSchema() {
        return this.mesgParts.get(SCHEMA);
    }

    public @Nullable String getTable() {
        return this.mesgParts.get(TABLE);
    }

    public @Nullable String getColumn() {
        return this.mesgParts.get(COLUMN);
    }

    public @Nullable String getDatatype() {
        return this.mesgParts.get(DATATYPE);
    }

    public @Nullable String getConstraint() {
        return this.mesgParts.get(CONSTRAINT);
    }

    public @Nullable String getFile() {
        return this.mesgParts.get(FILE);
    }

    public int getLine() {
        return this.getIntegerPart(LINE);
    }

    public @Nullable String getRoutine() {
        return this.mesgParts.get(ROUTINE);
    }

    public @Nullable String getInternalQuery() {
        return this.mesgParts.get(INTERNAL_QUERY);
    }

    public int getInternalPosition() {
        return this.getIntegerPart(INTERNAL_POSITION);
    }

    private int getIntegerPart(Character c) {
        String string = this.mesgParts.get(c);
        if (string == null) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    String getNonSensitiveErrorMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.mesgParts.get(SEVERITY);
        if (string != null) {
            stringBuilder.append(string).append(": ");
        }
        if ((string = this.mesgParts.get(MESSAGE)) != null) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.mesgParts.get(SEVERITY);
        if (string != null) {
            stringBuilder.append(string).append(": ");
        }
        if ((string = this.mesgParts.get(MESSAGE)) != null) {
            stringBuilder.append(string);
        }
        if ((string = this.mesgParts.get(DETAIL)) != null) {
            stringBuilder.append("\n  ").append(GT.tr("Detail: {0}", string));
        }
        if ((string = this.mesgParts.get(HINT)) != null) {
            stringBuilder.append("\n  ").append(GT.tr("Hint: {0}", string));
        }
        if ((string = this.mesgParts.get(POSITION)) != null) {
            stringBuilder.append("\n  ").append(GT.tr("Position: {0}", string));
        }
        if ((string = this.mesgParts.get(WHERE)) != null) {
            stringBuilder.append("\n  ").append(GT.tr("Where: {0}", string));
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            String string2;
            String string3 = this.mesgParts.get(INTERNAL_QUERY);
            if (string3 != null) {
                stringBuilder.append("\n  ").append(GT.tr("Internal Query: {0}", string3));
            }
            if ((string2 = this.mesgParts.get(INTERNAL_POSITION)) != null) {
                stringBuilder.append("\n  ").append(GT.tr("Internal Position: {0}", string2));
            }
            String string4 = this.mesgParts.get(FILE);
            String string5 = this.mesgParts.get(LINE);
            String string6 = this.mesgParts.get(ROUTINE);
            if (string4 != null || string5 != null || string6 != null) {
                stringBuilder.append("\n  ").append(GT.tr("Location: File: {0}, Routine: {1}, Line: {2}", string4, string6, string5));
            }
            if ((string = this.mesgParts.get(SQLSTATE)) != null) {
                stringBuilder.append("\n  ").append(GT.tr("Server SQLState: {0}", string));
            }
        }
        return stringBuilder.toString();
    }
}

