/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.util;

import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.util.internal.Nullness;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StreamWrapper {
    private static final int MAX_MEMORY_BUFFER_BYTES = 51200;
    private static final String TEMP_FILE_PREFIX = "postgres-pgjdbc-stream";
    private final @Nullable InputStream stream;
    private final byte @Nullable [] rawData;
    private final int offset;
    private final int length;

    public StreamWrapper(byte[] byArray, int n, int n2) {
        this.stream = null;
        this.rawData = byArray;
        this.offset = n;
        this.length = n2;
    }

    public StreamWrapper(InputStream inputStream, int n) {
        this.stream = inputStream;
        this.rawData = null;
        this.offset = 0;
        this.length = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamWrapper(InputStream inputStream) {
        block8: {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n = StreamWrapper.copyStream(inputStream, byteArrayOutputStream, 51200);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                if (n == -1) {
                    int n2;
                    final File file = File.createTempFile(TEMP_FILE_PREFIX, null);
                    fileOutputStream.write(byArray);
                    try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                        n2 = StreamWrapper.copyStream(inputStream, fileOutputStream, Integer.MAX_VALUE - byArray.length);
                        if (n2 == -1) {
                            throw new PSQLException(GT.tr("Object is too large to send over the protocol.", new Object[0]), PSQLState.NUMERIC_CONSTANT_OUT_OF_RANGE);
                        }
                        fileOutputStream.flush();
                    }
                    this.offset = 0;
                    this.length = byArray.length + n2;
                    this.rawData = null;
                    this.stream = new FileInputStream(file){
                        private boolean closed;
                        private int position;
                        {
                            super(file3);
                            this.closed = false;
                            this.position = 0;
                        }

                        private void checkShouldClose(int n) {
                            if (n == -1) {
                                this.close();
                            } else {
                                this.position += n;
                                if (this.position >= StreamWrapper.this.length) {
                                    this.close();
                                }
                            }
                        }

                        @Override
                        public int read(byte[] byArray) {
                            if (this.closed) {
                                return -1;
                            }
                            int n = super.read(byArray);
                            this.checkShouldClose(n);
                            return n;
                        }

                        @Override
                        public int read(byte[] byArray, int n, int n2) {
                            if (this.closed) {
                                return -1;
                            }
                            int n3 = super.read(byArray, n, n2);
                            this.checkShouldClose(n3);
                            return n3;
                        }

                        @Override
                        public void close() {
                            if (!this.closed) {
                                super.close();
                                file.delete();
                                this.closed = true;
                            }
                        }

                        protected void finalize() {
                            this.close();
                            try {
                                super.finalize();
                            }
                            catch (RuntimeException runtimeException) {
                                throw runtimeException;
                            }
                            catch (Error error) {
                                throw error;
                            }
                            catch (IOException iOException) {
                                throw iOException;
                            }
                            catch (Throwable throwable) {
                                throw new RuntimeException("Unexpected exception from finalize", throwable);
                            }
                        }
                    };
                    break block8;
                }
                this.rawData = byArray;
                this.stream = null;
                this.offset = 0;
                this.length = byArray.length;
            }
            catch (IOException iOException) {
                throw new PSQLException(GT.tr("An I/O error occurred while sending to the backend.", new Object[0]), PSQLState.IO_ERROR, (Throwable)iOException);
            }
        }
    }

    public InputStream getStream() {
        if (this.stream != null) {
            return this.stream;
        }
        return new ByteArrayInputStream(Nullness.castNonNull(this.rawData), this.offset, this.length);
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public byte @Nullable [] getBytes() {
        return this.rawData;
    }

    public String toString() {
        return "<stream of " + this.length + " bytes>";
    }

    private static int copyStream(InputStream inputStream, OutputStream outputStream, int n) {
        int n2 = 0;
        byte[] byArray = new byte[2048];
        int n3 = inputStream.read(byArray);
        while (n3 > 0) {
            outputStream.write(byArray, 0, n3);
            if ((n2 += n3) >= n) {
                return -1;
            }
            n3 = inputStream.read(byArray);
        }
        return n2;
    }
}

