/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.chest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import us.lynuxcraft.deadsilenceiv.advancedchests.AdvancedChestsPlugin;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.AdvancedChest;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.ChestType;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.ContainerType;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.containers.Container;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.SubChestInventory;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.page.BasePage;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.title.ChestTitle;
import us.lynuxcraft.deadsilenceiv.advancedchests.events.ChestRemoveEvent;
import us.lynuxcraft.deadsilenceiv.advancedchests.managers.ChestsManager;
import us.lynuxcraft.deadsilenceiv.advancedchests.managers.DataHandler;
import us.lynuxcraft.deadsilenceiv.advancedchests.managers.DataManager;
import us.lynuxcraft.deadsilenceiv.advancedchests.managers.InventoryManager;
import us.lynuxcraft.deadsilenceiv.advancedchests.managers.TaskManager;
import us.lynuxcraft.deadsilenceiv.advancedchests.managers.yml.config.Configuration;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.ChestsProvider;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.HologramProvider;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.SellType;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.SortStatus;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.WorthProvider;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.sorter.SortType;
import us.lynuxcraft.deadsilenceiv.advancedchests.tasks.AutomaticSell;
import us.lynuxcraft.deadsilenceiv.advancedchests.tasks.compress.DirectCompressProcess;
import us.lynuxcraft.deadsilenceiv.advancedchests.tasks.sells.AutomatedSellProcess;
import us.lynuxcraft.deadsilenceiv.advancedchests.tasks.sells.DirectSellProcess;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.ChunkLocation;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.InsightsUtils;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.LocationUtils;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.PlayerUtils;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.InteractiveInventory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.xseries.XBlock;

public abstract class BaseChest<I, T extends BasePage<I>>
implements AdvancedChest<I, T> {
    protected AdvancedChestsPlugin plugin = AdvancedChestsPlugin.getInstance();
    protected DataManager dataManager = this.plugin.getDataManager();
    protected ChestsManager chestsManager = this.plugin.getChestsManager();
    protected Configuration config = this.plugin.getConfiguration();
    protected InventoryManager inventoryManager = this.plugin.getInventoryManager();
    protected TaskManager taskManager = this.plugin.getTaskManager();
    protected Economy economy = this.plugin.getEcon();
    private UUID a;
    private Map<Integer, T> b = new HashMap<Integer, T>();
    private String c;
    private ChestType d;
    private Container e;
    private Integer f;
    private ChestTitle g;
    private boolean h;
    @Nullable
    private UUID i;
    @Nullable
    private UUID j;
    @Nullable
    private BlockFace k;
    private double l;
    private Set<InteractiveInventory> m;
    public Map<UUID, @Nullable ItemStack> changingPagePlayers;
    public Map<UUID, Integer> lastOpenedPages;
    private String n;
    private Location o;
    private ChunkLocation p;
    private boolean q;
    private Integer r;

    public BaseChest(int n, String string, ChestType chestType, String string2) {
        this.a = UUID.randomUUID();
        this.f = n;
        this.d = chestType;
        this.e = ContainerType.CHEST.getContainer();
        this.c = string;
        this.n = string2;
        this.l = 0.0;
        this.h = false;
        BaseChest baseChest = this;
        if (LocationUtils.verify(baseChest.getLocation())) {
            baseChest.p = new ChunkLocation(baseChest.getLocation());
        }
        this.m = new HashSet<InteractiveInventory>();
        this.changingPagePlayers = new HashMap<UUID, ItemStack>();
        this.lastOpenedPages = new HashMap<UUID, Integer>();
        this.q = false;
    }

    boolean load() {
        boolean bl;
        if (!this.canBeLoaded()) {
            return false;
        }
        BaseChest baseChest = this;
        if (!baseChest.b.isEmpty()) {
            baseChest.c();
            bl = true;
        } else {
            int n = (int)Math.floor((double)baseChest.f.intValue() / 45.0);
            int n2 = baseChest.f / 9;
            if (baseChest.f > 45) {
                int n3 = baseChest.f % 45 == 0 ? n - 1 : n;
                n = baseChest.f % 45 != 0 ? (n2 - n * 5) * 9 : 45;
                for (n2 = 0; n2 <= n3; ++n2) {
                    baseChest.b.put(n2, n2 < n3 ? baseChest.newPage(n2, baseChest.newContentArray(45)) : baseChest.newPage(n2, baseChest.newContentArray(n)));
                }
            } else {
                BaseChest baseChest2 = baseChest;
                baseChest.b.put(0, baseChest.newPage(0, baseChest2.newContentArray(baseChest2.f)));
            }
            baseChest.c();
            bl = false;
        }
        if (!bl) {
            this.save();
        }
        this.h();
        return true;
    }

    @Override
    public void loadEntity() {
        if (!this.canBeLoaded() || this.p == null || !this.p.isLoaded()) {
            return;
        }
        this.g();
        Block block = this.getLocation().getBlock();
        this.e.checkBlock(this.getLocation(), this.k);
        Object object = block;
        BaseChest baseChest = this;
        if (baseChest.k == null) {
            baseChest.k = XBlock.getDirection((Block)object);
        }
        block = (InventoryHolder)block.getState();
        block = block.getInventory();
        object = block;
        baseChest = this;
        for (HumanEntity humanEntity : new ArrayList(object.getViewers())) {
            baseChest.openPage(humanEntity, 0);
        }
        this.b((Inventory)block);
        this.q = true;
    }

    @Override
    public void unLoadEntity() {
        if (!this.q) {
            return;
        }
        if (this.g != null) {
            this.g.delete();
        }
        Inventory inventory = ((InventoryHolder)this.getLocation().getBlock().getState()).getInventory();
        inventory.clear();
    }

    private boolean a() {
        if (!this.b.isEmpty()) {
            this.c();
            return true;
        }
        this.b();
        return false;
    }

    private void a(Block block) {
        if (this.k == null) {
            this.k = XBlock.getDirection(block);
        }
    }

    private void a(Inventory object) {
        for (HumanEntity humanEntity : new ArrayList(object.getViewers())) {
            this.openPage(humanEntity, 0);
        }
    }

    private void b(Inventory inventory) {
        if (this.dataManager.areHoppersUseAllowed(this.getConfigType())) {
            inventory.clear();
            inventory.setItem(0, new ItemStack(Material.STRING));
        }
    }

    @Override
    public void openPage(HumanEntity humanEntity, int n) {
        UUID uUID = humanEntity.getUniqueId();
        if (this.lastOpenedPages.containsKey(uUID)) {
            this.lastOpenedPages.replace(uUID, n);
        } else {
            this.lastOpenedPages.put(uUID, n);
        }
        ((BasePage)this.getPageById(n)).open(humanEntity);
    }

    private void b() {
        int n = (int)Math.floor((double)this.f.intValue() / 45.0);
        int n2 = this.f / 9;
        if (this.f > 45) {
            int n3 = this.f % 45 == 0 ? n - 1 : n;
            n = this.f % 45 != 0 ? (n2 - n * 5) * 9 : 45;
            for (n2 = 0; n2 <= n3; ++n2) {
                this.b.put(n2, n2 < n3 ? this.newPage(n2, this.newContentArray(45)) : this.newPage(n2, this.newContentArray(n)));
            }
        } else {
            BaseChest baseChest = this;
            this.b.put(0, this.newPage(0, baseChest.newContentArray(baseChest.f)));
        }
        this.c();
    }

    protected abstract T newPage(int var1, I[] var2);

    private void c() {
        for (BasePage basePage : this.getPages().values()) {
            if (basePage.getChest() == null) {
                basePage.setChest(this);
            }
            basePage.setupPage();
        }
    }

    @Override
    public void expandSlots(int n) {
        if (n % 9 != 0 || n <= 0) {
            return;
        }
        this.closeForViewers();
        BaseChest baseChest = this;
        baseChest.setSize(baseChest.f + n);
        this.e();
        this.a(n);
        this.d();
        this.g();
        this.i();
        this.save();
    }

    @Override
    public void upgrade(String object, Player object2) {
        block4: {
            block5: {
                int n = this.dataManager.getChestSize((String)object) - this.dataManager.getChestSize(this.getConfigType());
                this.closeForViewers();
                BaseChest baseChest = this;
                baseChest.setSize(baseChest.dataManager.getChestSize((String)object));
                this.setConfigType((String)object);
                this.e();
                this.a(n);
                this.d();
                this.g();
                this.h();
                this.i();
                Player player = object2;
                object2 = object;
                object = this;
                object2 = ((DataHandler)((BaseChest)object).dataManager).getContainerType((String)object2);
                ((BaseChest)object).setContainer(((ContainerType)((Object)object2)).getContainer());
                if (((ContainerType)((Object)object2)).isBlockFaceAllowed(((BaseChest)object).k)) break block4;
                if (player == null) break block5;
                ((BaseChest)object).k = PlayerUtils.getDirection(player).getOppositeFace();
                if (((ContainerType)((Object)object2)).isBlockFaceAllowed(((BaseChest)object).k)) break block4;
            }
            ((BaseChest)object).k = BlockFace.NORTH;
        }
        if (((BaseChest)object).e.checkBlock(((BaseChest)object).getLocation(), ((BaseChest)object).k)) {
            object2 = (InventoryHolder)((BaseChest)object).getLocation().getBlock().getState();
            object2 = object2.getInventory();
            super.b((Inventory)object2);
        }
        this.save();
    }

    private void a(int n) {
        if (n <= 0) {
            return;
        }
        int n2 = n / 9;
        n = this.b(n);
        if ((n = n2 - n) > 0) {
            n2 = (int)Math.floor((double)(n *= 9) / 45.0);
            int n3 = n / 9;
            if (n > 45) {
                int n4 = n % 45 == 0 ? this.b.size() + (n2 - 1) : this.b.size() + n2;
                n = n % 45 != 0 ? (n3 - n2 * 5) * 9 : 45;
                for (n2 = this.b.size(); n2 <= n4; ++n2) {
                    this.b.put(n2, n2 < n4 ? this.newPage(n2, this.newContentArray(45)) : this.newPage(n2, this.newContentArray(n)));
                }
                return;
            }
            BaseChest baseChest = this;
            this.b.put(this.b.size(), baseChest.newPage(baseChest.b.size(), this.newContentArray(n)));
        }
    }

    private int b(int n) {
        BaseChest baseChest = this;
        Object t = baseChest.getPageById(baseChest.b.size() - 1);
        int n2 = t.getBukkitInventory().getContents().length - 9;
        int n3 = n2 / 9;
        if (n3 < 5) {
            n = (n = Math.min(n2 + n, 45)) == 45 ? 5 - n3 : n / 9 - n3;
            I[] IArray = t.getItems();
            if (n > 0) {
                t.setPreparedContent(this.a(IArray, n3 * 9 + n * 9));
            }
            return n;
        }
        return 0;
    }

    private I[] a(I[] IArray, int n) {
        I[] IArray2 = this.newContentArray(n);
        System.arraycopy(IArray, 0, IArray2, 0, IArray.length);
        return IArray2;
    }

    @Override
    public void updatePages() {
        this.e();
        this.d();
    }

    private void d() {
        for (BasePage basePage : this.b.values()) {
            basePage.reloadPage();
        }
    }

    private void e() {
        for (BasePage basePage : this.b.values()) {
            basePage.setPreparedContent(basePage.getItems());
        }
    }

    @Override
    public void remove(@Nullable BlockBreakEvent blockBreakEvent, @Nullable Player object, boolean bl) {
        boolean bl2;
        ChestRemoveEvent chestRemoveEvent;
        if (!this.canBeLoaded()) {
            return;
        }
        BaseChest baseChest = this;
        if (baseChest.config.getCallChestRemoveEvent()) {
            chestRemoveEvent = new ChestRemoveEvent(baseChest);
            baseChest.plugin.getServer().getPluginManager().callEvent((Event)chestRemoveEvent);
            bl2 = chestRemoveEvent.isCancelled();
        } else {
            bl2 = false;
        }
        if (bl2) {
            return;
        }
        this.closeForViewers();
        Block block = this.getLocation().getBlock();
        if (bl && !this.handleItemDropping(block, (Player)object)) {
            return;
        }
        chestRemoveEvent = object;
        baseChest = this;
        if (chestRemoveEvent != null && baseChest.economy != null && !(baseChest.l <= 0.0)) {
            baseChest.economy.depositPlayer((OfflinePlayer)chestRemoveEvent, baseChest.l);
            baseChest.setMoney(0.0);
        }
        this.b(block);
        chestRemoveEvent = blockBreakEvent;
        baseChest = this;
        object = baseChest.plugin.getInsightsVersion();
        if (chestRemoveEvent != null && object != null && (Integer)object >= 6) {
            InsightsUtils.handleBlockBreakEvent((BlockBreakEvent)chestRemoveEvent);
        }
        if (blockBreakEvent != null) {
            blockBreakEvent.setCancelled(true);
        }
        block.setType(Material.AIR);
    }

    @Override
    public void handleExplosion(List<Block> list, @Nullable Entity entity) {
        if (!this.canBeLoaded()) {
            return;
        }
        Map<String, Object> map = this.config.getOptions().get("explosions");
        boolean bl = true;
        if (entity != null) {
            if (entity instanceof Creeper) {
                bl = (Boolean)map.get("creeper");
            } else if (entity instanceof TNTPrimed) {
                bl = (Boolean)map.get("tnt");
            }
        }
        entity = this.getLocation().getBlock();
        if (bl) {
            this.closeForViewers();
            if (!this.handleItemDropping((Block)entity, null)) {
                list.remove(entity);
                return;
            }
            this.b((Block)entity);
            list.remove(entity);
            entity.setType(Material.AIR);
            return;
        }
        list.remove(entity);
    }

    private boolean f() {
        if (this.config.getCallChestRemoveEvent()) {
            ChestRemoveEvent chestRemoveEvent = new ChestRemoveEvent(this);
            this.plugin.getServer().getPluginManager().callEvent((Event)chestRemoveEvent);
            return chestRemoveEvent.isCancelled();
        }
        return false;
    }

    protected boolean handleItemDropping(Block block, @Nullable Player player) {
        if (this.config.getOnBreakWaitForEmptyChest() && this.getSlotsUsed() != 0) {
            return false;
        }
        if (this.config.getOnBreakDropChest()) {
            ItemStack itemStack = ChestsProvider.getAdvancedChest(this.getConfigType());
            if (player == null || !this.config.getOnBreakDropChestToInventory() || !player.getInventory().addItem(new ItemStack[]{itemStack}).isEmpty()) {
                block.getWorld().dropItem(this.getLocation(), itemStack);
            }
        }
        return true;
    }

    private void a(@Nullable Player player) {
        if (player == null || this.economy == null || this.l <= 0.0) {
            return;
        }
        this.economy.depositPlayer((OfflinePlayer)player, this.l);
        this.setMoney(0.0);
    }

    private void b(Block block) {
        BlockState blockState;
        if (this.g != null) {
            this.g.delete();
        }
        if ((blockState = block.getState()) instanceof InventoryHolder) {
            ((InventoryHolder)block.getState()).getInventory().clear();
        }
        this.inventoryManager.unRegister(this);
        this.chestsManager.unRegister(this);
    }

    private void a(BlockBreakEvent blockBreakEvent) {
        Integer n = this.plugin.getInsightsVersion();
        if (blockBreakEvent != null && n != null && n >= 6) {
            InsightsUtils.handleBlockBreakEvent(blockBreakEvent);
        }
    }

    @Override
    public SortStatus sort(SortType sortType) {
        return this.d.getSorterService().sort(this, sortType);
    }

    @Override
    public void sell(@Nullable Player player, SellType sellType) {
        if (this.isBeingSold()) {
            return;
        }
        Configuration configuration = this.plugin.getConfiguration();
        if (configuration.getWorthProvider() != null && WorthProvider.getAvailableProviders().contains((Object)configuration.getWorthProvider()) && this.plugin.getEcon() != null) {
            if (sellType == SellType.DIRECT) {
                if (player != null) {
                    new DirectSellProcess(this, player.getUniqueId());
                    return;
                }
            } else {
                new AutomatedSellProcess(this);
            }
        }
    }

    @Override
    public boolean smelt() {
        return this.d.getSmelterService().smelt(this);
    }

    @Override
    public void compress(@Nullable Player player) {
        if (this.isBeingCompressed()) {
            return;
        }
        new DirectCompressProcess(this, player);
    }

    private void g() {
        if (this.g != null) {
            this.g.delete();
        }
        Object object = HologramProvider.getAvailableProviders();
        HologramProvider hologramProvider = this.config.getHologramProvider();
        ChestTitle chestTitle = null;
        if (hologramProvider != null && object.contains((Object)hologramProvider) && this.dataManager.isTitleAvailable(this.getConfigType())) {
            try {
                BaseChest baseChest = this;
                chestTitle = hologramProvider.getTitle(baseChest, baseChest.dataManager.getTitleContent(this.getConfigType()));
                chestTitle.spawn();
            }
            catch (Exception exception) {
                object = exception;
                exception.printStackTrace();
            }
        }
        this.setChestTitle(chestTitle);
    }

    private void h() {
        if (this.isAutomaticSellsStatus() && this.getSubInventoryByName("automatic-sells") == null && ((BasePage)this.getPageById(0)).getButtonByName("automatic-sells") != null) {
            this.taskManager.register(new AutomaticSell(this));
        }
    }

    private void i() {
        Iterator<InteractiveInventory> iterator = this.m.iterator();
        while (iterator.hasNext()) {
            InteractiveInventory interactiveInventory = iterator.next();
            if (((SubChestInventory)interactiveInventory).isAvailable()) continue;
            this.inventoryManager.unRegister(interactiveInventory);
            iterator.remove();
        }
    }

    private void a(String object, Player player) {
        block4: {
            block5: {
                object = ((DataHandler)this.dataManager).getContainerType((String)object);
                this.setContainer(((ContainerType)((Object)object)).getContainer());
                if (((ContainerType)((Object)object)).isBlockFaceAllowed(this.k)) break block4;
                if (player == null) break block5;
                this.k = PlayerUtils.getDirection(player).getOppositeFace();
                if (((ContainerType)((Object)object)).isBlockFaceAllowed(this.k)) break block4;
            }
            this.k = BlockFace.NORTH;
        }
        if (this.e.checkBlock(this.getLocation(), this.k)) {
            object = (InventoryHolder)this.getLocation().getBlock().getState();
            object = object.getInventory();
            this.b((Inventory)object);
        }
    }

    private void j() {
        if (LocationUtils.verify(this.getLocation())) {
            this.p = new ChunkLocation(this.getLocation());
        }
    }

    @Override
    public void save() {
        this.chestsManager.getStorage().save(this);
    }

    public abstract void setContent(List<I> var1);

    @Override
    public T[] getOrderedPages() {
        BaseChest baseChest = this;
        BasePage[] basePageArray = baseChest.newPageArray(baseChest.getPages().size());
        for (int i = 0; i < this.getPages().size(); ++i) {
            basePageArray[i] = (BasePage)this.getPageById(i);
        }
        return basePageArray;
    }

    public abstract T[] newPageArray(int var1);

    public abstract I[] newContentArray(int var1);

    @Override
    public Location getLocation() {
        if (this.n != null && !this.n.isEmpty() && this.o == null) {
            this.o = LocationUtils.deserializeLoc(this.n);
        }
        return this.o;
    }

    @Override
    public boolean isPlayerChangingPage(Player player) {
        return this.changingPagePlayers.containsKey(player.getUniqueId());
    }

    @Override
    public InteractiveInventory getSubInventoryByName(String string) {
        for (InteractiveInventory interactiveInventory : this.m) {
            if (!((SubChestInventory)interactiveInventory).getName().equals(string)) continue;
            return interactiveInventory;
        }
        return null;
    }

    @Override
    public boolean isBeingSold() {
        return this.plugin.getTaskManager().getSellProcessByChest(this) != null;
    }

    @Override
    public boolean isBeingCompressed() {
        return this.plugin.getTaskManager().getCompressProcessByChest(this) != null;
    }

    @Override
    public boolean canBeLoaded() {
        return LocationUtils.verify(this.getLocation()) && this.dataManager.isAdvancedChest(this.getConfigType());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AdvancedChest)) {
            return false;
        }
        object = (AdvancedChest)object;
        return this.a.equals(object.getUniqueId());
    }

    public int hashCode() {
        if (this.r == null) {
            this.r = Objects.hash(this.a);
        }
        return this.r;
    }

    @Override
    public UUID getUniqueId() {
        return this.a;
    }

    void setUniqueId(UUID uUID) {
        this.a = uUID;
    }

    @Override
    public Map<Integer, T> getPages() {
        return this.b;
    }

    void setPages(Map<Integer, T> map) {
        this.b = map;
    }

    @Override
    public String getConfigType() {
        return this.c;
    }

    void setConfigType(String string) {
        this.c = string;
    }

    @Override
    public ChestType getChestType() {
        return this.d;
    }

    void setChestType(ChestType chestType) {
        this.d = chestType;
    }

    @Override
    public Container getContainer() {
        return this.e;
    }

    void setContainer(Container container) {
        this.e = container;
    }

    @Override
    public Integer getSize() {
        return this.f;
    }

    void setSize(Integer n) {
        this.f = n;
    }

    @Override
    public ChestTitle getChestTitle() {
        return this.g;
    }

    void setChestTitle(ChestTitle chestTitle) {
        this.g = chestTitle;
    }

    @Override
    public boolean isAutomaticSellsStatus() {
        return this.h;
    }

    @Override
    public void setAutomaticSellsStatus(boolean bl) {
        this.h = bl;
    }

    @Override
    @Nullable
    public UUID getAutomaticSellsSessionOwner() {
        return this.i;
    }

    @Override
    public void setAutomaticSellsSessionOwner(@Nullable UUID uUID) {
        this.i = uUID;
    }

    @Override
    @Nullable
    public UUID getWhoPlaced() {
        return this.j;
    }

    @Override
    public void setWhoPlaced(@Nullable UUID uUID) {
        this.j = uUID;
    }

    @Override
    @Nullable
    public BlockFace getDirection() {
        return this.k;
    }

    public void setDirection(@Nullable BlockFace blockFace) {
        this.k = blockFace;
    }

    @Override
    public double getMoney() {
        return this.l;
    }

    @Override
    public void setMoney(double d) {
        this.l = d;
    }

    @Override
    public Set<InteractiveInventory> getSubInventories() {
        return this.m;
    }

    @Override
    public ChunkLocation getChunkLocation() {
        return this.p;
    }

    @Override
    public boolean isEntityLoaded() {
        return this.q;
    }
}

