/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.page;

import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import us.lynuxcraft.deadsilenceiv.advancedchests.AdvancedChestsPlugin;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.AdvancedChest;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.BaseChest;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.ShareableChestButton;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.ShareableChestButtonType;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.page.ChestPage;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.page.actions.InventoryDeposit;
import us.lynuxcraft.deadsilenceiv.advancedchests.managers.DataManager;
import us.lynuxcraft.deadsilenceiv.advancedchests.managers.InventoryManager;
import us.lynuxcraft.deadsilenceiv.advancedchests.managers.yml.config.Configuration;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.WorthProvider;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.economy.PluginEconomy;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.ItemUtils;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.BaseInteractiveInventory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.Button;

public abstract class BasePage<I>
extends BaseInteractiveInventory
implements ChestPage<I> {
    protected AdvancedChestsPlugin plugin = AdvancedChestsPlugin.getInstance();
    protected Configuration config;
    protected DataManager dataManager;
    protected InventoryManager inventoryManager;
    protected WorthProvider worthProvider;
    protected int id;
    protected AdvancedChest<?, ?> chest;
    protected I[] preparedContent;
    protected Inventory inventory;
    protected int nextPageSlot;
    protected int previousPageSlot;
    private static ItemStack a;

    public BasePage(int n, I[] IArray, BaseChest<?, ?> baseChest) {
        this.id = n;
        this.config = this.plugin.getConfiguration();
        this.dataManager = this.plugin.getDataManager();
        this.inventoryManager = this.plugin.getInventoryManager();
        this.worthProvider = this.config.getWorthProvider();
        this.setChest(baseChest);
        this.setPreparedContent(IArray);
    }

    @Override
    public void open(HumanEntity humanEntity) {
        Object object = humanEntity.getOpenInventory().getTopInventory();
        object = (BaseChest)this.inventoryManager.getAdvancedChest((Inventory)object);
        ItemStack itemStack = humanEntity.getItemOnCursor();
        if (object != null && ((BaseChest)object).equals(this.chest)) {
            ((BaseChest)object).changingPagePlayers.put(humanEntity.getUniqueId(), itemStack);
            humanEntity.setItemOnCursor(null);
            humanEntity.openInventory(this.inventory);
            humanEntity.setItemOnCursor(((BaseChest)object).changingPagePlayers.get(humanEntity.getUniqueId()));
            ((BaseChest)object).changingPagePlayers.remove(humanEntity.getUniqueId());
            return;
        }
        humanEntity.openInventory(this.inventory);
    }

    @Override
    public void setupPage() {
        int n;
        BasePage basePage = this;
        int n2 = basePage.preparedContent.length + 9;
        String string = basePage.dataManager.getInventoryName(basePage.chest.getConfigType());
        if (string.contains("%i%")) {
            n = basePage.id + 1;
            string = string.replaceAll("%i%", "" + n);
        }
        basePage.inventory = Bukkit.createInventory(null, (int)n2, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)string));
        basePage.displayPreparedContent();
        this.b();
        basePage = this;
        if (basePage.dataManager.isUpgradable(basePage.chest.getConfigType())) {
            Object object = basePage.config.getServicePluginEconomy("upgrades_economy");
            if ((basePage.plugin.getEcon() != null || object != PluginEconomy.MONEY) && basePage.dataManager.isAdvancedChest(string = basePage.dataManager.getChestUpgrade(basePage.chest.getConfigType()))) {
                n = basePage.dataManager.getChestSize(string);
                object = basePage.dataManager.getChestType(string);
                if (n >= basePage.chest.getSize() && object.equals(basePage.chest.getChestType())) {
                    object = ShareableChestButtonType.PAGE_UPGRADE.get(basePage.chest.getConfigType());
                    basePage.addButton((Button)object);
                    ((ShareableChestButton)object).loadActions(basePage);
                    object.show("main", basePage);
                }
            }
        }
        basePage = this;
        if (basePage.dataManager.areSortersAvailable(basePage.chest.getConfigType())) {
            ShareableChestButton shareableChestButton = ShareableChestButtonType.PAGE_SORTER.get(basePage.chest.getConfigType());
            basePage.addButton(shareableChestButton);
            shareableChestButton.loadActions(basePage);
            shareableChestButton.show("main", basePage);
        }
        basePage = this;
        if (basePage.dataManager.areSellsAvailable(basePage.chest.getConfigType()) && basePage.plugin.getEcon() != null && basePage.worthProvider != null && WorthProvider.getAvailableProviders().contains((Object)basePage.worthProvider)) {
            ShareableChestButton shareableChestButton = ShareableChestButtonType.PAGE_SELL.get(basePage.chest.getConfigType());
            basePage.addButton(shareableChestButton);
            shareableChestButton.loadActions(basePage);
            shareableChestButton.show("main", basePage);
        }
        basePage = this;
        if (basePage.dataManager.areAutoSellsAvailable(basePage.chest.getConfigType()) && basePage.plugin.getEcon() != null && basePage.worthProvider != null && WorthProvider.getAvailableProviders().contains((Object)basePage.worthProvider)) {
            ShareableChestButton shareableChestButton = ShareableChestButtonType.PAGE_AUTOMATIC_SELLS.get(basePage.chest.getConfigType());
            basePage.addButton(shareableChestButton);
            shareableChestButton.loadActions(basePage);
            shareableChestButton.show("main", basePage);
        }
        basePage = this;
        if (basePage.dataManager.isSmelterAvailable(basePage.chest.getConfigType())) {
            ShareableChestButton shareableChestButton = ShareableChestButtonType.PAGE_SMELTER.get(basePage.chest.getConfigType());
            basePage.addButton(shareableChestButton);
            shareableChestButton.loadActions(basePage);
            shareableChestButton.show("main", basePage);
        }
        basePage = this;
        if (basePage.dataManager.isCompressorAvailable(basePage.chest.getConfigType())) {
            ShareableChestButton shareableChestButton = ShareableChestButtonType.PAGE_COMPRESSOR.get(basePage.chest.getConfigType());
            basePage.addButton(shareableChestButton);
            shareableChestButton.loadActions(basePage);
            shareableChestButton.show("main", basePage);
        }
        basePage = this;
        if (basePage.dataManager.isSearchAvailable(basePage.chest.getConfigType())) {
            ShareableChestButton shareableChestButton = ShareableChestButtonType.PAGE_SEARCH.get(basePage.chest.getConfigType());
            basePage.addButton(shareableChestButton);
            shareableChestButton.loadActions(basePage);
            shareableChestButton.show("main", basePage);
        }
        basePage = this;
        basePage.addAction(new InventoryDeposit(basePage.chest, ClickType.LEFT));
        this.inventoryManager.register(this);
    }

    private void a() {
        int n = this.preparedContent.length + 9;
        String string = this.dataManager.getInventoryName(this.chest.getConfigType());
        if (string.contains("%i%")) {
            int n2 = this.id + 1;
            string = string.replaceAll("%i%", "" + n2);
        }
        this.inventory = Bukkit.createInventory(null, (int)n, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)string));
        this.displayPreparedContent();
    }

    protected abstract void displayPreparedContent();

    private void b() {
        int n;
        BasePage basePage = this;
        Map<String, Object> map = basePage;
        map = basePage.config.getOptions().get("gui");
        Object object = basePage.getBackground(map.get("pageselector_color") instanceof Integer && (n = ((Integer)map.get("pageselector_color")).intValue()) <= 15 && n >= 0 ? (short)n : (short)7);
        for (int i = 1; i <= 9; ++i) {
            this.inventory.setItem(this.inventory.getSize() - i, (ItemStack)object);
        }
        if (this.chest.getPages().size() > 1) {
            if (this.id == 0) {
                ShareableChestButton shareableChestButton = ShareableChestButtonType.PAGE_NEXT_PAGE.get(this.chest.getConfigType());
                this.addButton(shareableChestButton);
                shareableChestButton.loadActions(this);
                shareableChestButton.show("main", this);
                this.nextPageSlot = shareableChestButton.getSlot(this);
            }
            if (this.id > 0 && this.id < this.chest.getPages().size() - 1) {
                ShareableChestButton shareableChestButton = ShareableChestButtonType.PAGE_PREVIOUS_PAGE.get(this.chest.getConfigType());
                this.addButton(shareableChestButton);
                shareableChestButton.loadActions(this);
                shareableChestButton.show("main", this);
                this.previousPageSlot = shareableChestButton.getSlot(this);
                object = ShareableChestButtonType.PAGE_NEXT_PAGE.get(this.chest.getConfigType());
                this.addButton((Button)object);
                ((ShareableChestButton)object).loadActions(this);
                object.show("main", this);
                this.nextPageSlot = object.getSlot(this);
            }
            if (this.id == this.chest.getPages().size() - 1) {
                ShareableChestButton shareableChestButton = ShareableChestButtonType.PAGE_PREVIOUS_PAGE.get(this.chest.getConfigType());
                this.addButton(shareableChestButton);
                shareableChestButton.loadActions(this);
                shareableChestButton.show("main", this);
                this.previousPageSlot = shareableChestButton.getSlot(this);
            }
        }
    }

    @Override
    public void reloadPage() {
        if (this.inventory != null) {
            this.inventory.clear();
        }
        this.buttons.clear();
        this.actions.clear();
        this.setupPage();
    }

    private void c() {
        if (this.dataManager.isUpgradable(this.chest.getConfigType())) {
            Object object = this.config.getServicePluginEconomy("upgrades_economy");
            if (this.plugin.getEcon() == null && object == PluginEconomy.MONEY) {
                return;
            }
            object = this.dataManager.getChestUpgrade(this.chest.getConfigType());
            if (!this.dataManager.isAdvancedChest((String)object)) {
                return;
            }
            int n = this.dataManager.getChestSize((String)object);
            object = this.dataManager.getChestType((String)object);
            if (n >= this.chest.getSize() && object.equals(this.chest.getChestType())) {
                object = ShareableChestButtonType.PAGE_UPGRADE.get(this.chest.getConfigType());
                this.addButton((Button)object);
                ((ShareableChestButton)object).loadActions(this);
                object.show("main", this);
            }
        }
    }

    private void d() {
        if (this.dataManager.areSortersAvailable(this.chest.getConfigType())) {
            ShareableChestButton shareableChestButton = ShareableChestButtonType.PAGE_SORTER.get(this.chest.getConfigType());
            this.addButton(shareableChestButton);
            shareableChestButton.loadActions(this);
            shareableChestButton.show("main", this);
        }
    }

    private void e() {
        if (this.dataManager.areSellsAvailable(this.chest.getConfigType()) && this.plugin.getEcon() != null && this.worthProvider != null && WorthProvider.getAvailableProviders().contains((Object)this.worthProvider)) {
            ShareableChestButton shareableChestButton = ShareableChestButtonType.PAGE_SELL.get(this.chest.getConfigType());
            this.addButton(shareableChestButton);
            shareableChestButton.loadActions(this);
            shareableChestButton.show("main", this);
        }
    }

    private void f() {
        if (this.dataManager.areAutoSellsAvailable(this.chest.getConfigType()) && this.plugin.getEcon() != null && this.worthProvider != null && WorthProvider.getAvailableProviders().contains((Object)this.worthProvider)) {
            ShareableChestButton shareableChestButton = ShareableChestButtonType.PAGE_AUTOMATIC_SELLS.get(this.chest.getConfigType());
            this.addButton(shareableChestButton);
            shareableChestButton.loadActions(this);
            shareableChestButton.show("main", this);
        }
    }

    private void g() {
        if (this.dataManager.isSmelterAvailable(this.chest.getConfigType())) {
            ShareableChestButton shareableChestButton = ShareableChestButtonType.PAGE_SMELTER.get(this.chest.getConfigType());
            this.addButton(shareableChestButton);
            shareableChestButton.loadActions(this);
            shareableChestButton.show("main", this);
        }
    }

    private void h() {
        if (this.dataManager.isCompressorAvailable(this.chest.getConfigType())) {
            ShareableChestButton shareableChestButton = ShareableChestButtonType.PAGE_COMPRESSOR.get(this.chest.getConfigType());
            this.addButton(shareableChestButton);
            shareableChestButton.loadActions(this);
            shareableChestButton.show("main", this);
        }
    }

    private void i() {
        if (this.dataManager.isSearchAvailable(this.chest.getConfigType())) {
            ShareableChestButton shareableChestButton = ShareableChestButtonType.PAGE_SEARCH.get(this.chest.getConfigType());
            this.addButton(shareableChestButton);
            shareableChestButton.loadActions(this);
            shareableChestButton.show("main", this);
        }
    }

    private void j() {
        this.addAction(new InventoryDeposit(this.chest, ClickType.LEFT));
    }

    private short k() {
        int n;
        Map<String, Object> map = this.config.getOptions().get("gui");
        if (map.get("pageselector_color") instanceof Integer && (n = ((Integer)map.get("pageselector_color")).intValue()) <= 15 && n >= 0) {
            return (short)n;
        }
        return 7;
    }

    @Override
    public Inventory getBukkitInventory() {
        return this.inventory;
    }

    protected ItemStack getBackground(short s) {
        if (a == null) {
            a = ItemUtils.getInventoryBackground(s);
        }
        return a;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public AdvancedChest<?, ?> getChest() {
        return this.chest;
    }

    @Override
    public void setChest(AdvancedChest<?, ?> advancedChest) {
        this.chest = advancedChest;
    }

    @Override
    public void setPreparedContent(I[] IArray) {
        this.preparedContent = IArray;
    }
}

