/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.page;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.BaseChest;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.page.BasePage;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.actions.InventoryAction;

public class NormalPage
extends BasePage<ItemStack> {
    public NormalPage(int n, ItemStack[] itemStackArray, BaseChest<?, ?> baseChest) {
        super(n, itemStackArray, baseChest);
    }

    @Override
    protected void displayPreparedContent() {
        for (int i = 0; i <= this.inventory.getSize() - 10; ++i) {
            this.inventory.setItem(i, ((ItemStack[])this.preparedContent)[i]);
        }
    }

    public ItemStack[] getItems() {
        if (this.inventory == null) {
            return (ItemStack[])this.preparedContent;
        }
        int n = this.inventory.getSize() - 10;
        ItemStack[] itemStackArray = new ItemStack[n + 1];
        for (int i = 0; i <= n; ++i) {
            itemStackArray[i] = this.inventory.getItem(i);
        }
        return itemStackArray;
    }

    @Override
    public void handleInventoryInteraction(InventoryClickEvent inventoryClickEvent) {
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        Object object = inventoryClickEvent.getClickedInventory();
        int n = inventoryClickEvent.getSlot();
        ClickType clickType = inventoryClickEvent.getClick();
        InventoryType.SlotType slotType = inventoryClickEvent.getSlotType();
        ItemStack itemStack = inventoryClickEvent.getCurrentItem();
        ItemStack itemStack2 = inventoryClickEvent.getCursor();
        if (slotType.equals((Object)InventoryType.SlotType.OUTSIDE)) {
            object = this.getOutSideAction(clickType);
            if (object != null) {
                ((InventoryAction)object).execute(player);
            }
            return;
        }
        if (object != null && object.equals(this.getBukkitInventory()) && itemStack != null) {
            if (inventoryClickEvent.getSlot() <= this.getBukkitInventory().getSize() - 10) {
                return;
            }
            object = this.getSlotAction(n, clickType);
            if (object != null && (itemStack2 != null && itemStack2.getType().equals((Object)Material.AIR) || n == this.previousPageSlot || n == this.nextPageSlot)) {
                ((InventoryAction)object).execute(player);
            }
            inventoryClickEvent.setCancelled(true);
        }
    }

    @Override
    public void setContent(List<ItemStack> list) {
        Inventory inventory = this.getBukkitInventory();
        if (list.size() == inventory.getContents().length - 9) {
            for (int i = 0; i <= inventory.getContents().length - 10; ++i) {
                inventory.setItem(i, list.get(i));
            }
        }
    }
}

