/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.page.buttons;

import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.BaseChest;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.ChestInventory;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.ShareableChestButton;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.page.actions.Sorting;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.sorters.SortersMenu;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.sorter.SortType;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.FormatUtils;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.ItemPlaceHolder;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.InteractiveInventory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.actions.SlotAction;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.items.BaseShareableButtonItem;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.items.ShareableButtonItem;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.xseries.XSound;

public class Sorter
extends ShareableChestButton {
    public Sorter(String string) {
        super(string, "sorters");
        this.build();
    }

    @Override
    protected void build() {
        Object object = this.languages.getSortersIconMaterial();
        String string = this.languages.getSortersIconName();
        ArrayList<String> arrayList = new ArrayList<String>(this.languages.getSortersIconLore());
        String string2 = this.languages.getSortersPriceFormat();
        if (this.dataManager.getSortersPrice(this.chestType) > 0.0 && this.plugin.getEcon() != null && !string2.isEmpty()) {
            arrayList.add("");
            arrayList.add(string2);
        }
        object = this.getItemStack((Material)object, string, this.languages.getSortersIconHead(), arrayList, this.languages.getSortersIconCustomModelData());
        object = new BaseShareableButtonItem(this, "main", (ItemStack)object);
        this.addItem(object);
        this.loadPlaceholders();
        ((BaseShareableButtonItem)object).refresh(null);
    }

    @Override
    public void loadActions(ChestInventory chestInventory) {
        int n = this.getSlot(chestInventory);
        final BaseChest baseChest = (BaseChest)chestInventory.getChest();
        chestInventory.addAction(new Sorting(baseChest, SortType.BYALL, ClickType.LEFT, n));
        chestInventory.addAction(new SlotAction(ClickType.RIGHT, n){

            @Override
            public boolean execute(Player player) {
                InteractiveInventory interactiveInventory = baseChest.getSubInventoryByName("sorters");
                if (interactiveInventory == null) {
                    interactiveInventory = new SortersMenu(baseChest);
                    baseChest.getSubInventories().add(interactiveInventory);
                    Sorter.this.inventoryManager.register(interactiveInventory);
                }
                ((SortersMenu)interactiveInventory).open(player);
                XSound.UI_BUTTON_CLICK.play((Entity)player, Sorter.this.config.getSoundsVolume(), Sorter.this.config.getSoundsPitch());
                return true;
            }
        });
    }

    @Override
    protected void loadPlaceholders() {
        for (ShareableButtonItem shareableButtonItem : this.getItems()) {
            shareableButtonItem.addPlaceholder(new ItemPlaceHolder("%price%"){

                @Override
                public String getReplacement() {
                    return FormatUtils.format(Sorter.this.dataManager.getSortersPrice(Sorter.this.chestType));
                }
            });
        }
    }

    @Override
    public Integer getSlot(@NotNull InteractiveInventory interactiveInventory) {
        return interactiveInventory.getBukkitInventory().getSize() - (10 - this.dataManager.getSortersSlot(this.chestType));
    }
}

