/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.managers;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.bukkit.block.Chest;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import us.lynuxcraft.deadsilenceiv.advancedchests.AdvancedChestsPlugin;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.AdvancedChest;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.ChestInventory;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.ShareableChestButton;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.ShareableChestButtonType;
import us.lynuxcraft.deadsilenceiv.advancedchests.managers.InventoryManager;
import us.lynuxcraft.deadsilenceiv.advancedchests.shop.IShop;
import us.lynuxcraft.deadsilenceiv.advancedchests.shop.Shop;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.Pair;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.InteractiveInventory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.xseries.XMaterial;

public class InventoryHandler
implements InventoryManager {
    private Map<Inventory, InteractiveInventory> a = new HashMap<Inventory, InteractiveInventory>();
    private Map<AdvancedChest<?, ?>, Set<ChestInventory>> b = new HashMap();
    private Map<Player, Shop> c = new HashMap<Player, Shop>();
    private LoadingCache<Pair<ShareableChestButtonType, String>, ShareableChestButton> d = ShareableChestButtonType.getLoadingCache();
    private LoadingCache<Inventory, Optional<AdvancedChest<?, ?>>> e = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build(new CacheLoader<Inventory, Optional<AdvancedChest<?, ?>>>(){

        public Optional<AdvancedChest<?, ?>> load(Inventory inventory) {
            if (XMaterial.supports(9)) {
                inventory = inventory.getLocation();
            } else {
                InventoryHolder inventoryHolder = inventory.getHolder();
                if (inventoryHolder instanceof Chest) {
                    inventory = ((Chest)inventory.getHolder()).getLocation();
                } else {
                    return Optional.empty();
                }
            }
            if (inventory == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(AdvancedChestsPlugin.getInstance().getChestsManager().getAdvancedChest((Location)inventory));
        }
    });

    @Override
    public void register(InteractiveInventory interactiveInventory) {
        this.a.put(interactiveInventory.getBukkitInventory(), interactiveInventory);
        if (interactiveInventory instanceof ChestInventory) {
            AdvancedChest<?, ?> advancedChest = ((ChestInventory)interactiveInventory).getChest();
            Set set = this.b.getOrDefault(advancedChest, new HashSet());
            set.add((ChestInventory)interactiveInventory);
            this.b.put(advancedChest, set);
            return;
        }
        if (interactiveInventory instanceof Shop) {
            Shop shop = (Shop)interactiveInventory;
            this.c.put(shop.getPlayer(), shop);
        }
    }

    @Override
    public void unRegister(InteractiveInventory interactiveInventory) {
        this.a.remove(interactiveInventory.getBukkitInventory());
        if (interactiveInventory instanceof ChestInventory) {
            Object object = ((ChestInventory)interactiveInventory).getChest();
            object = this.b.get(object);
            object.remove(interactiveInventory);
            return;
        }
        if (interactiveInventory instanceof Shop) {
            this.c.remove(((Shop)interactiveInventory).getPlayer());
        }
    }

    @Override
    public IShop getChestsShopByPlayer(Player player) {
        return this.c.get(player);
    }

    @Override
    public AdvancedChest<?, ?> getAdvancedChest(Inventory object) {
        if ((object = this.a.get(object)) instanceof ChestInventory) {
            return ((ChestInventory)object).getChest();
        }
        return null;
    }

    @Override
    public InteractiveInventory getInteractiveByBukkit(Inventory inventory) {
        return this.a.get(inventory);
    }

    public Collection<Shop> getChestShops() {
        return this.c.values();
    }

    @Override
    public void unRegister(AdvancedChest<?, ?> advancedChest) {
        Object object = this.b.get(advancedChest);
        object = object.iterator();
        while (object.hasNext()) {
            ChestInventory chestInventory = (ChestInventory)object.next();
            this.a.remove(chestInventory.getBukkitInventory());
        }
        this.b.remove(advancedChest);
    }

    @Override
    public Map<Inventory, InteractiveInventory> getInventories() {
        return this.a;
    }

    public LoadingCache<Pair<ShareableChestButtonType, String>, ShareableChestButton> getCachedShareableChestButtons() {
        return this.d;
    }

    @Override
    public LoadingCache<Inventory, Optional<AdvancedChest<?, ?>>> getCachedChestsVanillaContainers() {
        return this.e;
    }
}

