/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.tasks.compress;

import net.milkbowl.vault.economy.Economy;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.AdvancedChest;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.page.ChestPage;
import us.lynuxcraft.deadsilenceiv.advancedchests.managers.DataManager;
import us.lynuxcraft.deadsilenceiv.advancedchests.managers.LanguagesManager;
import us.lynuxcraft.deadsilenceiv.advancedchests.managers.TaskManager;
import us.lynuxcraft.deadsilenceiv.advancedchests.managers.yml.config.IConfiguration;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.compressor.PageBatchCompressor;
import us.lynuxcraft.deadsilenceiv.advancedchests.tasks.ChestTask;
import us.lynuxcraft.deadsilenceiv.advancedchests.tasks.SplitOperation;

public abstract class CompressProcess
extends SplitOperation<ChestPage<?>>
implements ChestTask {
    protected IConfiguration config;
    protected LanguagesManager languagesManager;
    protected DataManager dataManager;
    protected TaskManager taskManager;
    protected Economy economy;
    protected double price;
    protected int maxDelay;
    protected PageBatchCompressor batchCompressor;
    protected AdvancedChest<?, ?> chest;

    CompressProcess(AdvancedChest<?, ?> advancedChest) {
        this.chest = advancedChest;
        this.config = this.plugin.getConfiguration();
        this.languagesManager = this.plugin.getLanguagesManager();
        this.dataManager = this.plugin.getDataManager();
        this.taskManager = this.plugin.getTaskManager();
        this.economy = this.plugin.getEcon();
        this.price = this.dataManager.getCompressorPrice(advancedChest.getConfigType());
        this.maxDelay = this.config.getCompressTimeMaxDelay();
        if (this.maxDelay > 1) {
            advancedChest.closeForViewers();
        }
        this.batchCompressor = advancedChest.getChestType().getPageBatchCompressor();
    }

    @Override
    public AdvancedChest<?, ?> getChest() {
        return this.chest;
    }
}

