/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari;

import com.codahale.metrics.health.HealthCheckRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.HikariConfigMXBean;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.metrics.MetricsTrackerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.util.PropertyElf;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.util.UtilityElf;

public class HikariConfig
implements HikariConfigMXBean {
    private static final Logger a = LoggerFactory.getLogger(HikariConfig.class);
    private static final char[] b = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final long c = TimeUnit.SECONDS.toMillis(30L);
    private static final long d = TimeUnit.SECONDS.toMillis(5L);
    private static final long e = Long.getLong("us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.timeoutMs.floor", 250L);
    private static final long f = TimeUnit.MINUTES.toMillis(10L);
    private static final long g = TimeUnit.MINUTES.toMillis(30L);
    private static final long h = 0L;
    private static final int i = 10;
    private static boolean j = false;
    private volatile String k;
    private volatile long l;
    private volatile long m;
    private volatile long n;
    private volatile long o;
    private volatile long p;
    private volatile int q = -1;
    private volatile int r = -1;
    private volatile String s;
    private volatile String t;
    private long u = 1L;
    private String v;
    private String w;
    private String x;
    private String y;
    private String z;
    private String A;
    private String B;
    private String C;
    private String D;
    private String E;
    private boolean F = true;
    private boolean G;
    private boolean H;
    private boolean I;
    private boolean J;
    private DataSource K;
    private Properties L = new Properties();
    private ThreadFactory M;
    private ScheduledExecutorService N;
    private MetricsTrackerFactory O;
    private Object P;
    private Object Q;
    private Properties R = new Properties();
    private long S = 0L;
    private volatile boolean T;

    public HikariConfig() {
        this.p = g;
        this.l = c;
        this.m = d;
        this.n = f;
        String string = System.getProperty("hikaricp.configurationFile");
        if (string != null) {
            this.b(string);
        }
    }

    public HikariConfig(Properties properties) {
        this();
        PropertyElf.setTargetFromProperties(this, properties);
    }

    public HikariConfig(String string) {
        this();
        this.b(string);
    }

    @Override
    public String getCatalog() {
        return this.k;
    }

    @Override
    public void setCatalog(String string) {
        this.k = string;
    }

    @Override
    public long getConnectionTimeout() {
        return this.l;
    }

    @Override
    public void setConnectionTimeout(long l) {
        if (l == 0L) {
            this.l = Integer.MAX_VALUE;
            return;
        }
        if (l < e) {
            throw new IllegalArgumentException("connectionTimeout cannot be less than " + e + "ms");
        }
        this.l = l;
    }

    @Override
    public long getIdleTimeout() {
        return this.n;
    }

    @Override
    public void setIdleTimeout(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("idleTimeout cannot be negative");
        }
        this.n = l;
    }

    @Override
    public long getLeakDetectionThreshold() {
        return this.o;
    }

    @Override
    public void setLeakDetectionThreshold(long l) {
        this.o = l;
    }

    @Override
    public long getMaxLifetime() {
        return this.p;
    }

    @Override
    public void setMaxLifetime(long l) {
        this.p = l;
    }

    @Override
    public int getMaximumPoolSize() {
        return this.q;
    }

    @Override
    public void setMaximumPoolSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxPoolSize cannot be less than 1");
        }
        this.q = n;
    }

    @Override
    public int getMinimumIdle() {
        return this.r;
    }

    @Override
    public void setMinimumIdle(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("minimumIdle cannot be negative");
        }
        this.r = n;
    }

    public String getPassword() {
        return this.t;
    }

    @Override
    public void setPassword(String string) {
        this.t = string;
    }

    public String getUsername() {
        return this.s;
    }

    @Override
    public void setUsername(String string) {
        this.s = string;
    }

    @Override
    public long getValidationTimeout() {
        return this.m;
    }

    @Override
    public void setValidationTimeout(long l) {
        if (l < e) {
            throw new IllegalArgumentException("validationTimeout cannot be less than " + e + "ms");
        }
        this.m = l;
    }

    public String getConnectionTestQuery() {
        return this.w;
    }

    public void setConnectionTestQuery(String string) {
        this.b();
        this.w = string;
    }

    public String getConnectionInitSql() {
        return this.v;
    }

    public void setConnectionInitSql(String string) {
        this.b();
        this.v = string;
    }

    public DataSource getDataSource() {
        return this.K;
    }

    public void setDataSource(DataSource dataSource) {
        this.b();
        this.K = dataSource;
    }

    public String getDataSourceClassName() {
        return this.x;
    }

    public void setDataSourceClassName(String string) {
        this.b();
        this.x = string;
    }

    public void addDataSourceProperty(String string, Object object) {
        this.b();
        this.L.put(string, object);
    }

    public String getDataSourceJNDI() {
        return this.y;
    }

    public void setDataSourceJNDI(String string) {
        this.b();
        this.y = string;
    }

    public Properties getDataSourceProperties() {
        return this.L;
    }

    public void setDataSourceProperties(Properties properties) {
        this.b();
        this.L.putAll((Map<?, ?>)properties);
    }

    public String getDriverClassName() {
        return this.z;
    }

    public void setDriverClassName(String string) {
        this.b();
        Class<?> clazz = this.a(string);
        try {
            if (clazz == null) {
                clazz = this.getClass().getClassLoader().loadClass(string);
                a.debug("Driver class {} found in the HikariConfig class classloader {}", (Object)string, (Object)this.getClass().getClassLoader());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            a.error("Failed to load driver class {} from HikariConfig class classloader {}", (Object)string, (Object)this.getClass().getClassLoader());
        }
        if (clazz == null) {
            throw new RuntimeException("Failed to load driver class " + string + " in either of HikariConfig class loader or Thread context classloader");
        }
        try {
            clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.z = string;
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to instantiate class " + string, exception);
        }
    }

    public String getJdbcUrl() {
        return this.B;
    }

    public void setJdbcUrl(String string) {
        this.b();
        this.B = string;
    }

    public boolean isAutoCommit() {
        return this.F;
    }

    public void setAutoCommit(boolean bl) {
        this.b();
        this.F = bl;
    }

    public boolean isAllowPoolSuspension() {
        return this.J;
    }

    public void setAllowPoolSuspension(boolean bl) {
        this.b();
        this.J = bl;
    }

    public long getInitializationFailTimeout() {
        return this.u;
    }

    public void setInitializationFailTimeout(long l) {
        this.b();
        this.u = l;
    }

    public boolean isIsolateInternalQueries() {
        return this.H;
    }

    public void setIsolateInternalQueries(boolean bl) {
        this.b();
        this.H = bl;
    }

    public MetricsTrackerFactory getMetricsTrackerFactory() {
        return this.O;
    }

    public void setMetricsTrackerFactory(MetricsTrackerFactory metricsTrackerFactory) {
        if (this.P != null) {
            throw new IllegalStateException("cannot use setMetricsTrackerFactory() and setMetricRegistry() together");
        }
        this.O = metricsTrackerFactory;
    }

    public Object getMetricRegistry() {
        return this.P;
    }

    public void setMetricRegistry(Object object) {
        if (this.O != null) {
            throw new IllegalStateException("cannot use setMetricRegistry() and setMetricsTrackerFactory() together");
        }
        if (object != null && !UtilityElf.safeIsAssignableFrom(object = HikariConfig.a(object), "com.codahale.metrics.MetricRegistry") && !UtilityElf.safeIsAssignableFrom(object, "io.micrometer.core.instrument.MeterRegistry")) {
            throw new IllegalArgumentException("Class must be instance of com.codahale.metrics.MetricRegistry or io.micrometer.core.instrument.MeterRegistry");
        }
        this.P = object;
    }

    public Object getHealthCheckRegistry() {
        return this.Q;
    }

    public void setHealthCheckRegistry(Object object) {
        this.b();
        if (object != null && !((object = HikariConfig.a(object)) instanceof HealthCheckRegistry)) {
            throw new IllegalArgumentException("Class must be an instance of com.codahale.metrics.health.HealthCheckRegistry");
        }
        this.Q = object;
    }

    public Properties getHealthCheckProperties() {
        return this.R;
    }

    public void setHealthCheckProperties(Properties properties) {
        this.b();
        this.R.putAll((Map<?, ?>)properties);
    }

    public void addHealthCheckProperty(String string, String string2) {
        this.b();
        this.R.setProperty(string, string2);
    }

    public long getKeepaliveTime() {
        return this.S;
    }

    public void setKeepaliveTime(long l) {
        this.S = l;
    }

    public boolean isReadOnly() {
        return this.G;
    }

    public void setReadOnly(boolean bl) {
        this.b();
        this.G = bl;
    }

    public boolean isRegisterMbeans() {
        return this.I;
    }

    public void setRegisterMbeans(boolean bl) {
        this.b();
        this.I = bl;
    }

    @Override
    public String getPoolName() {
        return this.C;
    }

    public void setPoolName(String string) {
        this.b();
        this.C = string;
    }

    public ScheduledExecutorService getScheduledExecutor() {
        return this.N;
    }

    public void setScheduledExecutor(ScheduledExecutorService scheduledExecutorService) {
        this.b();
        this.N = scheduledExecutorService;
    }

    public String getTransactionIsolation() {
        return this.E;
    }

    public String getSchema() {
        return this.D;
    }

    public void setSchema(String string) {
        this.b();
        this.D = string;
    }

    public String getExceptionOverrideClassName() {
        return this.A;
    }

    public void setExceptionOverrideClassName(String string) {
        this.b();
        Class<?> clazz = this.a(string);
        try {
            if (clazz == null) {
                clazz = this.getClass().getClassLoader().loadClass(string);
                a.debug("SQLExceptionOverride class {} found in the HikariConfig class classloader {}", (Object)string, (Object)this.getClass().getClassLoader());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            a.error("Failed to load SQLExceptionOverride class {} from HikariConfig class classloader {}", (Object)string, (Object)this.getClass().getClassLoader());
        }
        if (clazz == null) {
            throw new RuntimeException("Failed to load SQLExceptionOverride class " + string + " in either of HikariConfig class loader or Thread context classloader");
        }
        try {
            clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.A = string;
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to instantiate class " + string, exception);
        }
    }

    public void setTransactionIsolation(String string) {
        this.b();
        this.E = string;
    }

    public ThreadFactory getThreadFactory() {
        return this.M;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.b();
        this.M = threadFactory;
    }

    void seal() {
        this.T = true;
    }

    public void copyStateTo(HikariConfig hikariConfig) {
        for (Field field : HikariConfig.class.getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                field.set(hikariConfig, field.get(this));
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to copy HikariConfig state: " + exception.getMessage(), exception);
            }
        }
        hikariConfig.T = false;
    }

    private Class<?> a(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                Class<?> clazz = classLoader.loadClass(string);
                a.debug("Driver class {} found in Thread context class loader {}", (Object)string, (Object)classLoader);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                a.debug("Driver class {} not found in Thread context class loader {}, trying classloader {}", string, classLoader, this.getClass().getClassLoader());
            }
        }
        return null;
    }

    public void validate() {
        if (this.C == null) {
            this.C = HikariConfig.d();
        } else if (this.I && this.C.contains(":")) {
            throw new IllegalArgumentException("poolName cannot contain ':' when used with JMX");
        }
        this.k = UtilityElf.getNullIfEmpty(this.k);
        this.v = UtilityElf.getNullIfEmpty(this.v);
        this.w = UtilityElf.getNullIfEmpty(this.w);
        this.E = UtilityElf.getNullIfEmpty(this.E);
        this.x = UtilityElf.getNullIfEmpty(this.x);
        this.y = UtilityElf.getNullIfEmpty(this.y);
        this.z = UtilityElf.getNullIfEmpty(this.z);
        this.B = UtilityElf.getNullIfEmpty(this.B);
        if (this.K != null) {
            if (this.x != null) {
                a.warn("{} - using dataSource and ignoring dataSourceClassName.", (Object)this.C);
            }
        } else if (this.x != null) {
            if (this.z != null) {
                a.error("{} - cannot use driverClassName and dataSourceClassName together.", (Object)this.C);
                throw new IllegalStateException("cannot use driverClassName and dataSourceClassName together.");
            }
            if (this.B != null) {
                a.warn("{} - using dataSourceClassName and ignoring jdbcUrl.", (Object)this.C);
            }
        } else if (this.B == null && this.y == null) {
            if (this.z != null) {
                a.error("{} - jdbcUrl is required with driverClassName.", (Object)this.C);
                throw new IllegalArgumentException("jdbcUrl is required with driverClassName.");
            }
            a.error("{} - dataSource or dataSourceClassName or jdbcUrl is required.", (Object)this.C);
            throw new IllegalArgumentException("dataSource or dataSourceClassName or jdbcUrl is required.");
        }
        HikariConfig hikariConfig = this;
        if (hikariConfig.p != 0L && hikariConfig.p < TimeUnit.SECONDS.toMillis(30L)) {
            a.warn("{} - maxLifetime is less than 30000ms, setting to default {}ms.", (Object)hikariConfig.C, (Object)g);
            hikariConfig.p = g;
        }
        if (hikariConfig.S != 0L && hikariConfig.S < TimeUnit.SECONDS.toMillis(30L)) {
            a.warn("{} - keepaliveTime is less than 30000ms, disabling it.", (Object)hikariConfig.C);
            hikariConfig.S = 0L;
        }
        if (hikariConfig.S != 0L && hikariConfig.p != 0L && hikariConfig.S >= hikariConfig.p) {
            a.warn("{} - keepaliveTime is greater than or equal to maxLifetime, disabling it.", (Object)hikariConfig.C);
            hikariConfig.S = 0L;
        }
        if (hikariConfig.o > 0L && (hikariConfig.o < TimeUnit.SECONDS.toMillis(2L) || hikariConfig.o > hikariConfig.p && hikariConfig.p > 0L)) {
            a.warn("{} - leakDetectionThreshold is less than 2000ms or more than maxLifetime, disabling it.", (Object)hikariConfig.C);
            hikariConfig.o = 0L;
        }
        if (hikariConfig.l < e) {
            a.warn("{} - connectionTimeout is less than {}ms, setting to {}ms.", hikariConfig.C, e, c);
            hikariConfig.l = c;
        }
        if (hikariConfig.m < e) {
            a.warn("{} - validationTimeout is less than {}ms, setting to {}ms.", hikariConfig.C, e, d);
            hikariConfig.m = d;
        }
        if (hikariConfig.q <= 0) {
            hikariConfig.q = 10;
        }
        if (hikariConfig.r < 0 || hikariConfig.r > hikariConfig.q) {
            hikariConfig.r = hikariConfig.q;
        }
        if (hikariConfig.n + TimeUnit.SECONDS.toMillis(1L) > hikariConfig.p && hikariConfig.p > 0L && hikariConfig.r < hikariConfig.q) {
            a.warn("{} - idleTimeout is close to or more than maxLifetime, disabling it.", (Object)hikariConfig.C);
            hikariConfig.n = 0L;
        } else if (hikariConfig.n != 0L && hikariConfig.n < TimeUnit.SECONDS.toMillis(10L) && hikariConfig.r < hikariConfig.q) {
            a.warn("{} - idleTimeout is less than 10000ms, setting to default {}ms.", (Object)hikariConfig.C, (Object)f);
            hikariConfig.n = f;
        } else if (hikariConfig.n != f && hikariConfig.n != 0L && hikariConfig.r == hikariConfig.q) {
            a.warn("{} - idleTimeout has been set but has no effect because the pool is operating as a fixed size pool.", (Object)hikariConfig.C);
        }
        if (a.isDebugEnabled()) {
            this.c();
        }
    }

    private void a() {
        if (this.p != 0L && this.p < TimeUnit.SECONDS.toMillis(30L)) {
            a.warn("{} - maxLifetime is less than 30000ms, setting to default {}ms.", (Object)this.C, (Object)g);
            this.p = g;
        }
        if (this.S != 0L && this.S < TimeUnit.SECONDS.toMillis(30L)) {
            a.warn("{} - keepaliveTime is less than 30000ms, disabling it.", (Object)this.C);
            this.S = 0L;
        }
        if (this.S != 0L && this.p != 0L && this.S >= this.p) {
            a.warn("{} - keepaliveTime is greater than or equal to maxLifetime, disabling it.", (Object)this.C);
            this.S = 0L;
        }
        if (this.o > 0L && (this.o < TimeUnit.SECONDS.toMillis(2L) || this.o > this.p && this.p > 0L)) {
            a.warn("{} - leakDetectionThreshold is less than 2000ms or more than maxLifetime, disabling it.", (Object)this.C);
            this.o = 0L;
        }
        if (this.l < e) {
            a.warn("{} - connectionTimeout is less than {}ms, setting to {}ms.", this.C, e, c);
            this.l = c;
        }
        if (this.m < e) {
            a.warn("{} - validationTimeout is less than {}ms, setting to {}ms.", this.C, e, d);
            this.m = d;
        }
        if (this.q <= 0) {
            this.q = 10;
        }
        if (this.r < 0 || this.r > this.q) {
            this.r = this.q;
        }
        if (this.n + TimeUnit.SECONDS.toMillis(1L) > this.p && this.p > 0L && this.r < this.q) {
            a.warn("{} - idleTimeout is close to or more than maxLifetime, disabling it.", (Object)this.C);
            this.n = 0L;
            return;
        }
        if (this.n != 0L && this.n < TimeUnit.SECONDS.toMillis(10L) && this.r < this.q) {
            a.warn("{} - idleTimeout is less than 10000ms, setting to default {}ms.", (Object)this.C, (Object)f);
            this.n = f;
            return;
        }
        if (this.n != f && this.n != 0L && this.r == this.q) {
            a.warn("{} - idleTimeout has been set but has no effect because the pool is operating as a fixed size pool.", (Object)this.C);
        }
    }

    private void b() {
        if (this.T) {
            throw new IllegalStateException("The configuration of the pool is sealed once started. Use HikariConfigMXBean for runtime changes.");
        }
    }

    private void c() {
        a.debug("{} - configuration:", (Object)this.C);
        Object object = new TreeSet<String>(PropertyElf.getPropertyNames(HikariConfig.class));
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            try {
                Object object2 = PropertyElf.getProperty(string, this);
                if ("dataSourceProperties".equals(string)) {
                    object2 = PropertyElf.copyProperties(this.L);
                    ((Properties)object2).setProperty("password", "<masked>");
                }
                if ("initializationFailTimeout".equals(string) && this.u == Long.MAX_VALUE) {
                    object2 = "infinite";
                } else if ("transactionIsolation".equals(string) && this.E == null) {
                    object2 = "default";
                } else if (string.matches("scheduledExecutorService|threadFactory") && object2 == null) {
                    object2 = "internal";
                } else if (string.contains("jdbcUrl") && object2 instanceof String) {
                    object2 = ((String)object2).replaceAll("([?&;]password=)[^&#;]*(.*)", "$1<masked>$2");
                } else if (string.contains("password")) {
                    object2 = "<masked>";
                } else if (object2 instanceof String) {
                    object2 = "\"" + object2 + "\"";
                } else if (object2 == null) {
                    object2 = "none";
                }
                a.debug("{}{}", (Object)(string + "................................................".substring(0, 32)), object2);
            }
            catch (Exception exception) {}
        }
    }

    private void b(String object) {
        Object object2 = new File((String)object);
        try {
            block9: {
                block8: {
                    object2 = ((File)object2).isFile() ? new FileInputStream((File)object2) : this.getClass().getResourceAsStream((String)object);
                    try {
                        if (object2 == null) {
                            throw new IllegalArgumentException("Cannot find property file: " + (String)object);
                        }
                        object = new Properties();
                        ((Properties)object).load((InputStream)object2);
                        PropertyElf.setTargetFromProperties(this, (Properties)object);
                        if (object2 == null) break block8;
                    }
                    catch (Throwable throwable) {
                        if (object2 != null) {
                            try {
                                ((InputStream)object2).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    break block9;
                }
                return;
            }
            ((InputStream)object2).close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to read property file", iOException);
        }
    }

    private static String d() {
        try {
            Properties properties = System.getProperties();
            synchronized (properties) {
                String string = String.valueOf(Integer.getInteger("us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.pool_number", 0) + 1);
                System.setProperty("us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.pool_number", string);
                return "HikariPool-" + string;
            }
        }
        catch (AccessControlException accessControlException) {
            ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
            StringBuilder stringBuilder = new StringBuilder("HikariPool-");
            for (int i = 0; i < 4; ++i) {
                stringBuilder.append(b[threadLocalRandom.nextInt(62)]);
            }
            a.info("assigned random pool name '{}' (security manager prevented access to system properties)", (Object)stringBuilder);
            return stringBuilder.toString();
        }
    }

    private static Object a(Object object) {
        if (object instanceof String) {
            try {
                InitialContext initialContext = new InitialContext();
                return initialContext.lookup((String)object);
            }
            catch (NamingException namingException) {
                throw new IllegalArgumentException(namingException);
            }
        }
        return object;
    }
}

