/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari;

import java.io.Closeable;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.HikariConfig;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.HikariConfigMXBean;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.HikariPoolMXBean;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.metrics.MetricsTrackerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.pool.HikariPool;

public class HikariDataSource
extends HikariConfig
implements Closeable,
DataSource {
    private static final Logger a = LoggerFactory.getLogger(HikariDataSource.class);
    private final AtomicBoolean b = new AtomicBoolean();
    private final HikariPool c;
    private volatile HikariPool d;

    public HikariDataSource() {
        this.c = null;
    }

    public HikariDataSource(HikariConfig hikariConfig) {
        hikariConfig.validate();
        hikariConfig.copyStateTo(this);
        a.info("{} - Starting...", (Object)hikariConfig.getPoolName());
        HikariDataSource hikariDataSource = this;
        hikariDataSource.d = hikariDataSource.c = new HikariPool(this);
        a.info("{} - Start completed.", (Object)hikariConfig.getPoolName());
        this.seal();
    }

    @Override
    public Connection getConnection() {
        if (this.isClosed()) {
            throw new SQLException("HikariDataSource " + this + " has been closed.");
        }
        if (this.c != null) {
            return this.c.getConnection();
        }
        Object object = this.d;
        if (object == null) {
            HikariDataSource hikariDataSource = this;
            synchronized (hikariDataSource) {
                object = this.d;
                if (object == null) {
                    this.validate();
                    a.info("{} - Starting...", (Object)this.getPoolName());
                    try {
                        object = new HikariPool(this);
                        this.d = object;
                        this.seal();
                    }
                    catch (HikariPool.PoolInitializationException poolInitializationException) {
                        object = poolInitializationException;
                        if (poolInitializationException.getCause() instanceof SQLException) {
                            throw (SQLException)((Throwable)object).getCause();
                        }
                        throw object;
                    }
                    a.info("{} - Start completed.", (Object)this.getPoolName());
                }
            }
        }
        return ((HikariPool)object).getConnection();
    }

    @Override
    public Connection getConnection(String string, String string2) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PrintWriter getLogWriter() {
        HikariPool hikariPool = this.d;
        if (hikariPool != null) {
            return hikariPool.getUnwrappedDataSource().getLogWriter();
        }
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
        HikariPool hikariPool = this.d;
        if (hikariPool != null) {
            hikariPool.getUnwrappedDataSource().setLogWriter(printWriter);
        }
    }

    @Override
    public void setLoginTimeout(int n) {
        HikariPool hikariPool = this.d;
        if (hikariPool != null) {
            hikariPool.getUnwrappedDataSource().setLoginTimeout(n);
        }
    }

    @Override
    public int getLoginTimeout() {
        HikariPool hikariPool = this.d;
        if (hikariPool != null) {
            return hikariPool.getUnwrappedDataSource().getLoginTimeout();
        }
        return 0;
    }

    @Override
    public java.util.logging.Logger getParentLogger() {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return (T)this;
        }
        Object object = this.d;
        if (object != null) {
            if (clazz.isInstance(object = ((HikariPool)object).getUnwrappedDataSource())) {
                return (T)object;
            }
            if (object != null) {
                return object.unwrap(clazz);
            }
        }
        throw new SQLException("Wrapped DataSource is not an instance of " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        if (clazz.isInstance(this)) {
            return true;
        }
        Object object = this.d;
        if (object != null) {
            if (clazz.isInstance(object = ((HikariPool)object).getUnwrappedDataSource())) {
                return true;
            }
            if (object != null) {
                return object.isWrapperFor(clazz);
            }
        }
        return false;
    }

    @Override
    public void setMetricRegistry(Object object) {
        boolean bl = this.getMetricRegistry() != null;
        super.setMetricRegistry(object);
        object = this.d;
        if (object != null) {
            if (bl) {
                throw new IllegalStateException("MetricRegistry can only be set one time");
            }
            ((HikariPool)object).setMetricRegistry(super.getMetricRegistry());
        }
    }

    @Override
    public void setMetricsTrackerFactory(MetricsTrackerFactory object) {
        boolean bl = this.getMetricsTrackerFactory() != null;
        super.setMetricsTrackerFactory((MetricsTrackerFactory)object);
        object = this.d;
        if (object != null) {
            if (bl) {
                throw new IllegalStateException("MetricsTrackerFactory can only be set one time");
            }
            ((HikariPool)object).setMetricsTrackerFactory(super.getMetricsTrackerFactory());
        }
    }

    @Override
    public void setHealthCheckRegistry(Object object) {
        boolean bl = this.getHealthCheckRegistry() != null;
        super.setHealthCheckRegistry(object);
        object = this.d;
        if (object != null) {
            if (bl) {
                throw new IllegalStateException("HealthCheckRegistry can only be set one time");
            }
            ((HikariPool)object).setHealthCheckRegistry(super.getHealthCheckRegistry());
        }
    }

    public boolean isRunning() {
        return this.d != null && this.d.poolState == 0;
    }

    public HikariPoolMXBean getHikariPoolMXBean() {
        return this.d;
    }

    public HikariConfigMXBean getHikariConfigMXBean() {
        return this;
    }

    public void evictConnection(Connection connection) {
        HikariPool hikariPool;
        if (!this.isClosed() && (hikariPool = this.d) != null && connection.getClass().getName().startsWith("us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari")) {
            hikariPool.evictConnection(connection);
        }
    }

    @Override
    public void close() {
        if (this.b.getAndSet(true)) {
            return;
        }
        HikariPool hikariPool = this.d;
        if (hikariPool != null) {
            try {
                a.info("{} - Shutdown initiated...", (Object)this.getPoolName());
                hikariPool.shutdown();
                a.info("{} - Shutdown completed.", (Object)this.getPoolName());
                return;
            }
            catch (InterruptedException interruptedException) {
                a.warn("{} - Interrupted during closing", (Object)this.getPoolName(), (Object)interruptedException);
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean isClosed() {
        return this.b.get();
    }

    public String toString() {
        return "HikariDataSource (" + this.d + ")";
    }
}

