/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.hibernate;

import java.sql.Connection;
import java.util.Map;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.Version;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.HikariConfig;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.HikariDataSource;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.hibernate.HikariConfigurationUtil;

public class HikariConnectionProvider
implements ConnectionProvider,
Configurable,
Stoppable {
    private static final long a = -9131625057941275711L;
    private static final Logger b = LoggerFactory.getLogger(HikariConnectionProvider.class);
    private HikariConfig c = null;
    private HikariDataSource d = null;

    public HikariConnectionProvider() {
        if (Version.getVersionString().substring(0, 5).compareTo("4.3.6") > 0) {
            b.warn("us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.hibernate.HikariConnectionProvider has been deprecated for versions of Hibernate 4.3.6 and newer.  Please switch to org.hibernate.hikaricp.internal.HikariCPConnectionProvider.");
        }
    }

    public void configure(Map map) {
        try {
            b.debug("Configuring HikariCP");
            this.c = HikariConfigurationUtil.loadConfiguration(map);
            this.d = new HikariDataSource(this.c);
        }
        catch (Exception exception) {
            throw new HibernateException((Throwable)exception);
        }
        b.debug("HikariCP Configured");
    }

    public Connection getConnection() {
        Connection connection = null;
        if (this.d != null) {
            connection = this.d.getConnection();
        }
        return connection;
    }

    public void closeConnection(Connection connection) {
        connection.close();
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public boolean isUnwrappableAs(Class clazz) {
        return ConnectionProvider.class.equals((Object)clazz) || HikariConnectionProvider.class.isAssignableFrom(clazz);
    }

    public <T> T unwrap(Class<T> clazz) {
        if (ConnectionProvider.class.equals(clazz) || HikariConnectionProvider.class.isAssignableFrom(clazz)) {
            return (T)this;
        }
        if (DataSource.class.isAssignableFrom(clazz)) {
            return (T)this.d;
        }
        throw new UnknownUnwrapTypeException(clazz);
    }

    public void stop() {
        this.d.close();
    }
}

