/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.metrics.micrometer;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.metrics.IMetricsTracker;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.metrics.PoolStats;

public class MicrometerMetricsTracker
implements IMetricsTracker {
    public static final String HIKARI_METRIC_NAME_PREFIX = "hikaricp";
    private static final String a = "pool";
    private static final String b = "hikaricp.connections.acquire";
    private static final String c = "hikaricp.connections.usage";
    private static final String d = "hikaricp.connections.creation";
    private static final String e = "hikaricp.connections.timeout";
    private static final String f = "hikaricp.connections";
    private static final String g = "hikaricp.connections.idle";
    private static final String h = "hikaricp.connections.active";
    private static final String i = "hikaricp.connections.pending";
    private static final String j = "hikaricp.connections.max";
    private static final String k = "hikaricp.connections.min";
    private final Timer l;
    private final Counter m;
    private final Timer n;
    private final Timer o;
    private final Gauge p;
    private final Gauge q;
    private final Gauge r;
    private final Gauge s;
    private final Gauge t;
    private final Gauge u;
    private final MeterRegistry v;
    private final PoolStats w;

    MicrometerMetricsTracker(String string, PoolStats poolStats, MeterRegistry meterRegistry) {
        this.v = meterRegistry;
        this.l = Timer.builder((String)b).description("Connection acquire time").tags(new String[]{a, string}).register(meterRegistry);
        this.o = Timer.builder((String)d).description("Connection creation time").tags(new String[]{a, string}).register(meterRegistry);
        this.n = Timer.builder((String)c).description("Connection usage time").tags(new String[]{a, string}).register(meterRegistry);
        this.m = Counter.builder((String)e).description("Connection timeout total count").tags(new String[]{a, string}).register(meterRegistry);
        this.p = Gauge.builder((String)f, (Object)poolStats, PoolStats::getTotalConnections).description("Total connections").tags(new String[]{a, string}).register(meterRegistry);
        this.q = Gauge.builder((String)g, (Object)poolStats, PoolStats::getIdleConnections).description("Idle connections").tags(new String[]{a, string}).register(meterRegistry);
        this.r = Gauge.builder((String)h, (Object)poolStats, PoolStats::getActiveConnections).description("Active connections").tags(new String[]{a, string}).register(meterRegistry);
        this.s = Gauge.builder((String)i, (Object)poolStats, PoolStats::getPendingThreads).description("Pending threads").tags(new String[]{a, string}).register(meterRegistry);
        this.t = Gauge.builder((String)j, (Object)poolStats, PoolStats::getMaxConnections).description("Max connections").tags(new String[]{a, string}).register(meterRegistry);
        this.u = Gauge.builder((String)k, (Object)poolStats, PoolStats::getMinConnections).description("Min connections").tags(new String[]{a, string}).register(meterRegistry);
    }

    @Override
    public void recordConnectionAcquiredNanos(long l) {
        this.l.record(l, TimeUnit.NANOSECONDS);
    }

    @Override
    public void recordConnectionUsageMillis(long l) {
        this.n.record(l, TimeUnit.MILLISECONDS);
    }

    @Override
    public void recordConnectionTimeout() {
        this.m.increment();
    }

    @Override
    public void recordConnectionCreatedMillis(long l) {
        this.o.record(l, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        this.v.remove((Meter)this.l);
        this.v.remove((Meter)this.m);
        this.v.remove((Meter)this.n);
        this.v.remove((Meter)this.o);
        this.v.remove((Meter)this.p);
        this.v.remove((Meter)this.q);
        this.v.remove((Meter)this.r);
        this.v.remove((Meter)this.s);
        this.v.remove((Meter)this.t);
        this.v.remove((Meter)this.u);
    }
}

