/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.pool;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import io.micrometer.core.instrument.MeterRegistry;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTransientConnectionException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.HikariConfig;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.HikariPoolMXBean;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.metrics.MetricsTrackerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.metrics.PoolStats;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.metrics.dropwizard.CodahaleHealthChecker;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.metrics.dropwizard.CodahaleMetricsTrackerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.metrics.micrometer.MicrometerMetricsTrackerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.pool.PoolBase;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.pool.PoolEntry;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.pool.ProxyConnection;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.pool.ProxyLeakTaskFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.util.ClockSource;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.util.ConcurrentBag;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.util.SuspendResumeLock;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.util.UtilityElf;

public final class HikariPool
extends PoolBase
implements HikariPoolMXBean,
ConcurrentBag.IBagStateListener {
    private final Logger a = LoggerFactory.getLogger(HikariPool.class);
    public static final int POOL_NORMAL = 0;
    public static final int POOL_SUSPENDED = 1;
    public static final int POOL_SHUTDOWN = 2;
    public volatile int poolState;
    private final long b = Long.getLong("us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.aliveBypassWindowMs", TimeUnit.MILLISECONDS.toMillis(500L));
    private final long c = Long.getLong("us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.housekeeping.periodMs", TimeUnit.SECONDS.toMillis(30L));
    private static final String d = "(connection was evicted)";
    private static final String e = "(connection is dead)";
    private final PoolEntryCreator f = new PoolEntryCreator(null);
    private final PoolEntryCreator g = new PoolEntryCreator("After adding ");
    private final Collection<Runnable> h;
    private final ThreadPoolExecutor i;
    private final ThreadPoolExecutor j;
    private final ConcurrentBag<PoolEntry> k = new ConcurrentBag(this);
    private final ProxyLeakTaskFactory l;
    private final SuspendResumeLock m;
    private final ScheduledExecutorService n;
    private ScheduledFuture<?> o;

    public HikariPool(HikariConfig hikariConfig) {
        super(hikariConfig);
        Object object;
        this.m = hikariConfig.isAllowPoolSuspension() ? new SuspendResumeLock() : SuspendResumeLock.FAUX_LOCK;
        Object object2 = this;
        if (((HikariPool)object2).config.getScheduledExecutor() == null) {
            object2 = Optional.ofNullable(((HikariPool)object2).config.getThreadFactory()).orElseGet(() -> new UtilityElf.DefaultThreadFactory(this.poolName + " housekeeper", true));
            object2 = new ScheduledThreadPoolExecutor(1, (ThreadFactory)object2, new ThreadPoolExecutor.DiscardPolicy());
            ((ScheduledThreadPoolExecutor)object2).setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            ((ScheduledThreadPoolExecutor)object2).setRemoveOnCancelPolicy(true);
            object = object2;
        } else {
            object = ((HikariPool)object2).config.getScheduledExecutor();
        }
        ((HikariPool)object2).n = object;
        this.c();
        if (hikariConfig.getMetricsTrackerFactory() != null) {
            this.setMetricsTrackerFactory(hikariConfig.getMetricsTrackerFactory());
        } else {
            this.setMetricRegistry(hikariConfig.getMetricRegistry());
        }
        this.setHealthCheckRegistry(hikariConfig.getHealthCheckRegistry());
        HikariPool hikariPool = this;
        hikariPool.handleMBeans(hikariPool, true);
        object2 = hikariConfig.getThreadFactory();
        int n = hikariConfig.getMaximumPoolSize();
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>(n);
        this.h = Collections.unmodifiableCollection(linkedBlockingQueue);
        this.i = UtilityElf.createThreadPoolExecutor(linkedBlockingQueue, this.poolName + " connection adder", (ThreadFactory)object2, (RejectedExecutionHandler)new ThreadPoolExecutor.DiscardOldestPolicy());
        this.j = UtilityElf.createThreadPoolExecutor(n, this.poolName + " connection closer", (ThreadFactory)object2, (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        this.l = new ProxyLeakTaskFactory(hikariConfig.getLeakDetectionThreshold(), this.n);
        this.o = this.n.scheduleWithFixedDelay(new HouseKeeper(0), 100L, this.c, TimeUnit.MILLISECONDS);
        if (Boolean.getBoolean("us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.blockUntilFilled") && hikariConfig.getInitializationFailTimeout() > 1L) {
            this.i.setMaximumPoolSize(Math.min(16, Runtime.getRuntime().availableProcessors()));
            this.i.setCorePoolSize(Math.min(16, Runtime.getRuntime().availableProcessors()));
            long l = ClockSource.currentTime();
            while (ClockSource.elapsedMillis(l) < hikariConfig.getInitializationFailTimeout() && this.getTotalConnections() < hikariConfig.getMinimumIdle()) {
                UtilityElf.quietlySleep(TimeUnit.MILLISECONDS.toMillis(100L));
            }
            this.i.setCorePoolSize(1);
            this.i.setMaximumPoolSize(1);
        }
    }

    public final Connection getConnection() {
        HikariPool hikariPool = this;
        return hikariPool.getConnection(hikariPool.connectionTimeout);
    }

    /*
     * Exception decompiling
     */
    public final Connection getConnection(long var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final synchronized void shutdown() {
        block8: {
            this.poolState = 2;
            if (this.i != null) break block8;
            this.a("After shutdown ");
            HikariPool hikariPool = this;
            hikariPool.handleMBeans(hikariPool, false);
            this.metricsTracker.close();
            return;
        }
        try {
            this.a("Before shutdown ");
            if (this.o != null) {
                this.o.cancel(false);
                this.o = null;
            }
            this.softEvictConnections();
            this.i.shutdown();
            this.i.awaitTermination(this.getLoginTimeout(), TimeUnit.SECONDS);
            this.e();
            this.k.close();
            ThreadPoolExecutor threadPoolExecutor = UtilityElf.createThreadPoolExecutor(this.config.getMaximumPoolSize(), this.poolName + " connection assassinator", this.config.getThreadFactory(), (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
            try {
                long l = ClockSource.currentTime();
                do {
                    this.a(threadPoolExecutor);
                    this.softEvictConnections();
                } while (this.getTotalConnections() > 0 && ClockSource.elapsedMillis(l) < TimeUnit.SECONDS.toMillis(10L));
            }
            finally {
                threadPoolExecutor.shutdown();
                threadPoolExecutor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            this.shutdownNetworkTimeoutExecutor();
            this.j.shutdown();
            this.j.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (Throwable throwable) {
            this.a("After shutdown ");
            HikariPool hikariPool = this;
            hikariPool.handleMBeans(hikariPool, false);
            this.metricsTracker.close();
            throw throwable;
        }
        this.a("After shutdown ");
        HikariPool hikariPool = this;
        hikariPool.handleMBeans(hikariPool, false);
        this.metricsTracker.close();
    }

    public final void evictConnection(Connection connection) {
        ProxyConnection proxyConnection = (ProxyConnection)connection;
        proxyConnection.cancelLeakTask();
        try {
            this.a(proxyConnection.g(), "(connection evicted by user)", !connection.isClosed());
            return;
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    public final void setMetricRegistry(Object object) {
        if (object != null && UtilityElf.safeIsAssignableFrom(object, "com.codahale.metrics.MetricRegistry")) {
            this.setMetricsTrackerFactory(new CodahaleMetricsTrackerFactory((MetricRegistry)object));
            return;
        }
        if (object != null && UtilityElf.safeIsAssignableFrom(object, "io.micrometer.core.instrument.MeterRegistry")) {
            this.setMetricsTrackerFactory(new MicrometerMetricsTrackerFactory((MeterRegistry)object));
            return;
        }
        this.setMetricsTrackerFactory(null);
    }

    public final void setMetricsTrackerFactory(MetricsTrackerFactory object) {
        if (object != null) {
            MetricsTrackerFactory metricsTrackerFactory = object;
            object = this;
            this.metricsTracker = new PoolBase.MetricsTrackerDelegate(metricsTrackerFactory.create(this.config.getPoolName(), new PoolStats(TimeUnit.SECONDS.toMillis(1L)){

                @Override
                protected void update() {
                    this.pendingThreads = HikariPool.this.getThreadsAwaitingConnection();
                    this.idleConnections = HikariPool.this.getIdleConnections();
                    this.totalConnections = HikariPool.this.getTotalConnections();
                    this.activeConnections = HikariPool.this.getActiveConnections();
                    this.maxConnections = HikariPool.this.config.getMaximumPoolSize();
                    this.minConnections = HikariPool.this.config.getMinimumIdle();
                }
            }));
            return;
        }
        this.metricsTracker = new PoolBase.NopMetricsTrackerDelegate();
    }

    public final void setHealthCheckRegistry(Object object) {
        if (object != null) {
            HikariPool hikariPool = this;
            CodahaleHealthChecker.registerHealthChecks(hikariPool, hikariPool.config, (HealthCheckRegistry)object);
        }
    }

    @Override
    public final void addBagItem(int n) {
        boolean bl = n - this.h.size() >= 0;
        if (bl) {
            this.i.submit(this.f);
            return;
        }
        this.a.debug("{} - Add connection elided, waiting {}, queue {}", this.poolName, n, this.h.size());
    }

    @Override
    public final int getActiveConnections() {
        return this.k.getCount(1);
    }

    @Override
    public final int getIdleConnections() {
        return this.k.getCount(0);
    }

    @Override
    public final int getTotalConnections() {
        return this.k.size();
    }

    @Override
    public final int getThreadsAwaitingConnection() {
        return this.k.getWaitingThreadCount();
    }

    @Override
    public final void softEvictConnections() {
        this.k.values().forEach(poolEntry -> this.a((PoolEntry)poolEntry, "(connection evicted)", false));
    }

    @Override
    public final synchronized void suspendPool() {
        if (this.m == SuspendResumeLock.FAUX_LOCK) {
            throw new IllegalStateException(this.poolName + " - is not suspendable");
        }
        if (this.poolState != 1) {
            this.m.suspend();
            this.poolState = 1;
        }
    }

    @Override
    public final synchronized void resumePool() {
        if (this.poolState == 1) {
            this.poolState = 0;
            this.b();
            this.m.resume();
        }
    }

    final void a(String ... stringArray) {
        if (this.a.isDebugEnabled()) {
            this.a.debug("{} - {}stats (total={}, active={}, idle={}, waiting={})", this.poolName, stringArray[0], this.getTotalConnections(), this.getActiveConnections(), this.getIdleConnections(), this.getThreadsAwaitingConnection());
        }
    }

    @Override
    final void recycle(PoolEntry poolEntry) {
        this.metricsTracker.recordConnectionUsage(poolEntry);
        this.k.requite(poolEntry);
    }

    final void closeConnection(PoolEntry object, String string) {
        if (this.k.remove((PoolEntry)object)) {
            object = ((PoolEntry)object).close();
            this.j.execute(() -> this.a((Connection)object, string));
        }
    }

    final int[] getPoolStateCounts() {
        return this.k.getStateCounts();
    }

    private PoolEntry a() {
        block6: {
            try {
                long l;
                long l2;
                PoolEntry poolEntry = this.newPoolEntry();
                long l3 = this.config.getMaxLifetime();
                if (l3 > 0L) {
                    l2 = l3 > 10000L ? ThreadLocalRandom.current().nextLong(l3 / 40L) : 0L;
                    l = l3 - l2;
                    poolEntry.setFutureEol(this.n.schedule(new MaxLifetimeTask(poolEntry), l, TimeUnit.MILLISECONDS));
                }
                if ((l2 = this.config.getKeepaliveTime()) > 0L) {
                    long l4;
                    l = ThreadLocalRandom.current().nextLong(l2 / 10L);
                    long l5 = l4 = l2 - l;
                    poolEntry.setKeepalive(this.n.scheduleWithFixedDelay(new KeepaliveTask(poolEntry), l5, l5, TimeUnit.MILLISECONDS));
                }
                return poolEntry;
            }
            catch (PoolBase.ConnectionSetupException connectionSetupException) {
                if (this.poolState == 0) {
                    this.a.error("{} - Error thrown while acquiring connection from data source", (Object)this.poolName, (Object)connectionSetupException.getCause());
                    this.lastConnectionFailure.set(connectionSetupException);
                }
            }
            catch (Exception exception) {
                if (this.poolState != 0) break block6;
                this.a.debug("{} - Cannot acquire connection from data source", (Object)this.poolName, (Object)exception);
            }
        }
        return null;
    }

    private synchronized void b() {
        int n = Math.min(this.config.getMaximumPoolSize() - this.getTotalConnections(), this.config.getMinimumIdle() - this.getIdleConnections()) - this.h.size();
        if (n <= 0) {
            this.a.debug("{} - Fill pool skipped, pool is at sufficient level.", (Object)this.poolName);
        }
        for (int i = 0; i < n; ++i) {
            this.i.submit(i < n - 1 ? this.f : this.g);
        }
    }

    private void a(ExecutorService executorService) {
        for (PoolEntry poolEntry : this.k.values(1)) {
            Connection connection = poolEntry.close();
            try {
                connection.abort(executorService);
            }
            catch (Throwable throwable) {
                this.quietlyCloseConnection(connection, "(connection aborted during shutdown)");
            }
            finally {
                this.k.remove(poolEntry);
            }
        }
    }

    private void c() {
        long l = this.config.getInitializationFailTimeout();
        if (l < 0L) {
            return;
        }
        long l2 = ClockSource.currentTime();
        do {
            PoolEntry poolEntry;
            if ((poolEntry = this.a()) != null) {
                if (this.config.getMinimumIdle() > 0) {
                    this.k.add(poolEntry);
                    this.a.debug("{} - Added connection {}", (Object)this.poolName, (Object)poolEntry.connection);
                    return;
                }
                this.quietlyCloseConnection(poolEntry.close(), "(initialization check complete and minimumIdle is zero)");
                return;
            }
            if (this.getLastConnectionFailure() instanceof PoolBase.ConnectionSetupException) {
                HikariPool hikariPool = this;
                hikariPool.a(hikariPool.getLastConnectionFailure().getCause());
            }
            UtilityElf.quietlySleep(TimeUnit.SECONDS.toMillis(1L));
        } while (ClockSource.elapsedMillis(l2) < l);
        if (l > 0L) {
            HikariPool hikariPool = this;
            hikariPool.a(hikariPool.getLastConnectionFailure());
        }
    }

    private void a(Throwable throwable) {
        this.a.error("{} - Exception during pool initialization.", (Object)this.poolName, (Object)throwable);
        this.e();
        throw new PoolInitializationException(throwable);
    }

    private boolean a(PoolEntry poolEntry, String string, boolean bl) {
        poolEntry.markEvicted();
        if (bl || this.k.reserve(poolEntry)) {
            this.closeConnection(poolEntry, string);
            return true;
        }
        return false;
    }

    private ScheduledExecutorService d() {
        if (this.config.getScheduledExecutor() == null) {
            Object object = Optional.ofNullable(this.config.getThreadFactory()).orElseGet(() -> new UtilityElf.DefaultThreadFactory(this.poolName + " housekeeper", true));
            object = new ScheduledThreadPoolExecutor(1, (ThreadFactory)object, new ThreadPoolExecutor.DiscardPolicy());
            ((ScheduledThreadPoolExecutor)object).setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            ((ScheduledThreadPoolExecutor)object).setRemoveOnCancelPolicy(true);
            return object;
        }
        return this.config.getScheduledExecutor();
    }

    private void e() {
        if (this.config.getScheduledExecutor() == null) {
            this.n.shutdownNow();
        }
    }

    private PoolStats f() {
        return new /* invalid duplicate definition of identical inner class */;
    }

    private SQLException a(long l) {
        this.a("Timeout failure ");
        this.metricsTracker.recordConnectionTimeout();
        String string = null;
        Exception exception = this.getLastConnectionFailure();
        if (exception instanceof SQLException) {
            string = ((SQLException)exception).getSQLState();
        }
        SQLTransientConnectionException sQLTransientConnectionException = new SQLTransientConnectionException(this.poolName + " - Connection is not available, request timed out after " + ClockSource.elapsedMillis(l) + "ms.", string, exception);
        if (exception instanceof SQLException) {
            sQLTransientConnectionException.setNextException((SQLException)exception);
        }
        return sQLTransientConnectionException;
    }

    private /* synthetic */ void a(Connection connection, String string) {
        this.quietlyCloseConnection(connection, string);
        if (this.poolState == 0) {
            this.b();
        }
    }

    public static class PoolInitializationException
    extends RuntimeException {
        private static final long a = 929872118275916520L;

        public PoolInitializationException(Throwable throwable) {
            super("Failed to initialize pool: " + throwable.getMessage(), throwable);
        }
    }

    private final class KeepaliveTask
    implements Runnable {
        private final PoolEntry a;

        KeepaliveTask(PoolEntry poolEntry) {
            this.a = poolEntry;
        }

        @Override
        public final void run() {
            if (HikariPool.this.k.reserve(this.a)) {
                if (!HikariPool.this.isConnectionAlive(this.a.connection)) {
                    HikariPool.this.a(this.a, HikariPool.e, true);
                    HikariPool.this.addBagItem(HikariPool.this.k.getWaitingThreadCount());
                    return;
                }
                HikariPool.this.k.unreserve(this.a);
                HikariPool.this.a.debug("{} - keepalive: connection {} is alive", (Object)HikariPool.this.poolName, (Object)this.a.connection);
            }
        }
    }

    private final class MaxLifetimeTask
    implements Runnable {
        private final PoolEntry a;

        MaxLifetimeTask(PoolEntry poolEntry) {
            this.a = poolEntry;
        }

        @Override
        public final void run() {
            if (HikariPool.this.a(this.a, "(connection has passed maxLifetime)", false)) {
                HikariPool.this.addBagItem(HikariPool.this.k.getWaitingThreadCount());
            }
        }
    }

    private final class HouseKeeper
    implements Runnable {
        private volatile long a;

        private HouseKeeper() {
            this.a = ClockSource.plusMillis(ClockSource.currentTime(), -HikariPool.this.c);
        }

        @Override
        public final void run() {
            try {
                HikariPool.this.connectionTimeout = HikariPool.this.config.getConnectionTimeout();
                HikariPool.this.validationTimeout = HikariPool.this.config.getValidationTimeout();
                HikariPool.this.l.updateLeakDetectionThreshold(HikariPool.this.config.getLeakDetectionThreshold());
                HikariPool.this.catalog = HikariPool.this.config.getCatalog() != null && !HikariPool.this.config.getCatalog().equals(HikariPool.this.catalog) ? HikariPool.this.config.getCatalog() : HikariPool.this.catalog;
                long l = HikariPool.this.config.getIdleTimeout();
                long l2 = ClockSource.currentTime();
                if (ClockSource.plusMillis(l2, 128L) < ClockSource.plusMillis(this.a, HikariPool.this.c)) {
                    HikariPool.this.a.warn("{} - Retrograde clock change detected (housekeeper delta={}), soft-evicting connections from pool.", (Object)HikariPool.this.poolName, (Object)ClockSource.elapsedDisplayString(this.a, l2));
                    this.a = l2;
                    HikariPool.this.softEvictConnections();
                    return;
                }
                if (l2 > ClockSource.plusMillis(this.a, 3L * HikariPool.this.c / 2L)) {
                    HikariPool.this.a.warn("{} - Thread starvation or clock leap detected (housekeeper delta={}).", (Object)HikariPool.this.poolName, (Object)ClockSource.elapsedDisplayString(this.a, l2));
                }
                this.a = l2;
                String string = "Pool ";
                if (l > 0L && HikariPool.this.config.getMinimumIdle() < HikariPool.this.config.getMaximumPoolSize()) {
                    HikariPool.this.a("Before cleanup ");
                    string = "After cleanup  ";
                    Object object = HikariPool.this.k.values(0);
                    int n = object.size() - HikariPool.this.config.getMinimumIdle();
                    object = object.iterator();
                    while (object.hasNext()) {
                        PoolEntry poolEntry = (PoolEntry)object.next();
                        if (n <= 0 || ClockSource.elapsedMillis(poolEntry.lastAccessed, l2) <= l || !HikariPool.this.k.reserve(poolEntry)) continue;
                        HikariPool.this.closeConnection(poolEntry, "(connection has passed idleTimeout)");
                        --n;
                    }
                }
                HikariPool.this.a(string);
                HikariPool.this.b();
                return;
            }
            catch (Exception exception) {
                HikariPool.this.a.error("Unexpected exception in housekeeping task", exception);
                return;
            }
        }

        /* synthetic */ HouseKeeper(byte by) {
            this();
        }
    }

    private final class PoolEntryCreator
    implements Callable<Boolean> {
        private final String a;

        PoolEntryCreator(String string) {
            this.a = string;
        }

        @Override
        public final Boolean call() {
            long l = 250L;
            while (HikariPool.this.poolState == 0 && this.a()) {
                PoolEntry poolEntry = HikariPool.this.a();
                if (poolEntry != null) {
                    HikariPool.this.k.add(poolEntry);
                    HikariPool.this.a.debug("{} - Added connection {}", (Object)HikariPool.this.poolName, (Object)poolEntry.connection);
                    if (this.a != null) {
                        HikariPool.this.a(this.a);
                    }
                    return Boolean.TRUE;
                }
                if (this.a != null) {
                    HikariPool.this.a.debug("{} - Connection add failed, sleeping with backoff: {}ms", (Object)HikariPool.this.poolName, (Object)l);
                }
                UtilityElf.quietlySleep(l);
                l = Math.min(TimeUnit.SECONDS.toMillis(10L), Math.min(HikariPool.this.connectionTimeout, (long)((double)l * 1.5)));
            }
            return Boolean.FALSE;
        }

        private synchronized boolean a() {
            return HikariPool.this.getTotalConnections() < HikariPool.this.config.getMaximumPoolSize() && (HikariPool.this.k.getWaitingThreadCount() > 0 || HikariPool.this.getIdleConnections() < HikariPool.this.config.getMinimumIdle());
        }
    }
}

