/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.pool;

import java.sql.Connection;
import java.sql.Statement;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.pool.HikariPool;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.pool.PoolBase;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.pool.ProxyConnection;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.pool.ProxyFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.pool.ProxyLeakTask;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.util.ClockSource;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.util.ConcurrentBag;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.util.FastList;

final class PoolEntry
implements ConcurrentBag.IConcurrentBagEntry {
    private static final Logger a = LoggerFactory.getLogger(PoolEntry.class);
    private static final AtomicIntegerFieldUpdater<PoolEntry> b = AtomicIntegerFieldUpdater.newUpdater(PoolEntry.class, "c");
    Connection connection;
    long lastAccessed;
    long lastBorrowed;
    private volatile int c = 0;
    private volatile boolean d;
    private volatile ScheduledFuture<?> e;
    private volatile ScheduledFuture<?> f;
    private final FastList<Statement> g;
    private final HikariPool h;
    private final boolean i;
    private final boolean j;

    PoolEntry(Connection connection, PoolBase poolBase, boolean bl, boolean bl2) {
        this.connection = connection;
        this.h = (HikariPool)poolBase;
        this.i = bl;
        this.j = bl2;
        this.lastAccessed = ClockSource.currentTime();
        this.g = new FastList(Statement.class, 16);
    }

    final void recycle(long l) {
        if (this.connection != null) {
            this.lastAccessed = l;
            this.h.recycle(this);
        }
    }

    final void setFutureEol(ScheduledFuture<?> scheduledFuture) {
        this.e = scheduledFuture;
    }

    public final void setKeepalive(ScheduledFuture<?> scheduledFuture) {
        this.f = scheduledFuture;
    }

    final Connection createProxyConnection(ProxyLeakTask proxyLeakTask, long l) {
        PoolEntry poolEntry = this;
        return ProxyFactory.getProxyConnection(poolEntry, poolEntry.connection, this.g, proxyLeakTask, l, this.i, this.j);
    }

    final void resetConnectionState(ProxyConnection proxyConnection, int n) {
        this.h.resetConnectionState(this.connection, proxyConnection, n);
    }

    final String getPoolName() {
        return this.h.toString();
    }

    final boolean isMarkedEvicted() {
        return this.d;
    }

    final void markEvicted() {
        this.d = true;
    }

    final void evict(String string) {
        this.h.closeConnection(this, string);
    }

    final long getMillisSinceBorrowed() {
        return ClockSource.elapsedMillis(this.lastBorrowed);
    }

    final PoolBase getPoolBase() {
        return this.h;
    }

    public final String toString() {
        String string;
        long l = ClockSource.currentTime();
        StringBuilder stringBuilder = new StringBuilder().append(this.connection).append(", accessed ").append(ClockSource.elapsedDisplayString(this.lastAccessed, l)).append(" ago, ");
        PoolEntry poolEntry = this;
        switch (poolEntry.c) {
            case 1: {
                string = "IN_USE";
                break;
            }
            case 0: {
                string = "NOT_IN_USE";
                break;
            }
            case -1: {
                string = "REMOVED";
                break;
            }
            case -2: {
                string = "RESERVED";
                break;
            }
            default: {
                string = "Invalid";
            }
        }
        return stringBuilder.append(string).toString();
    }

    @Override
    public final int getState() {
        return b.get(this);
    }

    @Override
    public final boolean compareAndSet(int n, int n2) {
        return b.compareAndSet(this, n, n2);
    }

    @Override
    public final void setState(int n) {
        b.set(this, n);
    }

    final Connection close() {
        ScheduledFuture<?> scheduledFuture = this.e;
        if (scheduledFuture != null && !scheduledFuture.isDone() && !scheduledFuture.cancel(false)) {
            a.warn("{} - maxLifeTime expiration task cancellation unexpectedly returned false for connection {}", (Object)this.getPoolName(), (Object)this.connection);
        }
        if ((scheduledFuture = this.f) != null && !scheduledFuture.isDone() && !scheduledFuture.cancel(false)) {
            a.warn("{} - keepalive task cancellation unexpectedly returned false for connection {}", (Object)this.getPoolName(), (Object)this.connection);
        }
        scheduledFuture = this.connection;
        this.connection = null;
        this.e = null;
        this.f = null;
        return scheduledFuture;
    }

    private String a() {
        switch (this.c) {
            case 1: {
                return "IN_USE";
            }
            case 0: {
                return "NOT_IN_USE";
            }
            case -1: {
                return "REMOVED";
            }
            case -2: {
                return "RESERVED";
            }
        }
        return "Invalid";
    }
}

