/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.util.ClockSource;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.util.FastList;

public class ConcurrentBag<T extends IConcurrentBagEntry>
implements AutoCloseable {
    private static final Logger a = LoggerFactory.getLogger(ConcurrentBag.class);
    private final CopyOnWriteArrayList<T> b;
    private final boolean c;
    private final ThreadLocal<List<Object>> d;
    private final IBagStateListener e;
    private final AtomicInteger f;
    private volatile boolean g;
    private final SynchronousQueue<T> h;

    public ConcurrentBag(IBagStateListener iBagStateListener) {
        this.e = iBagStateListener;
        this.c = this.a();
        this.h = new SynchronousQueue(true);
        this.f = new AtomicInteger();
        this.b = new CopyOnWriteArrayList();
        if (this.c) {
            this.d = ThreadLocal.withInitial(() -> new ArrayList(16));
            return;
        }
        this.d = ThreadLocal.withInitial(() -> new FastList(IConcurrentBagEntry.class, 16));
    }

    public T borrow(long l, TimeUnit object) {
        int n;
        List<Object> list = this.d.get();
        for (n = list.size() - 1; n >= 0; --n) {
            Iterator<T> iterator = list.remove(n);
            IConcurrentBagEntry iConcurrentBagEntry = this.c ? (IConcurrentBagEntry)((WeakReference)((Object)iterator)).get() : (IConcurrentBagEntry)((Object)iterator);
            if (iConcurrentBagEntry == null || !iConcurrentBagEntry.compareAndSet(0, 1)) continue;
            return (T)iConcurrentBagEntry;
        }
        n = this.f.incrementAndGet();
        try {
            long l2;
            for (IConcurrentBagEntry iConcurrentBagEntry : this.b) {
                if (!iConcurrentBagEntry.compareAndSet(0, 1)) continue;
                if (n > 1) {
                    this.e.addBagItem(n - 1);
                }
                object = iConcurrentBagEntry;
                return (T)object;
            }
            this.e.addBagItem(n);
            l = ((TimeUnit)((Object)object)).toNanos(l);
            do {
                l2 = ClockSource.currentTime();
                object = (IConcurrentBagEntry)this.h.poll(l, TimeUnit.NANOSECONDS);
                if (object != null && !object.compareAndSet(0, 1)) continue;
                Object object2 = object;
                return (T)object2;
            } while ((l -= ClockSource.elapsedNanos(l2)) > 10000L);
            T t = null;
            return t;
        }
        finally {
            this.f.decrementAndGet();
        }
    }

    public void requite(T t) {
        t.setState(0);
        int n = 0;
        while (this.f.get() > 0) {
            if (t.getState() != 0 || this.h.offer(t)) {
                return;
            }
            if ((n & 0xFF) == 255) {
                LockSupport.parkNanos(TimeUnit.MICROSECONDS.toNanos(10L));
            } else {
                Thread.yield();
            }
            ++n;
        }
        List<Object> list = this.d.get();
        if (list.size() < 50) {
            list.add(this.c ? new WeakReference<T>(t) : t);
        }
    }

    public void add(T t) {
        if (this.g) {
            a.info("ConcurrentBag has been closed, ignoring add()");
            throw new IllegalStateException("ConcurrentBag has been closed, ignoring add()");
        }
        this.b.add(t);
        while (this.f.get() > 0 && t.getState() == 0 && !this.h.offer(t)) {
            Thread.yield();
        }
    }

    public boolean remove(T t) {
        if (!(t.compareAndSet(1, -1) || t.compareAndSet(-2, -1) || this.g)) {
            a.warn("Attempt to remove an object from the bag that was not borrowed or reserved: {}", (Object)t);
            return false;
        }
        boolean bl = this.b.remove(t);
        if (!bl && !this.g) {
            a.warn("Attempt to remove an object from the bag that does not exist: {}", (Object)t);
        }
        this.d.get().remove(t);
        return bl;
    }

    @Override
    public void close() {
        this.g = true;
    }

    public List<T> values(int n) {
        List list = this.b.stream().filter(iConcurrentBagEntry -> iConcurrentBagEntry.getState() == n).collect(Collectors.toList());
        Collections.reverse(list);
        return list;
    }

    public List<T> values() {
        return (List)this.b.clone();
    }

    public boolean reserve(T t) {
        return t.compareAndSet(0, -2);
    }

    public void unreserve(T t) {
        if (t.compareAndSet(-2, 0)) {
            while (this.f.get() > 0 && !this.h.offer(t)) {
                Thread.yield();
            }
        } else {
            a.warn("Attempt to relinquish an object to the bag that was not reserved: {}", (Object)t);
        }
    }

    public int getWaitingThreadCount() {
        return this.f.get();
    }

    public int getCount(int n) {
        int n2 = 0;
        for (IConcurrentBagEntry iConcurrentBagEntry : this.b) {
            if (iConcurrentBagEntry.getState() != n) continue;
            ++n2;
        }
        return n2;
    }

    public int[] getStateCounts() {
        int[] nArray = new int[6];
        for (IConcurrentBagEntry iConcurrentBagEntry : this.b) {
            int n = iConcurrentBagEntry.getState();
            nArray[n] = nArray[n] + 1;
        }
        nArray[4] = this.b.size();
        nArray[5] = this.f.get();
        return nArray;
    }

    public int size() {
        return this.b.size();
    }

    public void dumpState() {
        this.b.forEach(iConcurrentBagEntry -> a.info(iConcurrentBagEntry.toString()));
    }

    private boolean a() {
        try {
            if (System.getProperty("us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.useWeakReferences") != null) {
                return Boolean.getBoolean("us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.useWeakReferences");
            }
            return this.getClass().getClassLoader() != ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException securityException) {
            return true;
        }
    }

    public static interface IBagStateListener {
        public void addBagItem(int var1);
    }

    public static interface IConcurrentBagEntry {
        public static final int STATE_NOT_IN_USE = 0;
        public static final int STATE_IN_USE = 1;
        public static final int STATE_REMOVED = -1;
        public static final int STATE_RESERVED = -2;

        public boolean compareAndSet(int var1, int var2);

        public void setState(int var1);

        public int getState();
    }
}

