/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Calendar;
import java.util.TimeZone;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbConnection;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbStatement;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.ColumnType;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters.BigDecimalParameter;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters.BooleanParameter;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters.ByteArrayParameter;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters.ByteParameter;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters.DateParameter;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters.DoubleParameter;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters.FloatParameter;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters.IntParameter;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters.LocalTimeParameter;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters.LongParameter;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters.NullParameter;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters.OffsetTimeParameter;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters.ParameterHolder;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters.ReaderParameter;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters.SerializableParameter;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters.ShortParameter;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters.StreamParameter;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters.StringParameter;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters.TimeParameter;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters.TimestampParameter;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters.ZonedDateTimeParameter;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.exceptions.ExceptionFactory;

public abstract class BasePrepareStatement
extends MariaDbStatement
implements PreparedStatement {
    public static final DateTimeFormatter SPEC_ISO_ZONED_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral('T').optionalEnd().optionalStart().appendLiteral(' ').optionalEnd().append(DateTimeFormatter.ISO_LOCAL_TIME).appendOffsetId().optionalStart().appendLiteral('[').parseCaseSensitive().appendZoneRegionId().appendLiteral(']').toFormatter();
    protected int autoGeneratedKeys;
    private boolean a;
    private boolean b;

    public BasePrepareStatement(MariaDbConnection mariaDbConnection, int n, int n2, int n3, ExceptionFactory exceptionFactory) {
        super(mariaDbConnection, n, n2, exceptionFactory);
        this.b = this.protocol.noBackslashEscapes();
        this.a = this.options.useFractionalSeconds;
        this.autoGeneratedKeys = n3;
    }

    @Override
    public BasePrepareStatement clone(MariaDbConnection autoCloseable) {
        autoCloseable = (BasePrepareStatement)super.clone((MariaDbConnection)autoCloseable);
        v0.a = this.options.useFractionalSeconds;
        return autoCloseable;
    }

    @Override
    public long executeLargeUpdate() {
        BasePrepareStatement basePrepareStatement = this;
        if (basePrepareStatement.executeInternal(basePrepareStatement.getFetchSize())) {
            return 0L;
        }
        return this.getLargeUpdateCount();
    }

    protected abstract boolean executeInternal(int var1);

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) {
        if (reader == null) {
            this.setNull(n, ColumnType.BLOB);
            return;
        }
        this.setParameter(n, new ReaderParameter(reader, n2, this.b));
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) {
        if (reader == null) {
            this.setNull(n, ColumnType.BLOB);
            return;
        }
        this.setParameter(n, new ReaderParameter(reader, l, this.b));
    }

    @Override
    public void setCharacterStream(int n, Reader reader) {
        if (reader == null) {
            this.setNull(n, ColumnType.BLOB);
            return;
        }
        this.setParameter(n, new ReaderParameter(reader, this.b));
    }

    @Override
    public void setRef(int n, Ref ref) {
        throw this.exceptionFactory.notSupported("REF parameter are not supported");
    }

    @Override
    public void setBlob(int n, Blob blob) {
        if (blob == null) {
            this.setNull(n, 2004);
            return;
        }
        this.setParameter(n, new StreamParameter(blob.getBinaryStream(), blob.length(), this.b));
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) {
        if (inputStream == null) {
            this.setNull(n, ColumnType.BLOB);
            return;
        }
        this.setParameter(n, new StreamParameter(inputStream, l, this.b));
    }

    @Override
    public void setBlob(int n, InputStream inputStream) {
        if (inputStream == null) {
            this.setNull(n, ColumnType.BLOB);
            return;
        }
        this.setParameter(n, new StreamParameter(inputStream, this.b));
    }

    @Override
    public void setClob(int n, Clob clob) {
        if (clob == null) {
            this.setNull(n, ColumnType.BLOB);
            return;
        }
        this.setParameter(n, new ReaderParameter(clob.getCharacterStream(), clob.length(), this.b));
    }

    @Override
    public void setClob(int n, Reader reader, long l) {
        this.setCharacterStream(n, reader, l);
    }

    @Override
    public void setClob(int n, Reader reader) {
        this.setCharacterStream(n, reader);
    }

    @Override
    public void setArray(int n, Array array) {
        throw this.exceptionFactory.notSupported("Arrays not supported");
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) {
        if (date == null) {
            this.setNull(n, 91);
            return;
        }
        this.setParameter(n, new DateParameter(date, calendar != null ? calendar.getTimeZone() : TimeZone.getDefault(), this.protocol.getOptions()));
    }

    @Override
    public void setDate(int n, Date date) {
        if (date == null) {
            this.setNull(n, 91);
            return;
        }
        this.setParameter(n, new DateParameter(date, TimeZone.getDefault(), this.protocol.getOptions()));
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) {
        if (time == null) {
            this.setNull(n, ColumnType.TIME);
            return;
        }
        this.setParameter(n, new TimeParameter(time, calendar != null ? calendar.getTimeZone() : TimeZone.getDefault(), this.a));
    }

    @Override
    public void setTime(int n, Time time) {
        if (time == null) {
            this.setNull(n, ColumnType.TIME);
            return;
        }
        this.setParameter(n, new TimeParameter(time, TimeZone.getDefault(), this.a));
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar cloneable) {
        if (timestamp == null) {
            this.setNull(n, ColumnType.DATETIME);
            return;
        }
        cloneable = cloneable != null ? cloneable.getTimeZone() : this.protocol.getTimeZone();
        this.setParameter(n, new TimestampParameter(timestamp, (TimeZone)cloneable, this.a));
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) {
        if (timestamp == null) {
            this.setNull(n, ColumnType.DATETIME);
            return;
        }
        this.setParameter(n, new TimestampParameter(timestamp, this.protocol.getTimeZone(), this.a));
    }

    @Override
    public void setNull(int n, int n2) {
        this.setParameter(n, new NullParameter());
    }

    public void setNull(int n, ColumnType columnType) {
        this.setParameter(n, new NullParameter(columnType));
    }

    @Override
    public void setNull(int n, int n2, String string) {
        this.setParameter(n, new NullParameter());
    }

    public abstract void setParameter(int var1, ParameterHolder var2);

    @Override
    public void setURL(int n, URL uRL) {
        if (uRL == null) {
            this.setNull(n, ColumnType.STRING);
            return;
        }
        this.setParameter(n, new StringParameter(uRL.toString(), this.b));
    }

    @Override
    public abstract ParameterMetaData getParameterMetaData();

    @Override
    public void setRowId(int n, RowId rowId) {
        throw this.exceptionFactory.notSupported("RowIDs not supported");
    }

    @Override
    public void setNString(int n, String string) {
        this.setString(n, string);
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) {
        this.setCharacterStream(n, reader, l);
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) {
        this.setCharacterStream(n, reader);
    }

    @Override
    public void setNClob(int n, NClob nClob) {
        this.setClob(n, nClob);
    }

    @Override
    public void setNClob(int n, Reader reader, long l) {
        this.setClob(n, reader, l);
    }

    @Override
    public void setNClob(int n, Reader reader) {
        this.setClob(n, reader);
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) {
        throw this.exceptionFactory.notSupported("SQlXML not supported");
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) {
        this.a(n, object, n2, n3);
    }

    @Override
    public void setObject(int n, Object object, int n2) {
        this.a(n, object, n2, Long.MAX_VALUE);
    }

    @Override
    public void setObject(int n, Object object) {
        if (object == null) {
            this.setNull(n, 4);
            return;
        }
        if (object instanceof String) {
            this.setString(n, (String)object);
            return;
        }
        if (object instanceof Integer) {
            this.setInt(n, (Integer)object);
            return;
        }
        if (object instanceof Long) {
            this.setLong(n, (Long)object);
            return;
        }
        if (object instanceof Short) {
            this.setShort(n, (Short)object);
            return;
        }
        if (object instanceof Double) {
            this.setDouble(n, (Double)object);
            return;
        }
        if (object instanceof Float) {
            this.setFloat(n, ((Float)object).floatValue());
            return;
        }
        if (object instanceof Byte) {
            this.setByte(n, (Byte)object);
            return;
        }
        if (object instanceof byte[]) {
            this.setBytes(n, (byte[])object);
            return;
        }
        if (object instanceof Date) {
            this.setDate(n, (Date)object);
            return;
        }
        if (object instanceof Time) {
            this.setTime(n, (Time)object);
            return;
        }
        if (object instanceof Timestamp) {
            this.setTimestamp(n, (Timestamp)object);
            return;
        }
        if (object instanceof java.util.Date) {
            this.setTimestamp(n, new Timestamp(((java.util.Date)object).getTime()));
            return;
        }
        if (object instanceof Boolean) {
            this.setBoolean(n, (Boolean)object);
            return;
        }
        if (object instanceof Blob) {
            this.setBlob(n, (Blob)object);
            return;
        }
        if (object instanceof InputStream) {
            this.setBinaryStream(n, (InputStream)object);
            return;
        }
        if (object instanceof Reader) {
            this.setCharacterStream(n, (Reader)object);
            return;
        }
        if (object instanceof BigDecimal) {
            this.setBigDecimal(n, (BigDecimal)object);
            return;
        }
        if (object instanceof BigInteger) {
            this.setString(n, object.toString());
            return;
        }
        if (object instanceof Clob) {
            this.setClob(n, (Clob)object);
            return;
        }
        if (object instanceof LocalDateTime) {
            this.setTimestamp(n, Timestamp.valueOf((LocalDateTime)object));
            return;
        }
        if (object instanceof Instant) {
            this.setTimestamp(n, Timestamp.from((Instant)object));
            return;
        }
        if (object instanceof LocalDate) {
            this.setDate(n, Date.valueOf((LocalDate)object));
            return;
        }
        if (object instanceof OffsetDateTime) {
            this.setParameter(n, new ZonedDateTimeParameter(((OffsetDateTime)object).toZonedDateTime(), this.protocol.getTimeZone(), this.a, this.options));
            return;
        }
        if (object instanceof OffsetTime) {
            this.setParameter(n, new OffsetTimeParameter((OffsetTime)object, this.protocol.getTimeZone(), this.a, this.options));
            return;
        }
        if (object instanceof ZonedDateTime) {
            this.setParameter(n, new ZonedDateTimeParameter((ZonedDateTime)object, this.protocol.getTimeZone(), this.a, this.options));
            return;
        }
        if (object instanceof LocalTime) {
            this.setParameter(n, new LocalTimeParameter((LocalTime)object, this.a));
            return;
        }
        this.setParameter(n, new SerializableParameter(object, this.b));
    }

    @Override
    public void setObject(int n, Object object, SQLType sQLType, int n2) {
        this.setObject(n, object, sQLType.getVendorTypeNumber(), n2);
    }

    @Override
    public void setObject(int n, Object object, SQLType sQLType) {
        this.setObject(n, object, sQLType.getVendorTypeNumber());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(int n, Object object, int n2, long l) {
        switch (n2) {
            case -8: 
            case 70: 
            case 2000: 
            case 2002: 
            case 2003: 
            case 2006: 
            case 2009: {
                throw this.exceptionFactory.notSupported("Type not supported");
            }
        }
        if (object == null) {
            this.setNull(n, 4);
            return;
        }
        if (object instanceof String || object instanceof Character) {
            if (n2 == 2004) {
                throw this.exceptionFactory.create(String.format("Cannot convert a %s to a Blob", object instanceof String ? "string" : "character"));
            }
            String string = object instanceof String ? (String)object : ((Character)object).toString();
            try {
                switch (n2) {
                    case -7: 
                    case 16: {
                        this.setBoolean(n, !"false".equalsIgnoreCase(string) && !"0".equals(string));
                        return;
                    }
                    case -6: {
                        this.setByte(n, Byte.parseByte(string));
                        return;
                    }
                    case 5: {
                        this.setShort(n, Short.parseShort(string));
                        return;
                    }
                    case 4: {
                        this.setInt(n, Integer.parseInt(string));
                        return;
                    }
                    case 6: 
                    case 8: {
                        this.setDouble(n, Double.valueOf(string));
                        return;
                    }
                    case 7: {
                        this.setFloat(n, Float.valueOf(string).floatValue());
                        return;
                    }
                    case -5: {
                        this.setLong(n, Long.valueOf(string));
                        return;
                    }
                    case 2: 
                    case 3: {
                        this.setBigDecimal(n, new BigDecimal(string));
                        return;
                    }
                    case -16: 
                    case -15: 
                    case -9: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: 
                    case 2011: {
                        this.setString(n, string);
                        return;
                    }
                    case 93: {
                        if (string.startsWith("0000-00-00")) {
                            this.setTimestamp(n, null);
                            return;
                        }
                        this.setTimestamp(n, Timestamp.valueOf(string));
                        return;
                    }
                    case 92: {
                        this.setTime(n, Time.valueOf((String)object));
                        return;
                    }
                    case 2013: {
                        this.setParameter(n, new OffsetTimeParameter(OffsetTime.parse(string), this.protocol.getTimeZone(), this.a, this.options));
                        return;
                    }
                    case 2014: {
                        this.setParameter(n, new ZonedDateTimeParameter(ZonedDateTime.parse(string, SPEC_ISO_ZONED_DATE_TIME), this.protocol.getTimeZone(), this.a, this.options));
                        return;
                    }
                }
                throw this.exceptionFactory.create(String.format("Could not convert [%s] to %s", string, n2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this.exceptionFactory.create(String.format("Could not convert [%s] to %s", string, n2), illegalArgumentException);
            }
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            switch (n2) {
                case -6: {
                    this.setByte(n, number.byteValue());
                    return;
                }
                case 5: {
                    this.setShort(n, number.shortValue());
                    return;
                }
                case 4: {
                    this.setInt(n, number.intValue());
                    return;
                }
                case -5: {
                    this.setLong(n, number.longValue());
                    return;
                }
                case 6: 
                case 8: {
                    this.setDouble(n, number.doubleValue());
                    return;
                }
                case 7: {
                    this.setFloat(n, number.floatValue());
                    return;
                }
                case 2: 
                case 3: {
                    if (object instanceof BigDecimal) {
                        this.setBigDecimal(n, (BigDecimal)object);
                        return;
                    }
                    if (!(object instanceof Double) && !(object instanceof Float)) {
                        this.setLong(n, number.longValue());
                        return;
                    }
                    this.setDouble(n, number.doubleValue());
                    return;
                }
                case -7: {
                    this.setBoolean(n, number.shortValue() != 0);
                    return;
                }
                case 1: 
                case 12: {
                    this.setString(n, number.toString());
                    return;
                }
            }
            throw this.exceptionFactory.create(String.format("Could not convert [%s] to %s", number, n2));
        }
        if (object instanceof byte[]) {
            if (n2 != -2 && n2 != -3) {
                if (n2 != -4) throw this.exceptionFactory.create("Can only convert a byte[] to BINARY, VARBINARY or LONGVARBINARY");
            }
            this.setBytes(n, (byte[])object);
            return;
        }
        if (object instanceof Time) {
            this.setTime(n, (Time)object);
            return;
        }
        if (object instanceof Timestamp) {
            this.setTimestamp(n, (Timestamp)object);
            return;
        }
        if (object instanceof Date) {
            this.setDate(n, (Date)object);
            return;
        }
        if (object instanceof java.util.Date) {
            long l2 = ((java.util.Date)object).getTime();
            if (n2 == 91) {
                this.setDate(n, new Date(l2));
                return;
            }
            if (n2 == 92) {
                this.setTime(n, new Time(l2));
                return;
            }
            if (n2 != 93) return;
            this.setTimestamp(n, new Timestamp(l2));
            return;
        }
        if (object instanceof Boolean) {
            this.setBoolean(n, (Boolean)object);
            return;
        }
        if (object instanceof Blob) {
            this.setBlob(n, (Blob)object);
            return;
        }
        if (object instanceof Clob) {
            this.setClob(n, (Clob)object);
            return;
        }
        if (object instanceof InputStream) {
            this.setBinaryStream(n, (InputStream)object, l);
            return;
        }
        if (object instanceof Reader) {
            this.setCharacterStream(n, (Reader)object, l);
            return;
        }
        if (object instanceof LocalDateTime) {
            this.setTimestamp(n, Timestamp.valueOf((LocalDateTime)object));
            return;
        }
        if (object instanceof Instant) {
            this.setTimestamp(n, Timestamp.from((Instant)object));
            return;
        }
        if (object instanceof LocalDate) {
            this.setDate(n, Date.valueOf((LocalDate)object));
            return;
        }
        if (object instanceof OffsetDateTime) {
            this.setParameter(n, new ZonedDateTimeParameter(((OffsetDateTime)object).toZonedDateTime(), this.protocol.getTimeZone(), this.a, this.options));
            return;
        }
        if (object instanceof OffsetTime) {
            this.setParameter(n, new OffsetTimeParameter((OffsetTime)object, this.protocol.getTimeZone(), this.a, this.options));
            return;
        }
        if (object instanceof ZonedDateTime) {
            this.setParameter(n, new ZonedDateTimeParameter((ZonedDateTime)object, this.protocol.getTimeZone(), this.a, this.options));
            return;
        }
        if (object instanceof LocalTime) {
            this.setParameter(n, new LocalTimeParameter((LocalTime)object, this.a));
            return;
        }
        throw this.exceptionFactory.create(String.format("Could not set parameter in setObject, could not convert: %s to %s", object.getClass(), n2));
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) {
        if (inputStream == null) {
            this.setNull(n, ColumnType.BLOB);
            return;
        }
        this.setParameter(n, new StreamParameter(inputStream, l, this.b));
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) {
        if (inputStream == null) {
            this.setNull(n, ColumnType.BLOB);
            return;
        }
        this.setParameter(n, new StreamParameter(inputStream, this.b));
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) {
        if (inputStream == null) {
            this.setNull(n, ColumnType.BLOB);
            return;
        }
        this.setParameter(n, new StreamParameter(inputStream, n2, this.b));
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) {
        if (inputStream == null) {
            this.setNull(n, ColumnType.BLOB);
            return;
        }
        this.setParameter(n, new StreamParameter(inputStream, l, this.b));
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) {
        if (inputStream == null) {
            this.setNull(n, ColumnType.BLOB);
            return;
        }
        this.setParameter(n, new StreamParameter(inputStream, this.b));
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) {
        if (inputStream == null) {
            this.setNull(n, ColumnType.BLOB);
            return;
        }
        this.setParameter(n, new StreamParameter(inputStream, n2, this.b));
    }

    @Override
    public void setBoolean(int n, boolean bl) {
        this.setParameter(n, new BooleanParameter(bl));
    }

    @Override
    public void setByte(int n, byte by) {
        this.setParameter(n, new ByteParameter(by));
    }

    @Override
    public void setShort(int n, short s) {
        this.setParameter(n, new ShortParameter(s));
    }

    @Override
    public void setString(int n, String string) {
        if (string == null) {
            this.setNull(n, ColumnType.VARCHAR);
            return;
        }
        this.setParameter(n, new StringParameter(string, this.b));
    }

    @Override
    public void setBytes(int n, byte[] byArray) {
        if (byArray == null) {
            this.setNull(n, ColumnType.BLOB);
            return;
        }
        this.setParameter(n, new ByteArrayParameter(byArray, this.b));
    }

    @Override
    public void setUnicodeStream(int n, InputStream inputStream, int n2) {
        if (inputStream == null) {
            this.setNull(n, 2004);
            return;
        }
        this.setParameter(n, new StreamParameter(inputStream, n2, this.b));
    }

    @Override
    public void setInt(int n, int n2) {
        this.setParameter(n, new IntParameter(n2));
    }

    @Override
    public void setLong(int n, long l) {
        this.setParameter(n, new LongParameter(l));
    }

    @Override
    public void setFloat(int n, float f) {
        this.setParameter(n, new FloatParameter(f));
    }

    @Override
    public void setDouble(int n, double d) {
        this.setParameter(n, new DoubleParameter(d));
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            this.setNull(n, ColumnType.DECIMAL);
            return;
        }
        this.setParameter(n, new BigDecimalParameter(bigDecimal));
    }
}

