/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.Logger;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.LoggerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.constant.HaMode;

public class HostAddress {
    private static final Logger a = LoggerFactory.getLogger(HostAddress.class);
    public String host;
    public int port;
    public String type = null;

    private HostAddress() {
    }

    public HostAddress(String string, int n) {
        this.host = string;
        this.port = n;
        this.type = "master";
    }

    public HostAddress(String string, int n, String string2) {
        this.host = string;
        this.port = n;
        this.type = string2;
    }

    public static List<HostAddress> parse(String object, HaMode haMode) {
        Object object2;
        if (object == null) {
            throw new IllegalArgumentException("Invalid connection URL, host address must not be empty ");
        }
        if ("".equals(object)) {
            return new ArrayList<HostAddress>(0);
        }
        String[] stringArray = ((String)object).trim().split(",");
        int n = stringArray.length;
        ArrayList<HostAddress> arrayList = new ArrayList<HostAddress>(n);
        if (haMode == HaMode.AURORA && !((Matcher)(object = (object2 = Pattern.compile("(.+)\\.(?:cluster-|cluster-ro-)([a-z0-9]+\\.[a-z0-9\\-]+\\.rds\\.amazonaws\\.com)", 2)).matcher((CharSequence)object))).find()) {
            a.warn("Aurora recommended connection URL must only use cluster end-point like \"jdbc:mariadb:aurora://xx.cluster-yy.zz.rds.amazonaws.com\". Using end-point permit auto-discovery of new replicas");
        }
        object2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = object2[i];
            if (string.startsWith("address=")) {
                arrayList.add(HostAddress.c(string));
                continue;
            }
            HostAddress hostAddress = new HostAddress();
            if (string.charAt(0) == '[') {
                int n3 = string.indexOf(93);
                hostAddress.host = string.substring(1, n3);
                if (n3 != string.length() - 1 && string.charAt(n3 + 1) == ':') {
                    hostAddress.port = HostAddress.b(string.substring(n3 + 2));
                }
            } else if (string.contains(":")) {
                String[] stringArray2 = string.split(":");
                hostAddress.host = stringArray2[0];
                hostAddress.port = HostAddress.b(stringArray2[1]);
            } else {
                hostAddress.host = string;
                hostAddress.port = 3306;
            }
            arrayList.add(hostAddress);
        }
        if (haMode == HaMode.REPLICATION) {
            for (int i = 0; i < n; ++i) {
                if (i == 0 && ((HostAddress)arrayList.get((int)i)).type == null) {
                    ((HostAddress)arrayList.get((int)i)).type = "master";
                    continue;
                }
                if (i == 0 || ((HostAddress)arrayList.get((int)i)).type != null) continue;
                ((HostAddress)arrayList.get((int)i)).type = "replica";
            }
        }
        return arrayList;
    }

    private static HostAddress a(String string) {
        HostAddress hostAddress = new HostAddress();
        if (string.charAt(0) == '[') {
            int n = string.indexOf(93);
            hostAddress.host = string.substring(1, n);
            if (n != string.length() - 1 && string.charAt(n + 1) == ':') {
                hostAddress.port = HostAddress.b(string.substring(n + 2));
            }
        } else if (string.contains(":")) {
            String[] stringArray = string.split(":");
            hostAddress.host = stringArray[0];
            hostAddress.port = HostAddress.b(stringArray[1]);
        } else {
            hostAddress.host = string;
            hostAddress.port = 3306;
        }
        return hostAddress;
    }

    private static int b(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Incorrect port value : " + string);
        }
    }

    private static HostAddress c(String stringArray) {
        HostAddress hostAddress = new HostAddress();
        stringArray = stringArray.split("(?=\\()|(?<=\\))");
        for (int i = 1; i < stringArray.length; ++i) {
            Object object = stringArray[i].replace("(", "").replace(")", "").trim().split("=");
            if (((String[])object).length != 2) {
                throw new IllegalArgumentException("Invalid connection URL, expected key=value pairs, found " + stringArray[i]);
            }
            String string = object[0].toLowerCase();
            object = object[1].toLowerCase();
            if ("host".equals(string)) {
                hostAddress.host = ((String)object).replace("[", "").replace("]", "");
                continue;
            }
            if ("port".equals(string)) {
                hostAddress.port = HostAddress.b((String)object);
                continue;
            }
            if (!"type".equals(string)) continue;
            if (((String)object).equals("master") || ((String)object).equals("replica")) {
                hostAddress.type = object;
                continue;
            }
            if (!"slave".equals(object)) continue;
            hostAddress.type = "replica";
        }
        return hostAddress;
    }

    public static String toString(List<HostAddress> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get((int)i).type != null) {
                stringBuilder.append("address=(host=").append(list.get((int)i).host).append(")(port=").append(list.get((int)i).port).append(")(type=").append(list.get((int)i).type).append(")");
            } else {
                boolean bl = list.get((int)i).host != null && list.get((int)i).host.contains(":");
                String string = bl ? "[" + list.get((int)i).host + "]" : list.get((int)i).host;
                stringBuilder.append(string).append(":").append(list.get((int)i).port);
            }
            if (i >= list.size() - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    public static String toString(HostAddress[] hostAddressArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < hostAddressArray.length; ++i) {
            if (hostAddressArray[i].type != null) {
                stringBuilder.append("address=(host=").append(hostAddressArray[i].host).append(")(port=").append(hostAddressArray[i].port).append(")(type=").append(hostAddressArray[i].type).append(")");
            } else {
                boolean bl = hostAddressArray[i].host != null && hostAddressArray[i].host.contains(":");
                String string = bl ? "[" + hostAddressArray[i].host + "]" : hostAddressArray[i].host;
                stringBuilder.append(string).append(":").append(hostAddressArray[i].port);
            }
            if (i >= hostAddressArray.length - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return "HostAddress{host='" + this.host + '\'' + ", port=" + this.port + (this.type != null ? ", type='" + this.type + "'" : "") + "}";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (HostAddress)object;
        return this.port == ((HostAddress)object).port && (this.host != null ? this.host.equals(((HostAddress)object).host) : ((HostAddress)object).host == null && !(this.type == null ? ((HostAddress)object).type != null : !this.type.equals(((HostAddress)object).type)));
    }

    public int hashCode() {
        int n = this.host != null ? this.host.hashCode() : 0;
        n = n * 31 + this.port;
        return n;
    }
}

