/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.ColumnType;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.read.resultset.ColumnDefinition;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.exceptions.ExceptionFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.util.Options;

public class MariaDbResultSetMetaData
implements ResultSetMetaData {
    private final ColumnDefinition[] a;
    private final Options b;
    private final boolean c;

    public MariaDbResultSetMetaData(ColumnDefinition[] columnDefinitionArray, Options options, boolean bl) {
        this.a = columnDefinitionArray;
        this.b = options;
        this.c = bl;
    }

    @Override
    public int getColumnCount() {
        return this.a.length;
    }

    @Override
    public boolean isAutoIncrement(int n) {
        return (this.a(n).getFlags() & 0x200) != 0;
    }

    @Override
    public boolean isCaseSensitive(int n) {
        return (this.a(n).getFlags() & 0x80) != 0;
    }

    @Override
    public boolean isSearchable(int n) {
        return true;
    }

    @Override
    public boolean isCurrency(int n) {
        return false;
    }

    @Override
    public int isNullable(int n) {
        if ((this.a(n).getFlags() & 1) == 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isSigned(int n) {
        return this.a(n).isSigned();
    }

    @Override
    public int getColumnDisplaySize(int n) {
        return this.a(n).getDisplaySize();
    }

    @Override
    public String getColumnLabel(int n) {
        return this.a(n).getName();
    }

    @Override
    public String getColumnName(int n) {
        String string = this.a(n).getOriginalName();
        if ("".equals(string) || this.b.useOldAliasMetadataBehavior || this.c) {
            return this.getColumnLabel(n);
        }
        return string;
    }

    @Override
    public String getCatalogName(int n) {
        return this.a(n).getDatabase();
    }

    @Override
    public int getPrecision(int n) {
        return (int)this.a(n).getPrecision();
    }

    @Override
    public int getScale(int n) {
        return this.a(n).getDecimals();
    }

    @Override
    public String getTableName(int n) {
        if (this.c) {
            return this.a(n).getTable();
        }
        if (this.b.blankTableNameMeta) {
            return "";
        }
        if (this.b.useOldAliasMetadataBehavior) {
            return this.a(n).getTable();
        }
        return this.a(n).getOriginalTable();
    }

    @Override
    public String getSchemaName(int n) {
        return "";
    }

    @Override
    public int getColumnType(int n) {
        ColumnDefinition columnDefinition = this.a(n);
        switch (columnDefinition.getColumnType()) {
            case BIT: {
                if (columnDefinition.getLength() == 1L) {
                    return -7;
                }
                return -3;
            }
            case TINYINT: {
                if (columnDefinition.getLength() == 1L && this.b.tinyInt1isBit) {
                    return -7;
                }
                return -6;
            }
            case YEAR: {
                if (this.b.yearIsDateType) {
                    return 91;
                }
                return 5;
            }
            case BLOB: {
                if (columnDefinition.getLength() < 0L || columnDefinition.getLength() > 0xFFFFFFL) {
                    return -4;
                }
                return -3;
            }
            case VARCHAR: 
            case VARSTRING: {
                if (columnDefinition.isBinary()) {
                    return -3;
                }
                if (columnDefinition.getLength() < 0L) {
                    return -1;
                }
                return 12;
            }
            case STRING: {
                if (columnDefinition.isBinary()) {
                    return -2;
                }
                return 1;
            }
        }
        return columnDefinition.getColumnType().getSqlType();
    }

    @Override
    public String getColumnTypeName(int n) {
        ColumnDefinition columnDefinition = this.a(n);
        return ColumnType.getColumnTypeName(columnDefinition.getColumnType(), columnDefinition.getLength(), columnDefinition.getDisplaySize(), columnDefinition.isSigned(), columnDefinition.isBinary());
    }

    @Override
    public boolean isReadOnly(int n) {
        ColumnDefinition columnDefinition = this.a(n);
        return !(columnDefinition.getOriginalTable() != null && !columnDefinition.getOriginalTable().isEmpty() || columnDefinition.getOriginalName() != null && !columnDefinition.getOriginalName().isEmpty());
    }

    @Override
    public boolean isWritable(int n) {
        return !this.isReadOnly(n);
    }

    @Override
    public boolean isDefinitelyWritable(int n) {
        return !this.isReadOnly(n);
    }

    @Override
    public String getColumnClassName(int n) {
        ColumnDefinition columnDefinition = this.a(n);
        ColumnType columnType = columnDefinition.getColumnType();
        return ColumnType.getClassName(columnType, (int)columnDefinition.getLength(), columnDefinition.isSigned(), columnDefinition.isBinary(), this.b);
    }

    private ColumnDefinition a(int n) {
        if (n > 0 && n <= this.a.length) {
            return this.a[n - 1];
        }
        throw ExceptionFactory.INSTANCE.create(String.format("wrong column index %s. must be in [1, %s] range", n, this.a.length));
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        try {
            if (this.isWrapperFor(clazz)) {
                return clazz.cast(this);
            }
            throw new SQLException("The receiver is not a wrapper for " + clazz.getName());
        }
        catch (Exception exception) {
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz.isInstance(this);
    }
}

