/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbConnection;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.read.dao.Results;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.read.resultset.SelectResultSet;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.Logger;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.LoggerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.Protocol;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.Utils;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.exceptions.ExceptionFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.scheduler.SchedulerServiceProviderHolder;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.util.Options;

public class MariaDbStatement
implements Cloneable,
Statement {
    private static final Pattern a = Pattern.compile("[0-9a-zA-Z\\$_\\u0080-\\uFFFF]*", 192);
    private static final Pattern b = Pattern.compile("[\u0000'\"\b\n\r\t\u001a\\\\]");
    private static final Map<String, String> c = new HashMap<String, String>();
    private static final Logger d = LoggerFactory.getLogger(MariaDbStatement.class);
    protected final ReentrantLock lock;
    protected final int resultSetScrollType;
    protected final int resultSetConcurrency;
    protected final Options options;
    protected final boolean canUseServerTimeout;
    protected Protocol protocol;
    protected MariaDbConnection connection;
    protected volatile boolean closed = false;
    protected int queryTimeout;
    protected long maxRows;
    protected Results results;
    protected int fetchSize;
    protected volatile boolean executing;
    protected ExceptionFactory exceptionFactory;
    private ScheduledExecutorService e;
    private boolean f;
    private boolean g = false;
    private List<String> h;
    private Future<?> i;
    private boolean j;
    private int k;
    private boolean l = true;

    public MariaDbStatement(MariaDbConnection mariaDbConnection, int n, int n2, ExceptionFactory exceptionFactory) {
        this.protocol = mariaDbConnection.getProtocol();
        this.connection = mariaDbConnection;
        this.canUseServerTimeout = mariaDbConnection.canUseServerTimeout();
        this.resultSetScrollType = n;
        this.resultSetConcurrency = n2;
        this.lock = this.connection.lock;
        this.options = this.protocol.getOptions();
        this.exceptionFactory = exceptionFactory;
        this.fetchSize = this.options.defaultFetchSize;
    }

    public MariaDbStatement clone(MariaDbConnection mariaDbConnection) {
        MariaDbStatement mariaDbStatement = (MariaDbStatement)super.clone();
        ((MariaDbStatement)super.clone()).connection = mariaDbConnection;
        mariaDbStatement.protocol = mariaDbConnection.getProtocol();
        mariaDbStatement.i = null;
        mariaDbStatement.h = new ArrayList<String>();
        mariaDbStatement.closed = false;
        mariaDbStatement.f = true;
        mariaDbStatement.maxRows = 0L;
        mariaDbStatement.fetchSize = this.options.defaultFetchSize;
        mariaDbStatement.exceptionFactory = ExceptionFactory.of(this.exceptionFactory.getThreadId(), this.exceptionFactory.getOptions());
        return mariaDbStatement;
    }

    protected void setTimerTask(boolean bl) {
        assert (this.i == null);
        if (this.e == null) {
            this.e = SchedulerServiceProviderHolder.getTimeoutScheduler();
        }
        this.i = this.e.schedule(() -> {
            try {
                this.j = true;
                if (!bl) {
                    this.protocol.cancelCurrentQuery();
                }
                this.protocol.interrupt();
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }, (long)this.queryTimeout, TimeUnit.SECONDS);
    }

    protected void executeQueryPrologue(boolean bl) {
        this.executing = true;
        if (this.closed) {
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("execute() is called on closed statement");
        }
        this.protocol.prolog(this.maxRows, this.protocol.getProxy() != null, this.connection, this);
        if (this.queryTimeout != 0 && (!this.canUseServerTimeout || bl)) {
            this.setTimerTask(bl);
        }
    }

    private void a() {
        if (this.i != null) {
            if (!this.i.cancel(true)) {
                try {
                    this.i.get();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException executionException) {}
            }
            this.i = null;
        }
    }

    protected SQLException executeExceptionEpilogue(SQLException sQLException) {
        if (sQLException.getSQLState() != null && sQLException.getSQLState().startsWith("08")) {
            try {
                this.close();
            }
            catch (SQLException sQLException2) {}
        }
        if (sQLException.getErrorCode() == 1148 && !this.options.allowLocalInfile) {
            return this.exceptionFactory.raiseStatementError(this.connection, this).create("Usage of LOCAL INFILE is disabled. To use it enable it via the connection property allowLocalInfile=true", "42000", 1148, sQLException);
        }
        if (this.j) {
            return this.exceptionFactory.raiseStatementError(this.connection, this).create("Query timed out", "70100", 1317, sQLException);
        }
        sQLException = this.exceptionFactory.raiseStatementError(this.connection, this).create(sQLException);
        d.error("error executing query", sQLException);
        return sQLException;
    }

    protected void executeEpilogue() {
        this.a();
        this.j = false;
        this.executing = false;
    }

    protected void executeBatchEpilogue() {
        this.executing = false;
        this.a();
        this.j = false;
        this.clearBatch();
    }

    private SQLException a(SQLException sQLException) {
        if (sQLException.getSQLState() != null && sQLException.getSQLState().startsWith("08")) {
            try {
                this.close();
            }
            catch (SQLException sQLException2) {}
        }
        if (this.j) {
            return this.exceptionFactory.raiseStatementError(this.connection, this).create("Query timed out", "70100", 1317, sQLException);
        }
        return sQLException;
    }

    protected BatchUpdateException executeBatchExceptionEpilogue(SQLException sQLException, int n) {
        int[] nArray;
        sQLException = this.a(sQLException);
        if (this.results == null || !this.results.commandEnd()) {
            nArray = new int[n];
            Arrays.fill(nArray, -3);
        } else {
            nArray = this.results.getCmdInformation().getUpdateCounts();
        }
        sQLException = this.exceptionFactory.raiseStatementError(this.connection, this).create(sQLException);
        d.error("error executing query", sQLException);
        return new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray, (Throwable)sQLException);
    }

    private boolean a(String string, int n, int n2) {
        this.lock.lock();
        try {
            this.executeQueryPrologue(false);
            this.results = new Results(this, n, false, 1, false, this.resultSetScrollType, this.resultSetConcurrency, n2, this.protocol.getAutoIncrementIncrement(), string, null);
            MariaDbStatement mariaDbStatement = this;
            this.protocol.executeQuery(this.protocol.isMasterConnection(), this.results, mariaDbStatement.a(mariaDbStatement.a(string, this.protocol)));
            this.results.commandEnd();
            boolean bl = this.results.getResultSet() != null;
            return bl;
        }
        catch (SQLException sQLException) {
            throw this.executeExceptionEpilogue(sQLException);
        }
        finally {
            this.executeEpilogue();
            this.lock.unlock();
        }
    }

    @Override
    public String enquoteLiteral(String object) {
        object = b.matcher((CharSequence)object);
        StringBuffer stringBuffer = new StringBuffer("'");
        while (((Matcher)object).find()) {
            ((Matcher)object).appendReplacement(stringBuffer, c.get(((Matcher)object).group()));
        }
        ((Matcher)object).appendTail(stringBuffer);
        stringBuffer.append("'");
        return stringBuffer.toString();
    }

    @Override
    public String enquoteIdentifier(String string, boolean bl) {
        if (this.isSimpleIdentifier(string)) {
            if (bl) {
                return "`" + string + "`";
            }
            return string;
        }
        if (string.contains("\u0000")) {
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("Invalid name - containing u0000 character", "42000");
        }
        if (string.matches("^`.+`$")) {
            string = string.substring(1, string.length() - 1);
        }
        return "`" + string.replace("`", "``") + "`";
    }

    @Override
    public boolean isSimpleIdentifier(String string) {
        return string != null && !string.isEmpty() && a.matcher(string).matches();
    }

    @Override
    public String enquoteNCharLiteral(String string) {
        return "N'" + string.replace("'", "''") + "'";
    }

    private String a(String string) {
        if (this.queryTimeout != 0 && this.canUseServerTimeout) {
            return "SET STATEMENT max_statement_time=" + this.queryTimeout + " FOR " + string;
        }
        return string;
    }

    private String a(String string, Protocol protocol) {
        if (this.l) {
            return Utils.nativeSql(string, protocol);
        }
        return string;
    }

    public boolean testExecute(String string, Charset charset) {
        this.lock.lock();
        try {
            this.executeQueryPrologue(false);
            MariaDbStatement mariaDbStatement = this;
            this.results = new Results(mariaDbStatement, mariaDbStatement.fetchSize, false, 1, false, this.resultSetScrollType, this.resultSetConcurrency, 2, this.protocol.getAutoIncrementIncrement(), string, null);
            MariaDbStatement mariaDbStatement2 = this;
            this.protocol.executeQuery(this.protocol.isMasterConnection(), this.results, mariaDbStatement2.a(mariaDbStatement2.a(string, this.protocol)), charset);
            this.results.commandEnd();
            boolean bl = this.results.getResultSet() != null;
            return bl;
        }
        catch (SQLException sQLException) {
            throw this.executeExceptionEpilogue(sQLException);
        }
        finally {
            this.executeEpilogue();
            this.lock.unlock();
        }
    }

    @Override
    public boolean execute(String string) {
        return this.a(string, this.fetchSize, 2);
    }

    @Override
    public boolean execute(String string, int n) {
        return this.a(string, this.fetchSize, n);
    }

    @Override
    public boolean execute(String string, int[] nArray) {
        return this.a(string, this.fetchSize, 1);
    }

    @Override
    public boolean execute(String string, String[] stringArray) {
        return this.a(string, this.fetchSize, 1);
    }

    @Override
    public ResultSet executeQuery(String string) {
        if (this.a(string, this.fetchSize, 2)) {
            return this.results.getResultSet();
        }
        return SelectResultSet.createEmptyResultSet();
    }

    @Override
    public int executeUpdate(String string) {
        if (this.a(string, this.fetchSize, 2)) {
            return 0;
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String string, int n) {
        if (this.a(string, this.fetchSize, n)) {
            return 0;
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String string, int[] nArray) {
        return this.executeUpdate(string, 1);
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) {
        return this.executeUpdate(string, 1);
    }

    @Override
    public long executeLargeUpdate(String string) {
        if (this.a(string, this.fetchSize, 2)) {
            return 0L;
        }
        return this.getLargeUpdateCount();
    }

    @Override
    public long executeLargeUpdate(String string, int n) {
        if (this.a(string, this.fetchSize, n)) {
            return 0L;
        }
        return this.getLargeUpdateCount();
    }

    @Override
    public long executeLargeUpdate(String string, int[] nArray) {
        return this.executeLargeUpdate(string, 1);
    }

    @Override
    public long executeLargeUpdate(String string, String[] stringArray) {
        return this.executeLargeUpdate(string, 1);
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            this.closed = true;
            if (this.results != null) {
                if (this.results.getFetchSize() != 0) {
                    this.skipMoreResults();
                }
                this.results.close();
            }
            if (this.connection == null || this.connection.pooledConnection == null || this.connection.pooledConnection.noStmtEventListeners()) {
                return;
            }
            this.connection.pooledConnection.fireStatementClosed(this);
            return;
        }
        finally {
            this.protocol = null;
            this.connection = null;
            this.lock.unlock();
        }
    }

    @Override
    public int getMaxFieldSize() {
        return this.k;
    }

    @Override
    public void setMaxFieldSize(int n) {
        this.k = n;
    }

    @Override
    public int getMaxRows() {
        return (int)this.maxRows;
    }

    @Override
    public void setMaxRows(int n) {
        if (n < 0) {
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("max rows cannot be negative : asked for " + n, "42000");
        }
        this.maxRows = n;
    }

    @Override
    public long getLargeMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setLargeMaxRows(long l) {
        if (l < 0L) {
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("max rows cannot be negative : setLargeMaxRows value is " + l, "42000");
        }
        this.maxRows = l;
    }

    @Override
    public void setEscapeProcessing(boolean bl) {
        this.l = bl;
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int n) {
        if (n < 0) {
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("Query timeout cannot be negative : asked for " + n, "42000");
        }
        this.queryTimeout = n;
    }

    public void setLocalInfileInputStream(InputStream inputStream) {
        this.checkClose();
        this.protocol.setLocalInfileInputStream(inputStream);
    }

    @Override
    public void cancel() {
        this.checkClose();
        boolean bl = this.lock.tryLock();
        try {
            if (this.executing) {
                this.protocol.cancelCurrentQuery();
            } else if (this.results != null && this.results.getFetchSize() != 0 && !this.results.isFullyLoaded(this.protocol)) {
                try {
                    this.protocol.cancelCurrentQuery();
                    this.skipMoreResults();
                }
                catch (SQLException sQLException) {}
                this.results.removeFetchSize();
            }
            if (bl) {
                this.lock.unlock();
                return;
            }
        }
        catch (SQLException sQLException) {
            try {
                d.error("error cancelling query", sQLException);
                throw this.exceptionFactory.raiseStatementError(this.connection, this).create(sQLException);
            }
            catch (Throwable throwable) {
                if (bl) {
                    this.lock.unlock();
                }
                throw throwable;
            }
        }
    }

    @Override
    public SQLWarning getWarnings() {
        this.checkClose();
        if (!this.f) {
            return this.connection.getWarnings();
        }
        return null;
    }

    @Override
    public void clearWarnings() {
        this.f = true;
    }

    @Override
    public void setCursorName(String string) {
        throw this.exceptionFactory.raiseStatementError(this.connection, this).notSupported("Cursors are not supported");
    }

    @Override
    public MariaDbConnection getConnection() {
        return this.connection;
    }

    @Override
    public ResultSet getGeneratedKeys() {
        if (this.results != null) {
            return this.results.getGeneratedKeys(this.protocol);
        }
        return SelectResultSet.createEmptyResultSet();
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isPoolable() {
        return false;
    }

    @Override
    public void setPoolable(boolean bl) {
    }

    @Override
    public ResultSet getResultSet() {
        this.checkClose();
        if (this.results != null) {
            return this.results.getResultSet();
        }
        return null;
    }

    @Override
    public int getUpdateCount() {
        if (this.results != null && this.results.getCmdInformation() != null && !this.results.isBatch()) {
            return this.results.getCmdInformation().getUpdateCount();
        }
        return -1;
    }

    @Override
    public long getLargeUpdateCount() {
        if (this.results != null && this.results.getCmdInformation() != null && !this.results.isBatch()) {
            return this.results.getCmdInformation().getLargeUpdateCount();
        }
        return -1L;
    }

    protected void skipMoreResults() {
        try {
            this.protocol.skip();
            this.f = false;
            this.connection.reenableWarnings();
            return;
        }
        catch (SQLException sQLException) {
            d.debug("error skipMoreResults", sQLException);
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create(sQLException);
        }
    }

    @Override
    public boolean getMoreResults() {
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int n) {
        this.checkClose();
        return this.results != null && this.results.getMoreResults(n, this.protocol);
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public void setFetchDirection(int n) {
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int n) {
        if (n < 0 && n != Integer.MIN_VALUE) {
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("invalid fetch size");
        }
        if (n == Integer.MIN_VALUE) {
            this.fetchSize = 1;
            return;
        }
        this.fetchSize = n;
    }

    @Override
    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() {
        return this.resultSetScrollType;
    }

    @Override
    public void addBatch(String string) {
        if (this.h == null) {
            this.h = new ArrayList<String>();
        }
        if (string == null) {
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("null cannot be set to addBatch( String sql)");
        }
        this.h.add(string);
    }

    @Override
    public void clearBatch() {
        if (this.h != null) {
            this.h.clear();
        }
    }

    @Override
    public int[] executeBatch() {
        int n;
        this.checkClose();
        if (this.h == null || (n = this.h.size()) == 0) {
            return new int[0];
        }
        this.lock.lock();
        try {
            this.a(n);
            int[] nArray = this.results.getCmdInformation().getUpdateCounts();
            return nArray;
        }
        catch (SQLException sQLException) {
            throw this.executeBatchExceptionEpilogue(sQLException, n);
        }
        finally {
            this.executeBatchEpilogue();
            this.lock.unlock();
        }
    }

    @Override
    public long[] executeLargeBatch() {
        int n;
        this.checkClose();
        if (this.h == null || (n = this.h.size()) == 0) {
            return new long[0];
        }
        this.lock.lock();
        try {
            this.a(n);
            long[] lArray = this.results.getCmdInformation().getLargeUpdateCounts();
            return lArray;
        }
        catch (SQLException sQLException) {
            throw this.executeBatchExceptionEpilogue(sQLException, n);
        }
        finally {
            this.executeBatchEpilogue();
            this.lock.unlock();
        }
    }

    private void a(int n) {
        this.executeQueryPrologue(true);
        this.results = new Results(this, 0, true, n, false, this.resultSetScrollType, this.resultSetConcurrency, 1, this.protocol.getAutoIncrementIncrement(), null, null);
        this.protocol.executeBatchStmt(this.protocol.isMasterConnection(), this.results, this.h);
        this.results.commandEnd();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        try {
            if (this.isWrapperFor(clazz)) {
                return (T)this;
            }
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("The receiver is not a wrapper and does not implement the interface", "42000");
        }
        catch (Exception exception) {
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("The receiver is not a wrapper and does not implement the interface", "42000");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz.isInstance(this);
    }

    @Override
    public void closeOnCompletion() {
        this.g = true;
    }

    @Override
    public boolean isCloseOnCompletion() {
        return this.g;
    }

    public void checkCloseOnCompletion(ResultSet resultSet) {
        if (this.g && !this.closed && this.results != null && resultSet.equals(this.results.getResultSet())) {
            this.close();
        }
    }

    protected void checkClose() {
        if (this.closed) {
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("Cannot do an operation on a closed statement");
        }
    }

    static {
        c.put("\u0000", "\\0");
        c.put("'", "\\\\'");
        c.put("\"", "\\\\\"");
        c.put("\b", "\\\\b");
        c.put("\n", "\\\\n");
        c.put("\r", "\\\\r");
        c.put("\t", "\\\\t");
        c.put("\u001a", "\\\\Z");
        c.put("\\", "\\\\");
    }
}

