/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.util.Options;

public enum ColumnType {
    OLDDECIMAL(0, 3, "Types.DECIMAL", BigDecimal.class.getName()),
    TINYINT(1, 5, "Types.SMALLINT", Integer.class.getName()),
    SMALLINT(2, 5, "Types.SMALLINT", Integer.class.getName()),
    INTEGER(3, 4, "Types.INTEGER", Integer.class.getName()),
    FLOAT(4, 7, "Types.REAL", Float.class.getName()),
    DOUBLE(5, 8, "Types.DOUBLE", Double.class.getName()),
    NULL(6, 0, "Types.NULL", String.class.getName()),
    TIMESTAMP(7, 93, "Types.TIMESTAMP", Timestamp.class.getName()),
    BIGINT(8, -5, "Types.BIGINT", Long.class.getName()),
    MEDIUMINT(9, 4, "Types.INTEGER", Integer.class.getName()),
    DATE(10, 91, "Types.DATE", Date.class.getName()),
    TIME(11, 92, "Types.TIME", Time.class.getName()),
    DATETIME(12, 93, "Types.TIMESTAMP", Timestamp.class.getName()),
    YEAR(13, 5, "Types.SMALLINT", Short.class.getName()),
    NEWDATE(14, 91, "Types.DATE", Date.class.getName()),
    VARCHAR(15, 12, "Types.VARCHAR", String.class.getName()),
    BIT(16, -7, "Types.BIT", "[B"),
    JSON(245, 12, "Types.VARCHAR", String.class.getName()),
    DECIMAL(246, 3, "Types.DECIMAL", BigDecimal.class.getName()),
    ENUM(247, 12, "Types.VARCHAR", String.class.getName()),
    SET(248, 12, "Types.VARCHAR", String.class.getName()),
    TINYBLOB(249, -3, "Types.VARBINARY", "[B"),
    MEDIUMBLOB(250, -3, "Types.VARBINARY", "[B"),
    LONGBLOB(251, -4, "Types.LONGVARBINARY", "[B"),
    BLOB(252, -4, "Types.LONGVARBINARY", "[B"),
    VARSTRING(253, 12, "Types.VARCHAR", String.class.getName()),
    STRING(254, 12, "Types.VARCHAR", String.class.getName()),
    GEOMETRY(255, -3, "Types.VARBINARY", "[B");

    static final ColumnType[] typeMap;
    private final short a;
    private final int b;
    private final String c;
    private final String d;

    private ColumnType(int n2, int n3, String string2, String string3) {
        this.a = (short)n2;
        this.b = n3;
        this.c = string2;
        this.d = string3;
    }

    public static Class classFromJavaType(int n) {
        switch (n) {
            case -7: 
            case 16: {
                return Boolean.class;
            }
            case -6: {
                return Byte.class;
            }
            case 5: {
                return Short.class;
            }
            case 4: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 6: 
            case 8: {
                return Double.class;
            }
            case 7: {
                return Float.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case 91: {
                return Date.class;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: 
            case 2011: {
                return String.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2000: 
            case 2004: {
                return byte[].class;
            }
            case 0: {
                return null;
            }
            case 92: {
                return Time.class;
            }
        }
        return null;
    }

    public static boolean isNumeric(ColumnType columnType) {
        switch (columnType) {
            case OLDDECIMAL: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: 
            case BIGINT: 
            case MEDIUMINT: 
            case BIT: 
            case DECIMAL: {
                return true;
            }
        }
        return false;
    }

    public static String getColumnTypeName(ColumnType columnType, long l, long l2, boolean bl, boolean bl2) {
        switch (columnType) {
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case MEDIUMINT: {
                if (!bl) {
                    return columnType.getTypeName() + " UNSIGNED";
                }
                return columnType.getTypeName();
            }
            case BLOB: {
                if (l < 0L) {
                    return "LONGBLOB";
                }
                if (l <= 255L) {
                    return "TINYBLOB";
                }
                if (l <= 65535L) {
                    return "BLOB";
                }
                if (l <= 0xFFFFFFL) {
                    return "MEDIUMBLOB";
                }
                return "LONGBLOB";
            }
            case VARSTRING: 
            case VARCHAR: {
                if (bl2) {
                    return "VARBINARY";
                }
                if (l < 0L) {
                    return "LONGTEXT";
                }
                if (l2 <= 65532L) {
                    return "VARCHAR";
                }
                if (l2 <= 65535L) {
                    return "TEXT";
                }
                if (l2 <= 0xFFFFFFL) {
                    return "MEDIUMTEXT";
                }
                return "LONGTEXT";
            }
            case STRING: {
                if (bl2) {
                    return "BINARY";
                }
                return "CHAR";
            }
        }
        return columnType.getTypeName();
    }

    public static ColumnType fromServer(int n, int n2) {
        ColumnType columnType = typeMap[n];
        if (columnType == null) {
            columnType = BLOB;
        }
        if (n2 != 63 && n >= 249 && n <= 252) {
            return VARCHAR;
        }
        return columnType;
    }

    public static ColumnType toServer(int n) {
        for (ColumnType columnType : ColumnType.values()) {
            if (columnType.b != n) continue;
            return columnType;
        }
        return BLOB;
    }

    public static String getClassName(ColumnType columnType, int n, boolean bl, boolean bl2, Options options) {
        switch (columnType) {
            case TINYINT: {
                if (n == 1 && options.tinyInt1isBit) {
                    return Boolean.class.getName();
                }
                return Integer.class.getName();
            }
            case INTEGER: {
                if (bl) {
                    return Integer.class.getName();
                }
                return Long.class.getName();
            }
            case BIGINT: {
                if (bl) {
                    return Long.class.getName();
                }
                return BigInteger.class.getName();
            }
            case YEAR: {
                if (options.yearIsDateType) {
                    return Date.class.getName();
                }
                return Short.class.getName();
            }
            case BIT: {
                if (n == 1) {
                    return Boolean.class.getName();
                }
                return "[B";
            }
            case VARSTRING: 
            case VARCHAR: 
            case STRING: {
                if (bl2) {
                    return "[B";
                }
                return String.class.getName();
            }
        }
        return columnType.getClassName();
    }

    public final String getClassName() {
        return this.d;
    }

    public final int getSqlType() {
        return this.b;
    }

    public final String getTypeName() {
        return this.name();
    }

    public final short getType() {
        return this.a;
    }

    public final String getJavaTypeName() {
        return this.c;
    }

    static {
        typeMap = new ColumnType[256];
        ColumnType[] columnTypeArray = ColumnType.values();
        int n = columnTypeArray.length;
        for (int i = 0; i < n; ++i) {
            ColumnType columnType;
            ColumnType.typeMap[columnType.a] = columnType = columnTypeArray[i];
        }
    }
}

