/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.read.resultset.rowprotocol;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.regex.Pattern;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.read.resultset.ColumnDefinition;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.util.Options;

public abstract class RowProtocol {
    public static final int BIT_LAST_FIELD_NOT_NULL = 0;
    public static final int BIT_LAST_FIELD_NULL = 1;
    public static final int BIT_LAST_ZERO_DATE = 2;
    public static final int TINYINT1_IS_BIT = 1;
    public static final int YEAR_IS_DATE_TYPE = 2;
    public static final DateTimeFormatter TEXT_LOCAL_DATE_TIME;
    public static final DateTimeFormatter TEXT_OFFSET_DATE_TIME;
    public static final DateTimeFormatter TEXT_ZONED_DATE_TIME;
    public static final Pattern isIntegerRegex;
    protected static final int NULL_LENGTH = -1;
    protected final int maxFieldSize;
    protected final Options options;
    public int lastValueNull;
    public byte[] buf;
    public int pos;
    public int length;
    protected int index;

    public RowProtocol(int n, Options options) {
        this.maxFieldSize = n;
        this.options = options;
    }

    public void resetRow(byte[] byArray) {
        this.buf = byArray;
        this.index = -1;
    }

    public abstract void setPosition(int var1);

    public int getLengthMaxFieldSize() {
        if (this.maxFieldSize != 0 && this.maxFieldSize < this.length) {
            return this.maxFieldSize;
        }
        return this.length;
    }

    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    public abstract String getInternalString(ColumnDefinition var1, Calendar var2, TimeZone var3);

    public abstract int getInternalInt(ColumnDefinition var1);

    public abstract long getInternalLong(ColumnDefinition var1);

    public abstract float getInternalFloat(ColumnDefinition var1);

    public abstract double getInternalDouble(ColumnDefinition var1);

    public abstract BigDecimal getInternalBigDecimal(ColumnDefinition var1);

    public abstract Date getInternalDate(ColumnDefinition var1, Calendar var2, TimeZone var3);

    public abstract Time getInternalTime(ColumnDefinition var1, Calendar var2, TimeZone var3);

    public abstract Timestamp getInternalTimestamp(ColumnDefinition var1, Calendar var2, TimeZone var3);

    public abstract Object getInternalObject(ColumnDefinition var1, TimeZone var2);

    public abstract boolean getInternalBoolean(ColumnDefinition var1);

    public abstract byte getInternalByte(ColumnDefinition var1);

    public abstract short getInternalShort(ColumnDefinition var1);

    public abstract String getInternalTimeString(ColumnDefinition var1);

    public abstract BigInteger getInternalBigInteger(ColumnDefinition var1);

    public abstract ZonedDateTime getInternalZonedDateTime(ColumnDefinition var1, Class var2, TimeZone var3);

    public abstract OffsetTime getInternalOffsetTime(ColumnDefinition var1, TimeZone var2);

    public abstract LocalTime getInternalLocalTime(ColumnDefinition var1, TimeZone var2);

    public abstract LocalDate getInternalLocalDate(ColumnDefinition var1, TimeZone var2);

    public abstract boolean isBinaryEncoded();

    public boolean lastValueWasNull() {
        return (this.lastValueNull & 1) != 0;
    }

    protected String zeroFillingIfNeeded(String string, ColumnDefinition columnDefinition) {
        if (columnDefinition.isZeroFill()) {
            StringBuilder stringBuilder = new StringBuilder();
            long l = columnDefinition.getDisplaySize() - string.length();
            while (l-- > 0L) {
                stringBuilder.append("0");
            }
            return stringBuilder.append(string).toString();
        }
        return string;
    }

    protected int getInternalTinyInt(ColumnDefinition columnDefinition) {
        if (this.lastValueWasNull()) {
            return 0;
        }
        int n = this.buf[this.pos];
        if (!columnDefinition.isSigned()) {
            n = this.buf[this.pos] & 0xFF;
        }
        return n;
    }

    protected long parseBit() {
        if (this.length == 1) {
            return this.buf[this.pos];
        }
        long l = 0L;
        int n = 0;
        do {
            l += (long)(this.buf[this.pos + n] & 0xFF) << 8 * (this.length - ++n);
        } while (n < this.length);
        return l;
    }

    protected int getInternalSmallInt(ColumnDefinition columnDefinition) {
        if (this.lastValueWasNull()) {
            return 0;
        }
        int n = (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8);
        if (!columnDefinition.isSigned()) {
            return n & 0xFFFF;
        }
        return (short)n;
    }

    protected long getInternalMediumInt(ColumnDefinition columnDefinition) {
        if (this.lastValueWasNull()) {
            return 0L;
        }
        long l = (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8) + ((this.buf[this.pos + 2] & 0xFF) << 16) + ((this.buf[this.pos + 3] & 0xFF) << 24);
        if (!columnDefinition.isSigned()) {
            l &= 0xFFFFFFFFL;
        }
        return l;
    }

    protected void rangeCheck(Object object, long l, long l2, BigDecimal bigDecimal, ColumnDefinition columnDefinition) {
        if (bigDecimal.compareTo(BigDecimal.valueOf(l)) < 0 || bigDecimal.compareTo(BigDecimal.valueOf(l2)) > 0) {
            throw new SQLException("Out of range value for column '" + columnDefinition.getName() + "' : value " + bigDecimal + " is not in " + object + " range", "22003", 1264);
        }
    }

    protected void rangeCheck(Object object, long l, long l2, long l3, ColumnDefinition columnDefinition) {
        if (l3 < l || l3 > l2) {
            throw new SQLException("Out of range value for column '" + columnDefinition.getName() + "' : value " + l3 + " is not in " + object + " range", "22003", 1264);
        }
    }

    protected int extractNanos(String string) {
        int n = string.indexOf(46);
        if (n == -1) {
            return 0;
        }
        int n2 = 0;
        for (int i = n + 1; i < n + 10; ++i) {
            int n3;
            if (i >= string.length()) {
                n3 = 0;
            } else {
                n3 = string.charAt(i);
                if (n3 < 48 || n3 > 57) {
                    throw new SQLException("cannot parse sub-second part in timestamp string '" + string + "'");
                }
                n3 -= 48;
            }
            n2 = n2 * 10 + n3;
        }
        return n2;
    }

    public boolean wasNull() {
        return (this.lastValueNull & 1) != 0 || (this.lastValueNull & 2) != 0;
    }

    static {
        isIntegerRegex = Pattern.compile("^-?\\d+\\.[0-9]+$");
        TEXT_LOCAL_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter();
        TEXT_OFFSET_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(TEXT_LOCAL_DATE_TIME).appendOffsetId().toFormatter();
        TEXT_ZONED_DATE_TIME = new DateTimeFormatterBuilder().append(TEXT_OFFSET_DATE_TIME).optionalStart().appendLiteral('[').parseCaseSensitive().appendZoneRegionId().appendLiteral(']').toFormatter();
    }
}

