/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.read.resultset.rowprotocol;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.TimeZone;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.ColumnType;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.read.resultset.ColumnDefinition;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.read.resultset.rowprotocol.RowProtocol;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.exceptions.ExceptionFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.util.Options;

public class TextRowProtocol
extends RowProtocol {
    public TextRowProtocol(int n, Options options) {
        super(n, options);
    }

    @Override
    public void setPosition(int n) {
        if (this.index != n) {
            if (this.index == -1 || this.index > n) {
                this.pos = 0;
                this.index = 0;
            } else {
                ++this.index;
                if (this.length != -1) {
                    this.pos += this.length;
                }
            }
            while (this.index <= n) {
                int n2;
                if (this.index != n) {
                    n2 = this.buf[this.pos++] & 0xFF;
                    switch (n2) {
                        case 251: {
                            break;
                        }
                        case 252: {
                            this.pos += 2 + (0xFFFF & (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8));
                            break;
                        }
                        case 253: {
                            this.pos += 3 + (0xFFFFFF & (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8) + ((this.buf[this.pos + 2] & 0xFF) << 16));
                            break;
                        }
                        case 254: {
                            this.pos = (int)((long)this.pos + (8L + ((long)(this.buf[this.pos] & 0xFF) + ((long)(this.buf[this.pos + 1] & 0xFF) << 8) + ((long)(this.buf[this.pos + 2] & 0xFF) << 16) + ((long)(this.buf[this.pos + 3] & 0xFF) << 24) + ((long)(this.buf[this.pos + 4] & 0xFF) << 32) + ((long)(this.buf[this.pos + 5] & 0xFF) << 40) + ((long)(this.buf[this.pos + 6] & 0xFF) << 48) + ((long)(this.buf[this.pos + 7] & 0xFF) << 56))));
                            break;
                        }
                        default: {
                            this.pos += n2;
                            break;
                        }
                    }
                } else {
                    n2 = this.buf[this.pos++] & 0xFF;
                    switch (n2) {
                        case 251: {
                            this.length = -1;
                            this.lastValueNull = 1;
                            return;
                        }
                        case 252: {
                            this.length = 0xFFFF & (this.buf[this.pos++] & 0xFF) + ((this.buf[this.pos++] & 0xFF) << 8);
                            break;
                        }
                        case 253: {
                            this.length = 0xFFFFFF & (this.buf[this.pos++] & 0xFF) + ((this.buf[this.pos++] & 0xFF) << 8) + ((this.buf[this.pos++] & 0xFF) << 16);
                            break;
                        }
                        case 254: {
                            this.length = (int)((long)(this.buf[this.pos++] & 0xFF) + ((long)(this.buf[this.pos++] & 0xFF) << 8) + ((long)(this.buf[this.pos++] & 0xFF) << 16) + ((long)(this.buf[this.pos++] & 0xFF) << 24) + ((long)(this.buf[this.pos++] & 0xFF) << 32) + ((long)(this.buf[this.pos++] & 0xFF) << 40) + ((long)(this.buf[this.pos++] & 0xFF) << 48) + ((long)(this.buf[this.pos++] & 0xFF) << 56));
                            break;
                        }
                        default: {
                            this.length = n2;
                        }
                    }
                    this.lastValueNull = 0;
                    return;
                }
                ++this.index;
            }
        }
        this.lastValueNull = this.length == -1 ? 1 : 0;
    }

    @Override
    public String getInternalString(ColumnDefinition object, Calendar comparable, TimeZone timeZone) {
        if (this.lastValueWasNull()) {
            return null;
        }
        switch (((ColumnDefinition)object).getColumnType()) {
            case BIT: {
                return String.valueOf(this.parseBit());
            }
            case DOUBLE: 
            case FLOAT: {
                return this.zeroFillingIfNeeded(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8), (ColumnDefinition)object);
            }
            case TIME: {
                return this.getInternalTimeString((ColumnDefinition)object);
            }
            case DATE: {
                object = this.getInternalDate((ColumnDefinition)object, (Calendar)comparable, timeZone);
                if (object == null) {
                    if ((this.lastValueNull & 2) != 0) {
                        this.lastValueNull ^= 2;
                        return new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
                    }
                    return null;
                }
                return ((Date)object).toString();
            }
            case YEAR: {
                if (!this.options.yearIsDateType) break;
                if ((object = this.getInternalDate((ColumnDefinition)object, (Calendar)comparable, timeZone)) == null) {
                    return null;
                }
                return ((Date)object).toString();
            }
            case TIMESTAMP: 
            case DATETIME: {
                object = this.getInternalTimestamp((ColumnDefinition)object, (Calendar)comparable, timeZone);
                if (object == null) {
                    if ((this.lastValueNull & 2) != 0) {
                        this.lastValueNull ^= 2;
                        return new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
                    }
                    return null;
                }
                return ((Timestamp)object).toString();
            }
            case DECIMAL: 
            case OLDDECIMAL: {
                comparable = this.getInternalBigDecimal((ColumnDefinition)object);
                if (comparable == null) {
                    return null;
                }
                return this.zeroFillingIfNeeded(((BigDecimal)comparable).toString(), (ColumnDefinition)object);
            }
            case NULL: {
                return null;
            }
        }
        if (this.maxFieldSize > 0) {
            return new String(this.buf, this.pos, Math.min(this.maxFieldSize, this.length), StandardCharsets.UTF_8);
        }
        return new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
    }

    @Override
    public int getInternalInt(ColumnDefinition columnDefinition) {
        if (this.lastValueWasNull()) {
            return 0;
        }
        long l = this.getInternalLong(columnDefinition);
        this.rangeCheck(Integer.class, Integer.MIN_VALUE, Integer.MAX_VALUE, l, columnDefinition);
        return (int)l;
    }

    @Override
    public long getInternalLong(ColumnDefinition columnDefinition) {
        if (this.lastValueWasNull()) {
            return 0L;
        }
        try {
            switch (columnDefinition.getColumnType()) {
                case FLOAT: {
                    Float f = Float.valueOf(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8));
                    if (f.compareTo(Float.valueOf(9.223372E18f)) > 0) {
                        throw new SQLException("Out of range value for column '" + columnDefinition.getName() + "' : value " + new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8) + " is not in Long range", "22003", 1264);
                    }
                    return f.longValue();
                }
                case DOUBLE: {
                    Double d = Double.valueOf(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8));
                    if (d.compareTo(9.223372036854776E18) > 0) {
                        throw new SQLException("Out of range value for column '" + columnDefinition.getName() + "' : value " + new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8) + " is not in Long range", "22003", 1264);
                    }
                    return d.longValue();
                }
                case BIT: {
                    return this.parseBit();
                }
                case YEAR: 
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case MEDIUMINT: 
                case BIGINT: {
                    long l = 0L;
                    boolean bl = false;
                    int n = this.pos;
                    if (this.length > 0 && this.buf[n] == 45) {
                        bl = true;
                        ++n;
                    }
                    while (n < this.pos + this.length) {
                        l = l * 10L + (long)this.buf[n] - 48L;
                        ++n;
                    }
                    if (l < 0L) {
                        if (l == Long.MIN_VALUE && bl) {
                            return Long.MIN_VALUE;
                        }
                        throw new SQLException("Out of range value for column '" + columnDefinition.getName() + "' for value " + new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8), "22003", 1264);
                    }
                    if (bl) {
                        return -1L * l;
                    }
                    return l;
                }
            }
            return Long.parseLong(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8));
        }
        catch (NumberFormatException numberFormatException) {
            String string = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
            if (isIntegerRegex.matcher(string).find()) {
                try {
                    return Long.parseLong(string.substring(0, string.indexOf(".")));
                }
                catch (NumberFormatException numberFormatException2) {}
            }
            throw new SQLException("Out of range value for column '" + columnDefinition.getName() + "' : value " + string, "22003", 1264);
        }
    }

    @Override
    public float getInternalFloat(ColumnDefinition object) {
        if (this.lastValueWasNull()) {
            return 0.0f;
        }
        switch (((ColumnDefinition)object).getColumnType()) {
            case BIT: {
                return this.parseBit();
            }
            case DOUBLE: 
            case FLOAT: 
            case YEAR: 
            case DECIMAL: 
            case OLDDECIMAL: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case MEDIUMINT: 
            case BIGINT: 
            case VARSTRING: 
            case VARCHAR: 
            case STRING: {
                try {
                    return Float.valueOf(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8)).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    object = new SQLException("Incorrect format \"" + new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8) + "\" for getFloat for data field with type " + ((ColumnDefinition)object).getColumnType().getJavaTypeName(), "22003", 1264);
                    ((Throwable)object).initCause(numberFormatException);
                    throw object;
                }
            }
        }
        throw new SQLException("getFloat not available for data field type " + ((ColumnDefinition)object).getColumnType().getJavaTypeName());
    }

    @Override
    public double getInternalDouble(ColumnDefinition object) {
        if (this.lastValueWasNull()) {
            return 0.0;
        }
        switch (((ColumnDefinition)object).getColumnType()) {
            case BIT: {
                return this.parseBit();
            }
            case DOUBLE: 
            case FLOAT: 
            case YEAR: 
            case DECIMAL: 
            case OLDDECIMAL: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case MEDIUMINT: 
            case BIGINT: 
            case VARSTRING: 
            case VARCHAR: 
            case STRING: {
                try {
                    return Double.valueOf(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8));
                }
                catch (NumberFormatException numberFormatException) {
                    object = new SQLException("Incorrect format \"" + new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8) + "\" for getDouble for data field with type " + ((ColumnDefinition)object).getColumnType().getJavaTypeName(), "22003", 1264);
                    ((Throwable)object).initCause(numberFormatException);
                    throw object;
                }
            }
        }
        throw new SQLException("getDouble not available for data field type " + ((ColumnDefinition)object).getColumnType().getJavaTypeName());
    }

    @Override
    public BigDecimal getInternalBigDecimal(ColumnDefinition columnDefinition) {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (columnDefinition.getColumnType() == ColumnType.BIT) {
            return BigDecimal.valueOf(this.parseBit());
        }
        return new BigDecimal(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8));
    }

    @Override
    public Date getInternalDate(ColumnDefinition object, Calendar calendar, TimeZone timeZone) {
        if (this.lastValueWasNull()) {
            return null;
        }
        int n = 0;
        switch (((ColumnDefinition)object).getColumnType()) {
            case DATE: {
                object = new int[]{0, 0, 0};
                for (int i = this.pos; i < this.pos + this.length; ++i) {
                    byte by = this.buf[i];
                    if (by == 45) {
                        ++n;
                        continue;
                    }
                    if (by < 48 || by > 57) {
                        throw new SQLException("cannot parse data in date string '" + new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8) + "'");
                    }
                    object[n] = object[n] * 10 + by - 48;
                }
                if (object[0] == false && object[1] == false && object[2] == false) {
                    this.lastValueNull |= 2;
                    return null;
                }
                return new Date((int)(object[0] - 1900), (int)(object[1] - true), (int)object[2]);
            }
            case TIMESTAMP: 
            case DATETIME: {
                int n2;
                int n3 = -1;
                int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0};
                for (n2 = this.pos; n2 < this.pos + this.length; ++n2) {
                    byte by = this.buf[n2];
                    if (by == 45 || by == 32 || by == 58) {
                        ++n;
                        continue;
                    }
                    if (by == 46) {
                        ++n;
                        n3 = n2;
                        continue;
                    }
                    if (by < 48 || by > 57) {
                        throw new SQLException("cannot parse data in timestamp string '" + new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8) + "'");
                    }
                    nArray[n] = nArray[n] * 10 + by - 48;
                }
                if (nArray[0] == 0 && nArray[1] == 0 && nArray[2] == 0 && nArray[3] == 0 && nArray[4] == 0 && nArray[5] == 0 && nArray[6] == 0) {
                    this.lastValueNull |= 2;
                    return null;
                }
                if (n3 > 0) {
                    for (n2 = 0; n2 < 6 - (this.pos + this.length - n3 - 1); ++n2) {
                        nArray[6] = nArray[6] * 10;
                    }
                }
                if (timeZone == null) {
                    Calendar calendar2 = calendar != null ? calendar : Calendar.getInstance();
                    Calendar calendar3 = calendar2;
                    synchronized (calendar2) {
                        calendar2.clear();
                        calendar2.set(1, nArray[0]);
                        calendar2.set(2, nArray[1] - 1);
                        calendar2.set(5, nArray[2]);
                        calendar2.set(11, 0);
                        calendar2.set(12, 0);
                        calendar2.set(13, 0);
                        calendar2.set(14, 0);
                        // ** MonitorExit[var7_18] (shouldn't be in output)
                        return new Date(calendar2.getTimeInMillis());
                    }
                }
                Comparable<ChronoLocalDateTime<?>> comparable = LocalDateTime.of(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5], nArray[6] * 1000);
                ZonedDateTime zonedDateTime = ((LocalDateTime)comparable).atZone(timeZone.toZoneId()).withZoneSameInstant(TimeZone.getDefault().toZoneId());
                comparable = calendar != null ? calendar : Calendar.getInstance();
                calendar = comparable;
                synchronized (comparable) {
                    ((Calendar)comparable).clear();
                    ((Calendar)comparable).set(1, zonedDateTime.getYear());
                    ((Calendar)comparable).set(2, zonedDateTime.getMonthValue() - 1);
                    ((Calendar)comparable).set(5, zonedDateTime.getDayOfMonth());
                    ((Calendar)comparable).set(11, 0);
                    ((Calendar)comparable).set(12, 0);
                    ((Calendar)comparable).set(13, 0);
                    ((Calendar)comparable).set(14, 0);
                    // ** MonitorExit[var2_6] (shouldn't be in output)
                    return new Date(((Calendar)comparable).getTimeInMillis());
                }
            }
            case TIME: {
                throw new SQLException("Cannot read DATE using a Types.TIME field");
            }
            case YEAR: {
                int n4 = 0;
                for (n = this.pos; n < this.pos + this.length; ++n) {
                    n4 = n4 * 10 + this.buf[n] - 48;
                }
                if (this.length == 2 && ((ColumnDefinition)object).getLength() == 2L) {
                    n4 = n4 <= 69 ? (n4 += 2000) : (n4 += 1900);
                }
                return new Date(n4 - 1900, 0, 1);
            }
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            if (timeZone != null) {
                simpleDateFormat.setTimeZone(timeZone);
            }
            object = simpleDateFormat.parse(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8));
            return new Date(((java.util.Date)object).getTime());
        }
        catch (ParseException parseException) {
            throw ExceptionFactory.INSTANCE.create("Could not get object as Date : " + parseException.getMessage(), "S1009", parseException);
        }
    }

    @Override
    public Time getInternalTime(ColumnDefinition object, Calendar calendar, TimeZone cloneable) {
        String[] stringArray;
        if (this.lastValueWasNull()) {
            return null;
        }
        if (((ColumnDefinition)object).getColumnType() == ColumnType.TIMESTAMP || ((ColumnDefinition)object).getColumnType() == ColumnType.DATETIME) {
            int n;
            int n2 = -1;
            int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0};
            int n3 = 0;
            for (n = this.pos; n < this.pos + this.length; ++n) {
                byte by = this.buf[n];
                if (by == 45 || by == 32 || by == 58) {
                    ++n3;
                    continue;
                }
                if (by == 46) {
                    ++n3;
                    n2 = n;
                    continue;
                }
                if (by < 48 || by > 57) {
                    throw new SQLException("cannot parse data in timestamp string '" + new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8) + "'");
                }
                nArray[n3] = nArray[n3] * 10 + by - 48;
            }
            if (nArray[0] == 0 && nArray[1] == 0 && nArray[2] == 0 && nArray[3] == 0 && nArray[4] == 0 && nArray[5] == 0 && nArray[6] == 0) {
                this.lastValueNull |= 2;
                return null;
            }
            if (n2 > 0) {
                for (n = 0; n < 6 - (this.pos + this.length - n2 - 1); ++n) {
                    nArray[6] = nArray[6] * 10;
                }
            }
            if (cloneable == null) {
                Calendar calendar2 = calendar != null ? calendar : Calendar.getInstance();
                Calendar calendar3 = calendar2;
                synchronized (calendar2) {
                    calendar2.clear();
                    calendar2.set(1, 1970);
                    calendar2.set(2, 0);
                    calendar2.set(5, 1);
                    calendar2.set(11, nArray[3]);
                    calendar2.set(12, nArray[4]);
                    calendar2.set(13, nArray[5]);
                    calendar2.set(14, nArray[6] / 1000);
                    // ** MonitorExit[var7_18] (shouldn't be in output)
                    return new Time(calendar2.getTimeInMillis());
                }
            }
            LocalDateTime localDateTime = LocalDateTime.of(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5], nArray[6] * 1000);
            ZonedDateTime zonedDateTime = localDateTime.atZone(((TimeZone)cloneable).toZoneId()).withZoneSameInstant(TimeZone.getDefault().toZoneId());
            cloneable = calendar != null ? calendar : Calendar.getInstance();
            calendar = cloneable;
            synchronized (cloneable) {
                ((Calendar)cloneable).clear();
                ((Calendar)cloneable).set(1, 1970);
                ((Calendar)cloneable).set(2, 0);
                ((Calendar)cloneable).set(5, 1);
                ((Calendar)cloneable).set(11, zonedDateTime.getHour());
                ((Calendar)cloneable).set(12, zonedDateTime.getMinute());
                ((Calendar)cloneable).set(13, zonedDateTime.getSecond());
                ((Calendar)cloneable).set(14, zonedDateTime.getNano() / 1000000);
                // ** MonitorExit[var2_5] (shouldn't be in output)
                return new Time(((Calendar)cloneable).getTimeInMillis());
            }
        }
        if (((ColumnDefinition)object).getColumnType() == ColumnType.DATE) {
            throw new SQLException("Cannot read Time using a Types.DATE field");
        }
        object = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
        if (!this.options.useLegacyDatetimeCode && (((String)object).startsWith("-") || ((String)object).split(":").length != 3 || ((String)object).indexOf(":") > 3)) {
            throw new SQLException("Time format \"" + (String)object + "\" incorrect, must be HH:mm:ss");
        }
        boolean bl = ((String)object).startsWith("-");
        if (bl) {
            object = ((String)object).substring(1);
        }
        if ((stringArray = ((String)object).split(":")).length == 3) {
            int n = Integer.parseInt(stringArray[0]);
            int n4 = Integer.parseInt(stringArray[1]);
            int n5 = Integer.parseInt(stringArray[2].substring(0, 2));
            Calendar calendar4 = calendar = calendar != null ? calendar : Calendar.getInstance();
            if (this.options.useLegacyDatetimeCode) {
                calendar.setLenient(true);
            }
            calendar.clear();
            calendar.set(1970, 0, 1, (bl ? -1 : 1) * n, n4, n5);
            int n6 = this.extractNanos((String)object);
            calendar.set(14, n6 / 1000000);
            return new Time(calendar.getTimeInMillis());
        }
        throw new SQLException((String)object + " cannot be parse as time. time must have \"99:99:99\" format");
    }

    @Override
    public Timestamp getInternalTimestamp(ColumnDefinition object, Calendar object2, TimeZone timeZone) {
        if (this.lastValueWasNull()) {
            return null;
        }
        switch (((ColumnDefinition)object).getColumnType()) {
            case DATE: 
            case TIMESTAMP: 
            case DATETIME: 
            case VARSTRING: 
            case VARCHAR: 
            case STRING: {
                Timestamp timestamp;
                int n;
                int n2 = -1;
                int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0};
                int n3 = 0;
                for (n = this.pos; n < this.pos + this.length; ++n) {
                    byte by = this.buf[n];
                    if (by == 45 || by == 32 || by == 58) {
                        ++n3;
                        continue;
                    }
                    if (by == 46) {
                        ++n3;
                        n2 = n;
                        continue;
                    }
                    if (by < 48 || by > 57) {
                        throw new SQLException("cannot parse data in timestamp string '" + new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8) + "'");
                    }
                    nArray[n3] = nArray[n3] * 10 + by - 48;
                }
                if (nArray[0] == 0 && nArray[1] == 0 && nArray[2] == 0 && nArray[3] == 0 && nArray[4] == 0 && nArray[5] == 0 && nArray[6] == 0) {
                    this.lastValueNull |= 2;
                    return null;
                }
                if (n2 > 0) {
                    for (n = 0; n < 6 - (this.pos + this.length - n2 - 1); ++n) {
                        nArray[6] = nArray[6] * 10;
                    }
                }
                Object object3 = object2 != null ? object2 : (timeZone != null && ((ColumnDefinition)object).getColumnType() != ColumnType.DATE ? Calendar.getInstance(timeZone) : Calendar.getInstance());
                Object object4 = object3;
                synchronized (object4) {
                    ((Calendar)object3).clear();
                    ((Calendar)object3).set(1, nArray[0]);
                    ((Calendar)object3).set(2, nArray[1] - 1);
                    ((Calendar)object3).set(5, nArray[2]);
                    ((Calendar)object3).set(11, nArray[3]);
                    ((Calendar)object3).set(12, nArray[4]);
                    ((Calendar)object3).set(13, nArray[5]);
                    ((Calendar)object3).set(14, nArray[6] / 1000000);
                    timestamp = new Timestamp(((Calendar)object3).getTime().getTime());
                }
                timestamp.setNanos(nArray[6] * 1000);
                return timestamp;
            }
            case TIME: {
                String string = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
                object = new Timestamp(this.getInternalTime((ColumnDefinition)object, (Calendar)object2, timeZone).getTime());
                ((Timestamp)object).setNanos(this.extractNanos(string));
                return object;
            }
        }
        object2 = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
        throw new SQLException("Value type \"" + ((ColumnDefinition)object).getColumnType().getTypeName() + "\" with value \"" + (String)object2 + "\" cannot be parse as Timestamp");
    }

    @Override
    public Object getInternalObject(ColumnDefinition object, TimeZone timeZone) {
        if (this.lastValueWasNull()) {
            return null;
        }
        switch (((ColumnDefinition)object).getColumnType()) {
            case BIT: {
                if (((ColumnDefinition)object).getLength() == 1L) {
                    return this.buf[this.pos] != 0;
                }
                object = new byte[this.length];
                System.arraycopy(this.buf, this.pos, object, 0, this.length);
                return object;
            }
            case TINYINT: {
                if (this.options.tinyInt1isBit && ((ColumnDefinition)object).getLength() == 1L) {
                    return this.buf[this.pos] != 48;
                }
                return this.getInternalInt((ColumnDefinition)object);
            }
            case INTEGER: {
                if (!((ColumnDefinition)object).isSigned()) {
                    return this.getInternalLong((ColumnDefinition)object);
                }
                return this.getInternalInt((ColumnDefinition)object);
            }
            case BIGINT: {
                if (!((ColumnDefinition)object).isSigned()) {
                    return this.getInternalBigInteger((ColumnDefinition)object);
                }
                return this.getInternalLong((ColumnDefinition)object);
            }
            case DOUBLE: {
                return this.getInternalDouble((ColumnDefinition)object);
            }
            case VARSTRING: 
            case VARCHAR: 
            case STRING: {
                if (((ColumnDefinition)object).isBinary()) {
                    object = new byte[this.getLengthMaxFieldSize()];
                    System.arraycopy(this.buf, this.pos, object, 0, this.getLengthMaxFieldSize());
                    return object;
                }
                return this.getInternalString((ColumnDefinition)object, null, timeZone);
            }
            case TIMESTAMP: 
            case DATETIME: {
                return this.getInternalTimestamp((ColumnDefinition)object, null, timeZone);
            }
            case DATE: {
                return this.getInternalDate((ColumnDefinition)object, null, timeZone);
            }
            case DECIMAL: {
                return this.getInternalBigDecimal((ColumnDefinition)object);
            }
            case BLOB: 
            case LONGBLOB: 
            case MEDIUMBLOB: 
            case TINYBLOB: {
                object = new byte[this.getLengthMaxFieldSize()];
                System.arraycopy(this.buf, this.pos, object, 0, this.getLengthMaxFieldSize());
                return object;
            }
            case NULL: {
                return null;
            }
            case YEAR: {
                if (this.options.yearIsDateType) {
                    return this.getInternalDate((ColumnDefinition)object, null, timeZone);
                }
                return this.getInternalShort((ColumnDefinition)object);
            }
            case SMALLINT: 
            case MEDIUMINT: {
                return this.getInternalInt((ColumnDefinition)object);
            }
            case FLOAT: {
                return Float.valueOf(this.getInternalFloat((ColumnDefinition)object));
            }
            case TIME: {
                return this.getInternalTime((ColumnDefinition)object, null, timeZone);
            }
            case OLDDECIMAL: 
            case JSON: {
                return this.getInternalString((ColumnDefinition)object, null, timeZone);
            }
            case GEOMETRY: {
                object = new byte[this.length];
                System.arraycopy(this.buf, this.pos, object, 0, this.length);
                return object;
            }
        }
        throw ExceptionFactory.INSTANCE.notSupported("Type '" + ((ColumnDefinition)object).getColumnType().getTypeName() + "' is not supported");
    }

    @Override
    public boolean getInternalBoolean(ColumnDefinition object) {
        if (this.lastValueWasNull()) {
            return false;
        }
        if (((ColumnDefinition)object).getColumnType() == ColumnType.BIT) {
            return this.parseBit() != 0L;
        }
        object = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
        return !"false".equals(object) && !"0".equals(object);
    }

    @Override
    public byte getInternalByte(ColumnDefinition columnDefinition) {
        if (this.lastValueWasNull()) {
            return 0;
        }
        long l = this.getInternalLong(columnDefinition);
        this.rangeCheck(Byte.class, -128L, 127L, l, columnDefinition);
        return (byte)l;
    }

    @Override
    public short getInternalShort(ColumnDefinition columnDefinition) {
        if (this.lastValueWasNull()) {
            return 0;
        }
        long l = this.getInternalLong(columnDefinition);
        this.rangeCheck(Short.class, -32768L, 32767L, l, columnDefinition);
        return (short)l;
    }

    @Override
    public String getInternalTimeString(ColumnDefinition object) {
        if (this.lastValueWasNull()) {
            return null;
        }
        object = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
        if ("0000-00-00".equals(object)) {
            return null;
        }
        if (this.options.maximizeMysqlCompatibility && this.options.useLegacyDatetimeCode && ((String)object).indexOf(".") > 0) {
            return ((String)object).substring(0, ((String)object).indexOf("."));
        }
        return object;
    }

    @Override
    public BigInteger getInternalBigInteger(ColumnDefinition columnDefinition) {
        if (this.lastValueWasNull()) {
            return null;
        }
        return new BigInteger(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8));
    }

    @Override
    public ZonedDateTime getInternalZonedDateTime(ColumnDefinition object, Class clazz, TimeZone timeZone) {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        String string = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
        switch (((ColumnDefinition)object).getColumnType().getSqlType()) {
            case 93: {
                if (string.startsWith("0000-00-00 00:00:00")) {
                    return null;
                }
                try {
                    if (timeZone == null) {
                        object = LocalDateTime.parse(string, TEXT_LOCAL_DATE_TIME);
                        return ZonedDateTime.of((LocalDateTime)object, TimeZone.getDefault().toZoneId());
                    }
                    object = LocalDateTime.parse(string, TEXT_LOCAL_DATE_TIME.withZone(timeZone.toZoneId()));
                    return ZonedDateTime.of((LocalDateTime)object, timeZone.toZoneId());
                }
                catch (DateTimeParseException dateTimeParseException) {
                    throw new SQLException(string + " cannot be parse as LocalDateTime. time must have \"yyyy-MM-dd HH:mm:ss[.S]\" format");
                }
            }
            case -1: 
            case 1: 
            case 12: {
                if (string.startsWith("0000-00-00 00:00:00")) {
                    return null;
                }
                try {
                    return ZonedDateTime.parse(string, TEXT_ZONED_DATE_TIME);
                }
                catch (DateTimeParseException dateTimeParseException) {
                    throw new SQLException(string + " cannot be parse as ZonedDateTime. time must have \"yyyy-MM-dd[T/ ]HH:mm:ss[.S]\" with offset and timezone format (example : '2011-12-03 10:15:30+01:00[Europe/Paris]')");
                }
            }
        }
        throw new SQLException("Cannot read " + clazz.getName() + " using a " + ((ColumnDefinition)object).getColumnType().getJavaTypeName() + " field");
    }

    @Override
    public OffsetTime getInternalOffsetTime(ColumnDefinition columnDefinition, TimeZone serializable) {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        if ((serializable = serializable != null ? serializable.toZoneId().normalized() : TimeZone.getDefault().toZoneId().normalized()) instanceof ZoneOffset) {
            serializable = (ZoneOffset)serializable;
            String string = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
            switch (columnDefinition.getColumnType().getSqlType()) {
                case 93: {
                    if (string.startsWith("0000-00-00 00:00:00")) {
                        return null;
                    }
                    try {
                        return ZonedDateTime.parse(string, TEXT_LOCAL_DATE_TIME.withZone((ZoneId)serializable)).toOffsetDateTime().toOffsetTime();
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                        throw new SQLException(string + " cannot be parse as OffsetTime. time must have \"yyyy-MM-dd HH:mm:ss[.S]\" format");
                    }
                }
                case 92: {
                    try {
                        LocalTime localTime = LocalTime.parse(string, DateTimeFormatter.ISO_LOCAL_TIME.withZone((ZoneId)serializable));
                        return OffsetTime.of(localTime, (ZoneOffset)serializable);
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                        throw new SQLException(string + " cannot be parse as OffsetTime (format is \"HH:mm:ss[.S]\" for data type \"" + (Object)((Object)columnDefinition.getColumnType()) + "\")");
                    }
                }
                case -1: 
                case 1: 
                case 12: {
                    try {
                        return OffsetTime.parse(string, DateTimeFormatter.ISO_OFFSET_TIME);
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                        throw new SQLException(string + " cannot be parse as OffsetTime (format is \"HH:mm:ss[.S]\" with offset for data type \"" + (Object)((Object)columnDefinition.getColumnType()) + "\")");
                    }
                }
            }
            throw new SQLException("Cannot read " + OffsetTime.class.getName() + " using a " + columnDefinition.getColumnType().getJavaTypeName() + " field");
        }
        if (this.options.useLegacyDatetimeCode) {
            throw new SQLException("Cannot return an OffsetTime for a TIME field when default timezone is '" + serializable + "' (only possible for time-zone offset from Greenwich/UTC, such as +02:00)");
        }
        throw new SQLException("Cannot return an OffsetTime for a TIME field when server timezone '" + serializable + "' (only possible for time-zone offset from Greenwich/UTC, such as +02:00)");
    }

    @Override
    public LocalTime getInternalLocalTime(ColumnDefinition object, TimeZone timeZone) {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        String string = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
        switch (((ColumnDefinition)object).getColumnType().getSqlType()) {
            case -1: 
            case 1: 
            case 12: 
            case 92: {
                try {
                    if (timeZone == null) {
                        return LocalTime.parse(string, DateTimeFormatter.ISO_LOCAL_TIME);
                    }
                    return LocalTime.parse(string, DateTimeFormatter.ISO_LOCAL_TIME.withZone(timeZone.toZoneId()));
                }
                catch (DateTimeParseException dateTimeParseException) {
                    throw new SQLException(string + " cannot be parse as LocalTime (format is \"HH:mm:ss[.S]\" for data type \"" + (Object)((Object)((ColumnDefinition)object).getColumnType()) + "\")");
                }
            }
            case 93: {
                object = this.getInternalZonedDateTime((ColumnDefinition)object, LocalTime.class, timeZone);
                if (object == null) {
                    return null;
                }
                return ((ZonedDateTime)object).withZoneSameInstant(ZoneId.systemDefault()).toLocalTime();
            }
        }
        throw new SQLException("Cannot read LocalTime using a " + ((ColumnDefinition)object).getColumnType().getJavaTypeName() + " field");
    }

    @Override
    public LocalDate getInternalLocalDate(ColumnDefinition object, TimeZone timeZone) {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        String string = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
        switch (((ColumnDefinition)object).getColumnType().getSqlType()) {
            case -1: 
            case 1: 
            case 12: 
            case 91: {
                if (string.startsWith("0000-00-00")) {
                    return null;
                }
                try {
                    if (timeZone == null) {
                        return LocalDate.parse(string, DateTimeFormatter.ISO_LOCAL_DATE);
                    }
                    return LocalDate.parse(string, DateTimeFormatter.ISO_LOCAL_DATE.withZone(timeZone.toZoneId()));
                }
                catch (DateTimeParseException dateTimeParseException) {
                    throw new SQLException(string + " cannot be parse as LocalDate (format is \"yyyy-MM-dd\" for data type \"" + (Object)((Object)((ColumnDefinition)object).getColumnType()) + "\")");
                }
            }
            case 93: {
                object = this.getInternalZonedDateTime((ColumnDefinition)object, LocalDate.class, timeZone);
                if (object == null) {
                    return null;
                }
                return ((ZonedDateTime)object).withZoneSameInstant(ZoneId.systemDefault()).toLocalDate();
            }
        }
        throw new SQLException("Cannot read LocalDate using a " + ((ColumnDefinition)object).getColumnType().getJavaTypeName() + " field");
    }

    @Override
    public boolean isBinaryEncoded() {
        return false;
    }
}

