/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.thread;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.Listener;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.thread.TerminableRunnable;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.tools.SearchFilter;

public class FailoverLoop
extends TerminableRunnable {
    private static final ConcurrentLinkedQueue<Listener> a = new ConcurrentLinkedQueue();

    public FailoverLoop(ScheduledExecutorService scheduledExecutorService) {
        super(scheduledExecutorService, 1L, 1L, TimeUnit.SECONDS);
    }

    public static void addListener(Listener listener) {
        a.add(listener);
    }

    public static void removeListener(Listener listener) {
        a.remove(listener);
    }

    @Override
    protected void doRun() {
        Listener listener;
        while (!this.isUnschedule() && (listener = a.poll()) != null) {
            if (listener.isExplicitClosed() || !listener.hasHostFail() || !listener.canRetryFailLoop()) continue;
            try {
                SearchFilter searchFilter = listener.getFilterForFailedHost();
                searchFilter.setFailoverLoop(true);
                listener.reconnectFailedConnection(searchFilter);
                if (!listener.hasHostFail() || listener.isExplicitClosed()) continue;
                a.add(listener);
            }
            catch (Exception exception) {
                a.add(listener);
            }
        }
    }
}

