/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.output;

import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.LruTraceCache;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.output.PacketOutputStream;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.exceptions.MaxAllowedPacketException;

public abstract class AbstractPacketOutputStream
extends FilterOutputStream
implements PacketOutputStream {
    private static final byte a = 39;
    private static final byte b = 34;
    private static final byte c = 0;
    private static final byte d = 92;
    private static final int e = 8192;
    private static final int f = 131072;
    private static final int g = 0x100000;
    protected final int maxQuerySizeToLog;
    protected byte[] buf;
    protected int pos;
    protected int maxAllowedPacket = Integer.MAX_VALUE;
    protected long cmdLength;
    protected boolean permitTrace;
    protected int seqNo = 0;
    protected String serverThreadLog = "";
    protected LruTraceCache traceCache = null;
    private int h = -1;
    private boolean i = false;
    protected long threadId;

    public AbstractPacketOutputStream(OutputStream outputStream, int n, long l) {
        super(outputStream);
        this.buf = new byte[8192];
        this.maxQuerySizeToLog = n;
        this.cmdLength = 0L;
        this.threadId = l;
    }

    public abstract int getMaxPacketLength();

    @Override
    public abstract void startPacket(int var1);

    protected abstract void flushBuffer(boolean var1);

    private void a(int n) {
        int n2 = this.buf.length;
        int n3 = n2 == 8192 ? (n + this.pos < 131072 ? 131072 : (n + this.pos < 0x100000 ? 0x100000 : this.getMaxPacketLength())) : (n2 == 131072 ? (n + this.pos < 0x100000 ? 0x100000 : this.getMaxPacketLength()) : (this.i ? Math.max(n + this.pos, this.getMaxPacketLength()) : this.getMaxPacketLength()));
        if (this.h != -1 && n + this.pos > n3) {
            this.flushBufferStopAtMark();
            if (n + this.pos <= n2) {
                return;
            }
            if (n + this.pos > n3) {
                n3 = n + this.pos;
            }
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(this.buf, 0, byArray, 0, this.pos);
        this.buf = byArray;
    }

    @Override
    public void writeEmptyPacket(int n) {
        this.startPacket(n);
        this.writeEmptyPacket();
        this.out.flush();
        this.cmdLength = 0L;
    }

    @Override
    public abstract void writeEmptyPacket();

    @Override
    public void flush() {
        this.flushBuffer(true);
        this.out.flush();
        if (this.buf.length > 8192 && this.cmdLength << 1 < (long)this.buf.length) {
            this.buf = new byte[8192];
        }
        if (this.cmdLength >= (long)this.maxAllowedPacket) {
            throw new MaxAllowedPacketException("query size (" + this.cmdLength + ") is >= to max_allowed_packet (" + this.maxAllowedPacket + ")", true);
        }
    }

    @Override
    public boolean checkRemainingSize(int n) {
        return this.getMaxPacketLength() - this.pos > n;
    }

    @Override
    public void checkMaxAllowedLength(int n) {
        if (this.cmdLength + (long)n >= (long)this.maxAllowedPacket && this.cmdLength == 0L) {
            throw new MaxAllowedPacketException("query size (" + (this.cmdLength + (long)n) + ") is >= to max_allowed_packet (" + this.maxAllowedPacket + ")", false);
        }
    }

    @Override
    public boolean exceedMaxLength() {
        return this.cmdLength + (long)(this.pos - this.initialPacketPos()) >= (long)this.maxAllowedPacket;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public void writeShort(short s) {
        if (2 > this.buf.length - this.pos) {
            byte[] byArray = new byte[2];
            byte[] byArray2 = byArray;
            byArray[0] = (byte)s;
            byArray2[1] = (byte)(s >> 8);
            this.write(byArray2, 0, 2);
            return;
        }
        this.buf[this.pos] = (byte)s;
        this.buf[this.pos + 1] = (byte)(s >> 8);
        this.pos += 2;
    }

    @Override
    public void writeInt(int n) {
        if (4 > this.buf.length - this.pos) {
            byte[] byArray = new byte[4];
            byte[] byArray2 = byArray;
            byArray[0] = (byte)n;
            byArray2[1] = (byte)(n >> 8);
            byArray2[2] = (byte)(n >> 16);
            byArray2[3] = (byte)(n >> 24);
            this.write(byArray2, 0, 4);
            return;
        }
        this.buf[this.pos] = (byte)n;
        this.buf[this.pos + 1] = (byte)(n >> 8);
        this.buf[this.pos + 2] = (byte)(n >> 16);
        this.buf[this.pos + 3] = (byte)(n >> 24);
        this.pos += 4;
    }

    @Override
    public void writeLong(long l) {
        if (8 > this.buf.length - this.pos) {
            byte[] byArray = new byte[8];
            byte[] byArray2 = byArray;
            byArray[0] = (byte)l;
            byArray2[1] = (byte)(l >> 8);
            byArray2[2] = (byte)(l >> 16);
            byArray2[3] = (byte)(l >> 24);
            byArray2[4] = (byte)(l >> 32);
            byArray2[5] = (byte)(l >> 40);
            byArray2[6] = (byte)(l >> 48);
            byArray2[7] = (byte)(l >> 56);
            this.write(byArray2, 0, 8);
            return;
        }
        this.buf[this.pos] = (byte)l;
        this.buf[this.pos + 1] = (byte)(l >> 8);
        this.buf[this.pos + 2] = (byte)(l >> 16);
        this.buf[this.pos + 3] = (byte)(l >> 24);
        this.buf[this.pos + 4] = (byte)(l >> 32);
        this.buf[this.pos + 5] = (byte)(l >> 40);
        this.buf[this.pos + 6] = (byte)(l >> 48);
        this.buf[this.pos + 7] = (byte)(l >> 56);
        this.pos += 8;
    }

    @Override
    public void writeBytes(byte by, int n) {
        if (n > this.buf.length - this.pos) {
            byte[] byArray = new byte[n];
            Arrays.fill(byArray, by);
            this.write(byArray, 0, n);
            return;
        }
        for (int i = this.pos; i < this.pos + n; ++i) {
            this.buf[i] = by;
        }
        this.pos += n;
    }

    @Override
    public void writeFieldLength(long l) {
        if (l < 251L) {
            this.write((byte)l);
            return;
        }
        if (l < 65536L) {
            if (3 > this.buf.length - this.pos) {
                byte[] byArray = new byte[3];
                byte[] byArray2 = byArray;
                byArray[0] = -4;
                byArray2[1] = (byte)l;
                byArray2[2] = (byte)(l >>> 8);
                this.write(byArray2, 0, 3);
                return;
            }
            this.buf[this.pos] = -4;
            this.buf[this.pos + 1] = (byte)l;
            this.buf[this.pos + 2] = (byte)(l >>> 8);
            this.pos += 3;
            return;
        }
        if (l < 0x1000000L) {
            if (4 > this.buf.length - this.pos) {
                byte[] byArray = new byte[4];
                byte[] byArray3 = byArray;
                byArray[0] = -3;
                byArray3[1] = (byte)l;
                byArray3[2] = (byte)(l >>> 8);
                byArray3[3] = (byte)(l >>> 16);
                this.write(byArray3, 0, 4);
                return;
            }
            this.buf[this.pos] = -3;
            this.buf[this.pos + 1] = (byte)l;
            this.buf[this.pos + 2] = (byte)(l >>> 8);
            this.buf[this.pos + 3] = (byte)(l >>> 16);
            this.pos += 4;
            return;
        }
        if (9 > this.buf.length - this.pos) {
            byte[] byArray = new byte[9];
            byte[] byArray4 = byArray;
            byArray[0] = -2;
            byArray4[1] = (byte)l;
            byArray4[2] = (byte)(l >>> 8);
            byArray4[3] = (byte)(l >>> 16);
            byArray4[4] = (byte)(l >>> 24);
            byArray4[5] = (byte)(l >>> 32);
            byArray4[6] = (byte)(l >>> 40);
            byArray4[7] = (byte)(l >>> 48);
            byArray4[8] = (byte)(l >>> 56);
            this.write(byArray4, 0, 9);
            return;
        }
        this.buf[this.pos] = -2;
        this.buf[this.pos + 1] = (byte)l;
        this.buf[this.pos + 2] = (byte)(l >>> 8);
        this.buf[this.pos + 3] = (byte)(l >>> 16);
        this.buf[this.pos + 4] = (byte)(l >>> 24);
        this.buf[this.pos + 5] = (byte)(l >>> 32);
        this.buf[this.pos + 6] = (byte)(l >>> 40);
        this.buf[this.pos + 7] = (byte)(l >>> 48);
        this.buf[this.pos + 8] = (byte)(l >>> 56);
        this.pos += 9;
    }

    @Override
    public void write(int n) {
        if (this.pos >= this.buf.length) {
            if (this.pos >= this.getMaxPacketLength() && !this.i) {
                this.flushBuffer(false);
            } else {
                this.a(1);
            }
        }
        this.buf[this.pos++] = (byte)n;
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (n2 > this.buf.length - this.pos) {
            if (this.buf.length != this.getMaxPacketLength()) {
                this.a(n2);
            }
            if (n2 > this.buf.length - this.pos) {
                if (this.h != -1) {
                    this.a(n2);
                    if (this.h != -1) {
                        this.flushBufferStopAtMark();
                    }
                } else {
                    while (true) {
                        int n3 = Math.min(this.getMaxPacketLength() - this.pos, n2);
                        System.arraycopy(byArray, n, this.buf, this.pos, n3);
                        n += n3;
                        this.pos += n3;
                        if ((n2 -= n3) <= 0) break;
                        this.flushBuffer(false);
                    }
                    return;
                }
            }
        }
        System.arraycopy(byArray, n, this.buf, this.pos, n2);
        this.pos += n2;
    }

    @Override
    public void write(String string) {
        this.write(string, false, false);
    }

    @Override
    public void write(String string, boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3 = string.length();
        if (n3 * 3 + 2 >= this.buf.length - this.pos) {
            byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
            if (bl) {
                this.write(39);
                this.writeBytesEscaped(byArray, byArray.length, bl2);
                this.write(39);
                return;
            }
            this.write(byArray, 0, byArray.length);
            return;
        }
        if (bl) {
            this.buf[this.pos++] = 39;
            if (bl2) {
                for (n2 = 0; n2 < n3 && (n = string.charAt(n2)) < 128; ++n2) {
                    if (n == 39) {
                        this.buf[this.pos++] = 39;
                    }
                    this.buf[this.pos++] = (byte)n;
                }
            } else {
                while (n2 < n3 && (n = string.charAt(n2)) < 128) {
                    if (n == 92 || n == 39 || n == 0 || n == 34) {
                        this.buf[this.pos++] = 92;
                    }
                    this.buf[this.pos++] = (byte)n;
                    ++n2;
                }
            }
        } else {
            while (n2 < n3 && (n = string.charAt(n2)) < 128) {
                this.buf[this.pos++] = (byte)n;
                ++n2;
            }
        }
        while (n2 < n3) {
            if ((n = string.charAt(n2++)) < 128) {
                if (bl) {
                    if (bl2) {
                        if (n == 39) {
                            this.buf[this.pos++] = 39;
                        }
                    } else if (n == 92 || n == 39 || n == 0 || n == 34) {
                        this.buf[this.pos++] = 92;
                    }
                }
                this.buf[this.pos++] = (byte)n;
                continue;
            }
            if (n < 2048) {
                this.buf[this.pos++] = (byte)(0xC0 | n >> 6);
                this.buf[this.pos++] = (byte)(0x80 | n & 0x3F);
                continue;
            }
            if (n >= 55296 && n < 57344) {
                if (n < 56320) {
                    if (n2 + 1 > n3) {
                        this.buf[this.pos++] = 99;
                        continue;
                    }
                    char c = string.charAt(n2);
                    if (c >= '\udc00' && c < '\ue000') {
                        n = (n << 10) + c + -56613888;
                        this.buf[this.pos++] = (byte)(0xF0 | n >> 18);
                        this.buf[this.pos++] = (byte)(0x80 | n >> 12 & 0x3F);
                        this.buf[this.pos++] = (byte)(0x80 | n >> 6 & 0x3F);
                        this.buf[this.pos++] = (byte)(0x80 | n & 0x3F);
                        ++n2;
                        continue;
                    }
                    this.buf[this.pos++] = 63;
                    continue;
                }
                this.buf[this.pos++] = 63;
                continue;
            }
            this.buf[this.pos++] = (byte)(0xE0 | n >> 12);
            this.buf[this.pos++] = (byte)(0x80 | n >> 6 & 0x3F);
            this.buf[this.pos++] = (byte)(0x80 | n & 0x3F);
        }
        if (bl) {
            this.buf[this.pos++] = 39;
        }
    }

    @Override
    public void write(InputStream inputStream, boolean n, boolean bl) {
        byte[] byArray = new byte[4096];
        if (n) {
            while ((n = inputStream.read(byArray)) > 0) {
                this.writeBytesEscaped(byArray, n, bl);
            }
        } else {
            while ((n = inputStream.read(byArray)) > 0) {
                this.write(byArray, 0, n);
            }
        }
    }

    @Override
    public void write(InputStream inputStream, long l, boolean bl, boolean bl2) {
        int n;
        byte[] byArray = new byte[4096];
        while (l > 0L && (n = inputStream.read(byArray, 0, Math.min(4096, (int)l))) > 0) {
            if (bl) {
                this.writeBytesEscaped(byArray, n, bl2);
            } else {
                this.write(byArray, 0, n);
            }
            l -= (long)n;
        }
    }

    @Override
    public void write(Reader reader, boolean bl, boolean bl2) {
        int n;
        char[] cArray = new char[4096];
        while ((n = reader.read(cArray)) >= 0) {
            byte[] byArray = new String(cArray, 0, n).getBytes(StandardCharsets.UTF_8);
            if (bl) {
                this.writeBytesEscaped(byArray, byArray.length, bl2);
                continue;
            }
            this.write(byArray);
        }
    }

    @Override
    public void write(Reader reader, long l, boolean bl, boolean bl2) {
        int n;
        char[] cArray = new char[4096];
        while (l > 0L && (n = reader.read(cArray, 0, Math.min((int)l, 4096))) >= 0) {
            byte[] byArray = new String(cArray, 0, n).getBytes(StandardCharsets.UTF_8);
            if (bl) {
                this.writeBytesEscaped(byArray, byArray.length, bl2);
            } else {
                this.write(byArray);
            }
            l -= (long)n;
        }
    }

    @Override
    public void writeBytesEscaped(byte[] byArray, int n, boolean n2) {
        if (n << 1 > this.buf.length - this.pos) {
            if (this.buf.length != this.getMaxPacketLength()) {
                this.a(n << 1);
            }
            if (n << 1 > this.buf.length - this.pos) {
                if (this.h != -1) {
                    this.a(n << 1);
                    if (this.h != -1) {
                        this.flushBufferStopAtMark();
                    }
                } else {
                    if (n2 != 0) {
                        for (n2 = 0; n2 < n; ++n2) {
                            if (39 == byArray[n2]) {
                                this.buf[this.pos++] = 39;
                                if (this.buf.length <= this.pos) {
                                    this.flushBuffer(false);
                                }
                            }
                            this.buf[this.pos++] = byArray[n2];
                            if (this.buf.length > this.pos) continue;
                            this.flushBuffer(false);
                        }
                        return;
                    }
                    for (n2 = 0; n2 < n; ++n2) {
                        if (byArray[n2] == 39 || byArray[n2] == 92 || byArray[n2] == 34 || byArray[n2] == 0) {
                            this.buf[this.pos++] = 92;
                            if (this.buf.length <= this.pos) {
                                this.flushBuffer(false);
                            }
                        }
                        this.buf[this.pos++] = byArray[n2];
                        if (this.buf.length > this.pos) continue;
                        this.flushBuffer(false);
                    }
                    return;
                }
            }
        }
        if (n2 != 0) {
            for (n2 = 0; n2 < n; ++n2) {
                if (39 == byArray[n2]) {
                    this.buf[this.pos++] = 39;
                }
                this.buf[this.pos++] = byArray[n2];
            }
            return;
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (byArray[n2] == 39 || byArray[n2] == 92 || byArray[n2] == 34 || byArray[n2] == 0) {
                this.buf[this.pos++] = 92;
            }
            this.buf[this.pos++] = byArray[n2];
        }
    }

    @Override
    public int getMaxAllowedPacket() {
        return this.maxAllowedPacket;
    }

    @Override
    public abstract void setMaxAllowedPacket(int var1);

    @Override
    public void permitTrace(boolean bl) {
        this.permitTrace = bl;
    }

    @Override
    public void setServerThreadId(long l, Boolean bl) {
        this.serverThreadLog = "conn=" + l + (bl != null ? "(" + (bl != false ? "M" : "S") + ")" : "");
    }

    @Override
    public void setTraceCache(LruTraceCache lruTraceCache) {
        this.traceCache = lruTraceCache;
    }

    @Override
    public void mark() {
        this.h = this.pos;
    }

    @Override
    public boolean isMarked() {
        return this.h != -1;
    }

    @Override
    public void flushBufferStopAtMark() {
        int n = this.pos;
        this.pos = this.h;
        this.flushBuffer(true);
        this.out.flush();
        this.startPacket(0);
        System.arraycopy(this.buf, this.h, this.buf, this.pos, n - this.h);
        this.pos += n - this.h;
        this.h = -1;
        this.i = true;
    }

    @Override
    public boolean bufferIsDataAfterMark() {
        return this.i;
    }

    @Override
    public byte[] resetMark() {
        this.h = -1;
        if (this.i) {
            byte[] byArray = Arrays.copyOfRange(this.buf, this.initialPacketPos(), this.pos);
            this.startPacket(0);
            this.i = false;
            return byArray;
        }
        return null;
    }
}

