/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransientConnectionException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.ReentrantLock;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.LocalInfileInterceptor;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbConnection;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbStatement;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.UrlParser;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.read.Buffer;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.read.ErrorPacket;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.read.dao.Results;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.read.resultset.ColumnDefinition;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.read.resultset.SelectResultSet;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.read.resultset.UpdatableResultSet;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.ComQuery;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.ComStmtExecute;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.ComStmtPrepare;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.SendChangeDbPacket;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters.ParameterHolder;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.LruTraceCache;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.output.PacketOutputStream;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.Logger;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.LoggerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.AbstractConnectProtocol;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.AbstractMultiSend;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.MasterProtocol;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.Protocol;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.BulkStatus;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.LogQueryTool;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.SqlStates;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.Utils;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.dao.ClientPrepareResult;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.dao.PrepareResult;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.dao.ServerPrepareResult;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.exceptions.ExceptionFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.exceptions.MariaDbSqlException;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.exceptions.MaxAllowedPacketException;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.pool.GlobalStateInfo;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.scheduler.SchedulerServiceProviderHolder;

public class AbstractQueryProtocol
extends AbstractConnectProtocol
implements Protocol {
    private static final Logger a = LoggerFactory.getLogger(AbstractQueryProtocol.class);
    private static final Set<Integer> b = new HashSet<Integer>(Arrays.asList(1205, 1213, 1614));
    private ThreadPoolExecutor c = null;
    private int d = 0;
    private InputStream e;
    private long f;
    private volatile int g = -1;
    private FutureTask h = null;
    private boolean i;

    AbstractQueryProtocol(UrlParser urlParser, GlobalStateInfo globalStateInfo, ReentrantLock reentrantLock, LruTraceCache lruTraceCache) {
        super(urlParser, globalStateInfo, reentrantLock, lruTraceCache);
    }

    @Override
    public void reset() {
        this.c();
        try {
            this.writer.startPacket(0);
            this.writer.write(31);
            this.writer.flush();
            this.getResult(new Results());
            if (this.options.cachePrepStmts && this.options.useServerPrepStmts) {
                this.serverPrepareStatementCache.clear();
            }
            return;
        }
        catch (SQLException sQLException) {
            throw this.a("COM_RESET_CONNECTION failed.", sQLException, this.explicitClosed);
        }
        catch (IOException iOException) {
            throw this.a("COM_RESET_CONNECTION failed.", this.handleIoException(iOException), this.explicitClosed);
        }
    }

    private MariaDbSqlException a(ParameterHolder[] parameterHolderArray, PrepareResult prepareResult, SQLException sQLException, boolean bl) {
        return this.a(LogQueryTool.queryWithParams(prepareResult, parameterHolderArray, this.options), sQLException, bl);
    }

    private MariaDbSqlException a(String object, SQLException object2, boolean bl) {
        object = bl ? new MariaDbSqlException("Connection has explicitly been closed/aborted.", (String)object, (Throwable)object2) : (((Throwable)object2).getCause() instanceof SocketTimeoutException ? new MariaDbSqlException("Connection timed out", (String)object, "08000", (Throwable)object2) : MariaDbSqlException.of((SQLException)object2, (String)object));
        if (this.options.includeThreadDumpInDeadlockExceptions || ((SQLException)object2).getErrorCode() == 1064) {
            ((MariaDbSqlException)object).withThreadName(Thread.currentThread().getName());
        }
        if (this.options.includeInnodbStatusInDeadlockExceptions && ((SQLException)object2).getSQLState() != null && b.contains(((SQLException)object2).getErrorCode())) {
            try {
                this.lock.lock();
                this.c();
                object2 = new Results();
                AbstractQueryProtocol abstractQueryProtocol = this;
                abstractQueryProtocol.executeQuery(abstractQueryProtocol.isMasterConnection(), (Results)object2, "SHOW ENGINE INNODB STATUS");
                ((Results)object2).commandEnd();
                object2 = ((Results)object2).getResultSet();
                if (object2.next()) {
                    object2 = ((MariaDbSqlException)object).withDeadLockInfo(object2.getString(3));
                    return object2;
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                this.lock.unlock();
            }
        }
        return object;
    }

    @Override
    public void executeQuery(String string) {
        AbstractQueryProtocol abstractQueryProtocol = this;
        abstractQueryProtocol.executeQuery(abstractQueryProtocol.isMasterConnection(), new Results(), string);
    }

    @Override
    public void executeQuery(boolean bl, Results results, String string) {
        this.c();
        try {
            this.writer.startPacket(0);
            this.writer.write(3);
            this.writer.write(string);
            this.writer.flush();
            this.getResult(results);
            return;
        }
        catch (SQLException sQLException) {
            if ("70100".equals(sQLException.getSQLState()) && 1927 == sQLException.getErrorCode()) {
                throw this.handleIoException(sQLException);
            }
            throw this.a(string, sQLException, this.explicitClosed);
        }
        catch (IOException iOException) {
            throw this.a(string, this.handleIoException(iOException), this.explicitClosed);
        }
    }

    @Override
    public void executeQuery(boolean bl, Results results, String string, Charset charset) {
        this.c();
        try {
            this.writer.startPacket(0);
            this.writer.write(3);
            this.writer.write(string.getBytes(charset));
            this.writer.flush();
            this.getResult(results);
            return;
        }
        catch (SQLException sQLException) {
            throw this.a(string, sQLException, this.explicitClosed);
        }
        catch (IOException iOException) {
            throw this.a(string, this.handleIoException(iOException), this.explicitClosed);
        }
    }

    @Override
    public void executeQuery(boolean bl, Results results, ClientPrepareResult clientPrepareResult, ParameterHolder[] parameterHolderArray) {
        this.c();
        try {
            if (clientPrepareResult.getParamCount() == 0 && !clientPrepareResult.isQueryMultiValuesRewritable()) {
                if (clientPrepareResult.getQueryParts().size() == 1) {
                    ComQuery.sendDirect(this.writer, clientPrepareResult.getQueryParts().get(0));
                } else {
                    ComQuery.sendMultiDirect(this.writer, clientPrepareResult.getQueryParts());
                }
            } else {
                this.writer.startPacket(0);
                ComQuery.sendSubCmd(this.writer, clientPrepareResult, parameterHolderArray, -1);
                this.writer.flush();
            }
            this.getResult(results);
            return;
        }
        catch (SQLException sQLException) {
            throw this.a(parameterHolderArray, (PrepareResult)clientPrepareResult, sQLException, false);
        }
        catch (IOException iOException) {
            throw this.a(parameterHolderArray, (PrepareResult)clientPrepareResult, this.handleIoException(iOException), false);
        }
    }

    @Override
    public void executeQuery(boolean bl, Results results, ClientPrepareResult clientPrepareResult, ParameterHolder[] parameterHolderArray, int n) {
        this.c();
        try {
            if (clientPrepareResult.getParamCount() == 0 && !clientPrepareResult.isQueryMultiValuesRewritable()) {
                if (clientPrepareResult.getQueryParts().size() == 1) {
                    ComQuery.sendDirect(this.writer, clientPrepareResult.getQueryParts().get(0), n);
                } else {
                    ComQuery.sendMultiDirect(this.writer, clientPrepareResult.getQueryParts(), n);
                }
            } else {
                this.writer.startPacket(0);
                ComQuery.sendSubCmd(this.writer, clientPrepareResult, parameterHolderArray, n);
                this.writer.flush();
            }
            this.getResult(results);
            return;
        }
        catch (SQLException sQLException) {
            throw this.a(parameterHolderArray, (PrepareResult)clientPrepareResult, sQLException, false);
        }
        catch (IOException iOException) {
            throw this.a(parameterHolderArray, (PrepareResult)clientPrepareResult, this.handleIoException(iOException), false);
        }
    }

    @Override
    public boolean executeBatchClient(boolean bl, Results results, ClientPrepareResult clientPrepareResult, List<ParameterHolder[]> list) {
        if (this.options.rewriteBatchedStatements) {
            if (clientPrepareResult.isQueryMultiValuesRewritable() && results.getAutoGeneratedKeys() == 2) {
                this.a(results, clientPrepareResult, list, true);
                return true;
            }
            if (clientPrepareResult.isQueryMultipleRewritable()) {
                if (this.options.useBulkStmts && clientPrepareResult.isQueryMultipleRewritable() && results.getAutoGeneratedKeys() == 2 && this.a(results, clientPrepareResult.getSql(), null, list)) {
                    return true;
                }
                this.a(results, clientPrepareResult, list, false);
                return true;
            }
        }
        if (this.options.useBulkStmts && results.getAutoGeneratedKeys() == 2 && this.a(results, clientPrepareResult.getSql(), null, list)) {
            return true;
        }
        if (this.options.useBatchMultiSend.booleanValue()) {
            AbstractQueryProtocol abstractQueryProtocol = this;
            abstractQueryProtocol.c();
            abstractQueryProtocol.a();
            AbstractQueryProtocol abstractQueryProtocol2 = abstractQueryProtocol;
            new AbstractMultiSend(abstractQueryProtocol2, abstractQueryProtocol.writer, results, clientPrepareResult, list, abstractQueryProtocol.c, clientPrepareResult, list){
                final /* synthetic */ ClientPrepareResult val$clientPrepareResult;
                final /* synthetic */ List val$parametersList;
                {
                    this.val$clientPrepareResult = clientPrepareResult2;
                    this.val$parametersList = list2;
                    super(protocol, packetOutputStream, results, clientPrepareResult, list, threadPoolExecutor);
                }

                @Override
                public void sendCmd(PacketOutputStream packetOutputStream, Results parameterHolderArray, List<ParameterHolder[]> list, List<String> list2, int n, BulkStatus bulkStatus, PrepareResult prepareResult) {
                    parameterHolderArray = list.get(bulkStatus.sendCmdCounter);
                    packetOutputStream.startPacket(0);
                    ComQuery.sendSubCmd(packetOutputStream, this.val$clientPrepareResult, parameterHolderArray, -1);
                    packetOutputStream.flush();
                }

                @Override
                public SQLException handleResultException(SQLException sQLException, Results results, List<ParameterHolder[]> list, List<String> object, int n, int n2, int n3, PrepareResult prepareResult) {
                    int n4 = results.getCurrentStatNumber() - 1;
                    ParameterHolder[] parameterHolderArray = list.get(n4);
                    list = this.val$clientPrepareResult.getQueryParts();
                    if (this.val$clientPrepareResult.isRewriteType()) {
                        object = new StringBuilder(new String((byte[])list.get(0)));
                        ((StringBuilder)object).append(new String((byte[])list.get(1)));
                        for (n = 0; n < n3; ++n) {
                            ((StringBuilder)object).append(parameterHolderArray[n].toString()).append(new String((byte[])list.get(n + 2)));
                        }
                        ((StringBuilder)object).append(new String((byte[])list.get(n3 + 2)));
                    } else {
                        object = new StringBuilder(new String((byte[])list.get(0)));
                        for (n = 0; n < n3; ++n) {
                            ((StringBuilder)object).append(parameterHolderArray[n].toString()).append(new String((byte[])list.get(n + 1)));
                        }
                    }
                    return AbstractQueryProtocol.this.a(((StringBuilder)object).toString(), sQLException, AbstractQueryProtocol.this.explicitClosed);
                }

                @Override
                public int getParamCount() {
                    return this.val$clientPrepareResult.getParamCount();
                }

                @Override
                public int getTotalExecutionNumber() {
                    return this.val$parametersList.size();
                }
            }.executeBatch();
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private boolean a(Results var1_1, String var2_3, ServerPrepareResult var3_4, List<ParameterHolder[]> var4_5) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[DOLOOP], 6[CATCHBLOCK], 7[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void a() {
        if (this.options.useBatchMultiSend.booleanValue()) {
            this.c = SchedulerServiceProviderHolder.getBulkScheduler();
        }
    }

    private void a(Results results, ClientPrepareResult clientPrepareResult, List<ParameterHolder[]> list) {
        this.c();
        this.a();
        AbstractQueryProtocol abstractQueryProtocol = this;
        new /* invalid duplicate definition of identical inner class */.executeBatch();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void executeBatchStmt(boolean bl, Results results, List<String> list) {
        this.c();
        if (!this.options.rewriteBatchedStatements) {
            this.a(results, list);
            return;
        }
        bl = true;
        for (String string : list) {
            if (ClientPrepareResult.canAggregateSemiColon(string, this.noBackslashEscapes())) continue;
            bl = false;
            break;
        }
        if (this.isInterrupted()) {
            throw new SQLTimeoutException("Timeout during batch execution");
        }
        if (bl) {
            this.b(results, list);
            return;
        }
        this.a(results, list);
    }

    private void a(Results results, final List<String> list) {
        if (!this.options.useBatchMultiSend.booleanValue()) {
            String string = null;
            MariaDbSqlException mariaDbSqlException = null;
            for (int i = 0; i < list.size() && !this.isInterrupted(); ++i) {
                try {
                    string = list.get(i);
                    this.writer.startPacket(0);
                    this.writer.write(3);
                    this.writer.write(string);
                    this.writer.flush();
                    this.getResult(results);
                    continue;
                }
                catch (SQLException sQLException) {
                    if (mariaDbSqlException != null) continue;
                    mariaDbSqlException = this.a(string, sQLException, this.explicitClosed);
                    if (this.options.continueBatchOnError) continue;
                    throw mariaDbSqlException;
                }
                catch (IOException iOException) {
                    if (mariaDbSqlException != null) continue;
                    mariaDbSqlException = this.a(string, this.handleIoException(iOException), this.explicitClosed);
                    if (this.options.continueBatchOnError) continue;
                    throw mariaDbSqlException;
                }
            }
            this.stopIfInterrupted();
            if (mariaDbSqlException != null) {
                throw mariaDbSqlException;
            }
            return;
        }
        this.a();
        AbstractQueryProtocol abstractQueryProtocol = this;
        new AbstractMultiSend(abstractQueryProtocol, this.writer, results, list, this.c){

            @Override
            public void sendCmd(PacketOutputStream packetOutputStream, Results object, List<ParameterHolder[]> list3, List<String> list2, int n, BulkStatus bulkStatus, PrepareResult prepareResult) {
                object = list2.get(bulkStatus.sendCmdCounter);
                packetOutputStream.startPacket(0);
                packetOutputStream.write(3);
                packetOutputStream.write((String)object);
                packetOutputStream.flush();
            }

            @Override
            public SQLException handleResultException(SQLException sQLException, Results object, List<ParameterHolder[]> list3, List<String> list2, int n, int n2, int n3, PrepareResult prepareResult) {
                object = list2.get(n + n2);
                return AbstractQueryProtocol.this.a((String)object, sQLException, AbstractQueryProtocol.this.explicitClosed);
            }

            @Override
            public int getParamCount() {
                return -1;
            }

            @Override
            public int getTotalExecutionNumber() {
                return list.size();
            }
        }.executeBatch();
    }

    @Override
    public ServerPrepareResult prepare(String string, boolean bl) {
        this.lock.lock();
        try {
            ServerPrepareResult serverPrepareResult;
            if (this.options.cachePrepStmts && this.options.useServerPrepStmts && (serverPrepareResult = (ServerPrepareResult)this.serverPrepareStatementCache.get(this.database + "-" + string)) != null && serverPrepareResult.incrementShareCounter()) {
                return serverPrepareResult;
            }
            this.c();
            ServerPrepareResult serverPrepareResult2 = new ComStmtPrepare(this, string).send(this.writer).read(this.reader, this.eofDeprecated);
            return serverPrepareResult2;
        }
        catch (IOException iOException) {
            throw this.a(string, this.handleIoException(iOException), this.explicitClosed);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void b(Results results, List<String> list) {
        String string = null;
        int n = 0;
        int n2 = list.size();
        MariaDbSqlException mariaDbSqlException = null;
        do {
            try {
                string = list.get(n++);
                if (n2 == 1) {
                    this.writer.startPacket(0);
                    this.writer.write(3);
                    this.writer.write(string);
                    this.writer.flush();
                } else {
                    n = ComQuery.sendBatchAggregateSemiColon(this.writer, string, list, n);
                }
                this.getResult(results);
            }
            catch (SQLException sQLException) {
                if (mariaDbSqlException == null) {
                    mariaDbSqlException = this.a(string, sQLException, this.explicitClosed);
                    if (!this.options.continueBatchOnError) {
                        throw mariaDbSqlException;
                    }
                }
            }
            catch (IOException iOException) {
                throw this.a(string, this.handleIoException(iOException), this.explicitClosed);
            }
            this.stopIfInterrupted();
        } while (n < n2);
        if (mariaDbSqlException != null) {
            throw mariaDbSqlException;
        }
    }

    private void a(Results results, ClientPrepareResult clientPrepareResult, List<ParameterHolder[]> list, boolean bl) {
        this.c();
        int n = 0;
        int n2 = list.size();
        try {
            do {
                n = ComQuery.sendRewriteCmd(this.writer, clientPrepareResult.getQueryParts(), n, clientPrepareResult.getParamCount(), list, bl);
                this.getResult(results);
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new SQLException("Interrupted during batch", SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), -1);
            } while (n < n2);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            throw MariaDbSqlException.of(sQLException, clientPrepareResult.getSql());
        }
        catch (IOException iOException) {
            throw this.a(list.get(n), (PrepareResult)clientPrepareResult, this.handleIoException(iOException), this.explicitClosed);
        }
        finally {
            results.setRewritten(bl);
        }
    }

    @Override
    public boolean executeBatchServer(boolean bl, final ServerPrepareResult serverPrepareResult, Results results, String string, final List<ParameterHolder[]> list) {
        this.c();
        if (this.options.useBulkStmts && results.getAutoGeneratedKeys() == 2 && this.a(results, string, serverPrepareResult, list)) {
            return true;
        }
        if (!this.options.useBatchMultiSend.booleanValue()) {
            return false;
        }
        this.a();
        AbstractQueryProtocol abstractQueryProtocol = this;
        new AbstractMultiSend(abstractQueryProtocol, this.writer, results, serverPrepareResult, list, string, this.c){

            @Override
            public void sendCmd(PacketOutputStream packetOutputStream, Results parameterHolderArray, List<ParameterHolder[]> list3, List<String> list2, int n, BulkStatus bulkStatus, PrepareResult prepareResult) {
                parameterHolderArray = list3.get(bulkStatus.sendCmdCounter);
                if (parameterHolderArray.length < n) {
                    throw new SQLException("Parameter at position " + (n - 1) + " is not set", "07004");
                }
                for (int i = 0; i < n; ++i) {
                    if (!parameterHolderArray[i].canBeLongData()) continue;
                    packetOutputStream.startPacket(0);
                    packetOutputStream.write(24);
                    packetOutputStream.writeInt(this.statementId);
                    packetOutputStream.writeShort((short)i);
                    parameterHolderArray[i].writeLongData(packetOutputStream);
                    packetOutputStream.flush();
                }
                packetOutputStream.startPacket(0);
                ComStmtExecute.writeCmd(this.statementId, parameterHolderArray, n, this.parameterTypeHeader, packetOutputStream, (byte)0);
                packetOutputStream.flush();
            }

            @Override
            public SQLException handleResultException(SQLException sQLException, Results results, List<ParameterHolder[]> list3, List<String> list2, int n, int n2, int n3, PrepareResult prepareResult) {
                return MariaDbSqlException.of(sQLException, prepareResult.getSql());
            }

            @Override
            public int getParamCount() {
                return serverPrepareResult.getParameters().length;
            }

            @Override
            public int getTotalExecutionNumber() {
                return list.size();
            }
        }.executeBatch();
        return true;
    }

    @Override
    public void executePreparedQuery(boolean n, ServerPrepareResult serverPrepareResult, Results results, ParameterHolder[] parameterHolderArray) {
        this.c();
        try {
            n = serverPrepareResult.getParameters().length;
            for (int i = 0; i < n; ++i) {
                if (!parameterHolderArray[i].canBeLongData()) continue;
                this.writer.startPacket(0);
                this.writer.write(24);
                this.writer.writeInt(serverPrepareResult.getStatementId());
                this.writer.writeShort((short)i);
                parameterHolderArray[i].writeLongData(this.writer);
                this.writer.flush();
            }
            ComStmtExecute.send(this.writer, serverPrepareResult.getStatementId(), parameterHolderArray, n, serverPrepareResult.getParameterTypeHeader(), (byte)0);
            this.getResult(results);
            return;
        }
        catch (SQLException sQLException) {
            throw this.a(parameterHolderArray, serverPrepareResult, sQLException, false);
        }
        catch (IOException iOException) {
            throw this.a(parameterHolderArray, serverPrepareResult, this.handleIoException(iOException), false);
        }
    }

    @Override
    public void rollback() {
        this.c();
        this.lock.lock();
        try {
            if (this.inTransaction()) {
                this.executeQuery("ROLLBACK");
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean forceReleasePrepareStatement(int n) {
        if (this.lock.tryLock()) {
            try {
                AbstractQueryProtocol abstractQueryProtocol = this;
                if (!abstractQueryProtocol.connected) {
                    throw new SQLException("Connection is close", "08000", 1220);
                }
                try {
                    this.writer.startPacket(0);
                    this.writer.write(25);
                    this.writer.writeInt(n);
                    this.writer.flush();
                    return true;
                }
                catch (IOException iOException) {
                    this.connected = false;
                    throw new SQLNonTransientConnectionException("Could not deallocate query: " + iOException.getMessage(), "08000", iOException);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        this.g = n;
        return false;
    }

    @Override
    public void forceReleaseWaitingPrepareStatement() {
        if (this.g != -1) {
            AbstractQueryProtocol abstractQueryProtocol = this;
            if (abstractQueryProtocol.forceReleasePrepareStatement(abstractQueryProtocol.g)) {
                this.g = -1;
            }
        }
    }

    @Override
    public boolean ping() {
        this.c();
        this.lock.lock();
        try {
            this.writer.startPacket(0);
            this.writer.write(14);
            this.writer.flush();
            Buffer buffer = this.reader.getPacket(true);
            boolean bl = buffer.getByteAt(0) == 0;
            return bl;
        }
        catch (IOException iOException) {
            this.connected = false;
            throw new SQLNonTransientConnectionException("Could not ping: " + iOException.getMessage(), "08000", iOException);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isValid(int n) {
        int n2 = -1;
        try {
            n2 = this.socketTimeout;
            if (n2 == 0) {
                this.changeSocketSoTimeout(n);
            }
            if (this.isMasterConnection() && !this.galeraAllowedStates.isEmpty()) {
                Results results = new Results();
                this.executeQuery(true, results, "show status like 'wsrep_local_state'");
                results.commandEnd();
                SelectResultSet selectResultSet = results.getResultSet();
                boolean bl = selectResultSet != null && selectResultSet.next() && this.galeraAllowedStates.contains(selectResultSet.getString(2));
                return bl;
            }
            n = this.ping() ? 1 : 0;
            return n != 0;
        }
        catch (SocketException socketException) {
            a.trace("Connection is not valid", socketException);
            this.connected = false;
            return false;
        }
        finally {
            try {
                if (n2 != -1) {
                    this.changeSocketSoTimeout(n2);
                }
            }
            catch (SocketException socketException) {
                a.warn("Could not set socket timeout back to " + n2, socketException);
                this.connected = false;
            }
        }
    }

    @Override
    public String getCatalog() {
        if ((this.serverCapabilities & 0x800000L) != 0L) {
            if (this.database != null && this.database.isEmpty()) {
                return null;
            }
            return this.database;
        }
        this.c();
        this.lock.lock();
        try {
            Object object = new Results();
            AbstractQueryProtocol abstractQueryProtocol = this;
            abstractQueryProtocol.executeQuery(abstractQueryProtocol.isMasterConnection(), (Results)object, "select database()");
            ((Results)object).commandEnd();
            object = ((Results)object).getResultSet();
            if (object.next()) {
                this.database = object.getString(1);
                object = this.database;
                this.lock.unlock();
                return object;
            }
            object = null;
            this.lock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
    }

    @Override
    public void setCatalog(String string) {
        this.c();
        this.lock.lock();
        try {
            SendChangeDbPacket.send(this.writer, string);
            Object object = this.reader.getPacket(true);
            if (((Buffer)object).getByteAt(0) == -1) {
                object = new ErrorPacket((Buffer)object);
                throw new SQLException("Could not select database '" + string + "' : " + ((ErrorPacket)object).getMessage(), ((ErrorPacket)object).getSqlState(), ((ErrorPacket)object).getErrorCode());
            }
            this.database = string;
            return;
        }
        catch (IOException iOException) {
            throw this.a("COM_INIT_DB", this.handleIoException(iOException), false);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void resetDatabase() {
        if (!this.database.equals(this.urlParser.getDatabase())) {
            AbstractQueryProtocol abstractQueryProtocol = this;
            abstractQueryProtocol.setCatalog(abstractQueryProtocol.urlParser.getDatabase());
        }
    }

    @Override
    public void cancelCurrentQuery() {
        Throwable throwable = null;
        try (MasterProtocol masterProtocol = new MasterProtocol(this.urlParser, new GlobalStateInfo(), new ReentrantLock(), this.traceCache);){
            masterProtocol.setHostAddress(this.getHostAddress());
            masterProtocol.connect();
            masterProtocol.executeQuery("KILL QUERY " + this.serverThreadId);
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throwable = throwable2;
            throw throwable3;
        }
        this.i = true;
    }

    @Override
    public boolean getAutocommit() {
        return (this.serverStatus & 2) != 0;
    }

    @Override
    public boolean inTransaction() {
        return (this.serverStatus & 1) != 0;
    }

    @Override
    public void closeExplicit() {
        this.explicitClosed = true;
        this.close();
    }

    @Override
    public void releasePrepareStatement(ServerPrepareResult serverPrepareResult) {
        serverPrepareResult.decrementShareCounter();
        if (serverPrepareResult.canBeDeallocate()) {
            this.forceReleasePrepareStatement(serverPrepareResult.getStatementId());
        }
    }

    @Override
    public long getMaxRows() {
        return this.f;
    }

    @Override
    public void setMaxRows(long l) {
        if (this.f != l) {
            if (l == 0L) {
                this.executeQuery("set @@SQL_SELECT_LIMIT=DEFAULT");
            } else {
                this.executeQuery("set @@SQL_SELECT_LIMIT=" + l);
            }
            this.f = l;
        }
    }

    @Override
    public void setLocalInfileInputStream(InputStream inputStream) {
        this.e = inputStream;
    }

    @Override
    public int getTimeout() {
        return this.socketTimeout;
    }

    @Override
    public void setTimeout(int n) {
        this.lock.lock();
        try {
            this.changeSocketSoTimeout(n);
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setReadonly(boolean bl) {
        if (this.options.assureReadOnly && this.readOnly != bl && this.versionGreaterOrEqual(5, 6, 5)) {
            this.executeQuery("SET SESSION TRANSACTION " + (bl ? "READ ONLY" : "READ WRITE"));
        }
        this.readOnly = bl;
    }

    @Override
    public void setTransactionIsolation(int n) {
        this.c();
        this.lock.lock();
        try {
            String string = "SET SESSION TRANSACTION ISOLATION LEVEL";
            switch (n) {
                case 1: {
                    string = string + " READ UNCOMMITTED";
                    break;
                }
                case 2: {
                    string = string + " READ COMMITTED";
                    break;
                }
                case 4: {
                    string = string + " REPEATABLE READ";
                    break;
                }
                case 8: {
                    string = string + " SERIALIZABLE";
                    break;
                }
                default: {
                    throw new SQLException("Unsupported transaction isolation level");
                }
            }
            this.executeQuery(string);
            this.d = n;
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getTransactionIsolationLevel() {
        return this.d;
    }

    private void b() {
        if (!this.connected) {
            throw new SQLException("Connection is close", "08000", 1220);
        }
    }

    @Override
    public void getResult(Results results) {
        this.a(results);
        while (this.hasMoreResults()) {
            this.a(results);
        }
    }

    private void a(Results results) {
        Buffer buffer;
        try {
            buffer = this.reader.getPacket(true);
        }
        catch (IOException iOException) {
            throw this.handleIoException(iOException);
        }
        switch (buffer.getByteAt(0)) {
            case 0: {
                this.a(buffer, results);
                return;
            }
            case -1: {
                throw this.c(buffer, results);
            }
            case -5: {
                this.d(buffer, results);
                return;
            }
        }
        this.e(buffer, results);
    }

    private void a(Buffer buffer, Results results) {
        buffer.skipByte();
        long l = buffer.getLengthEncodedNumeric();
        long l2 = buffer.getLengthEncodedNumeric();
        this.serverStatus = buffer.readShort();
        boolean bl = this.hasWarnings = buffer.readShort() > 0;
        if ((this.serverStatus & 0x4000) != 0) {
            this.b(buffer, results);
        }
        results.addStats(l, l2, this.hasMoreResults());
    }

    private void b(Buffer buffer, Results results) {
        buffer.skipLengthEncodedBytes();
        block10: while (buffer.remaining() > 0) {
            Object object = buffer.getLengthEncodedBuffer();
            if (((Buffer)object).remaining() <= 0) continue;
            switch (((Buffer)object).readByte()) {
                case 0: {
                    object = ((Buffer)object).getLengthEncodedBuffer();
                    Object object2 = ((Buffer)object).readStringLengthEncoded(StandardCharsets.UTF_8);
                    object = ((Buffer)object).readStringLengthEncoded(StandardCharsets.UTF_8);
                    a.debug("System variable change :  {} = {}", object2, object);
                    int n = -1;
                    switch (((String)object2).hashCode()) {
                        case 293703695: {
                            if (!((String)object2).equals("auto_increment_increment")) break;
                            n = 0;
                        }
                    }
                    switch (n) {
                        case 0: {
                            this.autoIncrementIncrement = Integer.parseInt((String)object);
                            results.setAutoIncrement(this.autoIncrementIncrement);
                        }
                    }
                    continue block10;
                }
                case 1: {
                    Object object2 = ((Buffer)object).getLengthEncodedBuffer();
                    this.database = ((Buffer)object2).readStringLengthEncoded(StandardCharsets.UTF_8);
                    a.debug("Database change : now is '{}'", (Object)this.database);
                    continue block10;
                }
            }
            ((Buffer)object).skipLengthEncodedBytes();
        }
    }

    @Override
    public int getAutoIncrementIncrement() {
        if (this.autoIncrementIncrement == 0) {
            this.lock.lock();
            try {
                Object object = new Results();
                this.executeQuery(true, (Results)object, "select @@auto_increment_increment");
                ((Results)object).commandEnd();
                object = ((Results)object).getResultSet();
                object.next();
                this.autoIncrementIncrement = object.getInt(1);
            }
            catch (SQLException sQLException) {
                SQLException sQLException2 = sQLException;
                if (sQLException.getSQLState().startsWith("08")) {
                    throw sQLException2;
                }
                this.autoIncrementIncrement = 1;
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.autoIncrementIncrement;
    }

    private SQLException c(Buffer object, Results results) {
        String string;
        this.removeHasMoreResults();
        this.hasWarnings = false;
        ((Buffer)object).skipByte();
        short s = ((Buffer)object).readShort();
        if (((Buffer)object).readByte() == 35) {
            string = new String(((Buffer)object).readRawBytes(5));
            object = ((Buffer)object).readStringNullEnd(StandardCharsets.UTF_8);
        } else {
            --((Buffer)object).position;
            object = new String(((Buffer)object).buf, ((Buffer)object).position, ((Buffer)object).limit - ((Buffer)object).position, StandardCharsets.UTF_8);
            string = "HY000";
        }
        results.addStatsError(false);
        this.serverStatus = (short)(this.serverStatus | 1);
        this.removeActiveStreamingResult();
        return new SQLException((String)object, string, s);
    }

    private void d(Buffer object, Results results) {
        int n = 2;
        ((Buffer)object).getLengthEncodedNumeric();
        object = ((Buffer)object).readStringNullEnd(StandardCharsets.UTF_8);
        try {
            Object object2;
            Object object3;
            this.writer.startPacket(2);
            if (this.e == null) {
                if (!this.getUrlParser().getOptions().allowLocalInfile) {
                    this.writer.writeEmptyPacket();
                    this.reader.getPacket(true);
                    throw new SQLException("Usage of LOCAL INFILE is disabled. To use it enable it via the connection property allowLocalInfile=true", SqlStates.FEATURE_NOT_SUPPORTED.getSqlState(), -1);
                }
                object3 = ServiceLoader.load(LocalInfileInterceptor.class);
                Object object4 = ((ServiceLoader)object3).iterator();
                while (object4.hasNext()) {
                    object2 = object4.next();
                    if (object2.validate((String)object)) continue;
                    this.writer.writeEmptyPacket();
                    this.reader.getPacket(true);
                    throw new SQLException("LOAD DATA LOCAL INFILE request to send local file named \"" + (String)object + "\" not validated by interceptor \"" + object2.getClass().getName() + "\"");
                }
                if (results.getSql() == null) {
                    this.writer.writeEmptyPacket();
                    this.reader.getPacket(true);
                    throw new SQLException("LOAD DATA LOCAL INFILE not permit in batch. file '" + (String)object + "'", SqlStates.INVALID_AUTHORIZATION.getSqlState(), -1);
                }
                if (!Utils.validateFileName(results.getSql(), results.getParameters(), (String)object)) {
                    this.writer.writeEmptyPacket();
                    this.reader.getPacket(true);
                    throw new SQLException("LOAD DATA LOCAL INFILE asked for file '" + (String)object + "' that doesn't correspond to initial query " + results.getSql() + ". Possible malicious proxy changing server answer ! Command interrupted", SqlStates.INVALID_AUTHORIZATION.getSqlState(), -1);
                }
                try {
                    object4 = new URL((String)object);
                    object2 = ((URL)object4).openStream();
                }
                catch (IOException iOException) {
                    try {
                        object2 = new FileInputStream((String)object);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.writer.writeEmptyPacket();
                        this.reader.getPacket(true);
                        throw new SQLException("Could not send file : " + fileNotFoundException.getMessage(), "22000", -1, fileNotFoundException);
                    }
                }
            } else {
                object2 = this.e;
                this.e = null;
            }
            try {
                int n2;
                object3 = new byte[8192];
                while ((n2 = ((InputStream)object2).read((byte[])object3)) > 0) {
                    this.writer.startPacket(n++);
                    this.writer.write((byte[])object3, 0, n2);
                    this.writer.flush();
                }
                this.writer.writeEmptyPacket();
            }
            catch (IOException iOException) {
                throw this.handleIoException(iOException);
            }
            finally {
                ((InputStream)object2).close();
            }
            this.getResult(results);
            return;
        }
        catch (IOException iOException) {
            throw this.handleIoException(iOException);
        }
    }

    private void e(Buffer columnDefinitionArray, Results results) {
        long l = columnDefinitionArray.getLengthEncodedNumeric();
        try {
            SelectResultSet selectResultSet;
            columnDefinitionArray = new ColumnDefinition[(int)l];
            boolean bl = false;
            while ((long)bl < l) {
                columnDefinitionArray[bl] = new ColumnDefinition(this.reader.getPacket(false));
                bl += 1;
            }
            bl = false;
            if (!this.eofDeprecated) {
                Buffer buffer = this.reader.getPacket(true);
                if (buffer.readByte() != -2) {
                    throw new IOException("Packets out of order when reading field packets, expected was EOF stream." + (this.options.enablePacketDebug ? this.getTraces() : "Packet contents (hex) = " + Utils.hexdump(this.options.maxQuerySizeToLog, 0, buffer.limit, (byte[][])new byte[][]{buffer.buf})));
                }
                buffer.skipBytes(2);
                boolean bl2 = bl = (buffer.readShort() & 0x1000) != 0;
            }
            if (results.getResultSetConcurrency() == 1007) {
                AbstractQueryProtocol abstractQueryProtocol = this;
                selectResultSet = new SelectResultSet(columnDefinitionArray, results, abstractQueryProtocol, abstractQueryProtocol.reader, bl, this.eofDeprecated);
            } else {
                results.removeFetchSize();
                AbstractQueryProtocol abstractQueryProtocol = this;
                selectResultSet = new UpdatableResultSet(columnDefinitionArray, results, abstractQueryProtocol, abstractQueryProtocol.reader, bl, this.eofDeprecated);
            }
            results.addResultSet(selectResultSet, this.hasMoreResults() || results.getFetchSize() > 0);
            return;
        }
        catch (IOException iOException) {
            throw this.handleIoException(iOException);
        }
    }

    @Override
    public void prologProxy(ServerPrepareResult serverPrepareResult, long l, boolean bl, MariaDbConnection mariaDbConnection, MariaDbStatement mariaDbStatement) {
        this.prolog(l, bl, mariaDbConnection, mariaDbStatement);
    }

    @Override
    public void prolog(long l, boolean bl, MariaDbConnection mariaDbConnection, MariaDbStatement mariaDbStatement) {
        if (this.explicitClosed) {
            throw new SQLNonTransientConnectionException("execute() is called on closed connection", "08000");
        }
        if (!bl && this.shouldReconnectWithoutProxy()) {
            try {
                this.connectWithoutProxy();
            }
            catch (SQLException sQLException) {
                throw ExceptionFactory.of((int)this.serverThreadId, this.options).create(sQLException);
            }
        }
        try {
            this.setMaxRows(l);
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.of((int)this.serverThreadId, this.options).create(sQLException);
        }
        mariaDbConnection.reenableWarnings();
    }

    @Override
    public ServerPrepareResult putInCache(String string, ServerPrepareResult serverPrepareResult) {
        return this.serverPrepareStatementCache.put(string, serverPrepareResult);
    }

    private void c() {
        if (this.activeStreamingResult != null) {
            this.activeStreamingResult.loadFully(false, this);
            this.activeStreamingResult = null;
        }
        if (this.h != null) {
            try {
                this.h.get();
            }
            catch (ExecutionException executionException) {
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new SQLException("Interrupted reading remaining batch response ", SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), -1, interruptedException);
            }
            finally {
                this.forceReleaseWaitingPrepareStatement();
            }
            this.h = null;
        }
        if (!this.connected) {
            throw this.exceptionFactory.create("Connection is closed", "08000", 1220);
        }
        this.i = false;
        if (this.options.ensureSocketState) {
            try {
                int n = this.reader.getInputStream().available();
                if (n > 0) {
                    int n2;
                    byte[] byArray = new byte[Math.min(n, 16000)];
                    int n3 = 0;
                    while ((n2 = this.reader.getInputStream().read(byArray, n3, n)) >= 0) {
                        n3 += n2;
                        if ((n -= n2) > 0) continue;
                    }
                    throw this.exceptionFactory.create("Unexpected data in socket buffer:" + Utils.hexdump(new byte[][]{byArray}), "HY000");
                }
                return;
            }
            catch (IOException iOException) {
                throw this.exceptionFactory.create("Unexpected socket error", "08000", iOException);
            }
        }
    }

    @Override
    public void resetStateAfterFailover(long l, int n, String string, boolean bl) {
        this.setMaxRows(l);
        if (n != 0) {
            this.setTransactionIsolation(n);
        }
        if (string != null && !"".equals(string) && !this.getDatabase().equals(string)) {
            this.setCatalog(string);
        }
        if (this.getAutocommit() != bl) {
            this.executeQuery("set autocommit=" + (bl ? "1" : "0"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SQLException handleIoException(Exception exception) {
        boolean bl;
        boolean bl2 = this.options.autoReconnect;
        if (exception instanceof MaxAllowedPacketException) {
            bl = true;
            if (!((MaxAllowedPacketException)exception).isMustReconnect()) return new SQLNonTransientConnectionException(exception.getMessage() + this.getTraces(), SqlStates.UNDEFINED_SQLSTATE.getSqlState(), exception);
            bl2 = true;
        } else {
            bl = this.writer.exceedMaxLength();
            if (bl) {
                bl2 = true;
            }
        }
        if (bl2 && !this.explicitClosed) {
            String string = this.getTraces();
            this.connect();
            try {
                AbstractQueryProtocol abstractQueryProtocol = this;
                abstractQueryProtocol.resetStateAfterFailover(abstractQueryProtocol.getMaxRows(), this.getTransactionIsolationLevel(), this.getDatabase(), this.getAutocommit());
                if (!bl) return new SQLTransientConnectionException(exception.getMessage() + string, "HY000", exception);
                return new SQLTransientConnectionException("Could not send query: query size is >= to max_allowed_packet (" + this.writer.getMaxAllowedPacket() + ")" + string, "HY000", exception);
            }
            catch (SQLException sQLException) {
                try {
                    return new SQLTransientConnectionException("reconnection succeed, but resetting previous state failed" + string, "HY000", exception);
                }
                catch (SQLException sQLException2) {
                    this.connected = false;
                    return new SQLNonTransientConnectionException(exception.getMessage() + "\nError during reconnection" + string, "08000", sQLException2);
                }
            }
        }
        this.connected = false;
        return new SQLNonTransientConnectionException(exception.getMessage() + this.getTraces(), "08000", exception);
    }

    @Override
    public void setActiveFutureTask(FutureTask futureTask) {
        this.h = futureTask;
    }

    @Override
    public void interrupt() {
        this.i = true;
    }

    @Override
    public boolean isInterrupted() {
        return this.i;
    }

    @Override
    public void stopIfInterrupted() {
        if (this.isInterrupted()) {
            throw new SQLTimeoutException("Timeout during batch execution");
        }
    }
}

