/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.Socket;
import java.security.MessageDigest;
import java.sql.SQLException;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.UrlParser;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters.ParameterHolder;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.FailoverProxy;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.impl.AuroraListener;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.impl.MastersFailoverListener;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.impl.MastersReplicasListener;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.LruTraceCache;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.socket.SocketHandlerFunction;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.socket.SocketUtility;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.ProtocolLoggingProxy;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.AuroraProtocol;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.MasterProtocol;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.MastersReplicasProtocol;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.Protocol;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.pool.GlobalStateInfo;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.util.ConfigurableSocketFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.util.Options;

public class Utils {
    private static final char[] a;
    private static final Pattern b;
    private static final Pattern c;
    private static final Pattern d;
    private static final SocketHandlerFunction e;

    public static Socket standardSocket(Options options, String string) {
        Object object = options.socketFactory;
        if (object != null) {
            try {
                object = Class.forName((String)object);
                if (object != null) {
                    object = ((Class)object).getConstructor(new Class[0]);
                    if (ConfigurableSocketFactory.class.isInstance(object = (SocketFactory)((Constructor)object).newInstance(new Object[0]))) {
                        ((ConfigurableSocketFactory)object).setConfiguration(options, string);
                    }
                    return ((SocketFactory)object).createSocket();
                }
            }
            catch (Exception exception) {
                throw new IOException("Socket factory failed to initialized with option \"socketFactory\" set to \"" + options.socketFactory + "\"", exception);
            }
        }
        object = SocketFactory.getDefault();
        return ((SocketFactory)object).createSocket();
    }

    public static String escapeString(String string, boolean bl) {
        if (!string.contains("'")) {
            if (bl) {
                return string;
            }
            if (!string.contains("\\")) {
                return string;
            }
        }
        string = string.replace("'", "''");
        if (bl) {
            return string;
        }
        return string.replace("\\", "\\\\");
    }

    public static byte[] encryptPassword(String object, byte[] byArray, String object2) {
        if (object == null || ((String)object).isEmpty()) {
            return new byte[0];
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        object = object2 != null && !((String)object2).isEmpty() ? (Object)((String)object).getBytes((String)object2) : (Object)((String)object).getBytes();
        object = messageDigest.digest((byte[])object);
        messageDigest.reset();
        object2 = messageDigest.digest((byte[])object);
        messageDigest.reset();
        messageDigest.update(byArray);
        messageDigest.update((byte[])object2);
        byArray = messageDigest.digest();
        object2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            object2[i] = (byte)(object[i] ^ byArray[i]);
        }
        return object2;
    }

    public static byte[] copyWithLength(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        n = n < byArray.length ? n : byArray.length;
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public static byte[] copyRange(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2 -= n];
        n2 = byArray.length - n < n2 ? byArray.length - n : n2;
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    private static String a(String string, Protocol protocol) {
        int n;
        char[] cArray = string.toCharArray();
        CharSequence charSequence = new StringBuilder();
        for (n = 0; n < cArray.length && cArray[n] == ' '; ++n) {
        }
        while ((cArray[n] >= 'a' && cArray[n] <= 'z' || cArray[n] >= 'A' && cArray[n] <= 'Z') && n < cArray.length) {
            ((StringBuilder)charSequence).append(cArray[n]);
            ++n;
        }
        switch (((StringBuilder)charSequence).toString().toLowerCase(Locale.ROOT)) {
            case "convert": {
                int n2 = string.lastIndexOf(44);
                n = string.indexOf(40);
                string = string.substring(n + 1, n2);
                for (n = n2 + 1; n < cArray.length && Character.isWhitespace(cArray[n]); ++n) {
                }
                for (n2 = n + 1; n2 < cArray.length && (cArray[n2] >= 'a' && cArray[n2] <= 'z' || cArray[n2] >= 'A' && cArray[n2] <= 'Z' || cArray[n2] == '_'); ++n2) {
                }
                String string2 = new String(cArray, n, n2 - n).toUpperCase(Locale.ROOT);
                if (string2.startsWith("SQL_")) {
                    string2 = string2.substring(4);
                }
                switch (string2) {
                    case "BOOLEAN": {
                        return "1=" + string;
                    }
                    case "BIGINT": 
                    case "SMALLINT": 
                    case "TINYINT": {
                        string2 = "SIGNED INTEGER";
                        break;
                    }
                    case "BIT": {
                        string2 = "UNSIGNED INTEGER";
                        break;
                    }
                    case "BLOB": 
                    case "VARBINARY": 
                    case "LONGVARBINARY": 
                    case "ROWID": {
                        string2 = "BINARY";
                        break;
                    }
                    case "NCHAR": 
                    case "CLOB": 
                    case "NCLOB": 
                    case "DATALINK": 
                    case "VARCHAR": 
                    case "NVARCHAR": 
                    case "LONGVARCHAR": 
                    case "LONGNVARCHAR": 
                    case "SQLXML": 
                    case "LONGNCHAR": {
                        string2 = "CHAR";
                        break;
                    }
                    case "DOUBLE": 
                    case "FLOAT": {
                        if (protocol.isServerMariaDb() || protocol.versionGreaterOrEqual(8, 0, 17)) {
                            string2 = "DOUBLE";
                            break;
                        }
                        return "0.0+" + string;
                    }
                    case "REAL": 
                    case "NUMERIC": {
                        string2 = "DECIMAL";
                        break;
                    }
                    case "TIMESTAMP": {
                        string2 = "DATETIME";
                    }
                }
                return new String(cArray, 0, n) + string2 + new String(cArray, n2, cArray.length - n2);
            }
            case "timestampdiff": 
            case "timestampadd": {
                String string3;
                while (n < cArray.length && (Character.isWhitespace(cArray[n]) || cArray[n] == '(')) {
                    ++n;
                }
                if (n < cArray.length - 8 && "SQL_TSI_".equals(string3 = new String(cArray, n, 8))) {
                    return new String(cArray, 0, n) + new String(cArray, n + 8, cArray.length - (n + 8));
                }
                return string;
            }
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private static String b(String string, Protocol protocol) {
        block0: while (true) {
            if (string.charAt(0) != '{') throw new SQLException("unexpected escaped string");
            String string2 = string;
            if (string2.charAt(string2.length() - 1) != '}') {
                throw new SQLException("unexpected escaped string");
            }
            int n = string.length() - 1;
            String string3 = string.toLowerCase(Locale.ROOT);
            if (string.startsWith("{fn ")) {
                String string4 = Utils.a(string.substring(4, n), protocol);
                return Utils.nativeSql(string4, protocol);
            }
            if (string3.startsWith("{oj ")) {
                return Utils.nativeSql(string.substring(4, n), protocol);
            }
            if (string.startsWith("{d ")) {
                return string.substring(3, n);
            }
            if (string.startsWith("{t ")) {
                return string.substring(3, n);
            }
            if (string.startsWith("{ts ")) {
                return string.substring(4, n);
            }
            if (string.startsWith("{d'")) {
                return string.substring(2, n);
            }
            if (string.startsWith("{t'")) {
                return string.substring(2, n);
            }
            if (string.startsWith("{ts'")) {
                return string.substring(3, n);
            }
            if (string.startsWith("{call ")) return Utils.nativeSql(string.substring(1, n), protocol);
            if (string.startsWith("{CALL ")) {
                return Utils.nativeSql(string.substring(1, n), protocol);
            }
            if (string.startsWith("{escape ")) {
                return string.substring(1, n);
            }
            if (string.startsWith("{?")) {
                return Utils.nativeSql(string.substring(1, n), protocol);
            }
            if (string.startsWith("{ ") || string.startsWith("{\n")) {
                n = 2;
                while (n < string.length()) {
                    if (!Character.isWhitespace(string.charAt(n))) {
                        string = "{" + string.substring(n);
                        continue block0;
                    }
                    ++n;
                }
                throw new SQLException("unknown escape sequence " + string);
            }
            if (!string.startsWith("{\r\n")) throw new SQLException("unknown escape sequence " + string);
            n = 3;
            while (n < string.length()) {
                if (!Character.isWhitespace(string.charAt(n))) {
                    string = "{" + string.substring(n);
                    continue block0;
                }
                ++n;
            }
            throw new SQLException("unknown escape sequence " + string);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String nativeSql(String object, Protocol protocol) {
        if (!((String)object).contains("{")) {
            return object;
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        object = ((String)object).toCharArray();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = 0;
        block8: for (int i = 0; i < ((Object)object).length; ++i) {
            Object object2;
            Object object3 = object[i];
            if (object2 == 92 && !protocol.noBackslashEscapes()) {
                stringBuilder2.append((char)object3);
                object2 = 32;
                continue;
            }
            switch (object3) {
                case 34: 
                case 39: 
                case 96: {
                    Object object4;
                    if (bl4) break;
                    if (bl2) {
                        if (object4 != object3) break;
                        bl2 = false;
                        break;
                    }
                    bl2 = true;
                    object4 = object3;
                    break;
                }
                case 42: {
                    if (bl2 || bl4 || object2 != 47) break;
                    bl4 = true;
                    bl5 = false;
                    break;
                }
                case 45: 
                case 47: {
                    if (bl2) break;
                    if (bl4) {
                        if (object2 == 42 && !bl5) {
                            bl4 = false;
                            break;
                        }
                        if (object2 != object3 || !bl5) break;
                        bl4 = false;
                        break;
                    }
                    if (object2 == object3) {
                        bl4 = true;
                        bl5 = true;
                        break;
                    }
                    if (object2 != 42) break;
                    bl4 = true;
                    bl5 = false;
                    break;
                }
                case 10: {
                    if (!bl4 || !bl5) break;
                    bl4 = false;
                    break;
                }
                case 123: {
                    if (bl2 || bl4) break;
                    ++n;
                    break;
                }
                case 125: {
                    if (bl2 || bl4 || --n != 0) break;
                    stringBuilder.append((char)object3);
                    stringBuilder2.append(Utils.b(stringBuilder.toString(), protocol));
                    stringBuilder.setLength(0);
                    object2 = object3;
                    continue block8;
                }
            }
            object2 = object3;
            if (n > 0) {
                stringBuilder.append((char)object3);
                continue;
            }
            stringBuilder2.append((char)object3);
        }
        if (n > 0) {
            throw new SQLException("Invalid escape sequence , missing closing '}' character in '" + stringBuilder2);
        }
        return stringBuilder2.toString();
    }

    public static Protocol retrieveProxy(UrlParser object, GlobalStateInfo globalStateInfo) {
        ReentrantLock reentrantLock = new ReentrantLock();
        LruTraceCache lruTraceCache = ((UrlParser)object).getOptions().enablePacketDebug ? new LruTraceCache() : null;
        switch (((UrlParser)object).getHaMode()) {
            case AURORA: {
                return Utils.a((UrlParser)object, (Protocol)Proxy.newProxyInstance(AuroraProtocol.class.getClassLoader(), new Class[]{Protocol.class}, (InvocationHandler)new FailoverProxy(new AuroraListener((UrlParser)object, globalStateInfo), reentrantLock, lruTraceCache)));
            }
            case REPLICATION: {
                return Utils.a((UrlParser)object, (Protocol)Proxy.newProxyInstance(MastersReplicasProtocol.class.getClassLoader(), new Class[]{Protocol.class}, (InvocationHandler)new FailoverProxy(new MastersReplicasListener((UrlParser)object, globalStateInfo), reentrantLock, lruTraceCache)));
            }
            case LOADBALANCE: 
            case SEQUENTIAL: {
                return Utils.a((UrlParser)object, (Protocol)Proxy.newProxyInstance(MasterProtocol.class.getClassLoader(), new Class[]{Protocol.class}, (InvocationHandler)new FailoverProxy(new MastersFailoverListener((UrlParser)object, globalStateInfo), reentrantLock, lruTraceCache)));
            }
        }
        object = Utils.a((UrlParser)object, (Protocol)new MasterProtocol((UrlParser)object, globalStateInfo, reentrantLock, lruTraceCache));
        object.connectWithoutProxy();
        return object;
    }

    private static Protocol a(UrlParser urlParser, Protocol protocol) {
        if (urlParser.getOptions().profileSql || urlParser.getOptions().slowQueryThresholdNanos != null) {
            return (Protocol)Proxy.newProxyInstance(MasterProtocol.class.getClassLoader(), new Class[]{Protocol.class}, (InvocationHandler)new ProtocolLoggingProxy(protocol, urlParser.getOptions()));
        }
        return protocol;
    }

    public static TimeZone getTimeZone(String string) {
        TimeZone timeZone = TimeZone.getTimeZone(string);
        if ("GMT".equals(timeZone.getID()) && !"GMT".equals(string)) {
            throw new SQLException("invalid timezone id '" + string + "'");
        }
        return timeZone;
    }

    public static Socket createSocket(Options options, String string) {
        return e.apply(options, string);
    }

    public static String hexdump(byte[] ... byArray) {
        return Utils.hexdump(Integer.MAX_VALUE, 0, Integer.MAX_VALUE, byArray);
    }

    public static String hexdump(int n, int n2, int n3, byte[] ... object) {
        byte[] byArray;
        switch (((byte[][])object).length) {
            case 0: {
                return "";
            }
            case 1: {
                byte[] byArray2 = object[0];
                object = byArray2;
                if (byArray2.length <= n2) {
                    return "";
                }
                n = Math.min(n, Math.min(((byte[][])object).length - n2, n3));
                StringBuilder stringBuilder = new StringBuilder(n * 5);
                stringBuilder.append("\n");
                Utils.a((byte[])object, n2, n, stringBuilder);
                return stringBuilder.toString();
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(object[0]);
            byteArrayOutputStream.write(object[1], n2, Math.min(n3, object[1].length));
            for (n3 = 2; n3 < ((byte[][])object).length; ++n3) {
                byteArrayOutputStream.write(object[n3]);
            }
        }
        catch (IOException iOException) {}
        if ((byArray = byteArrayOutputStream.toByteArray()).length <= n2) {
            return "";
        }
        n = Math.min(n, byteArrayOutputStream.size());
        StringBuilder stringBuilder = new StringBuilder(n * 3 + 80);
        stringBuilder.append("\n");
        Utils.a(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size(), stringBuilder);
        return stringBuilder.toString();
    }

    private static void a(byte[] byArray, int n, int n2, StringBuilder stringBuilder) {
        int n3;
        if (byArray == null || byArray.length == 0) {
            return;
        }
        char[] cArray = new char[16];
        char[] cArray2 = cArray;
        cArray[8] = 32;
        int n4 = 0;
        stringBuilder.append("+--------------------------------------------------+\n|  0  1  2  3  4  5  6  7   8  9  a  b  c  d  e  f |\n+--------------------------------------------------+------------------+\n| ");
        for (int i = n; i < n2 + n; ++i) {
            n3 = byArray[i] & 0xFF;
            stringBuilder.append(a[n3 >>> 4]).append(a[n3 & 0xF]).append(" ");
            int n5 = cArray2[n4++] = n3 > 31 && n3 < 127 ? (int)n3 : 46;
            if (n4 == 8) {
                stringBuilder.append(" ");
            }
            if (n4 != 16) continue;
            stringBuilder.append("| ").append(cArray2).append(" |\n");
            if (i + 1 != n2 + n) {
                stringBuilder.append("| ");
            }
            n4 = 0;
        }
        n3 = n4;
        if (n3 > 0) {
            if (n3 < 8) {
                while (n3 < 8) {
                    stringBuilder.append("   ");
                    ++n3;
                }
                stringBuilder.append(" ");
            }
            while (n3 < 16) {
                stringBuilder.append("   ");
                ++n3;
            }
            while (n4 < 16) {
                cArray2[n4] = 32;
                ++n4;
            }
            stringBuilder.append("| ").append(cArray2).append(" |\n");
        }
        stringBuilder.append("+--------------------------------------------------+------------------+\n");
    }

    private static String a(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
        for (byte by : byArray) {
            stringBuilder.append(a[(by & 0xF0) >> 4]).append(a[by & 0xF]);
        }
        return stringBuilder.toString();
    }

    public static String byteArrayToHexString(byte[] byArray) {
        if (byArray != null) {
            StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
            for (byte by : byArray) {
                stringBuilder.append(a[(by & 0xF0) >> 4]).append(a[by & 0xF]);
            }
            return stringBuilder.toString();
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String parseSessionVariables(String object) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        Parse parse = Parse.Normal;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        String string = null;
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        object = cArray;
        int n = cArray.length;
        block7: for (int i = 0; i < n; ++i) {
            Object object2 = object[i];
            if (parse == Parse.Escape) {
                stringBuilder2.append((char)object2);
                parse = bl2 ? Parse.Quote : Parse.String;
                continue;
            }
            switch (object2) {
                case 34: {
                    if (parse == Parse.Normal) {
                        parse = Parse.String;
                        bl2 = false;
                        break;
                    }
                    if (parse != Parse.String || bl2) break;
                    parse = Parse.Normal;
                    break;
                }
                case 39: {
                    if (parse == Parse.Normal) {
                        parse = Parse.String;
                        bl2 = true;
                        break;
                    }
                    if (parse != Parse.String || !bl2) break;
                    parse = Parse.Normal;
                    break;
                }
                case 92: {
                    if (parse != Parse.String) break;
                    parse = Parse.Escape;
                    break;
                }
                case 44: 
                case 59: {
                    if (parse != Parse.Normal) break;
                    if (!bl) {
                        if (!bl3) {
                            stringBuilder.append(",");
                        }
                        stringBuilder.append(string);
                        stringBuilder.append(stringBuilder2.toString());
                        bl3 = false;
                    } else {
                        string = stringBuilder2.toString().trim();
                        if (!string.isEmpty()) {
                            if (!bl3) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(string);
                            bl3 = false;
                        }
                    }
                    bl = true;
                    string = null;
                    stringBuilder2 = new StringBuilder();
                    continue block7;
                }
                case 61: {
                    if (parse != Parse.Normal || !bl) break;
                    string = stringBuilder2.toString().trim();
                    bl = false;
                    stringBuilder2 = new StringBuilder();
                }
            }
            stringBuilder2.append((char)object2);
        }
        if (!bl) {
            if (!bl3) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string);
            stringBuilder.append(stringBuilder2.toString());
            return stringBuilder.toString();
        }
        object = stringBuilder2.toString().trim();
        if (!((String)object).isEmpty() && !bl3) {
            stringBuilder.append(",");
        }
        stringBuilder.append((String)object);
        return stringBuilder.toString();
    }

    public static boolean isIPv4(String string) {
        return b.matcher(string).matches();
    }

    public static boolean isIPv6(String string) {
        return c.matcher(string).matches() || d.matcher(string).matches();
    }

    public static int transactionFromString(String string) {
        int n = -1;
        switch (string.hashCode()) {
            case -1296331988: {
                if (!string.equals("READ-UNCOMMITTED")) break;
                n = 0;
                break;
            }
            case 1633007589: {
                if (!string.equals("READ-COMMITTED")) break;
                n = 1;
                break;
            }
            case -718034194: {
                if (!string.equals("REPEATABLE-READ")) break;
                n = 2;
                break;
            }
            case -1116651265: {
                if (!string.equals("SERIALIZABLE")) break;
                n = 3;
            }
        }
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 8;
            }
        }
        throw new SQLException("unknown transaction isolation level");
    }

    public static boolean validateFileName(String string, ParameterHolder[] parameterHolderArray, String string2) {
        Pattern pattern = Pattern.compile("^(\\s*\\/\\*([^\\*]|\\*[^\\/])*\\*\\/)*\\s*LOAD\\s+DATA\\s+((LOW_PRIORITY|CONCURRENT)\\s+)?LOCAL\\s+INFILE\\s+'" + string2 + "'", 2);
        if (pattern.matcher(string).find()) {
            return true;
        }
        if (parameterHolderArray != null && (pattern = Pattern.compile("^(\\s*\\/\\*([^\\*]|\\*[^\\/])*\\*\\/)*\\s*LOAD\\s+DATA\\s+((LOW_PRIORITY|CONCURRENT)\\s+)?LOCAL\\s+INFILE\\s+\\?", 2)).matcher(string).find() && parameterHolderArray.length > 0) {
            return parameterHolderArray[0].toString().toLowerCase().equals("'" + string2.toLowerCase() + "'");
        }
        return false;
    }

    static {
        SocketHandlerFunction socketHandlerFunction;
        a = "0123456789ABCDEF".toCharArray();
        b = Pattern.compile("^(([1-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){1}(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){2}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
        c = Pattern.compile("^[0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4}){7}$");
        d = Pattern.compile("^(([0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4}){0,5})?)::(([0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4}){0,5})?)$");
        try {
            socketHandlerFunction = SocketUtility.getSocketHandler();
        }
        catch (Throwable throwable) {
            socketHandlerFunction = (options, string) -> Utils.standardSocket(options, string);
        }
        e = socketHandlerFunction;
    }

    private static enum Parse {
        Normal,
        String,
        Quote,
        Escape;

    }
}

