/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.exceptions;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientConnectionException;
import java.sql.Statement;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbConnection;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.exceptions.MariaDbSqlException;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.util.Options;

public final class ExceptionFactory {
    public static final ExceptionFactory INSTANCE = new ExceptionFactory(-1L, null);
    private final long a;
    private final Options b;
    private MariaDbConnection c;
    private Statement d;

    public ExceptionFactory(long l, Options options, MariaDbConnection mariaDbConnection, Statement statement) {
        this.a = l;
        this.b = options;
        this.c = mariaDbConnection;
        this.d = statement;
    }

    private ExceptionFactory(long l, Options options) {
        this.a = l;
        this.b = options;
    }

    public static ExceptionFactory of(long l, Options options) {
        return new ExceptionFactory(l, options);
    }

    private static SQLException a(String object, String string, int n, long l, Options object2, MariaDbConnection mariaDbConnection, Statement statement, Exception exception) {
        Object object3 = exception;
        Object object4 = object2;
        long l2 = l;
        object2 = new StringBuilder();
        String string2 = null;
        String string3 = null;
        if (l2 != -1L) {
            ((StringBuilder)object2).append("(conn=").append(l2).append(") ").append((String)object);
        } else {
            ((StringBuilder)object2).append((String)object);
        }
        if (object3 instanceof MariaDbSqlException) {
            object = (MariaDbSqlException)object3;
            object3 = ((MariaDbSqlException)object).getSql();
            if (((Options)object4).dumpQueriesOnException && object3 != null) {
                if (object4 != null && ((Options)object4).maxQuerySizeToLog != 0 && ((String)object3).length() > ((Options)object4).maxQuerySizeToLog - 3) {
                    ((StringBuilder)object2).append("\nQuery is: ").append((CharSequence)object3, 0, ((Options)object4).maxQuerySizeToLog - 3).append("...");
                } else {
                    ((StringBuilder)object2).append("\nQuery is: ").append((String)object3);
                }
            }
            string2 = ((MariaDbSqlException)object).getDeadLockInfo();
            string3 = ((MariaDbSqlException)object).getThreadName();
        }
        if (object4 != null && ((Options)object4).includeInnodbStatusInDeadlockExceptions && string2 != null) {
            ((StringBuilder)object2).append("\ndeadlock information: ").append(string2);
        }
        if (object4 != null && ((Options)object4).includeThreadDumpInDeadlockExceptions) {
            if (string3 != null) {
                ((StringBuilder)object2).append("\nthread name: ").append(string3);
            }
            ((StringBuilder)object2).append("\ncurrent threads: ");
            Thread.getAllStackTraces().forEach((arg_0, arg_1) -> ExceptionFactory.a((StringBuilder)object2, arg_0, arg_1));
        }
        object = ((StringBuilder)object2).toString();
        if ("70100".equals(string)) {
            return new SQLTimeoutException((String)object, string, n);
        }
        object4 = string == null ? "42" : string.substring(0, 2);
        switch (object4) {
            case "0A": {
                object = new SQLFeatureNotSupportedException((String)object, string, n, exception);
                break;
            }
            case "22": 
            case "26": 
            case "2F": 
            case "20": 
            case "42": 
            case "XA": {
                object = new SQLSyntaxErrorException((String)object, string, n, exception);
                break;
            }
            case "25": 
            case "28": {
                object = new SQLInvalidAuthorizationSpecException((String)object, string, n, exception);
                break;
            }
            case "21": 
            case "23": {
                object = new SQLIntegrityConstraintViolationException((String)object, string, n, exception);
                break;
            }
            case "08": {
                object = new SQLNonTransientConnectionException((String)object, string, n, exception);
                break;
            }
            case "40": {
                object = new SQLTransactionRollbackException((String)object, string, n, exception);
                break;
            }
            default: {
                object = new SQLTransientConnectionException((String)object, string, n, exception);
            }
        }
        if (mariaDbConnection != null && mariaDbConnection.pooledConnection != null) {
            mariaDbConnection.pooledConnection.fireStatementErrorOccured(statement, (SQLException)object);
        }
        return object;
    }

    private static String a(String object, long l, Options options, Exception exception) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        String string2 = null;
        if (l != -1L) {
            stringBuilder.append("(conn=").append(l).append(") ").append((String)object);
        } else {
            stringBuilder.append((String)object);
        }
        if (exception instanceof MariaDbSqlException) {
            object = (MariaDbSqlException)exception;
            String string3 = ((MariaDbSqlException)object).getSql();
            if (options.dumpQueriesOnException && string3 != null) {
                if (options != null && options.maxQuerySizeToLog != 0 && string3.length() > options.maxQuerySizeToLog - 3) {
                    stringBuilder.append("\nQuery is: ").append(string3, 0, options.maxQuerySizeToLog - 3).append("...");
                } else {
                    stringBuilder.append("\nQuery is: ").append(string3);
                }
            }
            string = ((MariaDbSqlException)object).getDeadLockInfo();
            string2 = ((MariaDbSqlException)object).getThreadName();
        }
        if (options != null && options.includeInnodbStatusInDeadlockExceptions && string != null) {
            stringBuilder.append("\ndeadlock information: ").append(string);
        }
        if (options != null && options.includeThreadDumpInDeadlockExceptions) {
            if (string2 != null) {
                stringBuilder.append("\nthread name: ").append(string2);
            }
            stringBuilder.append("\ncurrent threads: ");
            Thread.getAllStackTraces().forEach((thread, stackTraceElementArray) -> {
                stringBuilder.append("\n  name:\"").append(thread.getName()).append("\" pid:").append(thread.getId()).append(" status:").append((Object)thread.getState());
                for (int i = 0; i < ((StackTraceElement[])stackTraceElementArray).length; ++i) {
                    stringBuilder.append("\n    ").append(stackTraceElementArray[i]);
                }
            });
        }
        return stringBuilder.toString();
    }

    public final ExceptionFactory raiseStatementError(MariaDbConnection mariaDbConnection, Statement statement) {
        return new ExceptionFactory(this.a, this.b, mariaDbConnection, statement);
    }

    public final SQLException create(SQLException sQLException) {
        return ExceptionFactory.a(sQLException.getMessage().contains("\n") ? sQLException.getMessage().substring(0, sQLException.getMessage().indexOf("\n")) : sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), this.a, this.b, this.c, this.d, sQLException);
    }

    public final SQLException notSupported(String string) {
        return ExceptionFactory.a(string, "0A000", -1, this.a, this.b, this.c, this.d, null);
    }

    public final SQLException create(String string) {
        return ExceptionFactory.a(string, "42000", -1, this.a, this.b, this.c, this.d, null);
    }

    public final SQLException create(String string, Exception exception) {
        return ExceptionFactory.a(string, "42000", -1, this.a, this.b, this.c, this.d, exception);
    }

    public final SQLException create(String string, String string2) {
        return ExceptionFactory.a(string, string2, -1, this.a, this.b, this.c, this.d, null);
    }

    public final SQLException create(String string, String string2, Exception exception) {
        return ExceptionFactory.a(string, string2, -1, this.a, this.b, this.c, this.d, exception);
    }

    public final SQLException create(String string, String string2, int n) {
        return ExceptionFactory.a(string, string2, n, this.a, this.b, this.c, this.d, null);
    }

    public final SQLException create(String string, String string2, int n, Exception exception) {
        return ExceptionFactory.a(string, string2, n, this.a, this.b, this.c, this.d, exception);
    }

    public final long getThreadId() {
        return this.a;
    }

    public final Options getOptions() {
        return this.b;
    }

    public final String toString() {
        return "ExceptionFactory{threadId=" + this.a + '}';
    }
}

