/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.scheduler;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.scheduler.DynamicSizedSchedulerImpl;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.scheduler.DynamicSizedSchedulerInterface;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.scheduler.FixedSizedSchedulerImpl;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.scheduler.MariaDbThreadFactory;

public class SchedulerServiceProviderHolder {
    public static final SchedulerProvider DEFAULT_PROVIDER = new SchedulerProvider(){
        private DynamicSizedSchedulerInterface a;
        private FixedSizedSchedulerImpl b;
        private ScheduledThreadPoolExecutor c;
        private ThreadPoolExecutor d;

        @Override
        public final DynamicSizedSchedulerInterface getScheduler(int n, String string, int n2) {
            if (this.a == null) {
                1 var4_5 = this;
                synchronized (var4_5) {
                    if (this.a == null) {
                        this.a = new DynamicSizedSchedulerImpl(n, string, n2);
                    }
                }
            }
            return this.a;
        }

        @Override
        public final ScheduledThreadPoolExecutor getFixedSizeScheduler(int n, String string) {
            if (this.b == null) {
                1 var3_4 = this;
                synchronized (var3_4) {
                    if (this.b == null) {
                        this.b = new FixedSizedSchedulerImpl(n, string);
                    }
                }
            }
            return this.b;
        }

        @Override
        public final ScheduledThreadPoolExecutor getTimeoutScheduler() {
            if (this.c == null) {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (this.c == null) {
                        this.c = new ScheduledThreadPoolExecutor(1, new MariaDbThreadFactory("MariaDb-timeout"));
                        this.c.setRemoveOnCancelPolicy(true);
                    }
                }
            }
            return this.c;
        }

        @Override
        public final ThreadPoolExecutor getBulkScheduler() {
            if (this.d == null) {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (this.d == null) {
                        this.d = new ThreadPoolExecutor(5, 100, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), new MariaDbThreadFactory("MariaDb-bulk"));
                    }
                }
            }
            return this.d;
        }

        @Override
        public final void close() {
            1 var1_1 = this;
            synchronized (var1_1) {
                if (this.a != null) {
                    this.a.shutdownNow();
                }
                if (this.b != null) {
                    this.b.shutdownNow();
                }
                if (this.c != null) {
                    this.c.shutdownNow();
                }
                if (this.d != null) {
                    this.d.shutdownNow();
                }
                this.a = null;
                this.b = null;
                this.c = null;
                this.d = null;
                return;
            }
        }
    };
    private static AtomicReference<SchedulerProvider> a = new AtomicReference<SchedulerProvider>(DEFAULT_PROVIDER);

    public static SchedulerProvider getSchedulerProvider() {
        return a.get();
    }

    public static void setSchedulerProvider(SchedulerProvider schedulerProvider) {
        if (schedulerProvider == null) {
            schedulerProvider = DEFAULT_PROVIDER;
        }
        a.getAndSet(schedulerProvider).close();
    }

    public static void close() {
        a.get().close();
    }

    public static DynamicSizedSchedulerInterface getScheduler(int n, String string, int n2) {
        return SchedulerServiceProviderHolder.getSchedulerProvider().getScheduler(n, string, n2);
    }

    public static ScheduledExecutorService getFixedSizeScheduler(int n, String string) {
        return SchedulerServiceProviderHolder.getSchedulerProvider().getFixedSizeScheduler(n, string);
    }

    public static ScheduledExecutorService getTimeoutScheduler() {
        return SchedulerServiceProviderHolder.getSchedulerProvider().getTimeoutScheduler();
    }

    public static ThreadPoolExecutor getBulkScheduler() {
        return SchedulerServiceProviderHolder.getSchedulerProvider().getBulkScheduler();
    }

    public static interface SchedulerProvider {
        public DynamicSizedSchedulerInterface getScheduler(int var1, String var2, int var3);

        public ScheduledExecutorService getFixedSizeScheduler(int var1, String var2);

        public ScheduledThreadPoolExecutor getTimeoutScheduler();

        public ThreadPoolExecutor getBulkScheduler();

        public void close();
    }
}

