/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.util;

import java.lang.reflect.Field;
import java.util.Properties;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.credential.CredentialPlugin;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.OptionUtils;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.constant.HaMode;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.util.Options;

public final class DefaultOptions
extends Enum<DefaultOptions> {
    public static final /* enum */ DefaultOptions USER = new DefaultOptions("user", "Database user name", false);
    public static final /* enum */ DefaultOptions PASSWORD = new DefaultOptions("password", "Password of database user", false);
    public static final /* enum */ DefaultOptions CONNECT_TIMEOUT = new DefaultOptions("connectTimeout", 30000, (Integer)0, "The connect timeout value, in milliseconds, or zero for no timeout.", false);
    public static final /* enum */ DefaultOptions PIPE = new DefaultOptions("pipe", "On Windows, specify named pipe name to connect.", false);
    public static final /* enum */ DefaultOptions LOCAL_SOCKET = new DefaultOptions("localSocket", "Permits connecting to the database via Unix domain socket, if the server allows it. \nThe value is the path of Unix domain socket (i.e \"socket\" database parameter : select @@socket).", false);
    public static final /* enum */ DefaultOptions SHARED_MEMORY = new DefaultOptions("sharedMemory", "Permits connecting to the database via shared memory, if the server allows it. \nThe value is the base name of the shared memory.", false);
    public static final /* enum */ DefaultOptions TCP_NO_DELAY = new DefaultOptions("tcpNoDelay", Boolean.TRUE, "Sets corresponding option on the connection socket.", false);
    public static final /* enum */ DefaultOptions TCP_ABORTIVE_CLOSE = new DefaultOptions("tcpAbortiveClose", Boolean.FALSE, "Sets corresponding option on the connection socket.", false);
    public static final /* enum */ DefaultOptions LOCAL_SOCKET_ADDRESS = new DefaultOptions("localSocketAddress", "Hostname or IP address to bind the connection socket to a local (UNIX domain) socket.", false);
    public static final /* enum */ DefaultOptions SOCKET_TIMEOUT = new DefaultOptions("socketTimeout", new Integer[]{10000, null, null, null, null, null}, (Integer)0, "Defined the network socket timeout (SO_TIMEOUT) in milliseconds. Value of 0 disables this timeout. \nIf the goal is to set a timeout for all queries, since MariaDB 10.1.1, the server has permitted a solution to limit the query time by setting a system variable, max_statement_time. The advantage is that the connection then is still usable.\nDefault: 0 (standard configuration) or 10000ms (using \"aurora\" failover configuration).", false);
    public static final /* enum */ DefaultOptions INTERACTIVE_CLIENT = new DefaultOptions("interactiveClient", Boolean.FALSE, "Session timeout is defined by the wait_timeout server variable. Setting interactiveClient to true will tell the server to use the interactive_timeout server variable.", false);
    public static final /* enum */ DefaultOptions DUMP_QUERY_ON_EXCEPTION = new DefaultOptions("dumpQueriesOnException", Boolean.FALSE, "If set to 'true', an exception is thrown during query execution containing a query string.", false);
    public static final /* enum */ DefaultOptions USE_OLD_ALIAS_METADATA_BEHAVIOR = new DefaultOptions("useOldAliasMetadataBehavior", Boolean.FALSE, "Metadata ResultSetMetaData.getTableName() returns the physical table name. \"useOldAliasMetadataBehavior\" permits activating the legacy code that sends the table alias if set.", false);
    public static final /* enum */ DefaultOptions ALLOW_LOCAL_INFILE = new DefaultOptions("allowLocalInfile", Boolean.TRUE, "Permit loading data from file", false);
    public static final /* enum */ DefaultOptions SESSION_VARIABLES = new DefaultOptions("sessionVariables", "<var>=<value> pairs separated by comma, mysql session variables, set upon establishing successful connection.", false);
    public static final /* enum */ DefaultOptions CREATE_DATABASE_IF_NOT_EXISTS = new DefaultOptions("createDatabaseIfNotExist", Boolean.FALSE, "the specified database in the url will be created if non-existent.", false);
    public static final /* enum */ DefaultOptions SERVER_TIMEZONE = new DefaultOptions("serverTimezone", "Defines the server time zone.\nto use only if the jre server has a different time implementation of the server.\n(best to have the same server time zone when possible).", false);
    public static final /* enum */ DefaultOptions NULL_CATALOG_MEANS_CURRENT = new DefaultOptions("nullCatalogMeansCurrent", Boolean.TRUE, "DatabaseMetaData use current catalog if null.", false);
    public static final /* enum */ DefaultOptions TINY_INT_IS_BIT = new DefaultOptions("tinyInt1isBit", Boolean.TRUE, "Datatype mapping flag, handle Tiny as BIT(boolean).", false);
    public static final /* enum */ DefaultOptions YEAR_IS_DATE_TYPE = new DefaultOptions("yearIsDateType", Boolean.TRUE, "Year is date type, rather than numerical.", false);
    public static final /* enum */ DefaultOptions USE_SSL = new DefaultOptions("useSsl", Boolean.FALSE, "Force SSL on connection. (legacy alias \"useSSL\")", false);
    public static final /* enum */ DefaultOptions USER_COMPRESSION = new DefaultOptions("useCompression", Boolean.FALSE, "Compresses the exchange with the database through gzip. This permits better performance when the database is not in the same location.", false);
    public static final /* enum */ DefaultOptions ALLOW_MULTI_QUERIES = new DefaultOptions("allowMultiQueries", Boolean.FALSE, "permit multi-queries like insert into ab (i) values (1); insert into ab (i) values (2).", false);
    public static final /* enum */ DefaultOptions REWRITE_BATCHED_STATEMENTS = new DefaultOptions("rewriteBatchedStatements", Boolean.FALSE, "For insert queries, rewrite batchedStatement to execute in a single executeQuery.\nexample:\n   insert into ab (i) values (?) with first batch values = 1, second = 2 will be rewritten\n   insert into ab (i) values (1), (2). \n\nIf query cannot be rewriten in \"multi-values\", rewrite will use multi-queries : INSERT INTO TABLE(col1) VALUES (?) ON DUPLICATE KEY UPDATE col2=? with values [1,2] and [2,3]\" will be rewritten\nINSERT INTO TABLE(col1) VALUES (1) ON DUPLICATE KEY UPDATE col2=2;INSERT INTO TABLE(col1) VALUES (3) ON DUPLICATE KEY UPDATE col2=4\n\nwhen active, the useServerPrepStmts option is set to false", false);
    public static final /* enum */ DefaultOptions TCP_KEEP_ALIVE = new DefaultOptions("tcpKeepAlive", Boolean.TRUE, "Sets corresponding option on the connection socket.", false);
    public static final /* enum */ DefaultOptions TCP_RCV_BUF = new DefaultOptions("tcpRcvBuf", (Integer)null, (Integer)0, "set buffer size for TCP buffer (SO_RCVBUF).", false);
    public static final /* enum */ DefaultOptions TCP_SND_BUF = new DefaultOptions("tcpSndBuf", (Integer)null, (Integer)0, "set buffer size for TCP buffer (SO_SNDBUF).", false);
    public static final /* enum */ DefaultOptions SOCKET_FACTORY = new DefaultOptions("socketFactory", "to use a custom socket factory, set it to the full name of the class that implements javax.net.SocketFactory.", false);
    public static final /* enum */ DefaultOptions PIN_GLOBAL_TX_TO_PHYSICAL_CONNECTION = new DefaultOptions("pinGlobalTxToPhysicalConnection", Boolean.FALSE, "", false);
    public static final /* enum */ DefaultOptions TRUST_SERVER_CERTIFICATE = new DefaultOptions("trustServerCertificate", Boolean.FALSE, "When using SSL, do not check server's certificate.", false);
    public static final /* enum */ DefaultOptions SERVER_SSL_CERT = new DefaultOptions("serverSslCert", "Permits providing server's certificate in DER form, or server's CA certificate. The server will be added to trustStor. This permits a self-signed certificate to be trusted.\nCan be used in one of 3 forms : \n* serverSslCert=/path/to/cert.pem (full path to certificate)\n* serverSslCert=classpath:relative/cert.pem (relative to current classpath)\n* or as verbatim DER-encoded certificate string \"------BEGIN CERTIFICATE-----\" .", false);
    public static final /* enum */ DefaultOptions USE_FRACTIONAL_SECONDS = new DefaultOptions("useFractionalSeconds", Boolean.TRUE, "Correctly handle subsecond precision in timestamps (feature available with MariaDB 5.3 and later).\nMay confuse 3rd party components (Hibernate).", false);
    public static final /* enum */ DefaultOptions AUTO_RECONNECT = new DefaultOptions("autoReconnect", Boolean.FALSE, "Driver must recreateConnection after a failover.", false);
    public static final /* enum */ DefaultOptions FAIL_ON_READ_ONLY = new DefaultOptions("failOnReadOnly", Boolean.FALSE, "After a master failover and no other master found, back on a read-only host ( throw exception if not).", false);
    public static final /* enum */ DefaultOptions RETRY_ALL_DOWN = new DefaultOptions("retriesAllDown", 120, (Integer)0, "When using loadbalancing, the number of times the driver should cycle through available hosts, attempting to connect.\n     * Between cycles, the driver will pause for 250ms if no servers are available.", false);
    public static final /* enum */ DefaultOptions FAILOVER_LOOP_RETRIES = new DefaultOptions("failoverLoopRetries", 120, (Integer)0, "When using failover, the number of times the driver should cycle silently through available hosts, attempting to connect.\n     * Between cycles, the driver will pause for 250ms if no servers are available.\n     * if set to 0, there will be no silent reconnection", false);
    public static final /* enum */ DefaultOptions VALID_CONNECTION_TIMEOUT = new DefaultOptions("validConnectionTimeout", 0, (Integer)0, "When in multiple hosts, after this time in second without used, verification that the connections haven't been lost.\n     * When 0, no verification will be done. Defaults to 0 (120 before 1.5.8 version)", false);
    public static final /* enum */ DefaultOptions LOAD_BALANCE_BLACKLIST_TIMEOUT = new DefaultOptions("loadBalanceBlacklistTimeout", 50, (Integer)0, "time in second a server is blacklisted after a connection failure.", false);
    public static final /* enum */ DefaultOptions CACHE_PREP_STMTS = new DefaultOptions("cachePrepStmts", Boolean.TRUE, "enable/disable prepare Statement cache, default true.", false);
    public static final /* enum */ DefaultOptions PREP_STMT_CACHE_SIZE = new DefaultOptions("prepStmtCacheSize", 250, (Integer)0, "This sets the number of prepared statements that the driver will cache per connection if \"cachePrepStmts\" is enabled.", false);
    public static final /* enum */ DefaultOptions PREP_STMT_CACHE_SQL_LIMIT = new DefaultOptions("prepStmtCacheSqlLimit", 2048, (Integer)0, "This is the maximum length of a prepared SQL statement that the driver will cache  if \"cachePrepStmts\" is enabled.", false);
    public static final /* enum */ DefaultOptions ASSURE_READONLY = new DefaultOptions("assureReadOnly", Boolean.FALSE, "Ensure that when Connection.setReadOnly(true) is called, host is in read-only mode by setting the session transaction to read-only.", false);
    public static final /* enum */ DefaultOptions USE_LEGACY_DATETIME_CODE = new DefaultOptions("useLegacyDatetimeCode", Boolean.TRUE, "if true (default) store date/timestamps according to client time zone.\nif false, store all date/timestamps in DB according to server time zone, and time information (that is a time difference), doesn't take\ntimezone in account.", false);
    public static final /* enum */ DefaultOptions MAXIMIZE_MYSQL_COMPATIBILITY = new DefaultOptions("maximizeMysqlCompatibility", Boolean.FALSE, "maximize MySQL compatibility.\nwhen using jdbc setDate(), will store date in client timezone, not in server timezone when useLegacyDatetimeCode = false.\ndefault to false.", false);
    public static final /* enum */ DefaultOptions USE_SERVER_PREP_STMTS = new DefaultOptions("useServerPrepStmts", Boolean.FALSE, "useServerPrepStmts must prepared statements be prepared on server side, or just faked on client side.\n     * if rewriteBatchedStatements is set to true, this options will be set to false.", false);
    public static final /* enum */ DefaultOptions TRUSTSTORE = new DefaultOptions("trustStore", "File path of the trustStore file (similar to java System property \"javax.net.ssl.trustStore\"). (legacy alias trustCertificateKeyStoreUrl)\nUse the specified file for trusted root certificates.\nWhen set, overrides serverSslCert.", false);
    public static final /* enum */ DefaultOptions TRUST_CERTIFICATE_KEYSTORE_PASSWORD = new DefaultOptions("trustStorePassword", "Password for the trusted root certificate file (similar to java System property \"javax.net.ssl.trustStorePassword\").\n(legacy alias trustCertificateKeyStorePassword).", false);
    public static final /* enum */ DefaultOptions KEYSTORE = new DefaultOptions("keyStore", "File path of the keyStore file that contain client private key store and associate certificates (similar to java System property \"javax.net.ssl.keyStore\", but ensure that only the private key's entries are used).(legacy alias clientCertificateKeyStoreUrl).", false);
    public static final /* enum */ DefaultOptions KEYSTORE_PASSWORD = new DefaultOptions("keyStorePassword", "Password for the client certificate keyStore (similar to java System property \"javax.net.ssl.keyStorePassword\").(legacy alias clientCertificateKeyStorePassword)", false);
    public static final /* enum */ DefaultOptions PRIVATE_KEYS_PASSWORD = new DefaultOptions("keyPassword", "Password for the private key in client certificate keyStore. (only needed if private key password differ from keyStore password).", false);
    public static final /* enum */ DefaultOptions ENABLED_SSL_PROTOCOL_SUITES = new DefaultOptions("enabledSslProtocolSuites", "Force TLS/SSL protocol to a specific set of TLS versions (comma separated list). \nExample : \"TLSv1, TLSv1.1, TLSv1.2\"\n(Alias \"enabledSSLProtocolSuites\" works too)", false);
    public static final /* enum */ DefaultOptions ENABLED_SSL_CIPHER_SUITES = new DefaultOptions("enabledSslCipherSuites", "Force TLS/SSL cipher (comma separated list).\nExample : \"TLS_DHE_RSA_WITH_AES_256_GCM_SHA384, TLS_DHE_DSS_WITH_AES_256_GCM_SHA384\"", false);
    public static final /* enum */ DefaultOptions CONTINUE_BATCH_ON_ERROR = new DefaultOptions("continueBatchOnError", Boolean.TRUE, "When executing batch queries, must batch continue on error.", false);
    public static final /* enum */ DefaultOptions JDBC_COMPLIANT_TRUNCATION = new DefaultOptions("jdbcCompliantTruncation", Boolean.TRUE, "Truncation error (\"Data truncated for column '%' at row %\", \"Out of range value for column '%' at row %\") will be thrown as error, and not as warning.", false);
    public static final /* enum */ DefaultOptions CACHE_CALLABLE_STMTS = new DefaultOptions("cacheCallableStmts", Boolean.FALSE, "enable/disable callable Statement cache, default false.", false);
    public static final /* enum */ DefaultOptions CALLABLE_STMT_CACHE_SIZE = new DefaultOptions("callableStmtCacheSize", 150, (Integer)0, "This sets the number of callable statements that the driver will cache per VM if \"cacheCallableStmts\" is enabled.", false);
    public static final /* enum */ DefaultOptions CONNECTION_ATTRIBUTES = new DefaultOptions("connectionAttributes", "When performance_schema is active, permit to send server some client information in a key;value pair format (example: connectionAttributes=key1:value1,key2,value2).\nThose informations can be retrieved on server within tables performance_schema.session_connect_attrs and performance_schema.session_account_connect_attrs.\nThis can permit from server an identification of client/application", false);
    public static final /* enum */ DefaultOptions USE_BATCH_MULTI_SEND = new DefaultOptions("useBatchMultiSend", (Boolean)null, "*Not compatible with aurora*\nDriver will can send queries by batch. \nIf set to false, queries are sent one by one, waiting for the result before sending the next one. \nIf set to true, queries will be sent by batch corresponding to the useBatchMultiSendNumber option value (default 100) or according to the max_allowed_packet server variable if the packet size does not permit sending as many queries. Results will be read later, avoiding a lot of network latency when the client and server aren't on the same host. \n\nThis option is mainly effective when the client is distant from the server.", false);
    public static final /* enum */ DefaultOptions USE_BATCH_MULTI_SEND_NUMBER = new DefaultOptions("useBatchMultiSendNumber", 100, (Integer)1, "When option useBatchMultiSend is active, indicate the maximum query send in a row before reading results.", false);
    public static final /* enum */ DefaultOptions LOGGING = new DefaultOptions("log", Boolean.FALSE, "Enable log information. \nrequire Slf4j version > 1.4 dependency.\nLog level correspond to Slf4j logging implementation", false);
    public static final /* enum */ DefaultOptions PROFILE_SQL = new DefaultOptions("profileSql", Boolean.FALSE, "log query execution time.", false);
    public static final /* enum */ DefaultOptions MAX_QUERY_LOG_SIZE = new DefaultOptions("maxQuerySizeToLog", 1024, (Integer)0, "Max query log size.", false);
    public static final /* enum */ DefaultOptions SLOW_QUERY_TIME = new DefaultOptions("slowQueryThresholdNanos", null, 0L, "Will log query with execution time superior to this value (if defined )", false);
    public static final /* enum */ DefaultOptions PASSWORD_CHARACTER_ENCODING = new DefaultOptions("passwordCharacterEncoding", "Indicate password encoding charset. If not set, driver use platform's default charset.", false);
    public static final /* enum */ DefaultOptions PIPELINE_AUTH = new DefaultOptions("usePipelineAuth", (Boolean)null, "*Not compatible with aurora*\nDuring connection, different queries are executed. When option is active those queries are send using pipeline (all queries are send, then only all results are reads), permitting faster connection creation", false);
    public static final /* enum */ DefaultOptions ENABLE_PACKET_DEBUG = new DefaultOptions("enablePacketDebug", Boolean.FALSE, "Driver will save the last 16 MariaDB packet exchanges (limited to first 1000 bytes). Hexadecimal value of those packets will be added to stacktrace when an IOException occur.\nThis option has no impact on performance but driver will then take 16kb more memory.", false);
    public static final /* enum */ DefaultOptions SSL_HOSTNAME_VERIFICATION = new DefaultOptions("disableSslHostnameVerification", Boolean.FALSE, "When using ssl, the driver checks the hostname against the server's identity as presented in the server's certificate (checking alternative names or the certificate CN) to prevent man-in-the-middle attacks. This option permits deactivating this validation. Hostname verification is disabled when the trustServerCertificate option is set", false);
    public static final /* enum */ DefaultOptions USE_BULK_PROTOCOL = new DefaultOptions("useBulkStmts", Boolean.FALSE, "Use dedicated COM_STMT_BULK_EXECUTE protocol for batch insert when possible. (batch without Statement.RETURN_GENERATED_KEYS and streams) to have faster batch. (significant only if server MariaDB >= 10.2.7)", false);
    public static final /* enum */ DefaultOptions AUTOCOMMIT = new DefaultOptions("autocommit", Boolean.TRUE, "Set default autocommit value on connection initialization", false);
    public static final /* enum */ DefaultOptions POOL = new DefaultOptions("pool", Boolean.FALSE, "Use pool. This option is useful only if not using a DataSource object, but only a connection object.", false);
    public static final /* enum */ DefaultOptions POOL_NAME = new DefaultOptions("poolName", "Pool name that permits identifying threads. default: auto-generated as MariaDb-pool-<pool-index>", false);
    public static final /* enum */ DefaultOptions MAX_POOL_SIZE = new DefaultOptions("maxPoolSize", 8, (Integer)1, "The maximum number of physical connections that the pool should contain.", false);
    public static final /* enum */ DefaultOptions MIN_POOL_SIZE = new DefaultOptions("minPoolSize", (Integer)null, (Integer)0, "When connections are removed due to not being used for longer than than \"maxIdleTime\", connections are closed and removed from the pool. \"minPoolSize\" indicates the number of physical connections the pool should keep available at all times. Should be less or equal to maxPoolSize.", false);
    public static final /* enum */ DefaultOptions MAX_IDLE_TIME = new DefaultOptions("maxIdleTime", 600, (Integer)60, "The maximum amount of time in seconds that a connection can stay in the pool when not used. This value must always be below @wait_timeout value - 45s \nDefault: 600 in seconds (=10 minutes), minimum value is 60 seconds", false);
    public static final /* enum */ DefaultOptions POOL_VALID_MIN_DELAY = new DefaultOptions("poolValidMinDelay", 1000, (Integer)0, "When asking a connection to pool, the pool will validate the connection state. \"poolValidMinDelay\" permits disabling this validation if the connection has been borrowed recently avoiding useless verifications in case of frequent reuse of connections. 0 means validation is done each time the connection is asked.", false);
    public static final /* enum */ DefaultOptions STATIC_GLOBAL = new DefaultOptions("staticGlobal", Boolean.FALSE, "Indicates the values of the global variables max_allowed_packet, wait_timeout, autocommit, auto_increment_increment, time_zone, system_time_zone and tx_isolation) won't be changed, permitting the pool to create new connections faster.", false);
    public static final /* enum */ DefaultOptions REGISTER_POOL_JMX = new DefaultOptions("registerJmxPool", Boolean.TRUE, "Register JMX monitoring pools.", false);
    public static final /* enum */ DefaultOptions USE_RESET_CONNECTION = new DefaultOptions("useResetConnection", Boolean.FALSE, "When a connection is closed() (given back to pool), the pool resets the connection state. Setting this option, the prepare command will be deleted, session variables changed will be reset, and user variables will be destroyed when the server permits it (>= MariaDB 10.2.4, >= MySQL 5.7.3), permitting saving memory on the server if the application make extensive use of variables. Must not be used with the useServerPrepStmts option", false);
    public static final /* enum */ DefaultOptions ALLOW_MASTER_DOWN = new DefaultOptions("allowMasterDownConnection", Boolean.FALSE, "When using master/replica configuration, permit to create connection when master is down. If no master is up, default connection is then a replica and Connection.isReadOnly() will then return true.", false);
    public static final /* enum */ DefaultOptions GALERA_ALLOWED_STATE = new DefaultOptions("galeraAllowedState", "Usually, Connection.isValid just send an empty packet to server, and server send a small response to ensure connectivity. When this option is set, connector will ensure Galera server state \"wsrep_local_state\" correspond to allowed values (separated by comma). Example \"4,5\", recommended is \"4\". see galera state to know more.", false);
    public static final /* enum */ DefaultOptions USE_AFFECTED_ROWS = new DefaultOptions("useAffectedRows", Boolean.FALSE, "If false (default), use \"found rows\" for the row count of statements. This corresponds to the JDBC standard.\nIf true, use \"affected rows\" for the row count.\nThis changes the behavior of, for example, UPDATE... ON DUPLICATE KEY statements.", false);
    public static final /* enum */ DefaultOptions INCLUDE_STATUS = new DefaultOptions("includeInnodbStatusInDeadlockExceptions", Boolean.FALSE, "add \"SHOW ENGINE INNODB STATUS\" result to exception trace when having a deadlock exception", false);
    public static final /* enum */ DefaultOptions INCLUDE_THREAD_DUMP = new DefaultOptions("includeThreadDumpInDeadlockExceptions", Boolean.FALSE, "add thread dump to exception trace when having a deadlock exception", false);
    public static final /* enum */ DefaultOptions READ_AHEAD = new DefaultOptions("useReadAheadInput", Boolean.TRUE, "use a buffered inputSteam that read socket available data", false);
    public static final /* enum */ DefaultOptions KEY_STORE_TYPE = new DefaultOptions("keyStoreType", (String)null, "indicate key store type (JKS/PKCS12). default is null, then using java default type", false);
    public static final /* enum */ DefaultOptions TRUST_STORE_TYPE = new DefaultOptions("trustStoreType", (String)null, "indicate trust store type (JKS/PKCS12). default is null, then using java default type", false);
    public static final /* enum */ DefaultOptions SERVICE_PRINCIPAL_NAME = new DefaultOptions("servicePrincipalName", (String)null, "when using GSSAPI authentication, SPN (Service Principal Name) use the server SPN information. When set, connector will use this value, ignoring server information", false);
    public static final /* enum */ DefaultOptions DEFAULT_FETCH_SIZE = new DefaultOptions("defaultFetchSize", 0, (Integer)0, "The driver will call setFetchSize(n) with this value on all newly-created Statements", false);
    public static final /* enum */ DefaultOptions USE_MYSQL_AS_DATABASE = new DefaultOptions("useMysqlMetadata", Boolean.FALSE, "force DatabaseMetadata.getDatabaseProductName() to return \"MySQL\" as database, not real database type", false);
    public static final /* enum */ DefaultOptions BLANK_TABLE_NAME_META = new DefaultOptions("blankTableNameMeta", Boolean.FALSE, "Resultset metadata getTableName always return blank. This option is mainly for ORACLE db compatibility", false);
    public static final /* enum */ DefaultOptions CREDENTIAL_TYPE = new DefaultOptions("credentialType", (String)null, "Indicate the credential plugin type to use. Plugin must be present in classpath", false);
    public static final /* enum */ DefaultOptions SERVER_KEY_FILE = new DefaultOptions("serverRsaPublicKeyFile", (String)null, "Indicate path to MySQL server public key file", false);
    public static final /* enum */ DefaultOptions ALLOW_SERVER_KEY_RETRIEVAL = new DefaultOptions("allowPublicKeyRetrieval", Boolean.FALSE, "Permit to get MySQL server key retrieval", false);
    public static final /* enum */ DefaultOptions TLS_SOCKET_TYPE = new DefaultOptions("tlsSocketType", (String)null, "Indicate TLS socket type implementation", false);
    public static final /* enum */ DefaultOptions TRACK_SCHEMA = new DefaultOptions("trackSchema", Boolean.TRUE, "manage session_track_schema setting when server has CLIENT_SESSION_TRACK capability", false);
    public static final /* enum */ DefaultOptions ENSURE_SOCKET_STATE = new DefaultOptions("ensureSocketState", Boolean.FALSE, "ensure socket state before issuing a new command", false);
    private final String a;
    private final String b;
    private final boolean c;
    private final Object d;
    private final Object e;
    private final Object f;
    private final Object g;
    private static final /* synthetic */ DefaultOptions[] h;

    public static DefaultOptions[] values() {
        return (DefaultOptions[])h.clone();
    }

    public static DefaultOptions valueOf(String string) {
        return Enum.valueOf(DefaultOptions.class, string);
    }

    private DefaultOptions(String string2, String string3, boolean bl) {
        this.a = string2;
        this.b = string3;
        this.c = false;
        this.d = String.class;
        this.e = null;
        this.f = null;
        this.g = null;
    }

    private DefaultOptions(String string2, String string3, String string4, boolean bl) {
        this.a = string2;
        this.b = string4;
        this.c = false;
        this.d = String.class;
        this.e = string3;
        this.f = null;
        this.g = null;
    }

    private DefaultOptions(String string2, Boolean bl, String string3, boolean bl2) {
        this.a = string2;
        this.d = Boolean.class;
        this.e = bl;
        this.b = string3;
        this.c = false;
        this.f = null;
        this.g = null;
    }

    private DefaultOptions(String string2, Integer n2, Integer n3, String string3, boolean bl) {
        this.a = string2;
        this.d = Integer.class;
        this.e = n2;
        this.f = n3;
        this.g = Integer.MAX_VALUE;
        this.b = string3;
        this.c = false;
    }

    private DefaultOptions(String string2, Long l, Long l2, String string3, boolean bl) {
        this.a = string2;
        this.d = Long.class;
        this.e = l;
        this.f = l2;
        this.g = Long.MAX_VALUE;
        this.b = string3;
        this.c = false;
    }

    private DefaultOptions(String string2, Integer[] integerArray, Integer n2, String string3, boolean bl) {
        this.a = string2;
        this.d = Integer.class;
        this.e = integerArray;
        this.f = n2;
        this.g = Integer.MAX_VALUE;
        this.b = string3;
        this.c = false;
    }

    public static Options defaultValues(HaMode haMode) {
        return DefaultOptions.a(haMode, "", new Properties());
    }

    public static Options defaultValues(HaMode object, boolean bl) {
        Properties properties = new Properties();
        properties.setProperty("pool", String.valueOf(bl));
        object = DefaultOptions.a(object, "", properties);
        DefaultOptions.postOptionProcess((Options)object, null);
        return object;
    }

    public static void parse(HaMode haMode, String string, Options options) {
        Properties properties = new Properties();
        DefaultOptions.parse(haMode, string, properties, options);
        DefaultOptions.postOptionProcess(options, null);
    }

    private static Options a(HaMode object, String string, Properties properties) {
        object = DefaultOptions.parse(object, string, properties, null);
        DefaultOptions.postOptionProcess((Options)object, null);
        return object;
    }

    public static Options parse(HaMode haMode, String stringArray, Properties properties, Options options) {
        if (stringArray != null && !stringArray.isEmpty()) {
            String[] stringArray2 = stringArray.split("&");
            stringArray = stringArray2;
            stringArray = stringArray2;
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                int n2 = string.indexOf(61);
                if (n2 == -1) {
                    if (properties.containsKey(string)) continue;
                    properties.setProperty(string, "");
                    continue;
                }
                if (properties.containsKey(string.substring(0, n2))) continue;
                properties.setProperty(string.substring(0, n2), string.substring(n2 + 1));
            }
        }
        return DefaultOptions.a(haMode, properties, options);
    }

    private static Options a(HaMode haMode, Properties properties, Options options) {
        options = options != null ? options : new Options();
        try {
            block18: for (String string : properties.stringPropertyNames()) {
                String string2 = properties.getProperty(string);
                DefaultOptions defaultOptions = OptionUtils.OPTIONS_MAP.get(string);
                if (defaultOptions != null && string2 != null) {
                    Object object;
                    Field field = Options.class.getField(defaultOptions.a);
                    if (defaultOptions.d.equals(String.class)) {
                        field.set(options, string2);
                        continue;
                    }
                    if (defaultOptions.d.equals(Boolean.class)) {
                        switch (string2.toLowerCase()) {
                            case "": 
                            case "1": 
                            case "true": {
                                field.set(options, Boolean.TRUE);
                                continue block18;
                            }
                            case "0": 
                            case "false": {
                                field.set(options, Boolean.FALSE);
                                continue block18;
                            }
                        }
                        throw new IllegalArgumentException("Optional parameter " + defaultOptions.a + " must be boolean (true/false or 0/1) was \"" + string2 + "\"");
                    }
                    if (defaultOptions.d.equals(Integer.class)) {
                        try {
                            object = Integer.parseInt(string2);
                            assert (defaultOptions.f != null);
                            assert (defaultOptions.g != null);
                            if (((Integer)object).compareTo((Integer)defaultOptions.f) < 0 || ((Integer)object).compareTo((Integer)defaultOptions.g) > 0) {
                                throw new IllegalArgumentException("Optional parameter " + defaultOptions.a + " must be greater or equal to " + defaultOptions.f + ((Integer)defaultOptions.g != Integer.MAX_VALUE ? " and smaller than " + defaultOptions.g : " ") + ", was \"" + string2 + "\"");
                            }
                            field.set(options, object);
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IllegalArgumentException("Optional parameter " + defaultOptions.a + " must be Integer, was \"" + string2 + "\"");
                        }
                    }
                    if (!defaultOptions.d.equals(Long.class)) continue;
                    try {
                        object = Long.parseLong(string2);
                        assert (defaultOptions.f != null);
                        assert (defaultOptions.g != null);
                        if (((Long)object).compareTo((Long)defaultOptions.f) < 0 || ((Long)object).compareTo((Long)defaultOptions.g) > 0) {
                            throw new IllegalArgumentException("Optional parameter " + defaultOptions.a + " must be greater or equal to " + defaultOptions.f + ((Long)defaultOptions.g != Long.MAX_VALUE ? " and smaller than " + defaultOptions.g : " ") + ", was \"" + string2 + "\"");
                        }
                        field.set(options, object);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("Optional parameter " + defaultOptions.a + " must be Long, was \"" + string2 + "\"");
                    }
                }
                options.nonMappedOptions.setProperty(string, properties.getProperty(string));
            }
            if (options.socketTimeout == null) {
                options.socketTimeout = ((Integer[])DefaultOptions.SOCKET_TIMEOUT.e)[haMode.ordinal()];
            }
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            ReflectiveOperationException reflectiveOperationException2 = reflectiveOperationException;
            reflectiveOperationException.printStackTrace();
        }
        catch (SecurityException securityException) {
            throw new IllegalArgumentException("Security too restrictive : " + securityException.getMessage());
        }
        return options;
    }

    public static void postOptionProcess(Options options, CredentialPlugin credentialPlugin) {
        if (options.rewriteBatchedStatements) {
            options.useServerPrepStmts = false;
        }
        if (options.pipe != null) {
            options.useBatchMultiSend = Boolean.FALSE;
            options.usePipelineAuth = Boolean.FALSE;
        }
        if (options.pool) {
            options.minPoolSize = options.minPoolSize == null ? options.maxPoolSize : Math.min(options.minPoolSize, options.maxPoolSize);
        }
        if (options.defaultFetchSize < 0) {
            options.defaultFetchSize = 0;
        }
        if (credentialPlugin != null && credentialPlugin.mustUseSsl()) {
            options.useSsl = Boolean.TRUE;
        }
    }

    public static void propertyString(Options options, HaMode object, StringBuilder stringBuilder) {
        try {
            boolean bl = true;
            for (DefaultOptions defaultOptions : DefaultOptions.values()) {
                Object object2 = Options.class.getField(defaultOptions.a).get(options);
                if (object2 == null || object2.equals(defaultOptions.e)) continue;
                if (bl) {
                    bl = false;
                    stringBuilder.append('?');
                } else {
                    stringBuilder.append('&');
                }
                stringBuilder.append(defaultOptions.a).append('=');
                if (defaultOptions.d.equals(String.class)) {
                    stringBuilder.append((String)object2);
                    continue;
                }
                if (defaultOptions.d.equals(Boolean.class)) {
                    stringBuilder.append(((Boolean)object2).toString());
                    continue;
                }
                if (!defaultOptions.d.equals(Integer.class) && !defaultOptions.d.equals(Long.class)) continue;
                stringBuilder.append(object2);
            }
            return;
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            object = reflectiveOperationException;
            reflectiveOperationException.printStackTrace();
            return;
        }
    }

    public final String getOptionName() {
        return this.a;
    }

    public final String getDescription() {
        return this.b;
    }

    public final boolean isRequired() {
        return this.c;
    }

    static {
        h = new DefaultOptions[]{USER, PASSWORD, CONNECT_TIMEOUT, PIPE, LOCAL_SOCKET, SHARED_MEMORY, TCP_NO_DELAY, TCP_ABORTIVE_CLOSE, LOCAL_SOCKET_ADDRESS, SOCKET_TIMEOUT, INTERACTIVE_CLIENT, DUMP_QUERY_ON_EXCEPTION, USE_OLD_ALIAS_METADATA_BEHAVIOR, ALLOW_LOCAL_INFILE, SESSION_VARIABLES, CREATE_DATABASE_IF_NOT_EXISTS, SERVER_TIMEZONE, NULL_CATALOG_MEANS_CURRENT, TINY_INT_IS_BIT, YEAR_IS_DATE_TYPE, USE_SSL, USER_COMPRESSION, ALLOW_MULTI_QUERIES, REWRITE_BATCHED_STATEMENTS, TCP_KEEP_ALIVE, TCP_RCV_BUF, TCP_SND_BUF, SOCKET_FACTORY, PIN_GLOBAL_TX_TO_PHYSICAL_CONNECTION, TRUST_SERVER_CERTIFICATE, SERVER_SSL_CERT, USE_FRACTIONAL_SECONDS, AUTO_RECONNECT, FAIL_ON_READ_ONLY, RETRY_ALL_DOWN, FAILOVER_LOOP_RETRIES, VALID_CONNECTION_TIMEOUT, LOAD_BALANCE_BLACKLIST_TIMEOUT, CACHE_PREP_STMTS, PREP_STMT_CACHE_SIZE, PREP_STMT_CACHE_SQL_LIMIT, ASSURE_READONLY, USE_LEGACY_DATETIME_CODE, MAXIMIZE_MYSQL_COMPATIBILITY, USE_SERVER_PREP_STMTS, TRUSTSTORE, TRUST_CERTIFICATE_KEYSTORE_PASSWORD, KEYSTORE, KEYSTORE_PASSWORD, PRIVATE_KEYS_PASSWORD, ENABLED_SSL_PROTOCOL_SUITES, ENABLED_SSL_CIPHER_SUITES, CONTINUE_BATCH_ON_ERROR, JDBC_COMPLIANT_TRUNCATION, CACHE_CALLABLE_STMTS, CALLABLE_STMT_CACHE_SIZE, CONNECTION_ATTRIBUTES, USE_BATCH_MULTI_SEND, USE_BATCH_MULTI_SEND_NUMBER, LOGGING, PROFILE_SQL, MAX_QUERY_LOG_SIZE, SLOW_QUERY_TIME, PASSWORD_CHARACTER_ENCODING, PIPELINE_AUTH, ENABLE_PACKET_DEBUG, SSL_HOSTNAME_VERIFICATION, USE_BULK_PROTOCOL, AUTOCOMMIT, POOL, POOL_NAME, MAX_POOL_SIZE, MIN_POOL_SIZE, MAX_IDLE_TIME, POOL_VALID_MIN_DELAY, STATIC_GLOBAL, REGISTER_POOL_JMX, USE_RESET_CONNECTION, ALLOW_MASTER_DOWN, GALERA_ALLOWED_STATE, USE_AFFECTED_ROWS, INCLUDE_STATUS, INCLUDE_THREAD_DUMP, READ_AHEAD, KEY_STORE_TYPE, TRUST_STORE_TYPE, SERVICE_PRINCIPAL_NAME, DEFAULT_FETCH_SIZE, USE_MYSQL_AS_DATABASE, BLANK_TABLE_NAME_META, CREDENTIAL_TYPE, SERVER_KEY_FILE, ALLOW_SERVER_KEY_RETRIEVAL, TLS_SOCKET_TYPE, TRACK_SCHEMA, ENSURE_SOCKET_STATE};
    }
}

