/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.enchanthandler.enchanttypes.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.advancedplugins.ae.enchanthandler.enchantments.LocalAPI;
import net.advancedplugins.ae.enchanthandler.enchanttypes.utils.RollItemType;
import net.advancedplugins.ae.enchanthandler.enchanttypes.utils.StackItem;
import net.advancedplugins.ae.impl.effects.effects.effects.AdvancedEffect;
import net.advancedplugins.ae.impl.utils.nbt.utils.MinecraftVersion;
import net.advancedplugins.ae.utils.AManager;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GetAllRollItems {
    @NotNull
    public static List<StackItem> getAllItems(LivingEntity livingEntity) {
        List<StackItem> list = GetAllRollItems.getMainItems(livingEntity);
        String[] stringArray = RollItemType.b();
        List list2 = list.stream().map(stackItem -> stackItem.i).collect(Collectors.toList());
        if (livingEntity instanceof InventoryHolder) {
            for (ItemStack itemStack : ((InventoryHolder)livingEntity).getInventory().getContents()) {
                if (itemStack == null && stringArray == null || list2.stream().anyMatch(itemStack2 -> itemStack2.isSimilar(itemStack)) && stringArray == null) continue;
                list.add(new StackItem(itemStack, RollItemType.OTHER));
                if (stringArray == null) continue;
            }
        }
        return list;
    }

    @NotNull
    public static List<StackItem> get(LivingEntity livingEntity) {
        ArrayList<StackItem> arrayList = new ArrayList<StackItem>();
        String[] stringArray = RollItemType.b();
        if (livingEntity instanceof InventoryHolder) {
            for (ItemStack itemStack : ((InventoryHolder)livingEntity).getInventory().getContents()) {
                if (itemStack == null && stringArray == null) continue;
                arrayList.add(new StackItem(itemStack, RollItemType.OTHER));
                if (stringArray == null) continue;
            }
        }
        return arrayList;
    }

    public static List<StackItem> getItemsInHands(@NotNull LivingEntity livingEntity) {
        StackItem[] stackItemArray = new StackItem[2];
        String[] stringArray = RollItemType.b();
        stackItemArray[0] = new StackItem(AManager.getItemStackHandByVersion((Player)livingEntity, true), RollItemType.HAND);
        if (MinecraftVersion.isNew() && AManager.getItemStackHandByVersion((Player)livingEntity, false) != null) {
            stackItemArray[1] = new StackItem(AManager.getItemStackHandByVersion((Player)livingEntity, false), RollItemType.OFFHAND);
        }
        if (AdvancedEffect.b() == null) {
            RollItemType.b(new String[2]);
        }
        return Arrays.stream(stackItemArray).filter(stackItem -> stackItem != null && LocalAPI.isValidForEnchantments(stackItem.i)).collect(Collectors.toList());
    }

    public static List<StackItem> getMainItems(LivingEntity livingEntity) {
        StackItem[] stackItemArray = new StackItem[5];
        EntityEquipment entityEquipment = livingEntity.getEquipment();
        stackItemArray[0] = new StackItem(entityEquipment.getHelmet(), RollItemType.HELMET);
        String[] stringArray = RollItemType.b();
        stackItemArray[1] = new StackItem(entityEquipment.getChestplate(), RollItemType.CHESTPLATE);
        stackItemArray[2] = new StackItem(entityEquipment.getLeggings(), RollItemType.LEGGINGS);
        stackItemArray[3] = new StackItem(entityEquipment.getBoots(), RollItemType.BOOTS);
        stackItemArray[4] = new StackItem(entityEquipment.getItemInHand(), RollItemType.HAND);
        if (stringArray != null) {
            AdvancedEffect.b(new int[2]);
        }
        return Arrays.stream(stackItemArray).filter(stackItem -> LocalAPI.isValidForEnchantments(stackItem.i)).collect(Collectors.toList());
    }
}

