/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.impl.utils.nbt.backend;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import net.advancedplugins.ae.impl.utils.nbt.backend.NBTCompound;
import net.advancedplugins.ae.impl.utils.nbt.backend.NBTType;
import net.advancedplugins.ae.impl.utils.nbt.backend.NbtApiException;
import net.advancedplugins.ae.impl.utils.nbt.backend.ReflectionMethod;
import net.advancedplugins.ae.impl.utils.nbt.utils.ReadWriteNBTList;

public abstract class NBTList<T>
implements List<T>,
ReadWriteNBTList<T> {
    private String b;
    private NBTCompound a;
    private NBTType c;
    protected Object d;
    private static final String[] e;

    protected NBTList(NBTCompound nBTCompound, String string, NBTType nBTType, Object object) {
        this.a = nBTCompound;
        this.b = string;
        this.c = nBTType;
        this.d = object;
    }

    public String getName() {
        return this.b;
    }

    public NBTCompound getParent() {
        return this.a;
    }

    private void validateClosed() {
        try {
            if (this.a.isClosed()) {
                throw new NbtApiException(e[2]);
            }
        }
        catch (NbtApiException nbtApiException) {
            throw NBTList.b(nbtApiException);
        }
    }

    private void validateWritable() {
        try {
            if (this.getParent().isReadOnly()) {
                throw new NbtApiException(e[1]);
            }
        }
        catch (NbtApiException nbtApiException) {
            throw NBTList.b(nbtApiException);
        }
    }

    protected void save() {
        this.validateClosed();
        this.a.set(this.b, this.d);
    }

    protected abstract Object asTag(T var1);

    @Override
    public boolean add(T t) {
        this.validateClosed();
        this.validateWritable();
        try {
            this.a.getWriteLock().lock();
            ReflectionMethod.LIST_ADD.run(this.d, this.size(), this.asTag(t));
            this.save();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            throw new NbtApiException(exception);
        }
        finally {
            this.a.getWriteLock().unlock();
        }
    }

    @Override
    public void add(int n, T t) {
        this.validateClosed();
        this.validateWritable();
        try {
            this.a.getWriteLock().lock();
            ReflectionMethod.LIST_ADD.run(this.d, n, this.asTag(t));
            this.save();
        }
        catch (Exception exception) {
            throw new NbtApiException(exception);
        }
        finally {
            this.a.getWriteLock().unlock();
        }
    }

    @Override
    public T set(int n, T t) {
        this.validateClosed();
        this.validateWritable();
        try {
            this.a.getWriteLock().lock();
            Object e = this.get(n);
            ReflectionMethod.LIST_SET.run(this.d, n, this.asTag(t));
            this.save();
            Object e2 = e;
            return (T)e2;
        }
        catch (Exception exception) {
            throw new NbtApiException(exception);
        }
        finally {
            this.a.getWriteLock().unlock();
        }
    }

    @Override
    public T remove(int n) {
        this.validateClosed();
        this.validateWritable();
        try {
            this.a.getWriteLock().lock();
            Object e = this.get(n);
            ReflectionMethod.LIST_REMOVE_KEY.run(this.d, n);
            this.save();
            Object e2 = e;
            return (T)e2;
        }
        catch (Exception exception) {
            throw new NbtApiException(exception);
        }
        finally {
            this.a.getWriteLock().unlock();
        }
    }

    @Override
    public int size() {
        this.validateClosed();
        try {
            this.a.getReadLock().lock();
            int n = (Integer)ReflectionMethod.LIST_SIZE.run(this.d, new Object[0]);
            return n;
        }
        catch (Exception exception) {
            throw new NbtApiException(exception);
        }
        finally {
            this.a.getReadLock().unlock();
        }
    }

    @Override
    public NBTType getType() {
        return this.c;
    }

    @Override
    public boolean isEmpty() {
        boolean bl;
        try {
            bl = this.size() == 0;
        }
        catch (NbtApiException nbtApiException) {
            throw NBTList.b(nbtApiException);
        }
        return bl;
    }

    @Override
    public void clear() {
        boolean bl = NBTCompound.b();
        while (!this.isEmpty()) {
            this.remove(0);
            if (bl) continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean contains(Object object) {
        int n;
        block6: {
            boolean bl = NBTCompound.b();
            this.validateClosed();
            boolean bl2 = bl;
            try {
                int n2;
                this.a.getReadLock().lock();
                for (n2 = 0; n2 < this.size(); ++n2) {
                    try {
                        n = object.equals(this.get(n2));
                        if (!bl2) break block6;
                        if (n == 0) continue;
                    }
                    catch (NbtApiException nbtApiException) {
                        throw NBTList.b(nbtApiException);
                    }
                    boolean bl3 = true;
                    this.a.getReadLock().unlock();
                    return bl3;
                }
                n2 = 0;
                this.a.getReadLock().unlock();
                n = n2;
            }
            catch (Throwable throwable) {
                this.a.getReadLock().unlock();
                throw throwable;
            }
        }
        return n != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int indexOf(Object object) {
        int n;
        block6: {
            boolean bl = NBTCompound.b();
            this.validateClosed();
            boolean bl2 = bl;
            try {
                int n2;
                this.a.getReadLock().lock();
                for (n2 = 0; n2 < this.size(); ++n2) {
                    try {
                        n = object.equals(this.get(n2));
                        if (!bl2) break block6;
                        if (n == 0) continue;
                    }
                    catch (NbtApiException nbtApiException) {
                        throw NBTList.b(nbtApiException);
                    }
                    int n3 = n2;
                    this.a.getReadLock().unlock();
                    return n3;
                }
                n2 = -1;
                this.a.getReadLock().unlock();
                n = n2;
            }
            catch (Throwable throwable) {
                this.a.getReadLock().unlock();
                throw throwable;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends T> collection) {
        boolean bl = NBTCompound.a();
        this.validateClosed();
        boolean bl2 = bl;
        try {
            boolean bl3;
            block10: {
                block9: {
                    this.a.getWriteLock().lock();
                    int n = this.size();
                    for (T t : collection) {
                        try {
                            this.add(t);
                            if (!bl2) {
                                if (!bl2) continue;
                                break;
                            }
                            break block9;
                        }
                        catch (NbtApiException nbtApiException) {
                            throw NBTList.b(nbtApiException);
                        }
                    }
                    try {
                        if (n == this.size()) break block9;
                        bl3 = true;
                        break block10;
                    }
                    catch (NbtApiException nbtApiException) {
                        throw NBTList.b(nbtApiException);
                    }
                }
                bl3 = false;
            }
            boolean bl4 = bl3;
            return bl4;
        }
        finally {
            this.a.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int n, Collection<? extends T> collection) {
        boolean bl = NBTCompound.b();
        this.validateClosed();
        boolean bl2 = bl;
        try {
            boolean bl3;
            block10: {
                block9: {
                    this.a.getWriteLock().lock();
                    int n2 = this.size();
                    for (T t : collection) {
                        try {
                            this.add(n++, t);
                            if (bl2) {
                                if (bl2) continue;
                                break;
                            }
                            break block9;
                        }
                        catch (NbtApiException nbtApiException) {
                            throw NBTList.b(nbtApiException);
                        }
                    }
                    try {
                        if (n2 == this.size()) break block9;
                        bl3 = true;
                        break block10;
                    }
                    catch (NbtApiException nbtApiException) {
                        throw NBTList.b(nbtApiException);
                    }
                }
                bl3 = false;
            }
            boolean bl4 = bl3;
            return bl4;
        }
        finally {
            this.a.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> collection) {
        boolean bl = NBTCompound.b();
        this.validateClosed();
        boolean bl2 = bl;
        try {
            boolean bl3;
            block7: {
                this.a.getReadLock().lock();
                for (Object obj : collection) {
                    block8: {
                        try {
                            bl3 = this.contains(obj);
                            if (!bl2) break block7;
                            if (bl3) break block8;
                        }
                        catch (NbtApiException nbtApiException) {
                            throw NBTList.b(nbtApiException);
                        }
                        boolean bl4 = false;
                        return bl4;
                    }
                    if (bl2) continue;
                }
                bl3 = true;
            }
            boolean bl5 = bl3;
            return bl5;
        }
        finally {
            this.a.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(Object object) {
        int n;
        block5: {
            boolean bl = NBTCompound.a();
            this.validateClosed();
            boolean bl2 = bl;
            try {
                int n2;
                this.a.getReadLock().lock();
                int n3 = -1;
                for (n2 = 0; n2 < this.size(); ++n2) {
                    try {
                        n = object.equals(this.get(n2));
                        if (bl2) break block5;
                        if (n == 0) continue;
                    }
                    catch (NbtApiException nbtApiException) {
                        throw NBTList.b(nbtApiException);
                    }
                    n3 = n2;
                    if (!bl2) continue;
                }
                n2 = n3;
                this.a.getReadLock().unlock();
                n = n2;
            }
            catch (Throwable throwable) {
                this.a.getReadLock().unlock();
                throw throwable;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = NBTCompound.a();
        this.validateClosed();
        boolean bl2 = bl;
        try {
            boolean bl3;
            block10: {
                block9: {
                    this.a.getWriteLock().lock();
                    int n = this.size();
                    for (Object obj : collection) {
                        try {
                            this.remove(obj);
                            if (!bl2) {
                                if (!bl2) continue;
                                break;
                            }
                            break block9;
                        }
                        catch (NbtApiException nbtApiException) {
                            throw NBTList.b(nbtApiException);
                        }
                    }
                    try {
                        if (n == this.size()) break block9;
                        bl3 = true;
                        break block10;
                    }
                    catch (NbtApiException nbtApiException) {
                        throw NBTList.b(nbtApiException);
                    }
                }
                bl3 = false;
            }
            boolean bl4 = bl3;
            return bl4;
        }
        finally {
            this.a.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = NBTCompound.a();
        this.validateClosed();
        boolean bl2 = bl;
        try {
            boolean bl3;
            int n;
            block10: {
                this.a.getWriteLock().lock();
                int n2 = this.size();
                Iterator<?> iterator = collection.iterator();
                block7: while (true) {
                    boolean bl4 = iterator.hasNext();
                    block8: while (bl4) {
                        Object obj = iterator.next();
                        n = 0;
                        if (bl2) break block10;
                        for (int i = v1053297; i < this.size(); ++i) {
                            bl4 = obj.equals(this.get(i));
                            if (bl2) continue block8;
                            try {
                                if (bl4) continue;
                                this.remove(i--);
                                continue;
                            }
                            catch (NbtApiException nbtApiException) {
                                throw NBTList.b(nbtApiException);
                            }
                        }
                        if (!bl2) continue block7;
                    }
                    break;
                }
                n = n2;
            }
            try {
                bl3 = n != this.size();
            }
            catch (NbtApiException nbtApiException) {
                throw NBTList.b(nbtApiException);
            }
            boolean bl5 = bl3;
            return bl5;
        }
        finally {
            this.a.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        boolean bl = NBTCompound.a();
        this.validateClosed();
        boolean bl2 = bl;
        try {
            boolean bl3;
            block10: {
                block9: {
                    this.a.getWriteLock().lock();
                    int n = this.size();
                    int n2 = -1;
                    while ((n2 = this.indexOf(object)) != -1) {
                        try {
                            this.remove(n2);
                            if (!bl2) {
                                if (!bl2) continue;
                                break;
                            }
                            break block9;
                        }
                        catch (NbtApiException nbtApiException) {
                            throw NBTList.b(nbtApiException);
                        }
                    }
                    try {
                        if (n == this.size()) break block9;
                        bl3 = true;
                        break block10;
                    }
                    catch (NbtApiException nbtApiException) {
                        throw NBTList.b(nbtApiException);
                    }
                }
                bl3 = false;
            }
            boolean bl4 = bl3;
            return bl4;
        }
        finally {
            this.a.getWriteLock().unlock();
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int a = -1;

            @Override
            public boolean hasNext() {
                boolean bl;
                try {
                    bl = NBTList.this.size() > this.a + 1;
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw 1.b(noSuchElementException);
                }
                return bl;
            }

            @Override
            public T next() {
                try {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw 1.b(noSuchElementException);
                }
                return NBTList.this.get(++this.a);
            }

            @Override
            public void remove() {
                NBTList.this.remove(this.a);
                --this.a;
            }

            private static NoSuchElementException b(NoSuchElementException noSuchElementException) {
                return noSuchElementException;
            }
        };
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<T> listIterator(final int n) {
        final NBTList nBTList = this;
        return new ListIterator<T>(){
            int a;
            private static final String c;
            {
                this.a = n - 1;
            }

            @Override
            public void add(T t) {
                nBTList.add(this.a, t);
            }

            @Override
            public boolean hasNext() {
                boolean bl;
                try {
                    bl = NBTList.this.size() > this.a + 1;
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw 2.b(noSuchElementException);
                }
                return bl;
            }

            @Override
            public boolean hasPrevious() {
                boolean bl;
                block5: {
                    block4: {
                        try {
                            try {
                                if (this.a < 0 || this.a > NBTList.this.size()) break block4;
                            }
                            catch (NoSuchElementException noSuchElementException) {
                                throw 2.b(noSuchElementException);
                            }
                            bl = true;
                            break block5;
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            throw 2.b(noSuchElementException);
                        }
                    }
                    bl = false;
                }
                return bl;
            }

            @Override
            public T next() {
                try {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw 2.b(noSuchElementException);
                }
                return NBTList.this.get(++this.a);
            }

            @Override
            public int nextIndex() {
                return this.a + 1;
            }

            @Override
            public T previous() {
                try {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException(c + (this.a - 1));
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw 2.b(noSuchElementException);
                }
                return NBTList.this.get(this.a--);
            }

            @Override
            public int previousIndex() {
                return this.a - 1;
            }

            @Override
            public void remove() {
                nBTList.remove(this.a);
                --this.a;
            }

            @Override
            public void set(T t) {
                nBTList.set(this.a, t);
            }

            private static NoSuchElementException b(NoSuchElementException noSuchElementException) {
                return noSuchElementException;
            }

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             */
            static {
                char[] cArray;
                block12: {
                    int n9;
                    char[] cArray2;
                    int n2;
                    int n3;
                    block11: {
                        char[] cArray3 = "~\tg0".toCharArray();
                        int n4 = cArray3.length;
                        n3 = 0;
                        n2 = 108;
                        cArray2 = cArray3;
                        n9 = n4;
                        if (n4 <= 1) break block11;
                        cArray = cArray2;
                        n9 = n9;
                        if (n9 <= n3) break block12;
                    }
                    do {
                        int n5 = n2;
                        cArray2 = cArray2;
                        char[] cArray4 = cArray2;
                        int n6 = n2;
                        int n7 = n3;
                        while (true) {
                            int n8;
                            switch (n3 % 7) {
                                case 0: {
                                    n8 = 91;
                                    break;
                                }
                                case 1: {
                                    n8 = 1;
                                    break;
                                }
                                case 2: {
                                    n8 = 49;
                                    break;
                                }
                                case 3: {
                                    n8 = 124;
                                    break;
                                }
                                case 4: {
                                    n8 = 30;
                                    break;
                                }
                                case 5: {
                                    n8 = 108;
                                    break;
                                }
                                default: {
                                    n8 = 90;
                                }
                            }
                            cArray4[n7] = (char)(cArray4[n7] ^ (n6 ^ n8));
                            ++n3;
                            n2 = n5;
                            if (n5 != 0) break;
                            n5 = n2;
                            cArray2 = cArray2;
                            n7 = n2;
                            cArray4 = cArray2;
                            n6 = n2;
                        }
                        cArray = cArray2;
                        n9 = n9;
                    } while (n9 > n3);
                }
                c = new String(cArray).intern();
            }
        };
    }

    @Override
    public Object[] toArray() {
        boolean bl = NBTCompound.a();
        this.validateClosed();
        boolean bl2 = bl;
        try {
            Object[] objectArray;
            block7: {
                this.a.getReadLock().lock();
                Object[] objectArray2 = new Object[this.size()];
                for (int i = 0; i < this.size(); ++i) {
                    try {
                        objectArray = objectArray2;
                        if (!bl2) {
                            objectArray[i] = this.get(i);
                            if (!bl2) continue;
                            break;
                        }
                        break block7;
                    }
                    catch (NbtApiException nbtApiException) {
                        throw NBTList.b(nbtApiException);
                    }
                }
                objectArray = objectArray2;
            }
            Object[] objectArray3 = objectArray;
            return objectArray3;
        }
        finally {
            this.a.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <E> E[] toArray(E[] EArray) {
        boolean bl = NBTCompound.a();
        this.validateClosed();
        boolean bl2 = bl;
        try {
            this.a.getReadLock().lock();
            Object[] objectArray = Arrays.copyOf(EArray, this.size());
            Arrays.fill(objectArray, null);
            Class<?> clazz = EArray.getClass().getComponentType();
            for (int i = 0; i < this.size(); ++i) {
                Object e = this.get(i);
                if (!clazz.isInstance(e)) throw new ArrayStoreException(NBTList.e[0]);
                try {
                    objectArray[i] = this.get(i);
                    if (!bl2) continue;
                    throw new ArrayStoreException(NBTList.e[0]);
                    catch (NbtApiException nbtApiException) {
                        throw NBTList.b(nbtApiException);
                    }
                }
                catch (NbtApiException nbtApiException) {
                    throw NBTList.b(nbtApiException);
                }
            }
            Object[] objectArray2 = objectArray;
            return objectArray2;
        }
        finally {
            this.a.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> subList(int n, int n2) {
        boolean bl = NBTCompound.b();
        this.validateClosed();
        boolean bl2 = bl;
        try {
            ArrayList arrayList;
            block7: {
                this.a.getReadLock().lock();
                ArrayList arrayList2 = new ArrayList();
                for (int i = n; i < n2; ++i) {
                    try {
                        arrayList = arrayList2;
                        if (bl2) {
                            arrayList.add(this.get(i));
                            if (bl2) continue;
                            break;
                        }
                        break block7;
                    }
                    catch (NbtApiException nbtApiException) {
                        throw NBTList.b(nbtApiException);
                    }
                }
                arrayList = arrayList2;
            }
            ArrayList arrayList3 = arrayList;
            return arrayList3;
        }
        finally {
            this.a.getReadLock().unlock();
        }
    }

    @Override
    public boolean removeIf(Predicate<? super T> predicate) {
        return List.super.removeIf(predicate);
    }

    public String toString() {
        this.validateClosed();
        try {
            this.a.getReadLock().lock();
            String string = this.d.toString();
            return string;
        }
        finally {
            this.a.getReadLock().unlock();
        }
    }

    private static NbtApiException b(NbtApiException nbtApiException) {
        return nbtApiException;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block13: {
            var5 = new String[3];
            var3_1 = 0;
            var2_2 = "il-ud\u001d$\\}h1j\n%\u001dj'!%\u00027Ig uq\u00073\u001dk*?`\f\"N$;!j\u001d3Y$!;%\u001b>X$\u0004<v\u001bx%iv!0aO%Xp<<k\bvYe<4%\u00068\u001dv-4aO9Sh1uh\u00002X%\u001civ!0aO#Nm&2%\f:Rw-1%!\u0014i$,4q\u000ew";
            var4_3 = "il-ud\u001d$\\}h1j\n%\u001dj'!%\u00027Ig uq\u00073\u001dk*?`\f\"N$;!j\u001d3Y$!;%\u001b>X$\u0004<v\u001bx%iv!0aO%Xp<<k\bvYe<4%\u00068\u001dv-4aO9Sh1uh\u00002X%\u001civ!0aO#Nm&2%\f:Rw-1%!\u0014i$,4q\u000ew".length();
            var1_4 = 56;
            var0_5 = -1;
lbl7:
            // 2 sources

            while (true) {
                continue;
                break;
            }
lbl9:
            // 1 sources

            while (true) {
                var5[var3_1++] = new String(v0).intern();
                if ((var0_5 += var1_4) < var4_3) {
                    var1_4 = var2_2.charAt(var0_5);
                    ** continue;
                }
                break block13;
                break;
            }
            v1 = ++var0_5;
            v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
            v3 = v2.length;
            var6_6 = 0;
            v4 = 110;
            v5 = v2;
            v6 = v3;
            if (v3 > 1) ** GOTO lbl67
            do {
                v7 = v4;
                v5 = v5;
                v8 = v5;
                v9 = v4;
                v10 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v11 = 83;
                            break;
                        }
                        case 1: {
                            v11 = 106;
                            break;
                        }
                        case 2: {
                            v11 = 38;
                            break;
                        }
                        case 3: {
                            v11 = 59;
                            break;
                        }
                        case 4: {
                            v11 = 107;
                            break;
                        }
                        case 5: {
                            v11 = 1;
                            break;
                        }
                        default: {
                            v11 = 56;
                        }
                    }
                    v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                    ++var6_6;
                    v4 = v7;
                    if (v7 != 0) break;
                    v7 = v4;
                    v5 = v5;
                    v10 = v4;
                    v8 = v5;
                    v9 = v4;
                }
lbl67:
                // 2 sources

                v0 = v5;
                v6 = v6;
            } while (v6 > var6_6);
            ** while (true)
        }
        NBTList.e = var5;
    }
}

