/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.libs.apache.commons.math3.distribution;

import net.advancedplugins.ae.libs.apache.commons.math3.distribution.AbstractRealDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NotStrictlyPositiveException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.OutOfRangeException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.Localizable;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.LocalizedFormats;
import net.advancedplugins.ae.libs.apache.commons.math3.random.RandomGenerator;
import net.advancedplugins.ae.libs.apache.commons.math3.random.Well19937c;
import net.advancedplugins.ae.libs.apache.commons.math3.special.Gamma;
import net.advancedplugins.ae.libs.apache.commons.math3.util.FastMath;

public class WeibullDistribution
extends AbstractRealDistribution {
    public static final double i = 1.0E-9;
    private static final long serialVersionUID = 8589540077390120676L;
    private final double g;
    private final double k;
    private final double h;
    private double m = Double.NaN;
    private boolean l = false;
    private double f = Double.NaN;
    private boolean j = false;

    public WeibullDistribution(double d, double d2) {
        this(d, d2, 1.0E-9);
    }

    public WeibullDistribution(double d, double d2, double d3) {
        this(new Well19937c(), d, d2, d3);
    }

    public WeibullDistribution(RandomGenerator randomGenerator, double d, double d2) {
        this(randomGenerator, d, d2, 1.0E-9);
    }

    public WeibullDistribution(RandomGenerator randomGenerator, double d, double d2, double d3) {
        super(randomGenerator);
        if (d <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.SHAPE, d);
        }
        try {
            if (d2 <= 0.0) {
                throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.SCALE, d2);
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw WeibullDistribution.b(notStrictlyPositiveException);
        }
        this.k = d2;
        this.g = d;
        this.h = d3;
    }

    public double getShape() {
        return this.g;
    }

    public double getScale() {
        return this.k;
    }

    public double density(double d) {
        try {
            if (d < 0.0) {
                return 0.0;
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw WeibullDistribution.b(notStrictlyPositiveException);
        }
        double d2 = d / this.k;
        double d3 = FastMath.pow(d2, this.g - 1.0);
        double d4 = d3 * d2;
        return this.g / this.k * d3 * FastMath.exp(-d4);
    }

    public double logDensity(double d) {
        try {
            if (d < 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw WeibullDistribution.b(notStrictlyPositiveException);
        }
        double d2 = d / this.k;
        double d3 = FastMath.log(d2) * (this.g - 1.0);
        double d4 = FastMath.exp(d3) * d2;
        return FastMath.log(this.g / this.k) + d3 - d4;
    }

    public double cumulativeProbability(double d) {
        double d2;
        block3: {
            block2: {
                boolean bl = AbstractRealDistribution.b();
                if (!(d <= 0.0)) break block2;
                d2 = 0.0;
                if (bl) break block3;
            }
            d2 = 1.0 - FastMath.exp(-FastMath.pow(d / this.k, this.g));
        }
        return d2;
    }

    /*
     * Unable to fully structure code
     */
    public double inverseCumulativeProbability(double var1_1) {
        block9: {
            block10: {
                block8: {
                    var3_2 = AbstractRealDistribution.a();
                    try {
                        try {
                            if (!(var1_1 < 0.0) && !(var1_1 > 1.0)) break block8;
                        }
                        catch (NotStrictlyPositiveException v0) {
                            throw WeibullDistribution.b(v0);
                        }
                        throw new OutOfRangeException(var1_1, (Number)0.0, 1.0);
                    }
                    catch (NotStrictlyPositiveException v1) {
                        throw WeibullDistribution.b(v1);
                    }
                }
                if (var1_1 != 0.0) ** GOTO lbl16
                var4_3 = 0.0;
                try {
                    if (!var3_2) break block9;
lbl16:
                    // 2 sources

                    if (var1_1 != 1.0) break block10;
                }
                catch (NotStrictlyPositiveException v2) {
                    throw WeibullDistribution.b(v2);
                }
                var4_3 = Infinity;
                if (!var3_2) break block9;
            }
            var4_3 = this.k * FastMath.pow(-FastMath.log1p(-var1_1), 1.0 / this.g);
        }
        return var4_3;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.h;
    }

    public double getNumericalMean() {
        try {
            if (!this.l) {
                this.m = this.calculateNumericalMean();
                this.l = true;
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw WeibullDistribution.b(notStrictlyPositiveException);
        }
        return this.m;
    }

    protected double calculateNumericalMean() {
        double d = this.getShape();
        double d2 = this.getScale();
        return d2 * FastMath.exp(Gamma.logGamma(1.0 + 1.0 / d));
    }

    public double getNumericalVariance() {
        try {
            if (!this.j) {
                this.f = this.calculateNumericalVariance();
                this.j = true;
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw WeibullDistribution.b(notStrictlyPositiveException);
        }
        return this.f;
    }

    protected double calculateNumericalVariance() {
        double d = this.getShape();
        double d2 = this.getScale();
        double d3 = this.getNumericalMean();
        return d2 * d2 * FastMath.exp(Gamma.logGamma(1.0 + 2.0 / d)) - d3 * d3;
    }

    public double getSupportLowerBound() {
        return 0.0;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return true;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }

    private static NotStrictlyPositiveException b(NotStrictlyPositiveException notStrictlyPositiveException) {
        return notStrictlyPositiveException;
    }
}

