/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.libs.apache.commons.math3.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.DimensionMismatchException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.MathInternalError;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.OutOfRangeException;
import net.advancedplugins.ae.libs.apache.commons.math3.util.ArithmeticUtils;
import net.advancedplugins.ae.libs.apache.commons.math3.util.CombinatoricsUtils;
import net.advancedplugins.ae.libs.apache.commons.math3.util.FastMath;
import net.advancedplugins.ae.libs.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Combinations
implements Iterable<int[]> {
    private final int a;
    private final int c;
    private final IterationOrder b;

    public Combinations(int n, int n2) {
        this(n, n2, IterationOrder.LEXICOGRAPHIC);
    }

    private Combinations(int n, int n2, IterationOrder iterationOrder) {
        CombinatoricsUtils.checkBinomial(n, n2);
        this.a = n;
        this.c = n2;
        this.b = iterationOrder;
    }

    public int getN() {
        return this.a;
    }

    public int getK() {
        return this.c;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterator<int[]> iterator() {
        try {
            try {
                if (this.c == 0) return new SingletonIterator(MathArrays.natural(this.c));
                if (this.c == this.a) {
                    return new SingletonIterator(MathArrays.natural(this.c));
                }
            }
            catch (MathInternalError mathInternalError) {
                throw Combinations.b(mathInternalError);
            }
        }
        catch (MathInternalError mathInternalError) {
            throw Combinations.b(mathInternalError);
        }
        try {
            switch (this.b) {
                case LEXICOGRAPHIC: {
                    return new LexicographicIterator(this.a, this.c);
                }
                default: {
                    throw new MathInternalError();
                }
            }
        }
        catch (MathInternalError mathInternalError) {
            throw Combinations.b(mathInternalError);
        }
    }

    public Comparator<int[]> comparator() {
        return new LexicographicComparator(this.a, this.c);
    }

    private static MathInternalError b(MathInternalError mathInternalError) {
        return mathInternalError;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LexicographicComparator
    implements Comparator<int[]>,
    Serializable {
        private static final long serialVersionUID = 20130906L;
        private final int a;
        private final int b;

        LexicographicComparator(int n, int n2) {
            this.a = n;
            this.b = n2;
        }

        @Override
        public int compare(int[] nArray, int[] nArray2) {
            try {
                if (nArray.length != this.b) {
                    throw new DimensionMismatchException(nArray.length, this.b);
                }
            }
            catch (DimensionMismatchException dimensionMismatchException) {
                throw LexicographicComparator.b(dimensionMismatchException);
            }
            try {
                if (nArray2.length != this.b) {
                    throw new DimensionMismatchException(nArray2.length, this.b);
                }
            }
            catch (DimensionMismatchException dimensionMismatchException) {
                throw LexicographicComparator.b(dimensionMismatchException);
            }
            int[] nArray3 = MathArrays.copyOf(nArray);
            Arrays.sort(nArray3);
            int[] nArray4 = MathArrays.copyOf(nArray2);
            Arrays.sort(nArray4);
            long l = this.lexNorm(nArray3);
            long l2 = this.lexNorm(nArray4);
            try {
                if (l < l2) {
                    return -1;
                }
            }
            catch (DimensionMismatchException dimensionMismatchException) {
                throw LexicographicComparator.b(dimensionMismatchException);
            }
            try {
                if (l > l2) {
                    return 1;
                }
            }
            catch (DimensionMismatchException dimensionMismatchException) {
                throw LexicographicComparator.b(dimensionMismatchException);
            }
            return 0;
        }

        private long lexNorm(int[] nArray) {
            long l = 0L;
            int n = FastMath.b();
            for (int i = 0; i < nArray.length; ++i) {
                block5: {
                    int n2 = nArray[i];
                    try {
                        try {
                            if (n2 >= 0 && n2 < this.a) break block5;
                        }
                        catch (DimensionMismatchException dimensionMismatchException) {
                            throw LexicographicComparator.b(dimensionMismatchException);
                        }
                        throw new OutOfRangeException(n2, (Number)0, this.a - 1);
                    }
                    catch (DimensionMismatchException dimensionMismatchException) {
                        throw LexicographicComparator.b(dimensionMismatchException);
                    }
                }
                l += (long)(nArray[i] * ArithmeticUtils.pow(this.a, i));
                if (n != 0) continue;
            }
            return l;
        }

        private static DimensionMismatchException b(DimensionMismatchException dimensionMismatchException) {
            return dimensionMismatchException;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingletonIterator
    implements Iterator<int[]> {
        private final int[] b;
        private boolean a = true;

        SingletonIterator(int[] nArray) {
            this.b = nArray;
        }

        @Override
        public boolean hasNext() {
            return this.a;
        }

        @Override
        public int[] next() {
            try {
                if (this.a) {
                    this.a = false;
                    return this.b;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw SingletonIterator.b(noSuchElementException);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private static NoSuchElementException b(NoSuchElementException noSuchElementException) {
            return noSuchElementException;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LexicographicIterator
    implements Iterator<int[]> {
        private final int b;
        private final int[] d;
        private boolean c;
        private int a;

        LexicographicIterator(int n, int n2) {
            block9: {
                int n3;
                block8: {
                    this.c = true;
                    this.b = n2;
                    n3 = FastMath.c();
                    try {
                        try {
                            this.d = new int[n2 + 3];
                            if (n2 != 0 && n2 < n) break block8;
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            throw LexicographicIterator.b(noSuchElementException);
                        }
                        this.c = false;
                        return;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        throw LexicographicIterator.b(noSuchElementException);
                    }
                }
                for (int i = 1; i <= n2; ++i) {
                    try {
                        this.d[i] = i - 1;
                        if (n3 == 0) {
                            if (n3 == 0) continue;
                            break;
                        }
                        break block9;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        throw LexicographicIterator.b(noSuchElementException);
                    }
                }
                this.d[n2 + 1] = n;
                this.d[n2 + 2] = 0;
                this.a = n2;
            }
        }

        @Override
        public boolean hasNext() {
            return this.c;
        }

        @Override
        public int[] next() {
            int n;
            int n2;
            int n3;
            int[] nArray;
            block15: {
                int n4 = FastMath.b();
                try {
                    if (!this.c) {
                        throw new NoSuchElementException();
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw LexicographicIterator.b(noSuchElementException);
                }
                nArray = new int[this.b];
                System.arraycopy(this.d, 1, nArray, 0, this.b);
                n3 = 0;
                if (this.a > 0) {
                    this.d[this.a] = n3 = this.a;
                    --this.a;
                    return nArray;
                }
                try {
                    if (this.d[1] + 1 < this.d[2]) {
                        this.d[1] = this.d[1] + 1;
                        return nArray;
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw LexicographicIterator.b(noSuchElementException);
                }
                this.a = 2;
                boolean bl = false;
                while (!bl) {
                    block16: {
                        this.d[this.a - 1] = this.a - 2;
                        n3 = this.d[this.a] + 1;
                        try {
                            try {
                                n2 = n3;
                                n = this.d[this.a + 1];
                                if (n4 == 0) break block15;
                                if (n2 != n) break block16;
                            }
                            catch (NoSuchElementException noSuchElementException) {
                                throw LexicographicIterator.b(noSuchElementException);
                            }
                            ++this.a;
                            if (n4 != 0) continue;
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            throw LexicographicIterator.b(noSuchElementException);
                        }
                    }
                    bl = true;
                    if (n4 != 0) continue;
                }
                n2 = this.a;
                n = this.b;
            }
            try {
                if (n2 > n) {
                    this.c = false;
                    return nArray;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw LexicographicIterator.b(noSuchElementException);
            }
            this.d[this.a] = n3;
            --this.a;
            return nArray;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private static NoSuchElementException b(NoSuchElementException noSuchElementException) {
            return noSuchElementException;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IterationOrder
    extends Enum<IterationOrder> {
        public static final /* enum */ IterationOrder LEXICOGRAPHIC;
        private static final /* synthetic */ IterationOrder[] a;

        public static IterationOrder[] values() {
            return (IterationOrder[])a.clone();
        }

        public static IterationOrder valueOf(String string) {
            return Enum.valueOf(IterationOrder.class, string);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block12: {
                int n;
                char[] cArray2;
                int n2;
                int n3;
                block11: {
                    Object var1 = null;
                    char[] cArray3 = "\u0002\u0019.O{<\u001d\u001c\u001d&Nq0".toCharArray();
                    int n4 = cArray3.length;
                    n3 = 0;
                    n2 = 66;
                    cArray2 = cArray3;
                    n = n4;
                    if (n4 <= 1) break block11;
                    cArray = cArray2;
                    n = n;
                    if (n <= n3) break block12;
                }
                do {
                    int n5 = n2;
                    cArray2 = cArray2;
                    char[] cArray4 = cArray2;
                    int n6 = n2;
                    int n7 = n3;
                    while (true) {
                        int n8;
                        switch (n3 % 7) {
                            case 0: {
                                n8 = 12;
                                break;
                            }
                            case 1: {
                                n8 = 30;
                                break;
                            }
                            case 2: {
                                n8 = 52;
                                break;
                            }
                            case 3: {
                                n8 = 68;
                                break;
                            }
                            case 4: {
                                n8 = 122;
                                break;
                            }
                            case 5: {
                                n8 = 49;
                                break;
                            }
                            default: {
                                n8 = 24;
                            }
                        }
                        cArray4[n7] = (char)(cArray4[n7] ^ (n6 ^ n8));
                        ++n3;
                        n2 = n5;
                        if (n5 != 0) break;
                        n5 = n2;
                        cArray2 = cArray2;
                        n7 = n2;
                        cArray4 = cArray2;
                        n6 = n2;
                    }
                    cArray = cArray2;
                    n = n;
                } while (n > n3);
            }
            String string = new String(cArray).intern();
            LEXICOGRAPHIC = new IterationOrder();
            a = new IterationOrder[]{LEXICOGRAPHIC};
        }
    }
}

