/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.libs.apache.commons.math3.util;

import java.util.Iterator;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.MathUnsupportedOperationException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.MaxCountExceededException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NotStrictlyPositiveException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NullArgumentException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.ZeroException;

public class IntegerSequence {
    private IntegerSequence() {
    }

    public static Range range(int n, int n2) {
        return IntegerSequence.range(n, n2, 1);
    }

    public static Range range(int n, int n2, int n3) {
        return new Range(n, n2, n3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Incrementor
    implements Iterator<Integer> {
        private static final MaxCountExceededCallback f = new MaxCountExceededCallback(){

            public void trigger(int n) {
                throw new MaxCountExceededException(n);
            }
        };
        private final int d;
        private final int c;
        private final int b;
        private final MaxCountExceededCallback e;
        private int a = 0;

        private Incrementor(int n, int n2, int n3, MaxCountExceededCallback maxCountExceededCallback) {
            if (maxCountExceededCallback == null) {
                throw new NullArgumentException();
            }
            this.d = n;
            this.c = n2;
            this.b = n3;
            this.e = maxCountExceededCallback;
            this.a = n;
        }

        public static Incrementor create() {
            return new Incrementor(0, 0, 1, f);
        }

        public Incrementor withStart(int n) {
            return new Incrementor(n, this.c, this.b, this.e);
        }

        public Incrementor withMaximalCount(int n) {
            return new Incrementor(this.d, n, this.b, this.e);
        }

        public Incrementor withIncrement(int n) {
            try {
                if (n == 0) {
                    throw new ZeroException();
                }
            }
            catch (NullArgumentException nullArgumentException) {
                throw Incrementor.b(nullArgumentException);
            }
            return new Incrementor(this.d, this.c, n, this.e);
        }

        public Incrementor withCallback(MaxCountExceededCallback maxCountExceededCallback) {
            return new Incrementor(this.d, this.c, this.b, maxCountExceededCallback);
        }

        public int getMaximalCount() {
            return this.c;
        }

        public int getCount() {
            return this.a;
        }

        public boolean canIncrement() {
            return this.canIncrement(1);
        }

        public boolean canIncrement(int n) {
            boolean bl;
            block8: {
                int n2;
                block6: {
                    block7: {
                        n2 = this.a + n * this.b;
                        try {
                            try {
                                if (this.b >= 0) break block6;
                                if (n2 <= this.c) break block7;
                            }
                            catch (NullArgumentException nullArgumentException) {
                                throw Incrementor.b(nullArgumentException);
                            }
                            bl = true;
                            break block8;
                        }
                        catch (NullArgumentException nullArgumentException) {
                            throw Incrementor.b(nullArgumentException);
                        }
                    }
                    bl = false;
                    break block8;
                }
                try {
                    bl = n2 < this.c;
                }
                catch (NullArgumentException nullArgumentException) {
                    throw Incrementor.b(nullArgumentException);
                }
            }
            return bl;
        }

        public void increment(int n) {
            try {
                if (n <= 0) {
                    throw new NotStrictlyPositiveException(n);
                }
            }
            catch (MaxCountExceededException maxCountExceededException) {
                throw Incrementor.b(maxCountExceededException);
            }
            try {
                if (!this.canIncrement(0)) {
                    this.e.trigger(this.c);
                }
            }
            catch (MaxCountExceededException maxCountExceededException) {
                throw Incrementor.b(maxCountExceededException);
            }
            this.a += n * this.b;
        }

        public void increment() {
            this.increment(1);
        }

        @Override
        public boolean hasNext() {
            return this.canIncrement(0);
        }

        @Override
        public Integer next() {
            int n = this.a;
            this.increment();
            return n;
        }

        @Override
        public void remove() {
            throw new MathUnsupportedOperationException();
        }

        private static RuntimeException b(RuntimeException runtimeException) {
            return runtimeException;
        }

        public static interface MaxCountExceededCallback {
            public void trigger(int var1) throws MaxCountExceededException;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Range
    implements Iterable<Integer> {
        private final int a;
        private final int b;
        private final int d;
        private final int c;

        public Range(int n, int n2, int n3) {
            this.b = n;
            this.d = n2;
            this.c = n3;
            int n4 = (n2 - n) / n3 + 1;
            this.a = n4 < 0 ? 0 : n4;
        }

        public int size() {
            return this.a;
        }

        @Override
        public Iterator<Integer> iterator() {
            return Incrementor.create().withStart(this.b).withMaximalCount(this.d + (this.c > 0 ? 1 : -1)).withIncrement(this.c);
        }
    }
}

